
/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Minec-Debin
 * @version 1.0
 *
 * Structure d'un fichier de sauvegarde de parametres :
 *  $Section1
 *  variable1 valeur1
 *  variable2 valeur2
 *  $Section2
 *  variable1 valeur1
 * etc
 * ----------------------------------------------------
 * Pour charger et sauver, on peut choisir :
 * parametres techniques ou observateurs
 * ce tableau de booleans est passe en parametre aux differents
 * get_object_from _file()
 *
 */

package iu;

import java.awt.*;
//import java.awt.event.ActionEvent;
import java.io.*;
import java.text.*;
import javax.swing.*;

public class FileIO {
  private class DotIU extends javax.swing.filechooser.FileFilter {
    public boolean accept(File f) {
      if(f != null) {
        if(f.isDirectory()) return true;
        String extension = getExtension(f);
        if (extension != null )
          if(extension.equals("iu")) return true;
      }
      return false;
    }
    public String getDescription() { return ".iu files"; }
    public String getExtension(File f) {
      if(f != null) {
        String filename = f.getName();
        int i = filename.lastIndexOf('.');
        if ((i>0) && (i<filename.length()-1)) return filename.substring(i+1).toLowerCase();
      }
      return null;
    }
  }
  DotIU dotIU = new DotIU();

  public static final String REPERTOIRESAUVEGARDE = "/data/themis/io/config";
//public static final String REPERTOIRESAUVEGARDE = "/scratch/miguel/projets/io107";

//  public static MessageFormat format1 = new MessageFormat("{0} {1}\n");

  public FileIO() {
  }

  private boolean[] selectionPartie(String chaine) {

    JCheckBox jcb1 = new JCheckBox("technical", true);
    JCheckBox jcb2 = new JCheckBox("observation", true);

    Object[] options = { jcb1, jcb2, "OK", "Cancel" };

    JOptionPane pane = new JOptionPane("What part do you want to " + chaine + " ?",
      JOptionPane.QUESTION_MESSAGE, JOptionPane.OK_CANCEL_OPTION, null, options);

    JDialog dialog = pane.createDialog(null, "Select");
    dialog.show();
    Object selectedValue = pane.getValue();
    if (selectedValue == null)
      return null;

    for (int counter = 0, maxCounter = options.length; counter < maxCounter; counter++)
      if (options[counter].equals(selectedValue))
        return new boolean[] { jcb1.isSelected(), jcb2.isSelected() };
    return null;
  }

  public void jButtonLoad_actionPerformed() {
    boolean[] parties;

    JFileChooser chooser = new JFileChooser(FileIO.REPERTOIRESAUVEGARDE);
    chooser.setDialogTitle("Load parameters from file");
    chooser.setFileFilter(dotIU);
    chooser.setAcceptAllFileFilterUsed(false);
    int returnVal = chooser.showOpenDialog(null);
    if (returnVal == JFileChooser.APPROVE_OPTION)
      if ( (parties = selectionPartie("load")) != null )
        load(chooser.getSelectedFile(), parties);
  }

  public void jButtonSave_actionPerformed() {
//    boolean[] parties;

    JFileChooser chooser = new JFileChooser(FileIO.REPERTOIRESAUVEGARDE);
    chooser.setDialogTitle("Save parameters to file");
    chooser.setFileFilter(dotIU);
    int returnVal = chooser.showSaveDialog(null);
    if(returnVal == JFileChooser.APPROVE_OPTION) {
//      if ( (parties = selectionPartie("save")) != null )
        save(chooser.getSelectedFile());
    }
  }

  void save(File fichier) {
    try {
      String filename = fichier.getAbsolutePath();
      int i = filename.lastIndexOf('.');
      if ( (i==-1) || (!(filename.substring(i).toLowerCase().equals(".iu"))) ) {
          filename += ".iu";
          fichier = new File(filename);
        }

      BufferedWriter out = new BufferedWriter(new FileWriter(fichier));
//      System.out.println("[FileIO:save] saving '" + fichier.getName() + "' ...");
      AppIU.setStatus("Saving '"+fichier.getName()+"' ...");

      UserParameters.paramFits.setObject_to_file(out);
      UserParameters.acquisition.setObject_to_file(out);
      UserParameters.observation.setObject_to_file(out);
      UserParameters.listeMoteur.setObject_to_file(out);
      UserParameters.paramObservationStructure.setObject_to_file(out);
      UserParameters.listePolar.setObject_to_file(out);      

      out.close();
      AppIU.setStatus("'"+fichier.getName()+"' saved.");
    }
    catch (Exception ee) {
      ee.printStackTrace();
//      JOptionPane.showMessageDialog(null, "File not saved :\n"+ee.toString(), "Save error", JOptionPane.ERROR_MESSAGE);
      AppIU.setStatus("File not saved :\n"+ee.toString());
    }
  }
/*
  private void gotoNext(BufferedReader in) throws IOException {
    Integer nbvaleur = new Integer(0);
    Object constr[];
    ParsePosition status = new ParsePosition(0);
    MessageFormat formatNombre = new MessageFormat("'{'{0,number}'}'");

    // lecture de debut de zone
    in.readLine();

    String tostudy = new String(in.readLine());
    constr = formatNombre.parse(tostudy, status);
    nbvaleur = new Integer((constr[0]).toString());

    for( int i = 0; i < nbvaleur.intValue(); i++ )
      tostudy = in.readLine();

    // lecture de fin de zone
    in.readLine();
  }
*/
  void load(File fichier, boolean[] parties) {
    try {
      BufferedReader in = new BufferedReader(new FileReader(fichier));
//      System.out.println("[FileIO:load] loading '" + fichier.getName() + "' ...");
      AppIU.setStatus("Loading '"+fichier.getName()+"' ...");

      UserParameters.paramFits.getObject_from_File(in, parties);
      UserParameters.acquisition.getObject_from_File(in, parties);
      UserParameters.observation.getObject_from_File(in, parties);
      UserParameters.listeMoteur.getObject_from_File(in, parties);
      UserParameters.paramObservationStructure.getObject_from_File(in, parties);
      UserParameters.listePolar.getObject_from_File(in, parties);

      in.close();
      AppIU.setStatus("'"+fichier.getName()+"' loaded.");
    }
    catch (Exception ee) { // IOException ou IllegalArgumentException
//      JOptionPane.showMessageDialog(null, ee.toString(), "Load error", JOptionPane.ERROR_MESSAGE);
      AppIU.setStatus("Load error : "+ee.toString());
      ee.printStackTrace();
    }
  }
}
