/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

package iu;

import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.event.*;
import javax.swing.event.*;

public class DarkPanel extends JPanel {
  int darkNumber = 0;
  int nbWave = 0;
  WaveLine[] waveLines;

  TitledBorder titledBorder1;
  JPanel jPanelObturators = new JPanel();
  GridBagLayout gridBagLayoutDark = new GridBagLayout();
  GridBagLayout gridBagLayoutObturators = new GridBagLayout();
  GridBagLayout gridBagLayoutParameters = new GridBagLayout();
  JPanel jPanelParameters = new JPanel();
  JLabel jLabelIntegrationTime = new JLabel("Integration time (ms)");
  JLabel jLabelUsed = new JLabel("Used");
  JLabel jLabelName = new JLabel("Custom Name");
  JTextField jTextFieldName = new JTextField();
  TitledBorder titledBorder2;
  JRadioButton jRadioButtonCloseSpectro = new JRadioButton("Close spectrograph input");
  JRadioButton jRadioButtonCloseAll = new JRadioButton("Close shutters only");
  JLabel jLabelShots = new JLabel("Shots number");
  Border border3;
  Border border4;
  JScrollPane jScrollPaneWaveLength = new JScrollPane();
  GridBagLayout gridBagLayoutUsedWaveLength = new GridBagLayout();
  GridBagLayout gridBagLayoutWaveLength = new GridBagLayout();
  JPanel jPanelUsedWaveLength = new JPanel();
  JPanel jPanelWaveLength = new JPanel();
  Border border5;
  ButtonGroup groupObturators = new ButtonGroup();

  JLabel jLabelFitsMode = new JLabel("FITS mode");
  JComboBox jComboBoxFitsMode;

  JButton jButtonDebut = new JButton();
  JButton jButtonFin = new JButton();
  JButton jButtonApres = new JButton();
  JButton jButtonAvant = new JButton();
  GridBagLayout gridBagLayoutControlButtons = new GridBagLayout();
  GridBagLayout gridBagLayoutControlBar = new GridBagLayout();
  JPanel jPanelControlBar = new JPanel();
  JPanel jPanelControlButtons = new JPanel();
  JLabel jLabelNo = new JLabel();
  JButton jButtonDel = new JButton("del");

  public DarkPanel() {
    try { jbInit(); }
    catch(Exception e) { e.printStackTrace(); }
  }

  private void jbInit() throws Exception {
    initComponents();

    titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(),"Definitions");
    titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142)),"Number of cycles");
    border3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142)),"Wave Length");
    border4 = BorderFactory.createBevelBorder(BevelBorder.LOWERED,Color.white,Color.white,new Color(142, 142, 142),new Color(99, 99, 99));
    border5 = BorderFactory.createEmptyBorder();

    jPanelObturators.setBorder(titledBorder1);
    jPanelObturators.setLayout(gridBagLayoutObturators);
    this.setLayout(gridBagLayoutDark);
    jPanelParameters.setLayout(gridBagLayoutParameters);
    jLabelIntegrationTime.setHorizontalAlignment(SwingConstants.RIGHT);

    jLabelUsed.setHorizontalAlignment(SwingConstants.LEFT);

    jPanelParameters.setBorder(titledBorder2);
    titledBorder2.setBorder(BorderFactory.createEtchedBorder());
    titledBorder2.setTitle("Parameters");
    titledBorder1.setTitle("Obturators");

    groupObturators.add(jRadioButtonCloseSpectro);
    groupObturators.add(jRadioButtonCloseAll);

    jScrollPaneWaveLength.setBorder(border4);
    jPanelUsedWaveLength.setLayout(gridBagLayoutUsedWaveLength);
    jPanelWaveLength.setBorder(border3);
    jPanelWaveLength.setLayout(gridBagLayoutWaveLength);
    jPanelUsedWaveLength.setBorder(border5);

    jLabelNo.setMaximumSize(new Dimension(100, 37));
    jLabelNo.setMinimumSize(new Dimension(100, 37));
    jLabelNo.setPreferredSize(new Dimension(100, 37));
    jButtonDebut.setMargin(new Insets(0, 0, 0, 0));
    jButtonDebut.setIcon(new ImageIcon(DarkPanel.class.getResource("premier.gif")));
    jButtonDebut.setBorder(null);
    jButtonFin.setMargin(new Insets(0, 0, 0, 0));
    jButtonFin.setIcon(new ImageIcon(DarkPanel.class.getResource("dernier.gif")));
    jButtonFin.setBorder(null);
    jButtonApres.setMargin(new Insets(0, 0, 0, 0));
    jButtonApres.setIcon(new ImageIcon(DarkPanel.class.getResource("apres.gif")));
    jButtonApres.setBorder(null);
    jButtonAvant.setMargin(new Insets(0, 0, 0, 0));
    jButtonAvant.setIcon(new ImageIcon(DarkPanel.class.getResource("avant.gif")));
    jButtonAvant.setBorder(null);
    jPanelControlBar.setLayout(gridBagLayoutControlBar);
    jPanelControlButtons.setLayout(gridBagLayoutControlButtons);
    jLabelFitsMode.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabelNo.setFont(new java.awt.Font("Dialog", 1, 25));
    jLabelNo.setForeground(Color.red);
    jLabelNo.setHorizontalAlignment(SwingConstants.CENTER);

    jButtonDebut.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonDebut_actionPerformed(e); }
    });
    jButtonFin.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonFin_actionPerformed(e); }
    });
    jButtonApres.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonApres_actionPerformed(e); }
    });
    jButtonAvant.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonAvant_actionPerformed(e); }
    });
    jButtonDel.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonDel_actionPerformed(e); }
    });

    this.add(jPanelObturators, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelObturators.add(jRadioButtonCloseSpectro, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelObturators.add(jRadioButtonCloseAll, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));

    this.add(jPanelWaveLength, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0
            ,GridBagConstraints.SOUTHEAST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelWaveLength.add(jScrollPaneWaveLength, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelWaveLength.add(jLabelUsed, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelWaveLength.add(jLabelIntegrationTime, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jScrollPaneWaveLength.getViewport().add(jPanelUsedWaveLength, null);

    this.add(jPanelParameters, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

    jPanelParameters.add(jLabelName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelParameters.add(jTextFieldName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelParameters.add(jLabelShots, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelParameters.add(jTextFieldNumberOfCycles, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

    this.add(jPanelControlBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTHEAST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelControlBar.add(jLabelFitsMode, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelControlBar.add(jComboBoxFitsMode, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.VERTICAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelControlBar.add(jPanelControlButtons, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanelControlButtons.add(jButtonDebut, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanelControlButtons.add(jButtonFin, new GridBagConstraints(5, 0, 1, 2, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanelControlButtons.add(jButtonApres, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanelControlButtons.add(jButtonAvant, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanelControlButtons.add(jLabelNo, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanelControlButtons.add(jButtonDel, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
  }

  JPanel jPanel20 = new JPanel();
  JTextField jTextFieldNumberOfCycles = new JTextField();

  private void initComponents() {
    jComboBoxFitsMode = new JComboBox( (Integer[])UserParameters.paramFits
      .getChoice("THEMISFF") );

    waveLines = new WaveLine[ ListeCamera.NB_MAX_CAM ];
    litWave();

   jTextFieldNumberOfCycles.setInputVerifier(new Verif(Verif.TYPEINT,0));
  }

  public void jButtonDel_actionPerformed(ActionEvent e) {
    UserParameters.observation.delete(Cible.DARK, darkNumber );
    if ( darkNumber >= UserParameters.observation.nbDarks ) 
      darkNumber = UserParameters.observation.nbDarks-1;
    setValues(darkNumber);
  }

  public void jButtonApres_actionPerformed(ActionEvent e) {
    try { getValues(darkNumber); }
    catch(NumberFormatException ee) {
      JOptionPane.showMessageDialog(null, ee.toString(), "Error!", JOptionPane.ERROR_MESSAGE);
      return;
    }
    darkNumber++;
    if ( darkNumber >= UserParameters.observation.NB_FLAT_FIELD_MAX ) 
      darkNumber = UserParameters.observation.NB_FLAT_FIELD_MAX-1;
    if ( UserParameters.observation.nbDarks <= darkNumber ) 
      UserParameters.observation.append(Cible.DARK);
    setValues(darkNumber);
  }

  public void jButtonAvant_actionPerformed(ActionEvent e) {
    try { getValues(darkNumber); }
    catch(NumberFormatException ee) {
      JOptionPane.showMessageDialog(null, ee.toString(), "Error!", JOptionPane.ERROR_MESSAGE);
      return;
    }
    darkNumber--;
    if ( darkNumber < 0 ) darkNumber = 0;
    setValues(darkNumber);
  }

  public void jButtonDebut_actionPerformed(ActionEvent e) {
    try { getValues(darkNumber); }
    catch(NumberFormatException ee) {
      JOptionPane.showMessageDialog(null, ee.toString(), "Error!", JOptionPane.ERROR_MESSAGE);
      return;
    }
    darkNumber = 0;
    setValues(darkNumber);
  }

  public void jButtonFin_actionPerformed(ActionEvent e) {
    try { getValues(darkNumber); }
    catch(NumberFormatException ee) {
      JOptionPane.showMessageDialog(null, ee.toString(), "Error!", JOptionPane.ERROR_MESSAGE);
      return;
    }
    darkNumber = UserParameters.observation.nbDarks - 1;
    if ( darkNumber < 0 ) darkNumber = 0;
    setValues(darkNumber);
  }

  public void gainedFocus() {
    jPanelUsedWaveLength.removeAll();
    litWave();
    jPanelUsedWaveLength.validate();
    setValues(darkNumber);
  }

  public void lostFocus() throws NumberFormatException {
    getValues(darkNumber);
    jPanelUsedWaveLength.validate();
//    if (UserParameters.paramTargets.CheckObturateurs()==-1) throw new NumberFormatException("pb homogeneite tps integration");
  }

  private void getValues(int number) {
    Cible dark = UserParameters.observation.extraDarks[number];

    dark.closeSpectro = jRadioButtonCloseSpectro.isSelected();
    dark.nbacquisition = Integer.parseInt(jTextFieldNumberOfCycles.getText());
    dark.fitsMode = ((Integer)(jComboBoxFitsMode.getSelectedItem())).intValue();
    dark.customName = jTextFieldName.getText();

    int num;
    for (int i = 0 ; i < nbWave ; i++) {
      num = UserParameters.acquisition.listeWin.getWin(i);
      dark.winUsed[num] = waveLines[ i ].jCheckBoxWave.isSelected();
      dark.integrationTime[num] = Integer.parseInt(waveLines[ i ].jTextFieldTime.getText());
    }
  }

  private void setValues(int number) {
    String tps;
    Cible dark = UserParameters.observation.extraDarks[number];
    jLabelNo.setText(Integer.toString(number+1)+" of "+Integer.toString(UserParameters.observation.nbDarks));

    jRadioButtonCloseSpectro.setSelected(dark.closeSpectro);
    jTextFieldNumberOfCycles.setText(Integer.toString(dark.nbacquisition));
    jComboBoxFitsMode.setSelectedItem(new Integer(dark.fitsMode));
    jTextFieldName.setText(dark.customName);

    int num;
    for (int i = 0 ; i < nbWave ; i++) {
      num = UserParameters.acquisition.listeWin.getWin(i);
      if (dark.integrationTime[num]==-1)
        tps = "300";
      else
        tps = Integer.toString(dark.integrationTime[num]);
      waveLines[ i ].jCheckBoxWave.setSelected(dark.winUsed[num]);
      waveLines[ i ].jTextFieldTime.setText(tps);
      checkIntgTime(waveLines[i].jTextFieldTime);
    }
  }

  private void litWave() {
    int i;
    String[] waveString = UserParameters.acquisition.listeWin.getWaveString();
    Cible dark = UserParameters.observation.extraDarks[darkNumber];
    int num;
    for (i = 0 ; i < UserParameters.acquisition.listeWin.getNbWin() ; i++) {
      num = UserParameters.acquisition.listeWin.getWin(i);
      waveLines[ i ] = new WaveLine(dark.winUsed[num], waveString[ i ], dark.integrationTime[num]);
      jPanelUsedWaveLength.add(waveLines[ i ], new GridBagConstraints(0, i, 1, 1, 0.0, 0.0
        ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      JTextField jtf = waveLines[i].jTextFieldTime;
      jtf.addFocusListener(new java.awt.event.FocusAdapter() {
	public void focusLost(FocusEvent e) { checkIntgTime(e.getComponent()); }
      });
      jtf.setInputVerifier(new Verif(Verif.TYPEINT,0));
    }
    jPanelUsedWaveLength.add(jPanel20, new GridBagConstraints(0, i, 1, 1, 1.0, 1.0
      ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    nbWave = i;
  }

/**
 * Cette fonction s'assure :
 * - qu'il n'y a pas des temps d'int\uFFE9gration diff\uFFE9rents pour un m\uFFEAme
 * obturateur. Remarque : des cam\uFFE9ras diff\uFFE9rentes peuvent avoir le
 * m\uFFEAme obturateur.
 * - tintg > 300 pour l'obtu 7 et > 10 pour les autres.
 * Cette fonction est appel\uFFE9 d\uFFE8s qu'un jTextFieldTime perd le focus.
 */
  private void checkIntgTime(Component c) {
    int i;
    int obtu1 = 0, obtu2 = 0;
    int time1 = Integer.parseInt( ((JTextField)c).getText() ), time2 = 0;

  // on r\uFFE9cup\uFFE8re le num\uFFE9ro de waveline = le num\uFFE9ro de cam\uFFE9ra
    for (i = 0 ; i < nbWave ; i++)
      if (waveLines[i].jTextFieldTime == c) break;
    obtu1 = UserParameters.acquisition.listeCam.getListe()[UserParameters.acquisition.listeWin.getListe()[i].getCam()].numShutter.intValue();

    if (time1 < 10) time1 = 10;
    if ((obtu1 == 7) && (time1 < 300)) time1=300; 
    
  // boucle : si on trouve une autre cam\uFFE9ra avec le m\uFFEAme obturateur, on v\uFFE9rifie le temps
    for (int j = 0; j < nbWave ; j++) {
      obtu2 = UserParameters.acquisition.listeCam.getListe()[UserParameters.acquisition.listeWin.getListe()[j].getCam()].numShutter.intValue();
      if (obtu1 == obtu2) {
        time2 = Integer.parseInt(waveLines[j].jTextFieldTime.getText());
        if (time2 != time1) 
          waveLines[j].jTextFieldTime.setText(Integer.toString(time1));
      }
    }
  }
}
