/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) 2000 Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

package iu;

import java.io.*;
//import java.lang.System; // pour debugage seulement -------------
//import java.lang.String;
import java.net.*;
import java.util.ArrayList;

public class Communication {
  // pour debugage seulement -------------
  private static final boolean NOUCCI = false;

  // Ecrit au fur et a mesure a l'ecran
  private static final boolean VERBOSE = true;

  // Ecrit dans un fichier toutes les communications
  private static boolean doLog = true;
  private static final String FICHIERLOG = UserParameters.ressourceDir+"comm.log";

  public static final String UCCI = "uccis";
  public static final int PORTUCCI = 2222;
  public static final int ASYNCHRONE = 2500;

  public static final String VME = "vme";
  public static int PORTVME = 2222;

  public static final String ZEUS = "zeus";
/**
  * PORTZEUS n'est pas <code>final</code>, car si le programme d'acquisition plante,
  * le port devient inaccessible pendant qq minutes.
  * @see #connexion()
  */
  public static int PORTZEUS = 2222;

//  private static final int TAILLELIGNE = 1024;
  private static final int PORTCOMMDEFAUT = 2222;

  private static final int ACC_RECEP = 60; // ="<"
  private static final int ACC_FIN = 62; // =">"

  public static final String SEP_UCCI = "\r\n";
  public static final String SEP_DEF = "\n\r";

// Attention : apres <FIN>, la connexion doit etre coupee - pour l'UCCI
//  public static final String FIN_MESSAGE = "<FIN>";

  /*
  private static final byte[] ACKCMD = { 10, 13, 60, 10, 13 }; // ="\n\r<\n\r"
  private static final byte[] FINCMD = { 10, 13, 62, 10, 13 }; // ="\n\r>\n\r"
  */

  private Socket s;
  private BufferedReader fromServer;
  private PrintWriter toServer, toLog;
  private String serveur;
  private int port;

//  private File fich;

/**
  * Constructeurs
  */

/**
 * Attention avec ce constructeur : le port depend du serveur
 */
  public Communication(String serveur, int port) throws IOException {
    this.serveur = serveur;
    this.port = port;
    connexion();
  }

/**
 * Pour ces 2 constructeurs, serveur = UCCI ou VME ou ZEUS
 */
  public Communication(int timeout, String serveur) throws IOException {
    this(serveur);
    if (s != null) s.setSoTimeout(timeout);
  }

  public Communication(String serveur) throws IOException {
    port = PORTCOMMDEFAUT;
    this.serveur = serveur;

    if (serveur.equals(UCCI))
      port = PORTUCCI;
    else if(serveur.equals(VME))
      port = PORTVME;
    else if(serveur.equals(ZEUS))
      port = PORTZEUS;

    connexion();
  }

/**
 * Connexion
 */

  private void connexion() throws IOException {
    if (doLog) try {
      toLog = new PrintWriter(new FileWriter(FICHIERLOG, true));
      toLog.println("*****     connection to "+serveur+":"+port+", "+new java.util.Date()+" *****");
    } catch(IOException e) { 
      doLog = false;
      System.err.println("Error creating "+FICHIERLOG+" ("+e
        +"). There will be no I/O lo log.");
    }

    if (NOUCCI && serveur.equals(UCCI)) return; //********************

    boolean cont = true;
    while (cont) {
      try {
        s = new Socket(serveur, port);
        cont = false;
      }
      catch (ConnectException e) {
        if (doLog) toLog.println("Connection to "+serveur+":"+port+" refused.");
        String newport = javax.swing.JOptionPane.showInputDialog(null,
          "Connection to "+serveur+":"+port
          +" was refused.\nEnter a new port to try again :",
          "Connection error", javax.swing.JOptionPane.ERROR_MESSAGE);
//System.out.println("[Communication.connexion] newport="+newport);
        if (newport.length()==0) cont = false;
        try {
          port = Integer.parseInt(newport);
          if (serveur.equals(ZEUS)) PORTZEUS = port;
          else if (serveur.equals(VME)) PORTVME = port;
        }
        catch (NumberFormatException e2) { System.err.println(e2); }
        if (!cont) throw new ConnectException("Connection to "+serveur+":"
          +port+" refused.");
      }
    }

    InputStream sin = s.getInputStream();
    fromServer = new BufferedReader(new InputStreamReader(sin));

    OutputStream sout = s.getOutputStream();
    toServer = new PrintWriter(new OutputStreamWriter(sout));
  }

/**
 * Deconnexion
 */

  public void deconnexion() throws IOException {
    toServer.print("$ECOM\n\r");
    toServer.flush();

    if (s != null) s.close();
    if (doLog) {
      toLog.println("\n***** deconnection from "+serveur+":"+port+", "+new java.util.Date()+" *****");
      toLog.close();
    }
  }
/*
  class Envoi extends java.lang.Thread {
    String message;
    Envoi(String message) { this.message = message; }
    public void run() {
      try { envoi(message, 5000); }
      catch (IOException e) { javax.swing.JOptionPane.showMessageDialog(null, e.getMessage()); }
    }
  }
  */
/*
  public void envoi2(String message) throws IOException {
    Envoi envoi = new Envoi(message);
    envoi.start();
  }
*/
/**
 * Envoie un message
 */

  public String envoi(String message) throws IOException {
//    boolean contin;
//    String ligne = "";
    String resultat = "";
    int ch;

    if (NOUCCI && serveur.equals(UCCI)) return ""; //************************

    if (VERBOSE) System.out.println("[Communication.envoi] ["+serveur+", "+s.getSoTimeout()
      +"ms] envoi : "+message);

    toServer.print(message);
    if (doLog) toLog.print("envoi: (timeout "+s.getSoTimeout()+")\n"+message);

    if (serveur.equals(UCCI)) {
        if (! message.substring(message.length()-2).equals(SEP_UCCI)) {
            toServer.print(SEP_UCCI);
            if (doLog) toLog.print(SEP_UCCI);
        }
      }
    else if ( /*((serveur == ZEUS) && (! message.substring(message.length()-1).equals("\n")))
                ||*/ ! message.substring(message.length()-2).equals(SEP_DEF) ) {
      toServer.print(SEP_DEF);
      if (doLog) toLog.print(SEP_DEF);
  }

    toServer.flush();
    if (doLog) toLog.flush();
/*
    contin = true;
    while ( contin ) {
      ligne = fromServer.readLine();
      if ( ligne != null )
        if ( ligne.length() > 0 )
          if ( ligne.charAt(0) == '<' ) contin = false;
    }
*/

    if (doLog) toLog.println("\nreception:");
// lecture des eventuels caracteres initiaux (\10, \13) puis de ACC_RECEP (<)
    do {
      ch = fromServer.read();
      if (doLog) toLog.print(new Character((char)ch));
    }
    while (ch != ACC_RECEP);
    //System.out.println("[Communication.envoi] accuse de reception");

// lecture des eventuels caracteres suivants (\10, \13)
    do {
      ch = fromServer.read();
      if (doLog) toLog.print(new Character((char)ch));
    }
    while (ch <= 13); //((ch!=10) && (ch!=13));
    //System.out.println("[Communication.envoi] debut de reponse");

// lecture de la chaine de reponse : rien ou "?ERR=..."
    while (ch != ACC_FIN) {
      resultat = resultat.concat(new Character((char)ch).toString());
      ch = fromServer.read();
      if (doLog) toLog.print(new Character((char)ch));
    }
    //System.out.println("[Communication.envoi] accuse de fin d'execution");

//    if (! serveur.equals(UCCI)) ligne = fromServer.readLine(); // difference entre \n\r et \r\n
/*
    resultat = fromServer.readLine();

    contin = true;
    while ( contin ) {
      ligne = fromServer.readLine();
      if ( ligne != null )
        if ( ligne.length() > 0 ) {
          if ( ligne.charAt(0) == '>' ) contin = false;
          else resultat += "\n" + ligne;
        }
    }
*/
    if (VERBOSE) System.out.println("[Communication:envoi] [" + serveur + "] resultat : "
      + resultat);

    return resultat;
  }

/**
 * Envoie une String avec le timeout specifie (en ms)
 */
  public String envoi(String message, int timeout) throws IOException {
    if (NOUCCI && serveur.equals(UCCI)) return ""; //************************
    if (s != null) s.setSoTimeout(timeout);
    return envoi(message);
  }

/**
 * Envoie une String et se deconnecte
 */
  public String envoiMessage(String message) throws IOException {
    String resultat = "";
/*
    // il faut decouper et envoyer en plusieurs parties, pour XRLC
    if (serveur.equals(UCCI)) {
      int l = 0, ind = 0;
      while ( (ind=message.indexOf(SEP_UCCI, l))>-1 ) {
        resultat += envoi(message.substring(l, ind+3));
        l = ind+3;
      }
    }
    else */
      resultat = envoi(message);

    deconnexion();

    return resultat;
  }

/**
 * Envoie une String avec le timeout specifie (en ms) et se deconnecte
 */
  public String envoiMessage(String message, int timeout) throws IOException {
    if (NOUCCI && serveur.equals(UCCI)) return ""; //************************
    if (s != null) s.setSoTimeout(timeout);
    return envoiMessage(message);
  }

/**
 * Envoie une Instruction et se deconnecte
 */
  public static void envoiInstruction(Instruction instr) throws IOException {
    String resultat;
    String machine;
    String message;
    String chaine;
    Communication communication;

    machine = instr.getMachine();
    message = instr.getScript();
    chaine = "";
    resultat = "";
    int deb = 0, fin = 0;

    if (machine.equals(UCCI)) 
      // on envoie ligne par ligne, a cause des XRLC
      while ( deb < message.length() ) {
	fin = message.indexOf('\n', deb);
	if (fin == -1) fin = message.length();
	communication = new Communication(machine);
	chaine = message.substring(deb, fin);
	chaine += Communication.SEP_UCCI;
	resultat += communication.envoiMessage(chaine);
	deb = fin+1;
      }
    else {
      while ( deb < message.length() ) {
	fin = message.indexOf('\n', deb);
	if (fin == -1) fin = message.length();
	chaine += message.substring(deb, fin);
	chaine += Communication.SEP_DEF;
	deb = fin+1;
      }
      communication = new Communication(machine);
      resultat = communication.envoiMessage(chaine);
    }
    
    if (resultat.length() > 0)
      throw new IOException("Error with "+machine+" : "+resultat);    
  }

  public static void envoiScript(ArrayList liste) throws IOException {
    System.out.println("[Communication.envoiScript] size="+liste.size());
    for (int i=0; i<liste.size(); i++) 
      envoiInstruction((Instruction)liste.get(i));
  }
}
