/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Minec-Debin
 * @version 1.0
 */

package iu;

import java.lang.*;
import java.util.*;
import java.io.*;
import java.text.*;

public class Cible implements /*Formatable,*/ Sauvegardable {
    ListeKeyword fits = UserParameters.paramFits;
    public static final String[] SYSTEM_POS = { "equatorial", "heliographic", "polar"};

    public final static int NONE = 0;
    public final static int TARGET = 1;
    public final static int FLATFIELD = 2;
    public final static int DARK = 4;
    public final static String SCRIPTACQ = "XRWACQ";

    public int indreg=0;

    public boolean extra = false;

    public int type = NONE;
/* Panneau Targets */
    public String  systemPosition = SYSTEM_POS[0];
    public String  slitOrientation = "celestial north";
    public float   scanningDirection = 0;
    public boolean lockSlit = true;
    public Keyword obj_id;
    public String  customName;
    public Keyword object;
    public Keyword comment;
    public Keyword angle;
    public boolean Xaxis = true;
    public boolean cut = true;

    public Keyword obs_mode;
    public Keyword lngstart;
    public Keyword latstart;
    public Keyword longtrc;
    public Keyword latirc;

    public Keyword step_x;
    public Keyword step_y;
    public Keyword nbstep_x;
    public Keyword nbstep_y;
    public Keyword nbstep;
    public Keyword syscoord;
    public Keyword sequence;

    public Keyword cadac;
    public Keyword ctrac;

    public int     fitsMode = 0;
    public Keyword instrume;
    public boolean cadenced = false;
    public int     nbacquisition = 20;
    public int nbAcq = 1;
    public int     cadenceTime = 0;
/* panneau dark */
    public boolean closeSpectro = false;
/* panneau flatfield */
    public int l = 45;
    public int h = 45;
    public int ang = 45;
    public boolean centered = true;
    public boolean trackingSettings = true;
/* commun */
    public boolean[] winUsed = new boolean[ ListeWindow.NB_MAX_WIN ];
    public int[] integrationTime = new int[ ListeWindow.NB_MAX_WIN ];
    public String beforeAnalyser = "";
    public String beforeOther1 = "";
    public String beforeOther2 = "";
    public String loopAnalyser = "";
    public String loopOther1 = "";
    public String loopOther2 = "";
    public ArrayList polar = new ArrayList();
/* script */
    public String scriptComment = "";
    public Date scriptDate;
    public ArrayList scriptIO = null;
    public ArrayList scriptModif = null;

  public Cible(int type) {
    String obs_modeString = "";
    object = new Keyword(UserParameters.paramFits.getKeyword("OBJECT"));
    if (type != TARGET) object.setValeur("");
    obj_id = new Keyword(UserParameters.paramFits.getKeyword("OBJ_ID"));
    instrume = new Keyword(UserParameters.paramFits.getKeyword("INSTRUME"));

    obs_mode = new Keyword(UserParameters.paramFits.getKeyword("OBS_MODE"));
    switch (type) {
      case DARK : obs_modeString = "RDARK"; break;
      case TARGET : obs_modeString = "SCAN"; break;
      case FLATFIELD : obs_modeString = "RFLAT"; break;
      default : obs_modeString = "CALIB";
    }
    obs_mode.setValeur(obs_modeString);
    lngstart = new Keyword(UserParameters.paramFits.getKeyword("LNGSTART"));
    latstart = new Keyword(UserParameters.paramFits.getKeyword("LATSTART"));
    longtrc = new Keyword(UserParameters.paramFits.getKeyword("LONGTRC"));
    latirc = new Keyword(UserParameters.paramFits.getKeyword("LATIRC"));

    customName = new String("");
    int num;//, cam;
    for (int i = 0 ; i < ListeWindow.NB_MAX_WIN ; i++) {
      num = UserParameters.acquisition.listeWin.getWin(i);
      winUsed[num] = false;
//      cam = UserParameters.acquisition.listeWin.getListe()[i].getCam();
      integrationTime[num] = 350;//UserParameters.acquisition.listeCam.getListe()[cam].defIntgTime.intValue();
    }
    this.type = type;

    step_x = new Keyword(UserParameters.paramFits.getKeyword("STEP_X"));
    step_y = new Keyword(UserParameters.paramFits.getKeyword("STEP_Y"));
    nbstep_x = new Keyword(UserParameters.paramFits.getKeyword("NBSTEP_X"));
    nbstep_y = new Keyword(UserParameters.paramFits.getKeyword("NBSTEP_Y"));
    nbstep = new Keyword(UserParameters.paramFits.getKeyword("NBSTEP"));
    syscoord = new Keyword(UserParameters.paramFits.getKeyword("SYSCOORD"));
    sequence = new Keyword(UserParameters.paramFits.getKeyword("SEQ_STOK"));
    sequence.setValeur("");
    angle = new Keyword(UserParameters.paramFits.getKeyword("ANGLE"));

    cadac  = new Keyword(UserParameters.paramFits.getKeyword("CADAC"));
    ctrac = new Keyword(UserParameters.paramFits.getKeyword("CTRAC"));
    comment = new Keyword(UserParameters.paramFits.getKeyword("COMMENT"));
  }

  private static final String sauvFormat1 = "'{'{0,number}'}' '{'{1,number}'}' '{'{2,number}'}' '{'{3,number}'}' '{'{4,number}'}' '{'{5,number}'}' '{'{6,number}'}' '{'{7,number}'}' '{'{8,number}'}' '{'{9}'}' ";
  private static final String sauvFormat2 = "'{'{0,number}'}' '{'{1,number}'}' '{'{2,number}'}' '{'{3,number}'}' '{'{4}'}' '{'{5}'}' '{'{6}'}' '{'{7}'}' '{'{8}'}' ";
  private static final String sauvFormat3 = "'{'{0,number}'}' '{'{1,number}'}' ";
  private static final String sauvFormat4 = "'{'{0,number}'}' '{'{1,number}'}' '{'{2}'}' '{'{3}'}' '{'{4}'}' '{'{5,number}'}' '{'{6,number}'}' ";
  private static final String sauvFormat5 = "'{'{0,number}'}' '{'{1,number}'}' '{'{2,number}'}' '{'{3,number}'}' '{'{4,number}'}' ";
  private static final String sauvFormat6 = "'{'{0,number}'}' '{'{1}'}' '{'{2,number}'}' ";
  private static final String sauvFormat7 = "'{'{0}'}' ";
  private static final String sauvFormat8 = "'{'{0,number}'}' ";
  private static final String sauvFormat9 = "'{'{0}'}' '{'{1}'}' ";
  private static final String sauvFormat10 = "'{'{0,date}'}' '{'{1}'}' ";


 /***********************************************************
	*********************************************************************/



  public void setObject_to_file(BufferedWriter out) throws IOException {
    Object[] info1 = { (Float)latirc.getValeur(), (Float)longtrc.getValeur(),
      (Float)latstart.getValeur(), (Float)lngstart.getValeur(),
      (Integer)nbstep_x.getValeur(), (Float)step_x.getValeur(),
      (Integer)nbstep_y.getValeur(), (Float)step_y.getValeur(),
      new Integer(Xaxis==false?0:1), (String)instrume.getValeur() };

    Object[] info2 = { new Integer(fitsMode), new Integer(cadenced==false?0:1),
      new Integer(nbacquisition), new Integer(cadenceTime),
      new String(obj_id.getValeur().toString()),
      new String(comment.getValeur().toString()),
      new String(object.getValeur().toString()), new String(obs_mode.getValeur().toString()),
      new String(customName) };

    Object[] info3 = new Object[2];

    Object[] info4 = { new Integer(closeSpectro?1:0), new Integer(cut?1:0),
      systemPosition, syscoord.getValeur(), slitOrientation,
      new Float(scanningDirection), new Integer(lockSlit?1:0) };

    Object[] info5 = { new Float(l), new Float(h), new Float(ang),
      new Integer(centered?1:0), new Integer(trackingSettings?1:0) };

    loopAnalyser = sequence.getValeur().toString();
    Object[] info6 = { new Float(angle.getValeur().toString()), loopAnalyser,
      new Integer(nbAcq) };

    Object[] info10 = { scriptDate, scriptComment };

    MessageFormat form = new MessageFormat(sauvFormat1);
    String resultat = new String(form.format(info1));
    out.write(resultat,0,resultat.length());

    form = new MessageFormat(sauvFormat2);
    resultat = new String(form.format(info2));
    out.write(resultat,0,resultat.length());

    form = new MessageFormat(sauvFormat4);
    resultat = new String(form.format(info4));
    out.write(resultat,0,resultat.length());

    form = new MessageFormat(sauvFormat5);
    resultat = new String(form.format(info5));
    out.write(resultat,0,resultat.length());

    form = new MessageFormat(sauvFormat6);
    resultat = new String(form.format(info6));
    out.write(resultat,0,resultat.length());

    form = new MessageFormat(sauvFormat8);
    resultat = form.format(new Object[] {new Integer(ListeWindow.NB_MAX_WIN)});
    out.write(resultat,0,resultat.length());

    form = new MessageFormat(sauvFormat3);
    int num;
    for(int i=0; i<ListeWindow.NB_MAX_WIN; i++) {
      num = UserParameters.acquisition.listeWin.getWin(i);
      info3[0]=new Integer(winUsed[num]?1:0);
      info3[1]=new Integer(integrationTime[num]);
      resultat = new String(form.format(info3));
      out.write(resultat,0,resultat.length());
    }

    form = new MessageFormat(sauvFormat8);
System.out.println("polar="+polar.toString());
    resultat = form.format(new Object[] {new Integer(polar.size())});
    out.write(resultat,0,resultat.length());

    form = new MessageFormat(sauvFormat7);
    for (int i=0; i<polar.size(); i++) {
//      if (polar.get(i) != null)
        resultat = form.format(new Object[] { polar.get(i).toString() });
//      else resultat = form.format(new Object[] { new String("") });
      out.write(resultat, 0, resultat.length());
    }

    form = new MessageFormat(sauvFormat8);
    if (scriptModif != null)
      resultat = form.format(new Object[] {new Integer(scriptModif.size())});
    else resultat = form.format(new Object[] {new Integer(0)});
    out.write(resultat,0,resultat.length());

    form = new MessageFormat(sauvFormat9);
    if (scriptModif != null) for (int i=0; i<scriptModif.size(); i++) {
      info3[0] = ((Instruction)scriptModif.get(i)).getMachine();
      info3[1] = ((Instruction)scriptModif.get(i)).getScript();
      resultat = new String(form.format(info3));
      out.write(resultat, 0, resultat.length());
    }

    form = new MessageFormat(sauvFormat10);
    resultat = form.format(info10);
    out.write(resultat,0,resultat.length());

    resultat = new String("\n");
    out.write(resultat,0,resultat.length());
  }

 /***********************************************************
	*********************************************************************/



  public void getObject_from_File(BufferedReader in) throws IOException {
    Object constr[];
    String tostudy;
    ParsePosition status = new ParsePosition(0);
    MessageFormat form1 = new MessageFormat("'{'{0,number}'}' ");
    MessageFormat form2 = new MessageFormat("'{'{0}'}' ");
    MessageFormat form3 = new MessageFormat("'{'{0,date}'}' ");

    tostudy = new String(in.readLine());
// info1
    constr = form1.parse(tostudy,status);
    latirc.setValeur(constr[0].toString());

    constr = form1.parse(tostudy,status);
    longtrc.setValeur(constr[0].toString());

    constr = form1.parse(tostudy,status);
    latstart.setValeur(constr[0].toString());

    constr = form1.parse(tostudy,status);
    lngstart.setValeur(constr[0].toString());

    constr = form1.parse(tostudy,status);
    nbstep_x.setValeur(constr[0].toString());

    constr = form1.parse(tostudy,status);
    step_x.setValeur(constr[0].toString());

    constr = form1.parse(tostudy,status);
    nbstep_y.setValeur(constr[0].toString());

    constr = form1.parse(tostudy,status);
    step_y.setValeur(constr[0].toString());

    constr = form1.parse(tostudy,status);
    Xaxis = Integer.parseInt(constr[0].toString())==1;

    constr = form2.parse(tostudy,status);
    instrume.setValeur(constr[0].toString());
// end of info1
// info2
    constr = form1.parse(tostudy,status);
    fitsMode = Integer.parseInt(constr[0].toString());

    constr = form1.parse(tostudy,status);
    cadenced = Integer.parseInt(constr[0].toString())==1;

    constr = form1.parse(tostudy,status);
    nbacquisition = Integer.parseInt(constr[0].toString());

    constr = form1.parse(tostudy,status);
    cadenceTime = Integer.parseInt(constr[0].toString());

    constr = form2.parse(tostudy,status);
    obj_id.setValeur(constr[0].toString());

    //pour comment : lire eventuellement sur plusieurs lignes  jusqu'a '}'
    while (tostudy.lastIndexOf("}") < status.getIndex())
      tostudy += "\n" + in.readLine();

    constr = form2.parse(tostudy,status);
    comment.setValeur(constr[0].toString());

    constr = form2.parse(tostudy,status);
    object.setValeur(constr[0].toString());

    constr = form2.parse(tostudy,status);
    obs_mode.setValeur(constr[0].toString());

    constr = form2.parse(tostudy,status);
    customName = constr[0].toString();
// end of info2
// info4
    constr = form1.parse(tostudy,status);
    closeSpectro = Integer.parseInt(constr[0].toString())==1;

    constr = form1.parse(tostudy,status);
    cut = Integer.parseInt(constr[0].toString())==1;

    constr = form2.parse(tostudy,status);
    systemPosition = constr[0].toString();

    constr = form2.parse(tostudy,status);
    syscoord.setValeur(constr[0].toString());

    constr = form2.parse(tostudy,status);
    slitOrientation = constr[0].toString();

    constr = form1.parse(tostudy,status);
    scanningDirection = Float.parseFloat(constr[0].toString());

    constr = form1.parse(tostudy,status);
    lockSlit = Integer.parseInt(constr[0].toString())==1;
// end of info4
// info5
    constr = form1.parse(tostudy,status);
    l = Integer.parseInt(constr[0].toString());

    constr = form1.parse(tostudy,status);
    h = Integer.parseInt(constr[0].toString());

    constr = form1.parse(tostudy,status);
    ang = Integer.parseInt(constr[0].toString());

    constr = form1.parse(tostudy,status);
    centered = Integer.parseInt(constr[0].toString())==1;

    constr = form1.parse(tostudy,status);
    trackingSettings = Integer.parseInt(constr[0].toString())==1;
// end of info5
// info6
    constr = form2.parse(tostudy,status);
    angle.setValeur(constr[0].toString());

    constr = form2.parse(tostudy,status);
    loopAnalyser = constr[0].toString();
    calculeSeq();

    constr = form1.parse(tostudy,status);
    nbAcq = Integer.parseInt(constr[0].toString());
// end of info6
    constr = form1.parse(tostudy,status);
//System.out.println("[Cible.getObjectFromFile] constr[0]="+constr[0].toString() +", errorIndex="+status.getErrorIndex());
    int nbWave = Integer.parseInt(constr[0].toString());
//System.out.println("[Cible.getObjectFromFile] nbWave="+nbWave);

//    status = new ParsePosition(0);
    int num;
    for(int i=0; i<nbWave; i++) {
      num = UserParameters.acquisition.listeWin.getWin(i);
      constr = form1.parse(tostudy,status);
//System.out.println("[Cible.getObjectFromFile] constr[0]="+constr[0].toString() +", errorIndex="+status.getErrorIndex());
      winUsed[num] = Integer.parseInt(constr[0].toString())==1;
      constr = form1.parse(tostudy,status);
//System.out.println("[Cible.getObjectFromFile] constr[0]="+constr[0].toString() +", errorIndex="+status.getErrorIndex());
      integrationTime[num] = Integer.parseInt(constr[0].toString());
    }

    constr = form1.parse(tostudy,status);
//System.out.println("[Cible.getObjectFromFile] constr[0]="+constr[0].toString() +", errorIndex="+status.getErrorIndex());
    int nbPol = Integer.parseInt(constr[0].toString());
//System.out.println("[Cible.getObjectFromFile] nbPol="+nbPol);

    polar = new ArrayList(nbPol);
    for(int i=0; i<nbPol; i++) {
      constr = form2.parse(tostudy,status);
//System.out.println("[Cible.getObjectFromFile] constr[0]="+constr[0].toString() +", errorIndex="+status.getErrorIndex());
      polar.add(constr[0].toString());
    }
//System.out.println("[Cible.getObjectFromFile] polar="+polar.toString());

    constr = form1.parse(tostudy,status);
//System.out.println("[Cible.getObjectFromFile] constr[0]="+constr[0].toString() +", errorIndex="+status.getErrorIndex());
    int nbScript = Integer.parseInt(constr[0].toString());
//System.out.println("[Cible.getObjectFromFile] nbScript="+nbScript);

    scriptModif = new ArrayList(nbScript);
    String machine;
    for(int i=0; i<nbScript; i++) {
      constr = form2.parse(tostudy,status);
//      System.out.println("[Cible.getObjectFromFile] machine="+constr[0].toString() +", errorIndex="+status.getErrorIndex());
      machine = constr[0].toString();
      // lire eventuellement sur plusieurs lignes  jusqu'a '}'
      while (tostudy.lastIndexOf("}") < status.getIndex())
	tostudy += "\n" + in.readLine();

      constr = form2.parse(tostudy,status);
//      System.out.println("[Cible.getObjectFromFile] script="+constr[0].toString() +", errorIndex="+status.getErrorIndex());
      scriptModif.add(new Instruction (constr[0].toString(), machine));
    }

    constr = form3.parse(tostudy,status);
    if (nbScript > 0) scriptDate = (Date)constr[0];

    //pour comment : lire eventuellement sur plusieurs lignes  jusqu'a '}'
    while (tostudy.lastIndexOf("}") < status.getIndex())
      tostudy += "\n" + in.readLine();

    constr = form2.parse(tostudy,status);
    scriptComment = constr[0].toString();
  }

 /***********************************************************
	*********************************************************************/


  public int getNbWinSelected() {
    int nbWin=0;

    for(int i=0; i<ListeWindow.NB_MAX_WIN; i++) 
      if ((UserParameters.acquisition.listeWin.getListe())[i] !=null) 
	if(winUsed[UserParameters.acquisition.listeWin.getWin(i)]) nbWin++;    
      
    return nbWin;
  }
 /***********************************************************
	*********************************************************************/

  public int getMaxIntgTime() {
    int maxIntgT=0;
    int num;
    
    for(int i=0; i<ListeWindow.NB_MAX_WIN; i++) {
      num = UserParameters.acquisition.listeWin.getWin(i);
      if ((UserParameters.acquisition.listeWin.getListe())[i] !=null) 
	if(winUsed[num]) 
	  if (integrationTime[num] > maxIntgT) 
	    maxIntgT = integrationTime[num];
    }
    return maxIntgT;
  }

 /***********************************************************
	*********************************************************************/

/**
 * Calcule la sequence d'observation : "QUV", "Q"...
 */
  public void calculeSeq() {
    if (loopAnalyser.length()==0) sequence.setValeur(beforeAnalyser);
    else sequence.setValeur(loopAnalyser);
  }
 /***********************************************************
	*********************************************************************/

  // transforme la chaine sequence pour base 2000 pas () |

  public String transformeSequence() {
    String before,after,seq_stok;
    int ind_blanc;
// System.out.println("[Cible:transformeSequence] sequence >"+sequence+"<");	

 
	seq_stok = new String(sequence.getValeur().toString());
	before = new String();
	after = new String();

	// vire les parentheses et le slash
	seq_stok = seq_stok.replace('(',' ');
	seq_stok = seq_stok.replace(')',' ');
	seq_stok = seq_stok.replace('|',' ');
	seq_stok = seq_stok.trim();
	
//System.out.println("[Cible:transformeSequence] seq_stok "+seq_stok);
	ind_blanc = seq_stok.indexOf(" ");
	while(ind_blanc != -1) {
	before = seq_stok.substring(0,ind_blanc);
	after = seq_stok.substring(ind_blanc+1).trim();
	seq_stok = before+after;
	ind_blanc = seq_stok.indexOf(" ");
	}
// System.out.println("[Cible:transformeSequence] seq_stok "+seq_stok);
	
	return(seq_stok);

    
  }

 /***********************************************************
	*********************************************************************/


  public KeywordText format(boolean wacq) throws BadValeurException {
    KeywordText format = new KeywordText(0, "");
    String keyword;
    int i, cam=0, nbwin=0;

    Integer intWin,valCam,numBuf,numRep;
    Float val;
    boolean[] obturDone;
    obturDone = new boolean[ ListeWindow.NB_MAX_WIN];//ListeCamera.NB_MAX_CAM ];
    Acquisition //acq = new Acquisition();
    acq = UserParameters.acquisition;
    int nblamb = 0; //pour indlambd
    float[] wl = new float[ListeWindow.NB_MAX_WIN];
    Window win;

    for(i=0; i<ListeWindow.NB_MAX_WIN; i++){//acq.listeWin.getNbWin(); i++) {
      win = (acq.listeWin.getListe())[i];
      if (win !=null) { 
	cam = win.getCam();
System.out.println("[Cible.format] i="+i+", cam="+cam+", winUsed="+winUsed[acq.listeWin.getWin(i)]);
	if(winUsed[acq.listeWin.getWin(i)]) {
	  intWin = new Integer(nbwin);
	  //noC++;
	  
	  // NBLIG NBCOL LIGDB COLDB VISUF ENREG
	  win.setNumero(nbwin);
	  format = format.add( (acq.listeWin.getListe()[i]).getmotcle(wacq) );
	  
	  //NOCAM
	  keyword = UserRessource.cle_nocam;
	  numRep = acq.listeCam.getListe()[cam].numRep;
	  format = format.add(Formatage.motcle(keyword,intWin,true,numRep));
	  
	  //INDLAMB
	  wl[i] = win.wavelength.floatValue();
	  int l;
	  int indl=1;
	  for (l=0; l<i; l++)
	    if (winUsed[acq.listeWin.getWin(l)]) {
	      if (wl[l]==wl[i]) { nblamb--; break; }
	      indl++;
	    }
	  nblamb++;
	  //	if (l==i) indl=nblamb;
	  //System.out.println("[Cible.format] fenetre "+i+" : wl="+wl[i]+", INDLAMBD="+indl);
	  keyword = UserRessource.cle_lambd;
	  format = format.add(Formatage.motcle(keyword,intWin,true,new Integer(indl)));
	  
	  //NOBUF
	  keyword = UserRessource.cle_nobuf;
	  numBuf = acq.listeCam.getListe()[cam].numBuffer;
	  format =format.add(Formatage.motcle(keyword,intWin,true,numBuf));
	  
	  //WAVELT
/*	keyword = UserRessource.cle_wavlt;
        valWav = acq.listeCam.getListe()[cam].wavelength;
        format = format.add(Formatage.motcle(keyword,intWin,true,valWav));*/

	  //TPCAM
	  keyword = UserRessource.cle_tpcam;
	  valCam = acq.listeCam.getListe()[cam].temperature;
	  format =format.add(Formatage.motcle(keyword,numRep,true,valCam));
	  
	  //SPECSCAL et SPATSCAL
	  keyword = UserRessource.cle_specsc;
	  val = acq.listeCam.getListe()[cam].specscal;
	  format =format.add(Formatage.motcle(keyword,intWin,true,val));
	  keyword = UserRessource.cle_spatsc;
	  val = acq.listeCam.getListe()[cam].spatscal;
	  format =format.add(Formatage.motcle(keyword,intWin,true,val));
	  
	  //OBTUR
	  if(obturDone[i] == false) {	   
	    keyword = UserRessource.cle_obtur;
	    valCam = acq.listeCam.getListe()[cam].numShutter;
	    format = format.add(Formatage.motcle(keyword,numBuf,true,valCam));	    	    
	  }

	  //DINTG
	  //if(type != DARK) {
	  intWin = new Integer(integrationTime[UserParameters.acquisition.listeWin.getWin(i)]);
	  keyword = UserRessource.cle_dintg;
	  format = format.add(Formatage.motcle(keyword,valCam,true,intWin));
	  
	  nbwin++;
	}
      }
      obturDone[i] = true;
    }

    //NBFEN
    keyword = UserRessource.cle_nbfen;
    intWin = new Integer(nbwin);
    format = format.add(Formatage.motcle(keyword,intWin,false,intWin));
    
    //NBLAMBD
    keyword = UserRessource.cle_nblambd;
    intWin = new Integer(nblamb);
    format = format.add(Formatage.motcle(keyword,intWin,false,new Integer(nblamb)));

    //NBCAM
    keyword = UserRessource.cle_nbcam;
    intWin = new Integer(getNbCamUsed());
    format = format.add(Formatage.motcle(keyword,intWin,false,intWin));

    //CADAC et CTRAC
    keyword = UserRessource.cle_cadac;
    format = format.add(Formatage.motcle(keyword, intWin, false, (Integer)cadac.getValeur()));

    keyword = UserRessource.cle_ctrac;
    format = format.add(Formatage.motcle(keyword, intWin, false, (Integer)ctrac.getValeur()));

    //NBREG a mettre dans la liste des cibles des que plusieurs cibles
    //possibles par observation
/*    keyword = UserRessource.cle_nbreg;
    intWin = new Integer(1);
    format = format.add(Formatage.motcle(keyword,intWin,false,intWin));
*/
    return( format);
  }

 /***********************************************************
	*********************************************************************/


  public int getNbCamUsed() {
    int nbcam=0;
    boolean[] camUsed = new boolean[ListeCamera.NB_MAX_CAM];
    for (int i=0; i<ListeCamera.NB_MAX_CAM; i++) camUsed[i] = false;

    for (int i=0; i<ListeWindow.NB_MAX_WIN; i++)
      if(winUsed[UserParameters.acquisition.listeWin.getWin(i)])
        try{
          camUsed[UserParameters.acquisition.listeWin.getListe()[i].getCam()] = true;
/*System.out.println("[Cible.getNbCamUsed] winUsed["+i+"], cam="
  +UserParameters.acquisition.listeWin.getListe()[i].getCam());*/ }
  catch(NullPointerException e) { /*System.err.println("[Cible.getNbCamUsed] NullPointerException i="+i)*/; }

    for (int i=0; i<ListeCamera.NB_MAX_CAM; i++)
      if(camUsed[i]) nbcam++;
    return(nbcam);
  }

 /***********************************************************
	*********************************************************************/


  public void dax1() throws java.io.IOException {
    Communication communication = new Communication(Communication.UCCI);
    String res = communication.envoiMessage("DAX1()", 25000);

    UserParameters.paramFits.getKeyword("TEMPBMSP")
      .setValeur(res.substring(res.indexOf("TH77")+5, res.indexOf("TH77")+11));
    UserParameters.paramFits.getKeyword("PREDANG")
      .setValeur(res.substring(res.indexOf("EM32")+5, res.indexOf("EM32")+11));
    UserParameters.paramFits.getKeyword("ECHELANG")
      .setValeur(res.substring(res.indexOf("EM36")+5, res.indexOf("EM36")+11));
  }

 /***********************************************************
	*********************************************************************/


  public KeywordText getmotcle(boolean wacq) throws BadValeurException {
    String keyword;
    Integer valInt,nBXY,nBX,nBY;
    KeywordText resul = new KeywordText(0, "");
    Acquisition acq = UserParameters.acquisition;

System.out.println("[Cible.getmotcle] cible={type="+type+", customName="+customName+"}");
    //MODOB = 0 par defaut
    keyword = UserRessource.cle_modob;
    valInt  = new Integer(0);
    resul = resul.add(Formatage.motcle(keyword, valInt, false, valInt));
    //THEMISFF 0 1 2 3
    keyword = UserRessource.cle_themisff;
    if (wacq) valInt = new Integer(0);
    else valInt = new Integer(fitsMode);
    resul = resul.add(Formatage.motcle(keyword, valInt, false, valInt));

    if (!wacq) {
    // NAXIS
    if(fitsMode== acq.FITS3) {
      fits.getKeyword("NAXIS").setValeur(Integer.toString(fitsMode));
    // ci-dessous : ne pas mettre naxis3 si != fits3
      if (cut) valInt = new Integer(nbacquisition/((Integer)nbstep_y.getValeur()).intValue());
      else valInt = new Integer(nbacquisition);
      resul = resul.add(Formatage.motcle(UserRessource.cle_naxis3, valInt, false, valInt));
    }
    else
      fits.getKeyword("NAXIS").setValeur(Integer.toString(2));


    //DIMPIX
    // on determine DIMPIX en fonction de DETECTOR
    Object[] valeurs = fits.getChoice("DETECTOR");
    String detector = (String)(fits.getKeyword("DETECTOR").getValeur());
    for (int i=0; i<fits.getKeyword("DETECTOR").getNbVal(); i++)
      if ( ((String)valeurs[i]).equals(detector) ) {
        fits.getKeyword("DIMPIX").setValeur(i);
        break;
      }
//    resul = resul.add(fits.getKeyword("DIMPIX").getmotcle());
/*    //TEMPBMSP
    resul = resul.add(fits.getKeyword("TEMPBMSP").getmotcle());
    //PREDANG
    resul = resul.add(fits.getKeyword("PREDANG").getmotcle());
    //ECHELANG
    resul = resul.add(fits.getKeyword("ECHELANG").getmotcle());
    //COUNT
    resul = resul.add(fits.getKeyword("COUNT").getmotcle());
*/
    // NBREG
    fits.getKeyword("NBREG").setValeur(Integer.toString(UserParameters.paramObservationStructure.getNbReg()));
    //EXTEND
    if( fitsMode == acq.FITS3)
      fits.getKeyword("EXTEND").setValeur("F");
    else fits.getKeyword("EXTEND").setValeur("T");

    if( fitsMode == acq.FITS2) {
    //XTENSION
      keyword = UserRessource.cle_xtension;
      resul = resul.add(Formatage.motcle(keyword, valInt, false, new String("IMAGE000")));
    //PCOUNT
      keyword = UserRessource.cle_pcount;
      resul = resul.add(Formatage.motcle(keyword, valInt, false, new Integer(0)));
    //GCOUNT
      keyword = UserRessource.cle_gcount;
      resul = resul.add(Formatage.motcle(keyword, valInt, false, new Integer(1)));
    }

    // STEP_X, STEP_Y,NBSTEP_X, NBSTEP_Y, NBSTEP
    /*
    fits.getKeyword("STEP_X").setValeur(step_x.getValeur().toString());
    fits.getKeyword("STEP_Y").setValeur(step_y.getValeur().toString());
    fits.getKeyword("NBSTEP_X").setValeur(nbstep_x.getValeur().toString());
    fits.getKeyword("NBSTEP_Y").setValeur(nbstep_y.getValeur().toString());
    fits.getKeyword("NBSTEP").setValeur(nbstep.getValeur().toString());
    */
    fits.getKeyword("STEP_X").setValeur(step_x.getValeur().toString());
    fits.getKeyword("STEP_Y").setValeur(step_y.getValeur().toString());
    nBX =  (Integer) (nbstep_x.getValeur());
    fits.getKeyword("NBSTEP_X").setValeur(nBX.toString());
    nBY =  (Integer) (nbstep_y.getValeur());
    fits.getKeyword("NBSTEP_Y").setValeur(nBY.toString());
    nBXY = new Integer(nBX.intValue()*nBY.intValue());
    nbstep.setValeur(nBXY.toString());
    fits.getKeyword("NBSTEP").setValeur(nbstep.getValeur().toString());

    // ANGLE
    setAngle();
    //SEQ_STOK
    fits.getKeyword("SEQ_STOK").setValeur(transformeSequence());
    //OBJ_ID
    fits.getKeyword("OBJ_ID").setValeur(obj_id.getValeur().toString());
    //OBJECT
    if (object.getValeur().toString().length() > 3)
    fits.getKeyword("OBJECT").setValeur(object.getValeur().toString().substring(0,3));
    //COMMENT
    fits.getKeyword("COMMENT").setValeur(comment.getValeur().toString());
    //OBS_MODE
    fits.getKeyword("OBS_MODE").setValeur(obs_mode.getValeur().toString());

    //LNGSTART & LATSTART, LONGTRC & LATIRC
    Coordonnees ST = new Coordonnees(((Float)lngstart.getValeur()).floatValue(),
      ((Float)latstart.getValeur()).floatValue());
    Coordonnees RC = new Coordonnees(((Float)longtrc.getValeur()).floatValue(),
      ((Float)latirc.getValeur()).floatValue());
    Coordonnees helioST=new Coordonnees(0,0), helioRC=new Coordonnees(0,0);
    try {
      if (systemPosition.equals("equatorial"))
        helioST = ST.equatToHeliog();
      else if (systemPosition.equals("polar"))
        helioST = ST.polToHeliog();
      else
        helioST = ST;
    } catch (ArithmeticException e) { helioST.X=999.99; helioST.Y=999.99; }
    fits.getKeyword("LNGSTART").setValeur(Double.toString(helioST.X));
    fits.getKeyword("LATSTART").setValeur(Double.toString(helioST.Y));

    try {
      if (systemPosition.equals("equatorial"))
        helioRC = RC.equatToHeliog();
      else if (systemPosition.equals("polar"))
        helioRC = RC.polToHeliog();
      else
        helioRC = RC;
    } catch (ArithmeticException e) { helioRC.X=999.99; helioRC.Y=999.99; }
    fits.getKeyword("LONGTRC").setValeur(Double.toString(helioRC.X));
    fits.getKeyword("LATIRC").setValeur(Double.toString(helioRC.Y));

/*    //CADAC et CTRAC
    fits.getKeyword("CADAC").setValeur(cadac.getValeur().toString());
    fits.getKeyword("CTRAC").setValeur(ctrac.getValeur().toString());*/
    //FILTERCH
//    setFilterCh();

    //les keywords tec et obs
    resul = resul.add(fits.getAllOtherKeywords());
    }

    // Formatage de Acquisition
    resul = resul.add(format(wacq));
    //END, valeur entiere sans importance.
    keyword = UserRessource.cle_end;
    valInt = new Integer(1);
    resul = resul.add(Formatage.motcle(keyword, valInt, false, valInt));

    return( resul );
  }

 /***********************************************************
	*********************************************************************/


  void setAngle() {
    float x=999.f;

    if ((type==TARGET)||(type==FLATFIELD)) {
      if (slitOrientation.equals("other")) x = ((Float)angle.getValeur()).floatValue();
      else if (slitOrientation.equals("celestial north")) x = Coordonnees.getP0();
      else if (slitOrientation.equals("solar north")) x = 0f;
      else if (slitOrientation.equals("zenith")) x = 999.f;
      else if (slitOrientation.equals("celestial equator")) x = Coordonnees.getP0()+90f;
      else if (slitOrientation.equals("solar equator")) x = 90f;
      else if (slitOrientation.equals("radial")) x = 999.f;
      else if (slitOrientation.equals("tangential")) x = 999.f;
      else System.err.println("[Cible.setAngle] pour cible="+type+"-'"+customName
        +"' : angle de prefente inconnu : '"+slitOrientation+"'");
    }
    fits.getKeyword("ANGLE").setValeur(String.valueOf(x));
  }
/*
  void setProgNum() {
    int prognum = 0;
    int seq_ind = 1;//((Integer)UserParameters.paramFits.getKeyword("SEQ_IND").getValeur()).intValue();
    String progid = (String)fits.getKeyword("PROG_ID").getValeur();
    try {
      Object constr[];
      MessageFormat formatNum = UserParameters.formatNum;
      BufferedReader in = new BufferedReader(new FileReader(UserParameters.numFile));
      String tostudy = new String(in.readLine());
      in.close();
      ParsePosition status = new ParsePosition(0);

      // lecture du fichier
      constr = formatNum.parse(tostudy, status);
      if (status.getErrorIndex()>-1)
        throw new IOException("erreur au caractere "+status.getErrorIndex());

      if ((constr[1]).toString().equals(progid)) {
        GregorianCalendar ancien = new GregorianCalendar();
        ancien.setTime((Date)constr[0]);
        GregorianCalendar aujourdhui = new GregorianCalendar();
        aujourdhui.setTime(new Date());
        int djour = aujourdhui.get(Calendar.DAY_OF_YEAR) - ancien.get(Calendar.DAY_OF_YEAR);
        prognum = ((Long)constr[2]).intValue() + djour;
        if (djour == 0) seq_ind = ((Long)constr[3]).intValue();
      }
      else prognum = 1;

      UserParameters.paramFits.getKeyword("SEQ_IND").setValeur(String.valueOf(seq_ind));
      //UserParameters.observation.obsNum = obsnum;
      fits.getKeyword("PROG_NUM").setValeur(String.valueOf(prognum));

      // ecriture sur le fichier (maj)
      BufferedWriter out = new BufferedWriter(new FileWriter(UserParameters.numFile));
      constr = new Object[] { new Date(), progid, new Integer(prognum), new Integer(seq_ind) };
      out.write(formatNum.format(constr));
      out.close();
    }
    catch (IOException e) { System.err.println(e); }
  }
*/

 /***********************************************************
	*********************************************************************/


  public static void setFilterCh() throws BadValeurException {
    Communication comm;
    String resul = "";
    Keyword filterch = UserParameters.paramFits.getKeyword("FILTERCH");
    int pos,pos2;

    try {
      comm = new Communication(Communication.UCCI);
      resul = comm.envoiMessage(((MoteurBase)UserParameters.listeMoteur.getMoteur("EM30")).pmvtecho().getScript(), 6000);
      pos = Math.round(Float.valueOf(resul.substring(7,resul.length())).floatValue());

      switch (pos) {
        // spectro 100%
      case 0 : filterch.setValeur("NONE"); break;
        // 80/20
      case -81 : comm = new Communication(Communication.UCCI);
	resul = comm.envoiMessage(((MoteurBase)UserParameters.listeMoteur.getMoteur("EM31")).pmvtecho().getScript(), 10000);
	pos2 = Math.round(Float.valueOf(resul.substring(7,resul.length())).floatValue());
	switch (pos2) {
	case 182 : filterch.setValeur("H ALPHA"); break;	
	default : throw new BadValeurException("position de EM31 inconnue : "+pos2+"mm");
	}
	break;
      case 82 : comm = new Communication(Communication.UCCI);
	resul = comm.envoiMessage(((MoteurBase)UserParameters.listeMoteur.getMoteur("EM31")).pmvtecho().getScript(), 10000);
	pos2 = Math.round(Float.valueOf(resul.substring(7,resul.length())).floatValue());
	
	if(pos2 == -58)
	  filterch.setValeur("G BAND");
	else
	  throw new BadValeurException("position de EM31 inconnue : "+pos2+"mm");
	break;

      default : throw new BadValeurException("position de EM30 inconnue : "+pos+"mm");
      }
    }
    catch (Exception e) {
      resul = (String)javax.swing.JOptionPane.showInputDialog(null,
        "The following error has occurred while retrieving FILTERCH keyword :\n"
        +e.toString()
        +"\nDo you want to continue anyway with the following value ?",
        "Error", javax.swing.JOptionPane.ERROR_MESSAGE, null,
        filterch.listeValeurpossible, filterch.getValeur());
      if (resul != null)
        filterch.setValeur(resul);
      else throw new BadValeurException(e.getMessage());
    }
//    System.out.println("[Cible.setFilterCh] FILTERCH="+fits.getKeyword("FILTERCH").getValeur());
  }

  /**
   *  @param i numero de la bande : appartient a [1, YNb] (ou [1, XNb])
   *  @return l'increment entre le start et le debut de la bande sous forme de Coordonnees
   */

 /***********************************************************
	*********************************************************************/


  private Coordonnees debutBande(int i) {
    float XInc = ((Float)(step_x.getValeur())).floatValue();
    float YInc = ((Float)(step_y.getValeur())).floatValue();
    double direction = (double)scanningDirection;
    double incT;

    /*balayage bandes horizontales*/
    if (Xaxis) {
      incT = (i-1)*YInc;
      direction += Math.PI/2;
    }
    /*balayage bandes verticales*/
    else incT = (i-1)*XInc;

    return new Coordonnees(
      incT*Math.cos(direction),
      incT*Math.sin(direction)
    );
  }
/*
  private double debutBande(int axe) {
    int XNb = ((Integer)(nbstep_x.getValeur())).intValue();
    int YNb = ((Integer)(nbstep_y.getValeur())).intValue();
    float XInc = ((Float)(step_x.getValeur())).floatValue();
    float YInc = ((Float)(step_y.getValeur())).floatValue();
    double largeur = XNb*XInc;
    double hauteur = YNb*YInc;
    double posY, posX, posY2, posX2;

    // balayage bandes horizontales
    if (Xaxis) {
      posY = -hauteur + YInc;
      posX = -largeur;
    }
    // balayage bandes verticales
    else {
      posY = -hauteur;
      posX = -largeur + XInc;
    }
    // on fait la rotation du repere
    posX2 = posX*Math.cos((double)scanningDirection) - posY*Math.sin((double)scanningDirection);
    posY2 = posX*Math.sin((double)scanningDirection) + posY*Math.cos((double)scanningDirection);

    if (axe==1) return posX2;
    else return posY2;
  }
*/
  /**
   * Dans le cas de plusieurs boucles sur le meme scan, pour ne pas avoir a
   * repeter ce script.
   */
/*  public String getScriptAvantBande(int i) throws BadValeurException {
    String reponse = "";
    String separ = Communication.SEP_UCCI;

    // pointage
    reponse += getSequenceDebutBande(i);
    // ppou
    reponse += "PPOU()" + separ;

    return reponse;
  }
*/

 /***********************************************************
	*********************************************************************/


  public String getScriptPref() throws BadValeurException {
    String reponse = "";
    String separ = "\n";//Communication.SEP_UCCI;

    /* actions avant la boucle */
    // analyseur
/*    if (loopAnalyser.length()>0) {
      if (loopAnalyser.charAt(0)=='-')
        reponse += loopAnalyser.substring(0, 2);
      else reponse += loopAnalyser.charAt(0);
      reponse += "()/PLAM()" + separ;
    }*/

    // prfente
    if ((type==TARGET)||(type==FLATFIELD)) {
      if (slitOrientation.equals("other")) reponse += pr6(((Float)angle.getValeur()).floatValue());
      else if (slitOrientation.equals("celestial north")) reponse += "PR3()";
      else if (slitOrientation.equals("solar north")) reponse += "PR1()";
      else if (slitOrientation.equals("zenith")) reponse += "PR5()";
      else if (slitOrientation.equals("celestial equator")) reponse += "PR4()";
      else if (slitOrientation.equals("solar equator")) reponse += "PR2()";
      else if (slitOrientation.equals("radial")) reponse += "PR7()";
      else if (slitOrientation.equals("tangential")) reponse += "PR8()";
      else System.err.println("[Cible.getScriptAvant] pour cible="+type+"-'"+customName+"' : angle de prefente inconnu : '"+slitOrientation+"'");
    }

    return reponse;
  }

 /***********************************************************
	*********************************************************************/


  /* ! scanningDirection doit etre en deg ! */
  /** @todo boucles imbriquees */

  String getSequenceTarget() throws BadValeurException {
    int XNb = ((Integer)(nbstep_x.getValeur())).intValue();
    int YNb = ((Integer)(nbstep_y.getValeur())).intValue();
    int nbBandes;
    String reponse = "";

    /*balayage bandes horizontales*/
    if (Xaxis) nbBandes = YNb;
    /*balayage bandes verticales*/
    else nbBandes = XNb;

    for(int b=1;b<=nbBandes;b++) {
      reponse += getSequenceDebutBande(b);
      reponse += getSequenceBande();
    }

    return reponse;
  }

 /***********************************************************
	*********************************************************************/


  String getSequenceBande() throws BadValeurException {
    int indexOfPar;
    String polarCommand;
    String scriptXRWACQ = "";

    int XNb = ((Integer)(nbstep_x.getValeur())).intValue();
    int YNb = ((Integer)(nbstep_y.getValeur())).intValue();
    float XInc = ((Float)(step_x.getValeur())).floatValue();
    float YInc = ((Float)(step_y.getValeur())).floatValue();
    String bande = "";
    String reponse = "";
    int nbPas;
    //    String seq = (String)(sequence.getValeur());
    String separ = "\n";//Communication.SEP_UCCI;
    String sysIncr = (String)syscoord.getValeur();
    Coordonnees incr;
    Polar pol;

    scanningDirection = getScanningDirection(slitOrientation,
      ((Float)angle.getValeur()).floatValue(), lockSlit, scanningDirection);
    double alpha = (double)scanningDirection * Math.PI/180.0;
    /*balayage bandes horizontales*/
    if (Xaxis) {
      incr = new Coordonnees(XInc*Math.cos(alpha), YInc*Math.sin(alpha));
      nbPas = XNb;
    }
    /*balayage bandes verticales*/
    else {
      incr = new Coordonnees(-YInc*Math.sin(alpha), XInc*Math.cos(alpha));
      nbPas = YNb;
    }

    if (nbPas>1) bande += "XRLC(" + Integer.toString(nbPas) + ",\"";
    // pas de mouvement d'analyseur


    if ((polar.size()==0)||(fits.getKeyword("ANALYS").getValeur().equals("NOANALYZER"))) {
	if( nbAcq == 1) {
	    bande += "WACQ()/";
	}
	else {
	    scriptXRWACQ = new String("XRLC("+nbAcq+",\"WACQ()\")");
	    scriptXRWACQ = "USER("+SCRIPTACQ+","+scriptXRWACQ+")"+separ;
	    bande += SCRIPTACQ+"()/";
	}
    }


    // une sequence d'analyseur ('Q', '-Q', 'QUV', 'Q-Q', etc.)
    /* version sans script user imbrique
       else for (int i=0;i<nbAcq; i++) {
       for (int j=0; j<polar.size(); j++) {
       pol = UserParameters.listePolar.getPolar((String)polar.get(j));
       
       polarCommand = (String) polar.get(j);
       indexOfPar = polarCommand.indexOf("()");
       if(indexOfPar == -1) {
       bande += ((Roue)UserParameters.listeMoteur.getMoteur("EM25")).pmvt(pol.pos1).getScript();
       bande += ":";
       bande += ((Roue)UserParameters.listeMoteur.getMoteur("EM26")).pmvt(pol.pos2).getScript();
       }
       else {
       bande += polarCommand.replace('+',' ');
       } 
       if (fitsMode != Acquisition.FITS3)
       bande += "/PLAM()";
       bande += "/WACQ()/";
       }
       }
    */
    else {
      for (int j=0; j<polar.size(); j++) {
	pol = UserParameters.listePolar.getPolar((String)polar.get(j));
		
	polarCommand = (String) polar.get(j);
	indexOfPar = polarCommand.indexOf("()");
	if(indexOfPar == -1) {
	  scriptXRWACQ += ((Roue)UserParameters.listeMoteur.getMoteur("EM25")).pmvt(pol.pos1).getScript();
	  scriptXRWACQ += ":";
	  scriptXRWACQ += ((Roue)UserParameters.listeMoteur.getMoteur("EM26")).pmvt(pol.pos2).getScript();
	}
	else {
	  scriptXRWACQ += polarCommand.replace('+',' ');
	} 
	if (fitsMode != Acquisition.FITS3)
	  scriptXRWACQ += "/PLAM()";
	scriptXRWACQ += "/WACQ()/";
      }
      if(nbAcq == 1) {	    
	bande += scriptXRWACQ;
	scriptXRWACQ = "";
      }
      else {
	scriptXRWACQ = scriptXRWACQ.substring(0,scriptXRWACQ.length()-1);
	scriptXRWACQ = "XRLC("+nbAcq+",\""+scriptXRWACQ+"\"";
	scriptXRWACQ = "USER("+SCRIPTACQ+","+scriptXRWACQ+"))"+separ;
	bande += SCRIPTACQ+"()/";
      }
    }
    if (sysIncr.equals("EQUATORIAL")) bande += eqc(incr);
    else if (sysIncr.equals("AZIMUTHAL")) bande += azc(incr);
    else if (sysIncr.equals("HELIOGRAPHIC")) bande += hlc(incr);
    else if (sysIncr.equals("HELIOCENTRIC")) bande += helioc_inc(incr);
    if (fitsMode != Acquisition.FITS3) {
      bande += ":STEP():PAS"+(Xaxis?"X":"Y");
      bande += "()/PPOU()";
    }
    if (nbPas > 1) bande += "\")";
    reponse += bande+separ;
    if ((fitsMode != Acquisition.FITS3) || (cut)) {
      reponse += "PAS"+(Xaxis?"Y":"X")+"():ASTE("+(Xaxis?"0,-1":"-1,0")+")";
//      reponse += "PAS"+(Xaxis?"Y":"X")+"()/LAMBDA("+(Xaxis?0:1)+")";
      /* ci-dessus : temporaire - il faudra utiliser affstep() */
      reponse += separ;
    }

    return reponse;
  }


 /***********************************************************
	*********************************************************************/

  String getSequenceDark() {
    String reponse = "";
//    reponse += "PPOU()" + Communication.SEP_UCCI;
    reponse += "XRLC("+nbacquisition+",\"";
    reponse += "WACQ()";
    if(fitsMode != Acquisition.FITS3)
      reponse += "/STEP()\")";
    else
      reponse += "\")";
    return reponse;
  }

 /***********************************************************
	*********************************************************************/

  String getSequenceFlat(String anal) {
    String reponse = "";
    String separ = "\n";//Communication.SEP_UCCI;

  //  reponse += "PPOU()" + separ;
    reponse += fla(l, h, ang) + separ;

/*    if (anal.length()!=0) reponse += anal+"()" + separ;
    reponse += "PLAM()" + separ;
    ces commandes sont envoyees avant les mots cles, dans ProgObservation.run
*/
    reponse += "XRLC("+nbacquisition+",\"";
    reponse += "WACQ()";

    if(fitsMode != Acquisition.FITS3)
      reponse += "/STEP()\")/";
    else
      reponse += "\")/";

    reponse += equ(new Coordonnees(0d,0d));
    return reponse;
  }

  String getSequenceUCCI() throws BadValeurException {
    switch(type) {
      case TARGET : return getSequenceTarget();
      case DARK : return getSequenceDark();
      case FLATFIELD : return getSequenceFlat((String)sequence.getValeur());
      default : return "";
    }
  }

/**
 *  @return la direction de scanning, en radians
 */

  public static float getScanningDirection(String slitOrient, float slitAng,
                                    boolean perpSlit, float scanDir) {
    float f;

    if (slitOrient.equals("celestial north")) f= 0.f;
    else if (slitOrient.equals("solar north")) f= 0.f;
    else if (slitOrient.equals("celestial equator")) f= 90.f;
    else if (slitOrient.equals("solar equator")) f= 90.f;
    else if (slitOrient.equals("other")) f= slitAng;
    else {
      f= 0.f;
//      System.out.println("Attention : la direction de scanning ne va pas changer.");
    }
    if (!perpSlit) f += scanDir;

    if (f > 180.f) f -= 180.f;
    if (f < -180.f) f += 180.f;

    return new Double(Math.toRadians(f)).floatValue();
  }

  String getSequencePointage() throws BadValeurException {
    String posCentre = "";
    Coordonnees C;

    if(type != FLATFIELD)
      C = new Coordonnees(((Float)lngstart.getValeur()).floatValue(),
			  ((Float)latstart.getValeur()).floatValue());
    else
      C = new Coordonnees(((Float)longtrc.getValeur()).floatValue(),
			  ((Float)latirc.getValeur()).floatValue());

    if (systemPosition.equals(SYSTEM_POS[0])) posCentre = equ(C);
    else if (systemPosition.equals(SYSTEM_POS[1])) posCentre = hlg(C);
    else if (systemPosition.equals(SYSTEM_POS[2])) posCentre = pos(C);
    else throw new BadValeurException("mauvais systme de coordonnes : "+systemPosition);

//    posCentre += "\n";//Communication.SEP_UCCI;

    return posCentre;
  }

 /***********************************************************
	*********************************************************************/


  String getSequenceDebutBande(int i) throws BadValeurException {
    String sysIncr = (String)syscoord.getValeur();
    String separ = "\n";//Communication.SEP_UCCI;
    String reponse = "";
    Polar pol;

//    if (i>1) { // pas besoin de bouger si i=1 (start)
      reponse += getSequencePointage()+"\n";
      if (sysIncr.equals("EQUATORIAL")) reponse += eqc(debutBande(i))+separ;
      else if (sysIncr.equals("AZIMUTHAL")) reponse += azc(debutBande(i))+separ;
      else if (sysIncr.equals("HELIOGRAPHIC")) reponse += hlc(debutBande(i))+separ;
      else if (sysIncr.equals("HELIOCENTRIC")) reponse += helioc_inc(debutBande(i))+separ;
      // si fits<3 ou 1file/X : PPOU
//      if ((fitsMode != Acquisition.FITS3) || cut)
	reponse += "PPOU()"+separ;
	if ((fitsMode == Acquisition.FITS3)&&(polar.size()!=0)) {
        	
        pol = UserParameters.listePolar.getPolar((String)polar.get(0));

	if(pol.name.indexOf("()")== -1) {
           reponse +=(((Roue)UserParameters.listeMoteur.getMoteur("EM25")).pmvt(pol.pos1)).getScript()+separ;
           reponse +=(((Roue)UserParameters.listeMoteur.getMoteur("EM26")).pmvt(pol.pos2)).getScript()+separ;
	}
	else {
    	reponse += pol.name.replace('+',' ')+separ;
	}
	reponse += "PLAM()"+separ;
	}
//    System.out.print("[Cible.getSequenceDebutBande] i="+i+", message="+reponse);
//    }

    return reponse;
  }


 /***********************************************************
	*********************************************************************/

/*
  int getLambda() {
  // Calcule le nombre de longueurs d'onde differentes
    int param = 1;
    for (int i=0; i<ListeCamera.NB_MAX_CAM; i++)
      if ( camUsed[i] )
        for (int j=i+1; j<ListeCamera.NB_MAX_CAM; j++)
          if ( camUsed[j] && ( UserParameters.acquisition.listeCam.getListe()[i].wavelength
            .compareTo(UserParameters.acquisition.listeCam.getListe()[j].wavelength)!=0 ) )
            param++;
    return param;
  }*/

  static String hlg(Coordonnees C) {
    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    DecimalFormat formatX = new DecimalFormat("+000.00;-000.00");
    decimalFormatSymbols.setDecimalSeparator('.');
    formatX.setDecimalFormatSymbols(decimalFormatSymbols);
    return new String("HLG("+formatX.format(C.X)+","+formatX.format(C.Y)+")");
  }

  static String hlc(Coordonnees C) {
    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    DecimalFormat formatX = new DecimalFormat("+000.00;-000.00");
    decimalFormatSymbols.setDecimalSeparator('.');
    formatX.setDecimalFormatSymbols(decimalFormatSymbols);
    return new String("HLC("+formatX.format(C.X)+","+formatX.format(C.Y)+")");
  }

  static String helioc_inc(Coordonnees C) {
    return eqc(C.heliocToEquat());
  }

  static String equ(Coordonnees C) {
    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    DecimalFormat formatX = new DecimalFormat("+0000.0;-0000.0");
    decimalFormatSymbols.setDecimalSeparator('.');
    formatX.setDecimalFormatSymbols(decimalFormatSymbols);
    return new String("EQU("+formatX.format(C.X)+","+formatX.format(C.Y)+")");
  }

  static String eqc(Coordonnees C) {
    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    DecimalFormat formatX = new DecimalFormat("+0000.0;-0000.0");
    decimalFormatSymbols.setDecimalSeparator('.');
    formatX.setDecimalFormatSymbols(decimalFormatSymbols);
    return new String("EQC("+formatX.format(C.X)+","+formatX.format(C.Y)+")");
  }

  static String pos(Coordonnees C) {
    return equ(C.polToEquat());
/*    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    DecimalFormat formatX = new DecimalFormat("+000.00;-000.00");
    DecimalFormat formatY = new DecimalFormat("+0000.0;-0000.0");
    decimalFormatSymbols.setDecimalSeparator('.');
    formatX.setDecimalFormatSymbols(decimalFormatSymbols);
    formatY.setDecimalFormatSymbols(decimalFormatSymbols);
    return new String("HAL()/POS("+formatX.format(C.X)+","+formatY.format(C.Y)+")");*/
  }

  static String azc(Coordonnees C) {
    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    DecimalFormat formatX = new DecimalFormat("00000.0");
    decimalFormatSymbols.setDecimalSeparator('.');
    formatX.setDecimalFormatSymbols(decimalFormatSymbols);
    return new String("AZC("+formatX.format(C.X)+","+formatX.format(C.Y)+")");
  }

  static String fla(double x, double y, double z) {
    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    DecimalFormat format1 = new DecimalFormat("000.");
    DecimalFormat format2 = new DecimalFormat("+000.");
    decimalFormatSymbols.setDecimalSeparator('.');
    format1.setDecimalFormatSymbols(decimalFormatSymbols);
    format2.setDecimalFormatSymbols(decimalFormatSymbols);
    return new String("FLA("+format1.format(x)+","+format1.format(y)+","+format2.format(z)+")");
  }

  static String pr6(float x) {
    DecimalFormat form = new DecimalFormat("+000.00;-000.00");
    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    decimalFormatSymbols.setDecimalSeparator('.');
    form.setDecimalFormatSymbols(decimalFormatSymbols);
    return "PR6("+form.format(x)+")";
  }

  public boolean checkCameras() {
    for (int i=0; i<ListeWindow.NB_MAX_WIN ; i++)
      if (winUsed[UserParameters.acquisition.listeWin.getWin(i)]) return true;
    return false;
  }

  public boolean isCooled() {
    for (int i=0; i<ListeWindow.NB_MAX_WIN ; i++)
      if (winUsed[UserParameters.acquisition.listeWin.getWin(i)]) {
        Camera cam = UserParameters.acquisition.listeCam.listeCamera
          [UserParameters.paramWindowsConf.tableWindows[i].camera];
//System.out.println("[Cible.isCooled] win"+i+", cam="+cam.numRep+", temperature="
//  +cam.temperature+", cooled="+cam.cooled);
        if (cam.temperature.intValue()!=cam.cooled) return false;
      }
    return true;
  }

  private String closeObt(boolean closeAll, boolean ouvert) {
    String message = "";
    boolean[] shutter = new boolean[Observation.NB_MAX_OBTU];

    if (!closeAll)
      message += "$COBT(0,"+(ouvert?"1":"0")+")";
    else {
      for (int i=0; i<Observation.NB_MAX_OBTU; i++) shutter[i]=false;

      ListeCamera listeC = UserParameters.acquisition.listeCam;
      int obt;
      for(int i=0; i<listeC.getNbCam(); i++) {
        obt = (listeC.getListe())[i].numShutter.intValue();
	if (!shutter[obt]) {
	  message += "$COBT("+obt+","+(ouvert?"1":"0")+")"+"\n";//Communication.SEP_DEF;
	  shutter[obt] = true;
	}
      }
    }
    return message;
  }

  public Instruction index() {
    String ch;
    ch = "$INDE("+UserParameters.paramFits.getKeyword("SEQ_IND").getValeur()
      .toString()+",";
    if (type == TARGET) ch += Integer.toString(indreg);
    else ch += "1";
    ch += ")";
    return new Instruction(ch, Communication.VME);
  }

 /***********************************************************
	*********************************************************************/

  public void genereScript() throws BadValeurException {
    ParamObservationStructure structure = UserParameters.paramObservationStructure;
    Observation observation = UserParameters.observation;

    String ch,seqstokFlat,keyword,oldsequence;
    KeywordText listKeyword = new KeywordText(0,"");
	
    scriptIO = new ArrayList();

    ch = getScriptPref();
    if (ch.length()>0) ch+= "/";
    if (type == Cible.FLATFIELD)
      ch += getSequencePointage()+"/";
    ch += "DAX1()/PPOU()"; 
    scriptIO.add(new Instruction(ch, Communication.UCCI));

    KeywordText keywordText = getmotcle(false);
    ch = "$MCLE("+keywordText.nbLignes+")"+"\n";//Communication.SEP_DEF;
    ch += keywordText.texte;
    
/**
 *  attention : le mot cle seq_stok ne sera pas mis a jour a chaque mouvement
 *    d'analyseur...
 **/

    switch (type) {
      case Cible.DARK :
	scriptIO.add(new Instruction(ch, Communication.ZEUS));
        scriptIO.add(new Instruction("$DEC2", Communication.ZEUS));
        scriptIO.add(new Instruction(closeObt(!closeSpectro, false), Communication.VME));
        scriptIO.add(new Instruction(getSequenceDark(), Communication.UCCI));
        scriptIO.add(new Instruction(closeObt(!closeSpectro, true), Communication.VME));
        break;
      case Cible.TARGET :
	scriptIO.add(new Instruction(ch, Communication.ZEUS));
        if (!cut) {
          scriptIO.add(new Instruction(getSequenceDebutBande(1), Communication.UCCI));
          if (fitsMode == Acquisition.FITS3) 
            scriptIO.add(new Instruction("PPOU()", Communication.UCCI));	  
          scriptIO.add(new Instruction("$DEC2", Communication.ZEUS));
          scriptIO.add(new Instruction(getSequenceTarget(), Communication.UCCI));

        } else {
          int nbBandes = ((Integer)(Xaxis?nbstep_y:nbstep_x).getValeur()).intValue();
          for (int i=1; i<=nbBandes; i++) {
	    scriptIO.add(new Instruction(getSequenceDebutBande(i), Communication.UCCI));
            scriptIO.add(new Instruction("$DEC2", Communication.ZEUS));
            scriptIO.add(new Instruction(getSequenceBande(), Communication.UCCI));

          }  // for
        } // else
        break;
      case Cible.FLATFIELD :
        if ((polar.size()==0)||(fits.getKeyword("ANALYS").getValeur().equals("NOANALYZER"))) {

	  keywordText = getmotcle(false);
	  ch = "$MCLE("+keywordText.nbLignes+")"+"\n";//Communication.SEP_DEF;
	  ch += keywordText.texte;
	  scriptIO.add(new Instruction(ch, Communication.ZEUS));
          scriptIO.add(new Instruction("$DEC2", Communication.ZEUS));
          scriptIO.add(new Instruction(getSequenceFlat(""), Communication.UCCI));
        } else 	
	  for (int j=0; j<polar.size(); j++) {

	    Polar pol = UserParameters.listePolar.getPolar((String)polar.get(j));


	    if(pol.name.indexOf("()")== -1) {
	      scriptIO.add( ((Roue)UserParameters.listeMoteur.getMoteur("EM25")).pmvt(pol.pos1));
	      scriptIO.add( ((Roue)UserParameters.listeMoteur.getMoteur("EM26")).pmvt(pol.pos2));
	      scriptIO.add(new Instruction("PLAM()", Communication.UCCI));
	      
	    }
	    else {
	      scriptIO.add(new Instruction(pol.name.replace('+',' ')+"/PLAM()", Communication.UCCI));
	      if(j!=0) // car le pointage est deja fait pour la premiere position
		scriptIO.add(new Instruction(getSequencePointage(),Communication.UCCI));
	      oldsequence = new String(sequence.getValeur().toString());
	      seqstokFlat = new String(pol.name.replace('(',' '));
	      seqstokFlat = seqstokFlat.replace(')',' ').toUpperCase();
	      sequence.setValeur(seqstokFlat);
	
	      keywordText = getmotcle(false);
	      ch = "$MCLE("+keywordText.nbLignes+")"+"\n";//Communication.SEP_DEF;
	      ch += keywordText.texte;
	      scriptIO.add(new Instruction(ch, Communication.ZEUS));
	      sequence.setValeur(oldsequence);
	  
	    }
	    
	    scriptIO.add(new Instruction("$DEC2", Communication.ZEUS));	
	    scriptIO.add(new Instruction(getSequenceFlat(pol.name), Communication.UCCI));
	  }
	
        break;
    } // switch

  }
/**
 * @param i : l'indice de cible dans la liste
 **/
  public String getDesc(int i) {
    switch (type) {
      case TARGET : return obs_mode.getValeur()+" - "+Integer.toString(i+1)+" - "+customName;
      case FLATFIELD : return "FLAT FIELD - "+Integer.toString(i+1)+" - "+customName;
      case DARK : return "DARK CURRENT - "+Integer.toString(i+1)+" - "+customName;
    }
    return null;
  }
}
