/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */
package iu;

import java.awt.*;
import java.awt.event.*;
import java.text.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.AbstractTableModel;

public class CameraPanel extends JPanel {
  JButton jButtonIns = new JButton("ins");
  JButton jButtonDel = new JButton("del");
  JButton jButtonTemp = new JButton("start cam cooling");
  JButton jButtonBuff = new JButton("get buffers/cam");

  JLabel jLabelSettings = new JLabel("Spectral scaling setting");
  JButton jButtonScal = new JButton("set spec scale");
  JButton jButtonGetImg = new JButton("get image");
  JLabel jLabelTime = new JLabel("Integration time (ms)");
  JTextField jTextFieldTime = new JTextField("350");
  JLabel jLabelRef = new JLabel("Reference wavelengths (\u00C5)");
  JLabel jLabel1 = new JLabel("1 (left-click) :");
  JTextField jTextField1 = new JTextField("4000");
  JLabel jLabel2 = new JLabel("2 (right-click) :");
  JTextField jTextField2 = new JTextField("6000");
  DrawPanel drawPanel = new DrawPanel();
  JPanel scalPanel = new JPanel();

  JPanel jPanelCameras = new JPanel();
  JPanel jPanelTools = new JPanel();
  BorderLayout borderLayoutThis = new BorderLayout();
  JScrollPane jScrollPaneCameras = new JScrollPane();
  JTable jTableCameras;// = new JTable();
  GridBagLayout gridBagLayoutCameras = new GridBagLayout();
  GridBagLayout gridBagLayoutScal = new GridBagLayout();
  CameraTableModel cameraTableModel;
  final static String[] ATTRIB_LIST = {"none","I+Stokes","I-Stokes"};
  JComboBox jComboBoxAttrib = new JComboBox(ATTRIB_LIST);

  public CameraPanel() {
    try { jbInit(); }
    catch(Exception e) { e.printStackTrace(); }
  }

  private void jbInit() throws Exception {
    initComponents();

    drawPanel.setBackground(Color.black);
    jTextFieldTime.setMinimumSize(new Dimension(40, 25));
    jTextFieldTime.setPreferredSize(new Dimension(40, 25));
    jTextField1.setMinimumSize(new Dimension(50, 25));
    jTextField1.setPreferredSize(new Dimension(50, 25));
    jTextField2.setMinimumSize(new Dimension(50, 25));
    jTextField2.setPreferredSize(new Dimension(50, 25));
    jLabel1.setForeground(SystemColor.red);
    jLabel2.setForeground(SystemColor.blue);

    jPanelCameras.setLayout(gridBagLayoutCameras);
    this.setLayout(borderLayoutThis);

    jPanelTools.add(jButtonIns);
    jPanelTools.add(jButtonDel);
    jPanelTools.add(jButtonTemp);
    jPanelTools.add(jButtonBuff);
    this.add(jPanelTools, BorderLayout.NORTH);//new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5,5,5,5), 0, 0));

    jPanelCameras.add(jScrollPaneCameras, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0,
      GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    this.add(jPanelCameras, BorderLayout.CENTER);//new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5,5,5,5), 0, 0));

    scalPanel.setLayout(gridBagLayoutScal);
    scalPanel.add(drawPanel, new GridBagConstraints(0, 0, 1, 5, 1.0, 1.0,
      GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5,5,5,5), 
      ParamWindowsConf.XMAX-10, ParamWindowsConf.YMAX-10));
    scalPanel.add(jLabelSettings, new GridBagConstraints(1, 0, 3, 1, 1.0, 1.0,
      GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
    scalPanel.add(jLabelTime, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0,
      GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
    scalPanel.add(jTextFieldTime, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0,
      GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
    scalPanel.add(jButtonGetImg, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0,
      GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
    scalPanel.add(jLabelRef, new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0,
      GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
    scalPanel.add(jLabel1, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0,
      GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
    scalPanel.add(jTextField1, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0,
      GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
    scalPanel.add(jLabel2, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0,
      GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
    scalPanel.add(jTextField2, new GridBagConstraints(2, 4, 1, 1, 1.0, 1.0,
      GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
    scalPanel.add(jButtonScal, new GridBagConstraints(3, 3, 1, 2, 1.0, 1.0,
      GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
    this.add(scalPanel, BorderLayout.SOUTH);
  }

  private void initComponents() {
    jButtonDel.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        cameraTableModel.delete(jTableCameras.getSelectedRow());
      }
    });
    jButtonIns.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        if (jTableCameras.getSelectedRow() < cameraTableModel.nbRow - 1)
          cameraTableModel.insert(jTableCameras.getSelectedRow());
      }
    });
    jButtonTemp.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { envoiTemp(); }
    });
    jButtonBuff.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { testCam(); }
    });
    jButtonScal.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { 
        if (jTableCameras.getSelectedRow() != -1)
          scal(jTableCameras.getSelectedRow());
        else {
	AppIU.setStatus("No line selected."); 
        JOptionPane.showMessageDialog(null, "No line selected.","Error", JOptionPane.ERROR_MESSAGE);
        }	
      }
    });
    jButtonGetImg.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { 
        if (jTableCameras.getSelectedRow() != -1) {
          getTable();
          getImg(jTableCameras.getSelectedRow());
	}
        else {
	AppIU.setStatus("No line selected."); 
        JOptionPane.showMessageDialog(null, "No line selected.","Error", JOptionPane.ERROR_MESSAGE);
	}
      }
    });

    cameraTableModel = new CameraTableModel();
    setTable();
    jTableCameras = new JTable(cameraTableModel);
    jTableCameras.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(jComboBoxAttrib));
    cameraTableModel.addTableModelListener(new TableModelListener() {
      public void tableChanged(TableModelEvent e) { cameraTableModel_tableChanged(e); }
    });
//    jPanelCameras.setMinimumSize(new Dimension(800, 200));
    javax.swing.table.TableColumnModel cols = jTableCameras.getColumnModel();
    jTableCameras.setPreferredScrollableViewportSize(new Dimension(800, 600));
    jTableCameras.sizeColumnsToFit(-1);

    cols.getColumn(0).setPreferredWidth(100);
    cols.getColumn(1).setPreferredWidth(120);
    cols.getColumn(2).setPreferredWidth(120);
    cols.getColumn(3).setPreferredWidth(180);
    cols.getColumn(4).setPreferredWidth(120);
    cols.getColumn(5).setPreferredWidth(180);
    cols.getColumn(6).setPreferredWidth(160);
    cols.getColumn(7).setPreferredWidth(160);

    jScrollPaneCameras.getViewport().add(jTableCameras, null);
  }

  private void setTable() {
    ListeCamera paramCamera = UserParameters.acquisition.listeCam;
    System.out.println("CameraPanel:setTable, nbCam = " + paramCamera.getNbCam());
    for ( int i = 0 ; i < paramCamera.getNbCam(); i++ ) {
	
      cameraTableModel.data[ i ][ 0 ] = new Integer(paramCamera.listeCamera[i].numRep.intValue());
      cameraTableModel.data[ i ][ 1 ] = new Integer(paramCamera.listeCamera[i].numBuffer.intValue());
      cameraTableModel.data[ i ][ 2 ] = new Integer(paramCamera.listeCamera[i].numShutter.intValue());
      cameraTableModel.data[ i ][ 3 ] = new Float(paramCamera.listeCamera[i].wavelength.floatValue());
      cameraTableModel.data[ i ][ 4 ] = new String(paramCamera.listeCamera[i].stokesType);
      cameraTableModel.data[ i ][ 5 ] = new Integer(paramCamera.listeCamera[i].temperature.intValue());
      cameraTableModel.data[ i ][ 6 ] = new Float(paramCamera.listeCamera[i].specscal.floatValue());
      cameraTableModel.data[ i ][ 7 ] = new Float(paramCamera.listeCamera[i].spatscal.floatValue());
      cameraTableModel.data[ i ][ 8 ] = new Integer(paramCamera.listeCamera[i].cooled);
    }
    cameraTableModel.nbRow = paramCamera.getNbCam() + 1;
    cameraTableModel.init(cameraTableModel.nbRow-1);
    cameraTableModel.fireTableDataChanged();
  }

  private void scal(int cam) {
    float specscal = 0.f;
    float x1 = drawPanel.x1;
    float x2 = drawPanel.x2;
    int pix[] = Utils.getPix();
    int w = ParamWindowsConf.XMAX;//, l = ParamWindowsConf.YMAX;
    int m = w * drawPanel.y;
    int y1, y2, y3, y4, y5;
    float a, b;

System.out.println("[CameraPanel.scal] (valeurs initiales) x1="+x1+", x2="+x2
  +", y="+drawPanel.y);

  // l'ordonnee est la somme de 3 valeurs (m-1), m, (m+1), pour reduire le bruit
  
  // ajustement au pixel adjacent
    y1 = pix[m-w+(int)x1  ] + pix[m+(int)x1  ] + pix[m+w+(int)x1  ];
//    y2 = pix[m-w+(int)x1-2] + pix[m+(int)x1-2] + pix[m+w+(int)x1-2];
    y3 = pix[m-w+(int)x1-1] + pix[m+(int)x1-1] + pix[m+w+(int)x1-1];
    y4 = pix[m-w+(int)x1+1] + pix[m+(int)x1+1] + pix[m+w+(int)x1+1];
//    y5 = pix[m-w+(int)x1+2] + pix[m+(int)x1+2] + pix[m+w+(int)x1+2];
    if ((y3 < y1)&&(y3 < y4)) x1--;
    else if (y4 < y1) x1++;
    
    y1 = pix[m-w+(int)x2  ] + pix[m+(int)x2  ] + pix[m+w+(int)x2  ];
//    y2 = pix[m-w+(int)x2-2] + pix[m+(int)x2-2] + pix[m+w+(int)x2-2];
    y3 = pix[m-w+(int)x2-1] + pix[m+(int)x2-1] + pix[m+w+(int)x2-1];
    y4 = pix[m-w+(int)x2+1] + pix[m+(int)x2+1] + pix[m+w+(int)x2+1];
//    y5 = pix[m-w+(int)x2+2] + pix[m+(int)x2+2] + pix[m+w+(int)x2+2];
    if ((y3 < y1)&&(y3 < y4)) x2--;
    else if (y4 < y1) x2++;
System.out.println("[CameraPanel.scal] (ajustement au pixel adjacent) x1="+x1+", x2="+x2);

  // interpolation d'ordre 2 : f(x)=a*x^2+b*x+c
    y1 = pix[m-w+(int)x1  ] + pix[m+(int)x1  ] + pix[m+w+(int)x1  ];
    y2 = pix[m-w+(int)x1-1] + pix[m+(int)x1-1] + pix[m+w+(int)x1-1];
    y3 = pix[m-w+(int)x1+1] + pix[m+(int)x1+1] + pix[m+w+(int)x1+1];
    a = (y2+y3)/2-y1;
    b = (y3-y1)-a*(2*x1+1);
    x1 = -b/(2*a);

    y1 = pix[m-w+(int)x2  ] + pix[m+(int)x2  ] + pix[m+w+(int)x2  ];
    y2 = pix[m-w+(int)x2-1] + pix[m+(int)x2-1] + pix[m+w+(int)x2-1];
    y3 = pix[m-w+(int)x2+1] + pix[m+(int)x2+1] + pix[m+w+(int)x2+1];
    a = (y2+y3)/2-y1;
    b = (y3-y1)-a*(2*x2+1);
    x2 = -b/(2*a);

System.out.println("[CameraPanel.scal] (interpolation d'ordre 2) x1="+x1+", x2="+x2);
    specscal = (Float.parseFloat(jTextField1.getText())
      -Float.parseFloat(jTextField2.getText())) / (x1-x2);
    
    cameraTableModel.data[cam][6] = new Float(specscal);
    cameraTableModel.fireTableDataChanged();
    jTableCameras.setRowSelectionInterval(cam, cam);
  }
 
  private void getImg(int cam) {
    AppIU.setStatus("Getting image for camera "+cam+"...");
    try {
      int numWin = ListeWindow.NB_MAX_WIN-1; // cette window est instanciee des le depart, cf ListeWindow()
      UserParameters.acquisition.listeWin.getListe()[numWin].setCam(cam);
      UserParameters.acquisition.listeWin.getListe()[numWin].setNumero(numWin);
      
      ProgObservation.acquisition(numWin, Integer.parseInt(jTextFieldTime
        .getText()));
      drawPanel.im = Utils.getImage();
      drawPanel.repaint();
    }
    catch (Exception e) { 
      AppIU.setStatus("Error : "+e.getMessage());
      JOptionPane.showMessageDialog(null, "Exception, see message in status bar.","Error", JOptionPane.ERROR_MESSAGE);
      e.printStackTrace();
    }
    //IOException, BadValeurException
  }

  private void getTable() throws NumberFormatException {
    int i=0;
    ListeCamera paramCamera = UserParameters.acquisition.listeCam;
    Object[] ligne;
try {
    for ( i = 0 ; i < cameraTableModel.getRowCount() -1 ; i++ ) {
      ligne = cameraTableModel.data[i];
System.out.println("[CameraPanel:getTable] "+ ligne[0].toString()+" "+ligne[1].toString());
       
      paramCamera.listeCamera[i] = new Camera( Integer.parseInt(ligne[2].toString()),
        Integer.parseInt(ligne[1].toString()), Integer.parseInt(ligne[0].toString()),
        Integer.parseInt(ligne[5].toString()), Float.parseFloat(ligne[3].toString()),
        Float.parseFloat(ligne[7].toString()), ligne[4].toString(),
        Float.parseFloat(ligne[6].toString()), 0, Integer.parseInt(ligne[8].toString()));
    }
} catch (NumberFormatException e) { throw new NumberFormatException("camera line "+i+" : "+e.getMessage()); }
    paramCamera.nbCamera = cameraTableModel.getRowCount() - 1;
    if (paramCamera.nbCamera == 0) paramCamera.nbCamera = 1;
  System.out.println("[CameraPanel:getTable] paramCamera.nbCamera=" + paramCamera.getNbCam());
  }

  public void gainedFocus() {
    System.out.println("[CameraPanel:gainedFocus]");	
    setTable();
    drawPanel.repaint();

  }

  public void lostFocus() throws NumberFormatException {
    JTextField component;
    int row,column;
    System.out.println("[CameraPanel:lostFocus] editing ? "+jTableCameras.isEditing());    
  
      if(jTableCameras.isEditing()) {
	row = jTableCameras.getEditingRow();
	column = jTableCameras.getEditingColumn();
	component = (JTextField) jTableCameras.getEditorComponent();
	if((column <3)||(column ==5))
	  jTableCameras.setValueAt(new Integer(Integer.parseInt(component.getText())),row,column);
	else
	  jTableCameras.setValueAt(new Float(Float.parseFloat(component.getText())),row,column);
	  
	// System.out.println("[CameraPanel:lostFocus] editing at"+row+" "+column+" "+component.getText());
      }

    //cameraTableModel.fireTableCellUpdated(0, 0);
      //cameraTableModel.fireTableCellUpdated(0, 1);
      getTable();
  }

  private void testCam() {
    try {
      Communication communication = new Communication(Communication.VME);
      String resultat = communication.envoiMessage("$TCAM()", 180000); // 3min de timeout

      // format de la reponse : "N1buf N1cam/nN2buf N2cam\n etc.
      while (cameraTableModel.getRowCount()>1)
        cameraTableModel.delete(0); //RAZ

      MessageFormat format = new MessageFormat("{0,number} {1,number}\n");
      ParsePosition status = new ParsePosition(0);
      Integer buff, cam;
      int shutter;
      Object constr[];
      constr = format.parse(resultat, status);
      while (status.getErrorIndex()==-1) {
        cam = Integer.valueOf(constr[1].toString());
        buff = Integer.valueOf(constr[0].toString());
        if (cam.intValue()==0)
          System.err.println("Buffer "+buff+" is not connected.");
        else {
            cameraTableModel.append();
            cameraTableModel.data[cameraTableModel.getRowCount()-1][0]=cam;
            cameraTableModel.data[cameraTableModel.getRowCount()-1][1]=buff;
            if (buff.intValue()==22) shutter = 4; // visee de champ 
            else if (buff.intValue()==21) shutter = 5; // visee de fente
            else shutter = 7; // par defaut
            cameraTableModel.data[cameraTableModel.getRowCount()-1][2] = new Integer(shutter);
        } //else
        constr = format.parse(resultat, status);
      } //while
      cameraTableModel.fireTableDataChanged();
    } //try
    catch(java.io.IOException e) {
      AppIU.setStatus("Error : "+e.getMessage()); 
      JOptionPane.showMessageDialog(null, e.getMessage(), "Error !",JOptionPane.ERROR_MESSAGE);
    }
  }

  private void envoiTemp() {
  // envoi de la consigne de temperature
    String message = "", resultat = "";
    Communication communication;

/*    Acquisition acq = UserParameters.acquisition;
    for (int i=0; i < acq.getNbCamUsed(); i++)
      message += "$ATHE(" + acq.listeCam.getListe()[i].numBuffer + ","
        + acq.listeCam.getListe()[i].temperature + ")" + Communication.SEP_DEF;
        */
    for (int i=0; i < cameraTableModel.getRowCount()-1; i++) {
      if (!cameraTableModel.data[i][1].toString().equals("0")) {
        message = "$ATHE(" + cameraTableModel.data[i][1].toString() + ","
          + cameraTableModel.data[i][5].toString() + ")" + Communication.SEP_DEF;
        try {
          communication = new Communication(Communication.VME);
          resultat = communication.envoiMessage(message, 5000);
          if (resultat.length() != 0)
            throw new java.io.IOException("erreur renvoyee par le VME : " + resultat);
          else cameraTableModel.data[i][8] = cameraTableModel.data[i][5];
        }
        catch(java.io.IOException e) {
          AppIU.setStatus("Error : "+e.getMessage()); 
          JOptionPane.showMessageDialog(null, e.getMessage(), "Error !",JOptionPane.ERROR_MESSAGE);
          UserParameters.acquisition.listeCam.listeCamera[i].cooled = -1;
        }
      } // if
    } // for i
  }

  public void cameraTableModel_tableChanged(TableModelEvent e) {
    Object[][] data = cameraTableModel.data;
    int i = e.getFirstRow();

    if(  e.getType() == e.UPDATE ) {
      switch (e.getColumn()) {
        case 0 :// camera
          if ( data[i][0].equals(new Integer(0)) 
            && (i != cameraTableModel.getRowCount()-1) )
            cameraTableModel.delete(i);
          data[i][8] = new Integer(255);
          break;
        case 1 :// buffer
          checkBufferCam(e.getFirstRow());
          data[i][8] = new Integer(255);
          break;
      }
      if ( ( data[cameraTableModel.getRowCount()-1][0].equals(new Integer(0)) == false )
        && ( cameraTableModel.getRowCount() < ListeCamera.NB_MAX_CAM ) )
        cameraTableModel.append();
      if ( (cameraTableModel.getRowCount() > 1)
        && ( data[cameraTableModel.getRowCount()-2][0].equals(new Integer(0)) ) )
        cameraTableModel.delete(cameraTableModel.getRowCount()-1);
    }
  }

/**
 * Cette fonction s'assure qu'il n'y a pas des temps d'intgration diffrents
 * pour un mme obturateur. Remarque : des camras diffrentes peuvent avoir le
 * mme obturateur.
 * Cette fonction est appel ds qu'un temps d'intgration est mis  jour.
 * Obsolete depuis qu'on ne definit plus defaultIntegrationTime
 *//*
  private void checkIntgTime(int i) {
    Integer obtu1 = (Integer)cameraTableModel.data[i][2];
    Integer time1 = (Integer)cameraTableModel.data[i][8];

    for (int j = 0; j < cameraTableModel.getRowCount()-1 ; j++)
      if (cameraTableModel.data[j][2].equals(obtu1))
        if (!cameraTableModel.data[j][8].equals(time1))
          cameraTableModel.setValueAt(time1, j, 8);
  }*/

/**
 * Cette fonction s'assure qu'il n'y a pas 2 camras avec le meme buffer.
 * Cette fonction est appel ds qu'un buffer est mis  jour.
 */
  private void checkBufferCam(int i) {
    Integer cam1 = (Integer)cameraTableModel.data[i][0];
    Integer buff1 = (Integer)cameraTableModel.data[i][1];

    for (int j = 0; j < cameraTableModel.getRowCount()-1 ; j++)
      if (cameraTableModel.data[j][1].equals(buff1)) {
        Integer cam2 = (Integer)cameraTableModel.data[j][0];
        if (!cam2.equals(cam1)) {
          //jTableCameras.editCellAt(j, 1);
          AppIU.setStatus("Warning : cameras "+cam1.toString()+" and "
            +cam2.toString()+" are associated to buffer "+buff1.toString()
            +".\n2 cameras cannot have the same buffer."); 
          JOptionPane.showMessageDialog(null, "Cameras "+cam1.toString()+" and "
            +cam2.toString()+" are associated to buffer "+buff1.toString()
            +".\n2 cameras cannot have the same buffer.", "Error"
            , JOptionPane.ERROR_MESSAGE);
          return;
        }
      }
  }


  private class CameraTableModel extends AbstractTableModel {
    final String[] columnNames = { "camera", "buffer nb", "shutter nb", "wavelength (\u00C5)",
      "attribute", "temp. (consign)", "spectral scale", "spatial scale" };
    public final int NB_CAMERA_MAX = UserParameters.acquisition.listeCam.NB_MAX_CAM;
    private int nbRow;
    public Object[][] data;

    CameraTableModel() {
      super();
      data = new Object[ NB_CAMERA_MAX ][ 9 ];
/*      nbRow = UserParameters.acquisition.listeCam.getNbCam() +1;
      for (int i = 0; i < nbRow; i++) init(i);
      if (nbRow < 1) nbRow = 1;*/
      nbRow = 1;
    }

    public int getColumnCount() { return columnNames.length; }

    public int getRowCount() { return nbRow; }

    public String getColumnName(int col) { return columnNames[col]; }

    public Object getValueAt(int row, int col) { return data[row][col]; }

    public Class getColumnClass(int c) {
      switch (c) {
        case 0 : return new Integer(0).getClass();
        case 1 : return new Integer(0).getClass();
        case 2 : return new Integer(0).getClass();
        case 3 : return new Float(0).getClass();
        case 4 : return new String().getClass();
        case 5 : return new Integer(0).getClass();
        case 6 : return new Float(0).getClass();
        case 7 : return new Float(0).getClass();
        default : return new String().getClass();
      }
    }

    public boolean isCellEditable(int row, int col) { return true; }

    public void delete(int nb) {
      if ( nb >= 0 ) {
        for ( int i = nb ; i < nbRow - 1 ; i++ )
          move(i, i + 1);
        if ( --nbRow < 1 ) nbRow = 1;
        fireTableDataChanged();
      }
    }

    public void insert(int nb) {
      if ( nb >= 0 ) {
        nbRow++;
        init(nbRow - 1);
        for ( int i = nbRow - 1 ; i > nb ; i-- )
          move(i, i - 1);
        init(nb);
        fireTableDataChanged();
      }
    }

    private void move(int nb1, int nb2) {
      data[ nb1 ][ 0 ] = data[ nb2 ][ 0 ];
      data[ nb1 ][ 1 ] = data[ nb2 ][ 1 ];
      data[ nb1 ][ 2 ] = data[ nb2 ][ 2 ];
      data[ nb1 ][ 3 ] = data[ nb2 ][ 3 ];
      data[ nb1 ][ 4 ] = data[ nb2 ][ 4 ];
      data[ nb1 ][ 5 ] = data[ nb2 ][ 5 ];
      data[ nb1 ][ 6 ] = data[ nb2 ][ 6 ];
      data[ nb1 ][ 7 ] = data[ nb2 ][ 7 ];
      data[ nb1 ][ 8 ] = data[ nb2 ][ 8 ];
    }

    private void init(int nb) {
      data[ nb ][ 0 ] = new Integer(0);
      data[ nb ][ 1 ] = new Integer(0);
      data[ nb ][ 2 ] = new Integer(7);
      data[ nb ][ 3 ] = new Float(4000.0);
      data[ nb ][ 4 ] = new String(ATTRIB_LIST[0]);
      data[ nb ][ 5 ] = new Integer(255);
      data[ nb ][ 6 ] = new Float(999999.);
      data[ nb ][ 7 ] = new Float(999999.);
      data[ nb ][ 8 ] = new Integer(-1);
    }

    public void append() {
      nbRow++;
      init(nbRow - 1);
      fireTableDataChanged();
    }

    public void setValueAt(Object value, int row, int col) {
      try {
        switch (col) {
        case 0 : if ((((Integer)value).intValue()<0)||(((Integer)value).intValue()>255))
          throw new BadValeurException("0,255"); break;
        case 1 : if ((((Integer)value).intValue()<0)||(((Integer)value).intValue()>255))
          throw new BadValeurException("0,255"); break;
        case 2 : if ((((Integer)value).intValue()<0)||(((Integer)value).intValue()>255))
          throw new BadValeurException("0,255"); break;
        case 3 : if ((((Float)value).floatValue()<3000.)||(((Float)value).floatValue()>9000.))
          throw new BadValeurException("3000,9000"); break;
        case 5 : if ((((Integer)value).intValue()<0)||(((Integer)value).intValue()>255))
          throw new BadValeurException("0,255"); break;
        case 6 : if ((((Float)value).floatValue()<0)||(((Float)value).floatValue()>999999.))
          throw new BadValeurException("0,999999"); break;
        case 7 : if ((((Float)value).floatValue()<0)||(((Float)value).floatValue()>999999.))
          throw new BadValeurException("0,999999"); break;
        }
        data[row][col] = value;
        fireTableCellUpdated(row, col);
      }
      catch (BadValeurException e) {
        AppIU.setStatus("'"+columnNames[col]+"' must be in ["+e.getMessage()+"]");
	 JOptionPane.showMessageDialog(null, "bad value, see status bar message.","Error", JOptionPane.ERROR_MESSAGE);
      }
    }
  }

class DrawPanel extends JPanel implements MouseListener {
    public int x1 = 127;
    public int x2 = 254;
    public int y  = 180;
    public Image im;

    public DrawPanel() {
      addMouseListener(this);

      int[] pix = new int[ParamWindowsConf.XMAX*ParamWindowsConf.YMAX];

      im = Toolkit.getDefaultToolkit().createImage(new java.awt.image.MemoryImageSource(
        ParamWindowsConf.XMAX, ParamWindowsConf.YMAX, (int[])pix, 0, ParamWindowsConf.XMAX));
    }

    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}

    public void mouseClicked(MouseEvent e) {
        e.consume();
        int bouton = e.getModifiers();
        int x = e.getX();
        y = e.getY();

        if ((bouton & InputEvent.BUTTON1_MASK) >0) x1 = x;
        else if ((bouton & InputEvent.BUTTON3_MASK) >0) x2 = x;

        if ( x1 > ParamWindowsConf.XMAX ) x1 = ParamWindowsConf.XMAX;
        if ( x1 < ParamWindowsConf.XMIN ) x1 = ParamWindowsConf.XMIN;
        if ( x2 > ParamWindowsConf.XMAX ) x2 = ParamWindowsConf.XMAX;
        if ( x2 < ParamWindowsConf.XMIN ) x2 = ParamWindowsConf.XMIN;
        if ( y > ParamWindowsConf.YMAX ) y = ParamWindowsConf.YMAX;
        if ( y < ParamWindowsConf.YMIN ) y = ParamWindowsConf.YMIN;
        repaint();
    }

    public void paint(Graphics g) {
      super.paint(g);
      g.setColor(getForeground());
      g.setPaintMode();
      try { g.drawImage(im, 0, 0, this); }
      catch (NullPointerException e) { e.printStackTrace(); }
      g.setXORMode(Color.red);
      g.drawLine( x1, 0, x1, ParamWindowsConf.YMAX-1);
      g.setXORMode(Color.blue);
      g.drawLine( x2, 0, x2, ParamWindowsConf.YMAX-1);
      g.setXORMode(Color.white);
      g.drawLine( 0, y, ParamWindowsConf.XMAX-1, y);
    }
  }
}
