package iu;

//import java.lang.*;
import java.util.*;
import java.io.*;
import java.text.*;

/** Objet Camera Themis */

public class Camera implements Sauvegardable {
  private static final String sauvFormat = "'{'{0,number}'}' '{'{1,number}'}' '{'{2,number}'}' '{'{3,number}'}' '{'{4,number}'}' '{'{5,number}'}' '{'{6}'}' '{'{7,number}'}' '{'{8,number}'}' \n";

  Float   wavelength;
  Integer numShutter;
  Integer numBuffer;
  Integer numRep;
  Integer temperature;
  String  stokesType;
  Float   spatscal;
  Float   specscal;
  Integer defIntgTime;
  int cooled = 255;

  public Camera() {
    wavelength = new Float(4000.f);
    numShutter = new Integer(7);
    numBuffer = new Integer(0);
    numRep = new Integer(0);
    temperature = new Integer(255);
    stokesType = new String("none");
    spatscal = new Float(999999.f);
    specscal = new Float(999999.f);
    defIntgTime = new Integer(300);
  }

  public Camera(int numShutter,int numBuffer,int numRep,int temperature,
    float wavelength, float spatscal, String stokesType,float specscal,
    int integrationtime, int cooled) {
      this.numShutter = new Integer(numShutter);
      this.numBuffer = new Integer(numBuffer);
      this.numRep = new Integer(numRep);
      this.temperature = new Integer(temperature);
      this.wavelength = new Float(wavelength);
      this.stokesType = new String(stokesType);
      this.spatscal = new Float(spatscal);
      this.specscal = new Float(specscal);
      this.defIntgTime = new Integer(integrationtime);
      this.cooled=cooled;
    }

  public void setObject_to_file(BufferedWriter out) throws IOException
    {
      Object[] info = {numRep,numBuffer,numShutter,temperature,wavelength,spatscal,stokesType,
        specscal,defIntgTime};
      int i;
      MessageFormat form = new MessageFormat(sauvFormat);
      String resultat = new String(form.format(info));

      // info de camera
      out.write(resultat,0,resultat.length());
    }

  //
  public void getObject_from_File(BufferedReader in) throws IOException {
      Object constr[];
      String tostudy = new String(in.readLine());
      MessageFormat form1 = new MessageFormat("'{'{0,number}'}' ");
      ParsePosition status = new ParsePosition(0);
      int i;
      Window win;

      constr=  form1.parse(tostudy,status);
      numRep= new Integer((constr[0]).toString());

      constr=  form1.parse(tostudy,status);
      numBuffer= new Integer((constr[0]).toString());

      constr=  form1.parse(tostudy,status);
      numShutter= new Integer((constr[0]).toString());

      constr=  form1.parse(tostudy,status);
      temperature = new Integer((constr[0]).toString());

      constr=  form1.parse(tostudy,status);
      wavelength= new Float((constr[0]).toString());

      constr=  form1.parse(tostudy,status);
      spatscal= new Float((constr[0]).toString());

      form1 = new MessageFormat("'{'{0}'}' ");
      constr=  form1.parse(tostudy,status);
      stokesType= new String((constr[0]).toString());

      form1 = new MessageFormat("'{'{0,number}'}' ");

      constr=  form1.parse(tostudy,status);
      specscal= new Float((constr[0]).toString());

      constr=  form1.parse(tostudy,status);
      defIntgTime= new Integer((constr[0]).toString());
    }
}

