/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

package iu;

import java.text.*;
import java.io.*;

public class Armoire {
  String nom;
  int nbTiroir;
  Tiroir[] tiroirs;
  static int NB_MAX_ARMOIRES = 8;

  public Armoire() {
  }

  public String toString() { return nom; }

  public void setObject_to_file(BufferedWriter out) throws IOException {
    for (int t = 0; t < nbTiroir; t++)
      tiroirs[t].setObject_to_file(out);
  }

  public void getArmoire(BufferedReader in) throws IOException/*, NullPointerException*/ {
    Object constr[];
    ParsePosition status = new ParsePosition(0);
    String tostudy = new String(in.readLine());
    int i;

    constr = ListeMoteur.formatEntete.parse(tostudy, status);
//System.out.println("[ListeMoteur$Armoire:getArmoire] " + tostudy);

    if (! constr[0].equals("armoire"))
      throw new IOException("erreur dans le fichier " + UserParameters.moteurFile);
    nom = new String((constr[1]).toString());
    nbTiroir = Integer.parseInt(constr[2].toString());

    tiroirs = new Tiroir[ nbTiroir ];
    for (i = 0; i < nbTiroir; i++) {
      tiroirs[ i ] = new Tiroir();
      tiroirs[ i ].getTiroir( in );
    }
  }
}