/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

package iu;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 * La classe principale, contenant le {@link #main}.
 */

public class AppIU {
  JFrame frame = new JFrame("IO v1.1");

  static UserRessource message = new UserRessource("fr","FR");

  PanelObs panelObs = new PanelObs();
  GlobalMenuPanel globalMenuPanel = new GlobalMenuPanel();
  PanelTech panelTech = new PanelTech();
  PanelStart panelStart = new PanelStart();
  PanelData panelData = new PanelData();
  JPanel panel = globalMenuPanel;
  static JLabel statusLine = new JLabel("Initializing...");

  FileIO fileIO = new FileIO();

  public AppIU() {
    panelObs.jButtonMenu.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        panelObs.lostFocus();
        setPanel(globalMenuPanel);
      }
    });
    panelTech.jButtonMenu.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	/*	
	try {
	panelTech.cameraPanel.lostFocus();	
	panelTech.cameraPanel.gainedFocus();
	panelTech.fitsTechPanel.lostFocus(); 
 	panelTech.fitsTechPanel.gainedFocus();
	panelTech.polarPanel.lostFocus();	
	panelTech.polarPanel.gainedFocus();
	}
	catch(Exception exc)
	{ exc.printStackTrace(); }
	*/
        panelTech.lostFocus();
        setPanel(globalMenuPanel);
      }
    });
    panelStart.jButtonMenu.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        panelStart.lostFocus();
        setPanel(globalMenuPanel);
      }
    });
    panelData.jButtonMenu.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        panelData.lostFocus();
        setPanel(globalMenuPanel);
      }
    });
          
    frame.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) { System.exit(0); }
    });
    globalMenuPanel.jButton1.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { 
        Utils.recupDA3();
        setPanel(panelObs);
        panelObs.gainedFocus();
      }
    });
    globalMenuPanel.jButton2.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	panelTech.cameraPanel.gainedFocus();
	setPanel(panelTech); }
    });
    globalMenuPanel.jButton3.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { 
        UserParameters.paramObservationStructure.genereScripts();
        setPanel(panelStart); 
        panelStart.gainedFocus();
      }
    });
    globalMenuPanel.jButtonData.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { 
	setPanel(panelData); 
	panelData.gainedFocus();
      }
    });
    globalMenuPanel.jButtonLoad.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { fileIO.jButtonLoad_actionPerformed(); }
    });
    statusLine.setPreferredSize(new Dimension(800, 15));
    frame.getContentPane().add(statusLine, BorderLayout.SOUTH);
    setPanel(globalMenuPanel);
    frame.setVisible(true);
//    globalMenuPanel.setPreferredSize(new Dimension(1200, 1000));
//    frame.getContentPane().setPreferredSize(new Dimension(1000, 800));
/*    panelObs.setPreferredSize(new Dimension(1000, 800));
    panelTech.setPreferredSize(new Dimension(1000, 800));
    panelStart.setPreferredSize(new Dimension(1000, 800));
    panelData.setPreferredSize(new Dimension(1000, 800));*/
//    frame.setSize(1200, 1000);

//    fileIO.load(new java.io.File("test.iu"), new boolean[] {true, true});
//    jButtonObservationSettings_actionPerformed();
//    jButtonStart_actionPerformed();
//    panelStart.observationPanel.jButtonStart_actionPerformed();
  }

  private void setPanel(JPanel nouveauPanel) {
    if (panel != null ) { 
//      panel.transferFocus(); 
      frame.getContentPane().remove(panel);
    }
    panel = nouveauPanel;
    frame.getContentPane().add(panel, BorderLayout.CENTER);
    frame.pack();
//    panel.requestFocus();
//    panel.grabFocus();
    setStatus("");
  }

  public static void setStatus(String ch) { 
    statusLine.setText(ch.trim());
    statusLine.repaint();
    System.out.println(">"+ch.trim()+"<");
  };
  
  private void jButtonObservationSettings_actionPerformed() {
    setPanel(panelObs);
    Utils.recupDA3();
  }

  private static boolean initialise() {
    boolean erreur = false;

    java.util.Locale.setDefault(java.util.Locale.US);
    System.out.println("Locale=" + java.util.Locale.getDefault());

    String os = "";
    os += System.getProperties().getProperty("os.arch") + ", ";
    os += System.getProperties().getProperty("os.name") + " ";
    os += System.getProperties().getProperty("os.version");
//    UserParameters.paramFits.getKeyword("").setValeur(os);
    System.out.println("system : " + os);

    String rep = "";
    System.out.println("Prise de controle du superviseur...");
    try {
      Communication comm = new Communication(Communication.UCCI);
      rep = comm.envoiMessage("MASTER()", 10000);
      if (rep.length() > 0) throw new java.io.IOException(rep);
    }
    catch(Exception e) {
      System.err.println(e.getMessage() + " => l'IU ne peut avoir la main sur l'UCCI.");
      erreur = true;
    }

    try {
      Communication comm = new Communication(Communication.ZEUS);
      rep = comm.envoiMessage("$NAME", 2000).trim().toUpperCase();
      rep = rep.substring(rep.indexOf('/')+1);
      UserParameters.paramFits.getKeyword("ORIGIN").setValeur(rep);
      System.out.println("Acquisition server program : "+rep+"@"+Communication.ZEUS);
    }
    catch(Exception e) {
      System.err.println(e.getMessage() + " => The acquisition server program name could not be retrieved.\n"
        + "The ORIGIN keyword is not initialised.");
      erreur = true;
    }
    UserParameters.cible0 = new Cible(Cible.NONE); // -> CALIB par defaut

    return erreur;
  }

  private static void initStyle() {

  //ci-dessous : pour connaitre les keys pour UIManager.put();
/*    java.util.Hashtable defaultProps = UIManager.getDefaults();
    java.util.Enumeration enum = defaultProps.keys();
    while (enum.hasMoreElements()) {
      Object key = enum.nextElement();
      System.out.println(key + "\t" + defaultProps.get(key));
    }
    System.exit(0);*/

    Font font = new java.awt.Font("Dialog", 1, 14); // 14
    Font font16 = new java.awt.Font("Dialog", 1, 16); // 16
    Color vertFonce = new Color(60, 160, 60);
    Color rougeFonce = new Color(160, 60, 60);
    UIManager.put("Button.font", font);
    UIManager.put("CheckBox.font", font);
    UIManager.put("ComboBox.font", font);
    UIManager.put("Label.font", font);
    UIManager.put("OptionPane.font", font);
    UIManager.put("Panel.font", font);
    UIManager.put("RadioButton.font", font);
//    UIManager.put("ScrollPane.font", font);
    UIManager.put("TabbedPane.font", font16);
    UIManager.put("TabbedPane.foreground", rougeFonce);
    UIManager.put("Table.font", font);
    UIManager.put("TableHeader.font", font);
    UIManager.put("TextArea.font", font);
    UIManager.put("TextField.font", font);
//    UIManager.put("TextPane.font", font);
    UIManager.put("TitledBorder.font", font16);
    UIManager.put("TitledBorder.titleColor", vertFonce);
//    UIManager.put("ToggleButton.font", font);
    UIManager.put("ToolTip.font", font);
  }

  public static void main(String[] args) {
    if (initialise())
      System.out.println("An error has occured while initializing. "
        + "You may have to quit and restart the program to have it running properly.");
    initStyle();
    AppIU appIU1 = new AppIU();
    setStatus("Ready.");
  }
}
