package iu;

//import java.lang.*;
import java.util.*;
import java.math.*;
import java.io.*;

/** Ensemble des informations pour l'acquisition */

public class Acquisition implements Sauvegardable//, Formatable
{

  ListeCamera listeCam;
  ListeWindow listeWin;
  private static final int NB_MAX_OBT = 8;
  public static final int FITS0 =0;
  public static final int FITS1 =1;
  public static final int FITS2 =2;
  public static final int FITS3 =3;
  public int listeDintg[];
  private String formCam = "";
/*  private static String separateur1 = "{ACQ}\n";
  private static String separateur2 = "{/ACQ}\n";
*/
  public Acquisition() {
    int i;
    listeWin = new ListeWindow();
    listeCam = new ListeCamera();

    listeDintg = new int[NB_MAX_OBT];
      for (i=0; i< NB_MAX_OBT; i++) {
	listeDintg[i]=-1;
      }
  }

  public void setObject_to_file(BufferedWriter out) throws IOException {

//    out.write(separateur1);
    listeCam.setObject_to_file(out);
    listeWin.setObject_to_file(out);
//    out.write(separateur2);
  }

  public void getObject_from_File(BufferedReader in) throws IOException {
    getObject_from_File(in, new boolean[] { true, true });
  }

  public void getObject_from_File(BufferedReader in, boolean[] parties) throws IOException {
//    in.readLine(); // lecture de ACQ
//    in.readLine(); // lecture de CAM
    //    System.out.println("Acquisition.java: Charge les cameras "+parties[0]+parties[1]);
    listeCam.getObject_from_File(in, parties);
//    System.out.println("de Acquisition avant get Win");
//    in.readLine(); // fin de lecture de CAM
//    in.readLine(); // lecture de WIN
    listeWin.getObject_from_File(in, parties);
//    in.readLine(); // fin lecture de WIN
//    in.readLine(); // fin lecture de ACQ
  }

  /** Il peut y avoir plusieurs fenetre par camera */
  public int getNbCamUsed() /*throws BadValeurException*/ {

    int index[];
    int i,j,trouve,nbcam=0,nbwin = listeWin.getNbWin();
    Integer intWin,valCam;

    index = new int[ListeCamera.NB_MAX_CAM];

    for(i=0;i<nbwin;i++) {

      j=0;trouve =0;

      while(j<nbcam) {
	if( index[nbcam] == (listeWin.getListe())[i].getCam())
	  trouve =1;
	j++;
      }
      //
      if(trouve == 0) {
	index[nbcam]=(listeWin.getListe())[i].getCam();
	nbcam++;
	  }
      i++;
    }
    return nbcam;
  }
/*
  public void getDintg() throws BadValeurException {
    int index[];
    String keword = UserRessource.cle_dintg;
    int i,obt,trouve,cam,nbwin = listeWin.getNbWin();
    Integer intObt,intVal;

    index = new int[NB_MAX_OBT];

    for(i=0;i<nbwin;i++) {
     cam = (listeWin.getListe())[i].getCam();
     intObt = listeCam.getListe()[cam].numShutter;
     index[intObt.intValue()]=listeCam.getListe()[cam].defaultIntegrationTime.intValue();
    }
  }
*/
/*
  public KeywordText getmotcle() throws BadValeurException {
    int i,j,limite,cam;
    KeywordText resul = new KeywordText(0, "");
    String keyword;
    Integer valCam= new Integer(0),intWin= new Integer(0);
    Integer intBid= new Integer(0);
    Float valCam2;

    //NBCAM (utilisees)
    limite = getNbCamUsed();
    //DINTG
    getDintg();
    valCam = new Integer(limite);
    keyword = UserRessource.cle_nbcam;
    resul = resul.add(Formatage.motcle(keyword,intBid,false,valCam));

    // NBFEN (de l'acquisition)
    limite = listeWin.getNbWin();
    intWin = new Integer(limite);
    keyword = UserRessource.cle_nbfen;
    resul = resul.add(Formatage.motcle(keyword,intBid,false,intWin));

    // OBTUR
    resul = resul.add(formCam);

    for(i=0;i<limite;i++) {

      cam = listeWin.getListe()[i].getCam();
      intWin = new Integer(i);

      //NOCAM
      keyword = UserRessource.cle_nocam;
      valCam = listeCam.getListe()[cam].numRep;
      resul = resul.add(Formatage.motcle(keyword,intWin,true,valCam));

      //NOBUF
      keyword = UserRessource.cle_nobuf;
      valCam = listeCam.getListe()[cam].numBuffer;
      resul =resul.add(Formatage.motcle(keyword,intWin,true,valCam));

      //WAVELT
      keyword = UserRessource.cle_wavlt;
      valCam2 = listeCam.getListe()[cam].wavelength;
      resul = resul.add(Formatage.motcle(keyword,intWin,true,valCam2));

      //TPCAM
//      keyword = UserRessource.cle_tpcam;
//      valCam = listeCam.getListe()[cam].temperature;
//      resul =resul.add(Formatage.motcle(keyword,intWin,true,valCam));

      // NBLIG NBCOL LIGDB COLDB VISUF ENREG
      resul = resul.add((listeWin.getListe()[i]).getmotcle());
    }
    return(resul);
  }
*/
  public Instruction acqi() {
    return new Instruction(UserRessource.acqui_acqi, UserRessource.acqui_acqi + "()",
      UserRessource.acqui_acqi_c, Communication.UCCI);
  }

  public Instruction wacq()
    {
      return(new Instruction(UserRessource.acqui_wacq,
			     UserRessource.acqui_wacq+"()",
			     UserRessource.acqui_wacq_c, Communication.UCCI));
    }
  public Instruction plam()
    {
      return(new Instruction(UserRessource.acqui_plam,
			     UserRessource.acqui_plam+"()",
			     UserRessource.acqui_plam_c, Communication.UCCI));
    }
  public Instruction ppou()
    {
      return(new Instruction(UserRessource.acqui_ppou,
			     UserRessource.acqui_ppou+"()",
			     UserRessource.acqui_ppou_c, Communication.UCCI));
    }
  public Instruction step()
    {
      return(new Instruction(UserRessource.acqui_step,
			     UserRessource.acqui_step+"()",
			     UserRessource.acqui_step_c, Communication.UCCI));
    }
  public Instruction ana(BigDecimal valeur)
    throws BadValeurException
    {
      try{
	return(new Instruction(UserRessource.acqui_ana,
			       UserRessource.acqui_ana+"("+Formatage.setModel(valeur,"****")+")",
			       UserRessource.acqui_ana_c, Communication.UCCI));}
      catch(BadValeurException e)
	{throw e;}
    }

  public Instruction index(BigDecimal seqind,BigDecimal indreg)
    throws BadValeurException
    {
      try {
	return(new Instruction(UserRessource.acqui_index,
			       UserRessource.acqui_index+
			       "("+Formatage.setModel(seqind,"****")+","+
			       Formatage.setModel(indreg,"****")+")",UserRessource.acqui_index_c, Communication.UCCI));
      }
      catch(BadValeurException e)
	{throw e;}
    }

  public Instruction lambda(BigDecimal indlambd)
    throws BadValeurException
    {
      try{
	return(new Instruction(UserRessource.acqui_lambda,
			       UserRessource.acqui_lambda+"("+
			       Formatage.setModel(indlambd,"****")+")",
			       UserRessource.acqui_lambda_c, Communication.UCCI));}
      catch(BadValeurException e)
	{throw e;}
    }
  /** Paramtre 1: index de la boucle principale
    Parametre 2: index de la region
    parametre 3: index de la longeur d'onde */
  public Instruction pdyn(BigDecimal p1,BigDecimal p2,BigDecimal p3)
    throws BadValeurException
    {
      try {
	return(new Instruction(UserRessource.acqui_pdyn,
			       UserRessource.acqui_pdyn+
			       "("+Formatage.setModel(p1,"****")+","+
			       Formatage.setModel(p2,"****")+","+
			       Formatage.setModel(p3,"****")+")",UserRessource.acqui_pdyn_c, Communication.UCCI));
      }
      catch(BadValeurException e)
	{throw e;}
    }
}

