
static char *SccsId="%w% %g%";
/*;+********************************************************************
-----------------
ENTETE DE FICHIER       :  rs232_v3.c     
-----------------
-Auteur(s):D.Zig
-Rle:
-Constantes
	Internes au fichier: 
		
				
		
-Variables
	Internes au fichier: 

		
-Fonctions:
	Internes au fichier:


	 
-Commentaires:	

********************************************************************;-*/

/*------------------------------HISTORIQUE--------------------------
  9 Octobre 1998 dz Bonne fete Denis !! Merci, c'est sympa, MERCI
  GRAND DEBUGGING D'AUTOMNE 

  Ajout de la fonction debug_com( flag ) et de plein de printErr partout
  pour debugger la tache en cas de problemes.
  debug_com(1) valide tous les printErr.
  debug_com(0) les inhibe.
  Plus d'autres lignes de codes pour debugger.

  8 Octobre 1998 dz
  Ajout d'un compteur de commandes recues par la ligne RS232 pour debug
  2 fonctions :
    raz_cpt_cmd() : raz du compteur
    print_cpt_cmd() : affichage du contenu du compteur

  28 Juillet 1998 dz
  Si init_acquisition n'a pas ete lance, on retourne directement un
  code d'erreur generale. Voir la chaine err_ae24.

  25Juillet 1998 dz
  Profonde modification du fichier.
  Creation du fichier header com_ucci_vme.h qui contient les constantes
  de parametrage de la liaison rs232 et la definition de la structure
  Cmd_ucci_vme.
  Le decodage des infos,actions en provenance de l'UCCI se font maintenant
  en scrutant une table de structures de type Cmd_ucci_vme.

  24 Juillet 1998 dz
  Correction d'un bug sur la chaine de caracteres recue dans tamp_rs232
  Si les taches ne sont pas lancees par init_acquisition, j'ai un caractere
  pirate ( 0x0d ) qui se place avant la commande envoyee par l'ucci dans
  la chaine tamp_rs232 ou le buffer d'entree et qui fausse le decodage
  La correction s'effectue dans la fonction decode().

  4 Juin 1998 : Ajout de la commande WACQ 

 */

#include <vxWorks.h>
#include <stdio.h>
#include <ioLib.h>
#include <taskLib.h>
#include <string.h>
#include <intf.h>
#include <com_ucci_vme.h>

#include "tab_cmd_ucci.c"


/*-----------------------------VARIABLES GLOBALES----------------------*/

char tamp_rs232[NB_MAX_BYTES]; /* tampon de reception du message */
static char *msg = "Hola caballero, como esta ??\n\r";

static char *cmd_unknow = "?ERR=81,\"\"\\\\AE24\n\r"; /* commande inconnue  */
static char *cmd_ok = "\n\r<\n\r";            /* commande recue     */
static char *cmd_done="\n\r>\n\r";            /* commande effectuee */
static char *err_ae24 = "?ERR=1,\"\"\\\\AE24\n\r"; /* Erreur generale
						      init_acquisition n'est
						      pas lancee */





int demande_rs232; /* actif si demande d'acquisition via la ligne RS232 */
int demande_utc;   /* actif si demande de mise a l'heure via la ligne RS232 */
int fd_rs232; /* file descriptor de la liaison RS232 */

extern int init_acq_ok ; /* actif si le programme d'acquisition est lance
			    start_v3.c */

static int cpt_cmd; /* compteur de commandes recues via la ligne RS232 */
int flag_debug_com; /* flag pour debug de la tache de communication serie */

/*---------------------------------------------------------------------*/

int init_rs232(char *port)
{
  int fd;
  if ( (fd = open( port , O_RDWR , 0 )) == ERROR )
    {
      printf(" Erreur ouverture de communication sur port RS232 %s\n",port );
      return ( ERROR );
    }
  ioctl(fd,FIOBAUDRATE,SPEED_RS232);
  ioctl(fd,FIOSETOPTIONS, OPT_LINE ); /* line mode*/
  ioctl(fd,FIOFLUSH,0);	/* Vidage des buffers IN et OUT */
  taskDelay(2);
  return( fd );
}

int test_rd_rs232( char *port )
{
  int fd , nb_bytes , i ;
  if ( (fd = init_rs232( port )) == ERROR ) return ( ERROR );
  nb_bytes = read( fd , tamp_rs232 , NB_MAX_BYTES);
  printf(" %d Caracteres recus\n", nb_bytes);
  if ( nb_bytes )
    for( i=0 ; i<nb_bytes ; i++) printf("%c",tamp_rs232[i]);
  printf("\n");
  close(fd);
  return ( OK );
}

int test_wr_rs232( char *port )
{
  int fd , nb_bytes , i ;
  if ( (fd = init_rs232( port )) == ERROR ) return ( ERROR );
  nb_bytes = write( fd , msg , strlen(msg));
  printf(" %d Caracteres envoyes\n", nb_bytes);
  if ( nb_bytes )
    for( i=0 ; i<nb_bytes ; i++) printf("%c",msg[i]);
  printf("\n");
  close(fd);
  return ( OK );
}



int init_com( void )
 {
  int code,cmd_valide,code_err;
  int i;
  ULONG  first_time ,second_time, delta ; /* pour faire des mesures de temps */
  flag_debug_com =0;
  first_time = second_time = 0;
  if ( (fd_rs232 = init_rs232(RS232_1)) == ERROR ) return (ERROR);
  while (1)
    {
      demande_rs232=0;
      cmd_valide = 0;

      if (flag_debug_com)
	printErr("\n--------> Avant ioctl\n");

      ioctl(fd_rs232 , FIORFLUSH , 0); /* Vide le buffer IN  */

      if (flag_debug_com)
	printErr("\n------------> Avant read\n");
      read_rs232( tamp_rs232 );
      
      if (flag_debug_com)
	printErr("\n------------> Apres read\n");
      
      cpt_cmd ++ ; /* increment du compteur de commandes recues */
      if (flag_debug_com)
	{
	  second_time = tickGet();
	  delta = second_time - first_time ;
	  first_time = second_time ;
	  printErr("\nRecu: --%s-- \nTemps:%ld cs",tamp_rs232, delta);
	}

      if (flag_debug_com)
	printErr("\n---------------> Avant write recu\n");
      write_rs232( cmd_ok );

      if (flag_debug_com)
	printErr("\nEnvoi: %s",cmd_ok);

      /* si le prog d'acquisition n'est pas lance, ce n'est pas la peine
	 d'aller plus loin */
      if ( init_acq_ok == 0 )
	{
	  write_rs232( err_ae24 );
	  if (flag_debug_com)
	    printErr("\nEnvoi: %s",err_ae24);
	  write_rs232( cmd_done );
	  if (flag_debug_com)
	    printErr("\nEnvoi: %s",cmd_done);
	  continue;
	}
      for( i=0 ; i<nb_cmd_ucci_vme ; i++ )
	{
	  code=decode(tamp_rs232, tab_cmd_ucci[i].chaine);
	  /*	  printf("\nCode= %d pour la chaine %s",code,tab_cmd_ucci[i].chaine );
	   */
	  if (code == OK)
	    {
	      cmd_valide=1; /* la commande est trouvee */
	      if (flag_debug_com)
		printErr("\nExecution commande");
	      code_err =(tab_cmd_ucci[i].pt_fonc)(); /* la fonction associee est lancee*/
	      if ( code_err !=NO_ERR_CMD_UCCI ) /* Si retour d'erreur,on l'envoie
						   sur la ligne RS232 */
		{
		  write_rs232( tab_cmd_ucci[i].erreur[code_err - 1] );
		  if (flag_debug_com)
		    printErr("\nEnvoi: %s",tab_cmd_ucci[i].erreur[code_err -1]);
		}
	      break; /* et on sort de la boucle for*/
	    }
	} /* fin de boucle for */

      if( cmd_valide == 0 ) 
	{
	  if (flag_debug_com)
	    printErr("\n-------------------> Avant cmd unknown \n");
	  write_rs232( cmd_unknow ); /* la commande n'est pas connue */
	  if (flag_debug_com)
	    printErr("\nEnvoi: %s",cmd_unknow);
	}
      if (flag_debug_com)
	printErr("\n-----------------------> Avant cmd done\n");
      write_rs232( cmd_done);
      if (flag_debug_com)
	printErr("\nEnvoi: %s",cmd_done);
    } /* fin de  boucle while(1) */

  printErr("\nALAAAARM !!!! Plantage tache lecture rs232");
 }


int decode(char *chaine, char *table )
  {
    int code;
    char *string=chaine;
    /* Si le buffer commence par des caracteres indesirables
       du genre \n et/ou \r , on les saute ......Hop !! */
    while( (*string == CR) || ( *string == NL ) )
      {
	string +=1;
      }
    code = strncmp(table , string , strlen(table)  );
    if (code ==0 ) return ( OK );
    return (ERROR);
  }



void write_rs232( char *msg )
{
  write( fd_rs232 , msg , strlen(msg) );
}

void read_rs232( char *msg)
{
  int nb_char;
  nb_char = read( fd_rs232 , msg , NB_MAX_BYTES );
  msg[nb_char] = 0 ; /* Pour terminer une chaine de caracteres */
} 

void raz_cpt_cmd( void )
{
  cpt_cmd = 0 ;
}

void print_cpt_cmd( void )
{
  printf("\nNbre de commandes recues = %d\n", cpt_cmd);
}

void debug_com( int flag )
{
  flag_debug_com = flag;
}

/*----------------------------------------------------------------------------*/




    
 



 
 

 


