static char *SccsId="@(#)lecture_v3.c	1.3 07/28/98";
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:	LECTURE_V3.C
-----------------
-Auteur(s):	Denis Ziegler
-Role:	
	Tache  de lecture des buffers en mode acquisitions CCD
-Constantes
	Internes au fichier:
						
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:	
				lecture
				
				calcul_adr_zone
				zone_libre
				zone_libre_vis
				lock_zone
				wr_total_data
				debug_lect
	 
Commentaires:	
Ce fichier contient la fonction principale de lecture des buffers em mode CCD.
La nouvelle disposition des donnees en memoire ( plus d'entete de fenetres et debut 
des fenetres a un offset calcule because DMA ) impose ce nouveau fichier.

********************************************************************;-*/
/*
  15 Mars 1999 dz
  en cas d'erreur sur lecture DMA, on affiche le numero de la fenetre

  13 Octobre 1998 dz
  La constante de timout sur enregistrement passe a 10 secondes

  9 Octobre 1998 dz
  Ajout de la fonction debug_lect( flag ) et de plein de printErr
  partout pour debugger la tache de lecture si necessaire.
  debug_lect(1) valide les printErr.
  debug_lect(0) les inhibe.

  28 Juillet 1998 dz
  reset des cartes buffers avant la lecture. C'est surtout utile
  en mode cadenceur ou on ne peut pas faire de reset n'importe quand
  surtout pas en cours de DMA.

  27 Juillet 1998 dz
  Correction bug.  ( version 1.2 )
  Si en cours de lecture, on a une erreur de timout sur enregistrement,
  il ne faut pas auussi donner le semaphore sem_lect_ok. Vu !!!!!!

  17.12.96 dz
  on fait des mesures de temps avec la fonction wr_tab_perf
  Voir test_perf.c
  */

#include <vxWorks.h>
#include <errnoLib.h>
#include <stdio.h>
#include <fioLib.h>
#include <semLib.h>
#include <tickLib.h>
#include <acq.h>
#include <intf.h>

/*-----------------------CONSTANTES INTERNES --------------------*/

#define TIMOUT_ENRG_SUN  (10*sysClkRateGet())

/*---------------------------------------------------------------*/

extern lect_buf();        /* buf_v3.c */
extern lect_buf_no_dma(); /* buf_v3.c */
extern wr_tab_perf();     /* test_perf.c */
/*
 *		FONCTIONS INTERNES AU FICHIER
 */
void calcul_adr_zone( Datum **pt_zone , Datum *pt ,Tb_ctrl *pt_ctrl );
int zone_libre( Tb_ctrl *pt_ctrl , int base );
void lock_zone( Tb_ctrl *pt_ctrl , int zone , int lock );


/*
 *			VARIABLES GLOBALES
 */


extern Tb_acq *Pt_acq; /* Pointeur sur Tab_acq */
extern Datum *Pt_data; /* Pointeur sur zone des donnees */
extern Tb_ctrl *Pt_ctrl; /* pointeur sur la structure partage memoire */
extern int attente_enrg; /* defini dans commandes.c  Si attente_enrg=1\
			    la fonction lecture se met en attente de la\
			    liberation du verrou */
extern int reglage_se;  /* defini dans gen_intg.c Utilise pour ne pas prendre \
                           le premier fin de numerisation en mode reglage des \
                           cameras Soleil Entier */


extern int cpt_start_acq; /* test_perf.c */

SEM_ID sem_go_lect; /* semaphore d'autorisation de lecture */
SEM_ID sem_lect_ok; /* semaphore lecture effectuee */
SEM_ID sem_timout_enrg; /* semaphore de timout sur enregistrement */

Datum *pt_zone_data[ NB_MAX_EMPL ];
int test_lect; /* test interne . Si test_lect=1 on ne teste pas la \
                  disponibilite des zones memoires */

int dma;  /* Si on positionne DMA a 1 --> lecture des buffers en mode DMA */
int num_buf_vme; /* le numero du buffer de stockage des fenetres */

int flag_lect; /* Indicateur de lecture en cours */

static flag_debug_lect; /* flag pour autoriser les affichages ( debug) */

/*++********************************************************************
------------------
ENTETE DE FONCTION	:	lecture
------------------

-Role:	fonction principale de lecture des buffers
-inclure:
-Prototype:
	int lecture(void)
-Parametres:
-Variables globales utilisees
	Internes au fichier:
	Importees:

-Retour: si retour alors ERROR
-Description:	
Creation des semaphores utilises par la tache de lecture.
Lecture des buffers selon le contenu de la table d'acquisition
		
-Constantes utilisees
	Internes au fichier:
	Importees:
	
-Fonctions utilisees
	Internes au fichier:
	Importees:
		intf_wr_rctrl ( intf_v3.c)
		lect_buf ( buf_v3.c)

-Exemple:
-Commentaires:
	Si la variable attente_enrg est positionnee a 1 la fonction de lecture 
	attend la fin de l'enregistrement ( disponibilite du verrou).
********************************************************************--*/
int lecture(void)
{
  int i,code, zone_active,err_lect;
  Datum *pt_buffer,*pt_fenetre;
  double nbvaleur; /* nombre de valeurs a lire  */
  long start_enrg;
  long start_lect, end_lect, lect ; /* pour mesurer le temps de lecture */
  long start_sun, end_sun; /* pour mesurer le temps d'execution du
			      process de lecture SUN */
  
  if ( ((sem_go_lect = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL) ||\
       (( sem_lect_ok = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL) ||\
       (( sem_timout_enrg = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL))\
     return (ERR_SEM);
  
  /* DEBUT DE LA GRANDE BOUCLE SANS FIN */
  num_buf_vme = 0;
  flag_debug_lect = 0;
  while(1)
    {
      flag_lect = FLAG_OFF;
      /* Calcul des pointeurs sur les NB_MAX_EMPL zones de stockage */
      calcul_adr_zone( pt_zone_data,Pt_data , Pt_ctrl );
      if ( flag_debug_lect)
	printErr("\nAttente nouvelle lecture");
      
      semTake(sem_go_lect,WAIT_FOREVER); /* blocage sur l'autorisation de lecture*/
      semTake( sem_lect_ok , NO_WAIT ); /* On vide le semaphore */
      flag_lect = FLAG_ON;

      if ( flag_debug_lect)
	printErr("\nStart lecture");
      reset_cam(); /*reset des cartes buffers */
      err_lect = FLAG_OFF; /* raz du flag */

      /* Si on est en mode reglage avec les cameras Soleil Entier, on ne lit 
	 pas apres le premier fin de numerisation mais apres le deuxieme 
	 c'est comme ca */
      if ( (Pt_acq->modob == MODE_REGL_SE) && (reglage_se != 2) ) continue;
      /* 
       * 	Test de disponibilite memoire
       */
      if ( test_lect == FLAG_OFF ) 
	{
	  /* test de disponibilite des tampons */
	  zone_active = zone_libre( Pt_ctrl,num_buf_vme );
	  if (zone_active == ERR_MEM)
	    {
	      err_lect = FLAG_OFF;
	      logMsg("Buffers data non libres ?\n",0,0,0,0,0,0);
	      continue;		/* Dans ce cas c'est pas la peine de lire */
	    }
	  else pt_buffer = pt_zone_data[ zone_active ] ; /* on pointe au debut de la\
							    zone memoire disponible */
        
	}
      else pt_buffer = pt_zone_data[0] ; /* si test_lect est positionne a 1
					    on ecrit systematiquement dans 
					    le premier tampon */
      
      /*------------------------------LA LECTURE-------------------------*/
      intf_wr_rctrl( DAM ,BUSY ); /* on prend le controle des buffers */
      if ( flag_debug_lect)
	printErr("\nOccupation buffers (DAM=1)");
      pt_fenetre=pt_buffer;
      /* on mesure l'instant de demarrage de la lecture */
      wr_tab_perf( cpt_start_acq , 4 , start_lect = lect_mcchip_timer() );
      nbvaleur = 0.0;
      for(i = 0 ; i < Pt_acq->nbfen ; i++) 
	{
	  if ( Pt_acq->tab_info_fen[i].nobuf  == -1 )
	    {
	      printErr("\nDefaut d'initialisation de la fenetre no:%2d",i);
	      printErr("\nVerifier votre paracq.don !!!!!!!!!\n");
	      break; /* on arrete le processus de lecture */
	    }

	  nbvaleur  += (double)(Pt_acq->tab_fen[i].nblig * Pt_acq->tab_fen[i].nbcol);
	  /* l'offset de debut de la fenetre est determine par le 
	     programme SUN */
	  if ( test_lect == FLAG_OFF )
	    pt_fenetre=pt_buffer+(Pt_acq->tab_info_fen)[i].mem_offset/2;
	  else 
	    pt_fenetre = pt_buffer;

	  if (dma)
            code=lect_buf(&Pt_acq->tab_fen[i], &Pt_acq->tab_info_fen[i],\
			  pt_fenetre);
	  else        
            code=lect_buf_no_dma(&Pt_acq->tab_fen[i], &Pt_acq->tab_info_fen[i],\
				 pt_fenetre);

	  if (code == ERROR)
	    { 
	      logMsg("\n Erreur sur lecture DMA: code 0x%x\n",errnoGet(),0,0,0,0,0 );
	      printErr("\nFenetre no:%2d  Buffer no:%2d",\
		       i, Pt_acq->tab_info_fen[i].nobuf );
	      printErr(" Adresse VME no: %lu ( %X )\n",\
		       pt_fenetre, pt_fenetre );
	      break; /* vaut mieux sortir */
	    }
	  
	} /* fin de la boucle for */

      /* on repere la fin de lecture */
      wr_tab_perf( cpt_start_acq,5,end_lect=lect_mcchip_timer());

      /* lect exprime en millisecondes */
      lect = (end_lect - start_lect + 500)/1000 ;
      printErr("\nDuree de lecture DMA: %d millisecondes ( %2.2f Mo/s )\n",\
	       lect, nbvaleur*2./lect/1000 );
      intf_wr_rctrl( DAM , NOT_BUSY ); /* on rend les buffers */
      if ( flag_debug_lect)
	printErr("\nLiberation buffers (DAM=0)");

      /* positionnement du flag "lecture terminee" */

      if ( test_lect == FLAG_OFF ) 
	{
	  
	  lock_zone( Pt_ctrl , zone_active , SUN_NOT_BUSY );
	  if ( flag_debug_lect)
	    printErr("\nPositionnement flag SUN_NOT_BUSY ( Ok pour la SUN)");
	  
	  if (attente_enrg)
	    {
	      start_enrg = tickGet();
	      start_sun = lect_mcchip_timer();
	      /* attente de fin d'enregistrement avec un chien 
	       de garde de 10 secondes */
	      /* On vide le semaphore de timout sur enregistrement */
	      semTake( sem_timout_enrg , NO_WAIT );
	      while ( Pt_ctrl->verrou[zone_active] != VME_NOT_BUSY )
		{
		  if (tickGet() >= start_enrg + TIMOUT_ENRG_SUN )
		    {
		      logMsg("\n Erreur de timout sur enregistrement\n"\
			     ,0,0,0,0,0,0);
		      err_lect = FLAG_ON ;
		      semGive( sem_timout_enrg );
		      break;
		    }
		}
	      /* on mesure l'instant de fin de l'enregistrement */
	      wr_tab_perf( cpt_start_acq ,6, lect_mcchip_timer() );
	      if ( flag_debug_lect)
		{
		  end_sun = lect_mcchip_timer() - start_sun ;
		  end_sun = (end_sun + 500)/1000; /* en millisecondes */
		  printErr("\nEnregistrement termine. Duree= %d millisecondes", end_sun);
		}
	    }
	  /* Positionnement sur le prochain buffer a remplir */
	  num_buf_vme +=1;
	  if( num_buf_vme == Pt_ctrl->nb_empl) num_buf_vme = 0;
	}
      if (err_lect == FLAG_OFF)
	semGive( sem_lect_ok);	/* liberation du semaphore lecture terminee */
      flag_lect = FLAG_OFF ;
      if ( flag_debug_lect)
	printErr("\nFin de lecture");
      
    }/* fin de la boucle while(1) */
}



/*++********************************************************************
------------------
ENTETE DE FONCTION	:	calcul_adr_zone
------------------

-Role:
Calcul des adresses des NB_MAX_EMPL buffers de donnees definis en memoire commune.
-inclure:
-Prototype:
	void calcul_adr_zone( Datum **pt_zone,Datum *pt,Tb_ctrl *pt_ctrl)
-Parametres:	
		pt_zone : pointeur sur l'adresse du 1er buffer reserve
		pt: pointeur sur la zone commune reservee
		pt_ctrl: pointeur sur la structure partage memoire
-Variables globales utilisees
	Internes au fichier:
	Importees:

-Retour:
-Description:
-Constantes utilisees
	Internes au fichier:
	Importees:
	
-Fonctions utilisees
	Internes au fichier:
	Importees:

-Exemple:
-Commentaires:
********************************************************************--*/


void calcul_adr_zone( Datum **pt_zone , Datum *pt , Tb_ctrl *pt_ctrl )
{
  int i;
  long taille_zone = pt_ctrl->taille_empl;
  for( i = 0 ; i < pt_ctrl->nb_empl ; i++ ) pt_zone[i] = pt + i * taille_zone ;
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	zone_libre
------------------

-Role: 
retourne la  zone de donnees en memoire commune qui est non occupee par la SUN
-inclure:
-Prototype:
	int zone_libre( Tb_ctrl *pt_ctrl , int base)
-Parametres:	
	pt_ctrl: pointeur sur la table de partage memoire
	base = numero de la zone de donnees que l'on veut tester
-Variables globales utilisees
	Internes au fichier:
	Importees:

-Retour: l'indice de la zone libre ou ERR_MEM
-Description:
-Constantes utilisees
	Internes au fichier:
	Importees:	
			VME_NOT_BUSY (acq.h)
	
-Fonctions utilisees
	Internes au fichier:
	Importees:

-Exemple:
-Commentaires:
********************************************************************--*/

int zone_libre( Tb_ctrl *pt_ctrl ,int base )
{
  if ( pt_ctrl->verrou[base] == VME_NOT_BUSY ) return ( base );
  else return ( ERR_MEM);
}

int zone_libre_vis( Tb_ctrl *pt_ctrl ,int base )
{
  if ( pt_ctrl->vervis[base] == VME_NOT_BUSY ) return ( base );
  else return ( ERR_MEM);
}



/*++********************************************************************
------------------
ENTETE DE FONCTION	:	lock_zone
------------------

-Role: positionne un verrou dans la structure partage memoire	
-inclure:
-Prototype:
	void lock_zone( Tb_ctrl *pt_ctrl , int zone , int lock )
-Parametres:	
	pt_ctrl:pointeur sur la structure de controle du partage memoire
	zone:	indice de la zone a verrouiller
	lock:	valeur du verrou
			VME_NOT_BUSY : la memoire est disponible pour le VME
			SUN_NOT_BUSY: la memoire est disponible pour la SUN
			Ces constantes sont definies dans acq.h
-Variables globales utilisees
	Internes au fichier:
	Importees:

-Retour:
-Description:
-Constantes utilisees
	Internes au fichier:
	Importees:
	
-Fonctions utilisees
	Internes au fichier:
	Importees:

-Exemple:
-Commentaires:
********************************************************************--*/
void lock_zone (Tb_ctrl *pt_ctrl,int zone,int lock)
{
   pt_ctrl->verrou[ zone ] = lock ;
   pt_ctrl->vervis[ zone ] = lock ;
	
}

void debug_lect( int flag )
{
  flag_debug_lect = flag;
}
 







