static char *SccsId="@(#)ipg_ccd_v3.c	1.1 07/24/98";

/*
**
**   FILE   : ipg_ccd_v3.c
**
**   AUTHOR : sr ac ( LORIN SA ) dz ( CNRS URA 2080 )
**
**   PRODUCT: logiciel de test IPG, interface camera CCD.
**
**   VERSION: 1.1
**
**   CREATED : 98/07/24 from /usr/themis/soft/bibli/acq/vme/interface/SCCS/s.ipg_ccd_v3.c . Retrieved 98/07/24
**
**   COMMENT: 	
**
*/

/*-------------------------------------HISTORIQUE---------------------------*/
/*
   01.06.98 dz
   allongement du timout sur lecture DMA dans la fonction ipg_rd_bloc
   en esperant que ca evitera l'erreur DMA ???????

   03.11.97 dz

   implementation de semaphores a exclusion mutuelle sur les fonctions
   ipg_rd et ipg_wr pour securiser les les acces aux cartes IPG
   Ce fichier s'appelle maintenant IPG_CCD_V3.C


   14.01.97 dz

   ecriture des fonctions enable_ipg_it() et disable_ipg_it()
   fonctions de validation/inhibition des interruptions entrant sur la carte 
   IP LORIN ( fin_intg , fin_num , it_timout et it_synchro_gps)

   17.12.96 dz

   re-ecriture  de 2 fonctions pour mesurer les performances. 
   utilisation du timer 3 du mcchip.Resolution = 1 micro seconde
       start_mcchip_timer( valeur ): demarrage du timer avec la valeur passee en
       parametre.
       lect_mcchip_timer( ): retourne le contenu du timer.

   12.12.96 dz
                 CE FICHIER S'APPELLE MAINTENANT IPG_CCD_V2.C

   Ajout de la variable ipg_dma et modifications des fonctions 
   d'acces aux registres de l'interface en fonction de cette
   variable. En gros ca veut dire que tant qu'on est en lecture
   DMA, les fonctions ipg_wr/rd quelque chose sont inhibees.
   Because perturbations du generateur d'adresse LORIN .
  
   8.10.96 dz     
   validation de l'it top synchro
   creation du semaphore sem_top_synchro
   Desactivation de l'it timout ( pour l'instant )

   5.10.95 dz	
   Correction du tests d'overflow de la FIFO dans ipg_rd_bloc

   1.09.95 ac	
   Modif ipg_rd_bloc pour utiliser le dma sur ipIn
   Ajout de ipg_test_d, ipg_test_i, ipg_test_a, ipg_test_o

*/

#include <vxWorks.h>
#include <errnoLib.h>
#include <intLib.h>
#include <iv.h>
#include <logLib.h>
#include <semLib.h>
#include <stdio.h>
#include <taskLib.h>
#include <tickLib.h>
#include <vxLib.h>
#include <usrLib.h>
#include <cacheLib.h>
#include <intf.h>

/* Pour mesurer les performances */
#include <drv/multi/mcchip.h>
#define MCC_BASE_ADRS      (0xfff42000)    /* PCC registers base address */

#include <ipic.h>
#include <ipdma.h>

extern int sysIntEnable(int);
extern int sysClkRateGet();


struct	ipg_adr  *ipAdr = (struct ipg_adr *) 0xfff58300 ;
struct	ipg_data *ipIn  = (struct ipg_data *)0xfff58000 ;
struct	ipg_data *ipOut = (struct ipg_data *)0xfff58100;

int	ip_timeout;	/* Timeout sur acces camera (exprime en ticks) */
int     err_num;        /* Erreur de numerisation  */
static int     ipg_dma;        /* positionne a 1 tant que dure la lecture DMA */


int	ipg_drv = 0;
int	ipLevel = 0x02;
u16	ipVector = 0xb0;

SEM_ID	ip_tra_sid;
SEM_ID  sem_fin_intg; /* semaphore fin d'integration */
SEM_ID  sem_fin_num;  /* semaphore fin de numerisation */
SEM_ID  sem_top_synchro; /* semaphore synchro GPS ( venant de la poursuite ) */

SEM_ID  sem_acces_ipg; /* semaphore a exclusion mutuelle
			  ( protection d'acces aux cartes IPG ) */

/*
 *                      LES VARIABLES EXTERNES
 */
extern SEM_ID sem_go_lect; /* semaphore d'autorisation de lecture mode CCD\
                              decrit dans lecture.c */
extern SEM_ID sem_lect_se; /* semaphore d'autorisation de lecture mode \
                                SOLEIL ENTIER. decrit dans soleil_entier.c */
extern lect_ccd;        /* defini dans gen_intg.c */
extern int demande_utc; /* com_rs232.c actif si demande de mise a l'heure */




static	void	ip_intr	(void) ;

int ipg_reset()
{
	u16	val = 0;
	int	erreur ;

	*IPIC_IP_RESET = IPIC_RESET ;
	taskDelay(2);
	*IPIC_IP_RESET = 0 ;
	taskDelay(2);   /* Attend la fin du reset */

	ipg_dma = 0;
	erreur = 0 ;
	if ((vxMemProbe((char *)&ipIn->cmd,  VX_WRITE, 2, (char *)&val)))
	{	printf ("ERREUR acces ipIn\n") ;
		erreur = 1 ;
	}
	if ((vxMemProbe((char *)&ipOut->cmd, VX_WRITE, 2, (char *)&val)))
	{	printf ("ERREUR acces ipOut\n") ;
		erreur = 1 ;
	}
	if ((vxMemProbe((char *)&ipAdr->it,  VX_WRITE, 2, (char *)&ipVector)))
	{	printf ("ERREUR acces ipAdr\n") ;
		erreur = 1 ;
	}
	if ((vxMemProbe((char *)&ipAdr->csr, VX_WRITE, 2, (char *)&val)))
	{	printf ("ERREUR acces ipAdr\n") ;
		erreur = 1 ;
	}

	if (erreur)
	{	errnoSet(IP_INST);
		return(ERROR);
	}

	ipIn->cmd  = IP_OFF ;
	ipOut->cmd = IP_OFF ;

	return (OK) ;
}

int ipg_init()
{
	u16	val = 0;
	u16	itmask;

	if (ipg_reset () != OK)
		return(ERROR);

	if (ipg_drv) return (OK) ;

	/* Create and initialise the semaphores */

	if (((ip_tra_sid = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL) ||
	    ((sem_fin_intg = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL) ||
	    ((sem_top_synchro = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL) ||
            ((sem_fin_num = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL) )
	  {
	    errnoSet(IP_SEM);
	    return(ERROR);
	  }
	/* creation semaphore a exclusion mutuelle */
	if (( sem_acces_ipg = semMCreate(SEM_Q_PRIORITY | SEM_INVERSION_SAFE))==NULL)
	  {
	    errnoSet(IP_SEM);
	    return(ERROR);
	  }
	    
	/* enable interrupt on cpu board and load vector */
	if (intConnect(INUM_TO_IVEC(ipVector) , ip_intr, 0) != 0) 
	{
		logMsg("\n Erreur intconnect %x ", errnoGet(), 0, 0, 0, 0, 0);	
		return(ERROR);
	}

	ipAdr->it = ipVector;
	sysIntEnable (ipLevel);

	/* Valide les interruptions sur le controleur IPIC */
	*IPIC_IPD_INT0_CTL = ipLevel | IP_IT_CLEAR_STATUS | 
			IP_IT_SENSE_LEVEL | IP_IT_ENABLE;

	/* Valide les sources d'interruptions */
	/* ici fin d'intg(IPA_IEN1), fin de num(IPA_IEN2), top synchro GPS(IPA_IEN4) */
	itmask = IPA_IEN1 | IPA_IEN2 | IPA_IEN4;
	val       = ipAdr->acq;	/* Acquittement */
	ipAdr->it = IPA_GIEN | itmask | IPA_IEDMA | ipVector;

	ip_timeout = sysClkRateGet();
	ipg_drv += 1;
	return(OK);
}


int ipg_wr_reg (u16 adrs, u16 val)
{
  u32	tickStart;
  
  if ( ipg_drv == 0)
    {	
      errnoSet( IP_DRV);
      return(ERROR);
    }

  semTake( sem_acces_ipg , WAIT_FOREVER );
 
  ipAdr->adrxs = 0;	/* stoppe l'ipg adresse */
  ipIn->cmd = IP_OFF;
  ipOut->cmd = IP_ON;
  ipOut->fifo = val;
  ipAdr->adrxs = (u16)((adrs & 0x0fff) | IPA_EXEC | IPA_REG);
  tickStart = tickGet();
  while ((ipAdr->csr & IPA_MASK_BUSY) != 0)
    {	if ( tickGet() > ( tickStart + ip_timeout))
      {	
	errnoSet( IP_TMO_1);
	semGive( sem_acces_ipg );
	return(ERROR);
      }
    }
  semGive( sem_acces_ipg );
  return(OK);
}	


int ipg_rd_reg (u16 adrs, u16 *dest)
{
  u32	tickStart;
  
  if ( ipg_drv == 0)
    {	
      errnoSet( IP_DRV);
      return(ERROR);
    }

  semTake( sem_acces_ipg , WAIT_FOREVER );

  ipAdr->adrxs = 0;	/* stoppe l'ipg adresse */
  ipOut->cmd = IP_OFF;
  ipIn->cmd = IP_ON;
  ipAdr->adrxs = (u16)((adrs & 0x0fff) | IPA_EXEC | IPA_REG);
  ipAdr->adrxs = (u16)IPA_NOP;
  tickStart = tickGet();
  while ((ipAdr->csr & IPA_MASK_BUSY) != 0)
    {	
      if ( tickGet() > ( tickStart + ip_timeout))
		{	
		  errnoSet( IP_TMO_1);
		  semGive( sem_acces_ipg );
		  return(ERROR);
		}
    }
  *dest = ipIn->fifo;
  semGive( sem_acces_ipg );
  return(OK);
}


int ipg_wr_data (
	u16 ligne, 
	u16 colonne, 
	u16 val
	)
{
  u32	tickStart;
  
  if ( ipg_drv == 0)
    {	
      errnoSet( IP_DRV);
      return(ERROR);
    }

  semTake( sem_acces_ipg , WAIT_FOREVER );
 
  ipAdr->adrxs = 0;	/* stoppe l'ipg adresse */
  ipIn->cmd = IP_OFF;
  ipOut->cmd = IP_ON;
  ipOut->fifo = val;
  ipAdr->adrys = (u16)(ligne & 0x0fff );
  ipAdr->adrxs = (u16)((colonne & 0x0fff) | IPA_EXEC | IPA_MEM);
  tickStart = tickGet();
  while ((ipAdr->csr & IPA_MASK_BUSY) != 0)
    {	
      if ( tickGet() > ( tickStart + ip_timeout))
	{	
	  errnoSet( IP_TMO_1);
	  semGive( sem_acces_ipg );
	  return(ERROR);
	}
    }
  semGive( sem_acces_ipg );
  return(OK);
}


int ipg_rd_data (
	u16 ligne, 
	u16 colonne, 
	u16 *dest
	)
{
  u32	tickStart;
  
  if ( ipg_drv == 0)
    {	
      errnoSet( IP_DRV);
      return(ERROR);
    }

  semTake( sem_acces_ipg , WAIT_FOREVER ); 

  ipAdr->adrxs = 0;	/* stoppe l'ipg adresse */
  ipOut->cmd = IP_OFF;
  ipIn->cmd = IP_ON;
  ipAdr->adrys = (u16)(ligne & 0x0fff );
  ipAdr->adrxs = (u16)((colonne & 0x0fff) | IPA_EXEC | IPA_MEM);
  ipAdr->adrxs = (u16)IPA_NOP;
  tickStart = tickGet();
  while ((ipAdr->csr & IPA_MASK_BUSY) != 0)
    {	
      if ( tickGet() > ( tickStart + ip_timeout))
	{	
	  errnoSet( IP_TMO_1);
	  semGive( sem_acces_ipg );
	  return(ERROR);
	}
    }
  *dest = ipIn->fifo;
  semGive( sem_acces_ipg );
  return(OK);
}



static	int	test_rdb = 0 ;

int ipg_rd_bloc (
	u16 Sligne, 
	u16 Scolonne, 
	u16 Eligne,
	u16 Ecolonne,
	u16 *buffer,
	int sizeDest,
	int sens
	)
{
  u32	tickStart, total;
  S_IPDMA * pdma ;
  
  pdma = (S_IPDMA *) IPDMA_A ;
  
  if ( ipg_drv == 0)
    {	
      errnoSet( IP_DRV);
      return(ERROR);
    }

  total = (( Eligne - Sligne +1) * ( Ecolonne - Scolonne + 1));
  
  if ( (total > (u32)sizeDest) ||
       ((sens != IPA_INC_LIG) && (sens != IPA_INC_COL)))
    {	
      errnoSet( IP_PARM);
      return(ERROR);
    }
  /* Le buffer doit etre aligne sur une frontiere de ligne de cache */
  if (((u32) buffer % _CACHE_ALIGN_SIZE) != 0)
    {	
      errnoSet( IP_PARM);
      return(ERROR);
    }

  semTake( sem_acces_ipg , WAIT_FOREVER );

  if (test_rdb)
    printf ("Recevoir %d mots\n", total) ;
  else	ipOut->cmd = IP_OFF;

  /* vide le semaphore */
  semTake( ip_tra_sid, NO_WAIT);
  ipg_dma = 1;
  /* Programmer le DMA ip */
  pdma->count   = total * 2 ;		/* compte d'octets */
  pdma->ipadr   = (u32) & ipIn->fifo ;
  pdma->busadr  = (u32)buffer ;
  pdma->itc     = DMAIT_DICLR ;		/* Pas d'it */
  pdma->timeout = DMATO_16 ;
  pdma->ctr2    = DMAC2_SNOOP2 | DMAC2_FROMIP ;

  /* Armer le DMA */
  pdma->ctr1    = DMAC1_16 | DMAC1_SDMA | DMAC1_DTBL ;
  pdma->ctr1    = DMAC1_16 | DMAC1_SDMA | DMAC1_DTBL | DMAC1_DEN ;
  
  if (test_rdb)
    ipIn->cmd = IP_ON | IPI_DMA | IPI_AACK ;
  else	ipIn->cmd = IP_ON | IPI_DMA ;
  
  /* Programmer et demarrer ipAdr */
  ipAdr->adrys = (u16)(Sligne & 0x0fff );
  ipAdr->adrxs = (u16)(Scolonne & 0x0fff );
  ipAdr->adrye = (u16)(Eligne & 0x0fff );
  ipAdr->adrxe = (u16)((Ecolonne & 0x0fff) | 
		       IPA_EXEC | IPA_MEM | IPA_BLOC | (u16)sens);
  
  /* Attend l'it de fin  de generation d'adresse */
  if ( semTake( ip_tra_sid, ip_timeout) != OK)
    {	
      errnoSet(IP_TMO_1);
      ipg_dma = 0;
      semGive( sem_acces_ipg );
      return(ERROR);
    }
  
  /* Attend fin du DMA, avec timeout */
  tickStart = tickGet();
  while (! (pdma->sts & DMASR_DONE))
    {	
      if ( tickGet() > ( tickStart + 2))
	{	
	  errnoSet( IP_TMO_2);
	  ipg_dma = 0;
	  semGive( sem_acces_ipg );
	  return(ERROR);
	}
    }
  
  /* Teste si debordement de la fifo */
  if ((ipIn->sts & IP_MASK_OVFL) != 0)
    {	
      errnoSet( IP_OVER);
      ipIn->sts = 0 ;/* effacer IP_MASK_OVFL */
      ipg_dma = 0;
      semGive( sem_acces_ipg );
      return(ERROR);
    }
  ipg_dma = 0;
  semGive( sem_acces_ipg );
  return(OK);
}


int ipg_wr_bloc (
	u16 Sligne, 
	u16 Scolonne, 
	u16 Eligne,
	u16 Ecolonne,
	u16 *buffer,
	int sens
	)
{
  u32	cnt, tickStart, passe, reste, total;
  register u32 i;	
  register u16 *src;
  
  if ( ipg_drv == 0)
    {	
      errnoSet( IP_DRV);
      return(ERROR);
    }

  if ((sens != IPA_INC_LIG) && (sens != IPA_INC_COL))
    {	
      errnoSet( IP_PARM);
      return(ERROR);
    }

  semTake( sem_acces_ipg , WAIT_FOREVER );

  src = (u16 *)buffer;
  total = (( Eligne - Sligne +1) * ( Ecolonne - Scolonne + 1));
  passe = total / IP_FIFO;
  reste = total % IP_FIFO;
  if ( passe >= 2)
    {	
      cnt = IP_FIFO;
      passe -= 1;
    }
  else
    {	
      cnt = (IP_FIFO * passe) + reste;
      passe = 0;
      reste = 0;
    }
  for ( i=cnt; i!=0; i--)
    ipOut->fifo = *(buffer++);
  
  /* vide le semaphore */
  semTake( ip_tra_sid, NO_WAIT);
  ipg_dma=1;
  ipAdr->adrys = (u16)(Sligne & 0x0fff );
  ipAdr->adrxs = (u16)(Scolonne & 0x0fff );
  ipAdr->adrye = (u16)(Eligne & 0x0fff );
  ipIn->cmd = IP_OFF;
  ipOut->cmd = IP_ON;
  ipAdr->adrxe = (u16)((Ecolonne  & 0x0fff) | 
		       IPA_EXEC | IPA_MEM | IPA_BLOC | (u16)sens);
  
  tickStart = tickGet();
  while ( passe != 0)
    {		/* envoie une demi fifo de donnees */
      for ( i=IP_FIFO; i!=0; i--)
	ipOut->fifo = *(src++);
      passe -= 1;
      
      /* attend fifo mis pleine */
      while ((ipOut->sts & IP_MASK_HALF) == 0)
	{	
	  if ( tickGet() > ( tickStart + ip_timeout))
	    {	
	      errnoSet( IP_TMO_1);
	      ipg_dma=0;
	      semGive( sem_acces_ipg );
	      return(ERROR);
	    }
	}
    }
  /* Envoie le reste */
  for ( i=reste; i!=0; i--)
    ipOut->fifo = *(src++);
  
  /* Attend l'it de fin */
  if ( semTake( ip_tra_sid, ip_timeout) != OK)
    {	
      errnoSet(IP_TMO_2);
      ipg_dma=0;
      semGive( sem_acces_ipg );
      return(ERROR);
    }
  ipg_dma=0;
  semGive( sem_acces_ipg );
  return(OK);
}

/*----------------------------------------------------------------------*/

static	void ip_intr()
{
  u16	valid, activ, tmp;
  
  valid = ipAdr->it & 0x3f00;	/* masque des it valides */
  activ = ipAdr->csr & valid;	/* it actives */
  tmp = ipAdr->acq;		/* acquittement */
  
  if (( activ & IPA_IEDMA) != 0)
    {
      semGive( ip_tra_sid);
    }
  
  /* FIN D'INTEGRATION */
  if (( activ & IPA_IEN1) != 0)
    {
      /* on positionne err_num selon l'etat de ipg_dma 
	 En clair ca veut dire que si la lecture DMA n'est
	 pas terminee avant la fin d'integration, err_num
	 est valide
	 */
      
      err_num = ipg_dma;
      semGive( sem_fin_intg );
      
    }
  
  /* FIN DE NUMERISATION */
  if (( activ & IPA_IEN2) != 0)
    {
      semGive( sem_fin_num );
      /* Si err_num est valide, il n'y a pas de lecture */
      if ( !err_num && lect_ccd ) semGive( sem_go_lect );
      if ( !err_num && !lect_ccd ) semGive( sem_lect_se );
    }
  
  /* IT DE TIMOUT */
  if (( activ & IPA_IEN3) != 0)
    {
      logMsg("IT Time out\n",0,0,0,0,0,0);
    }
  /* IT TOP SYNCHRO HORLOGE GPS */
  if (( activ & IPA_IEN4) != 0)
    {
      /*logMsg("IT IEN4 Top synchro horloge GPS\n",0,0,0,0,0,0);*/
      if( demande_utc ) semGive( sem_top_synchro );
    }
  if (( activ & IPA_IEN5) != 0)
    {
      logMsg("IT IEN5\n",0,0,0,0,0,0);
    }
}


/*      COMPTAGE DU TEMPS QUI PASSE ET QUI NOUS LASSE HELAS !!!!!! */

void start_mcchip_timer( u32 valeur )
{

  *MCC_TIMER3_CR = TIMER3_CR_DIS;
  *MCC_GCR |= GCR_FAST_ON;
  *MCC_TIMER3_CMP = 0xffffffff;
  *MCC_TIMER3_CNT = valeur;            /*charge le compteur avec valeur */
  *MCC_T3_IRQ_CR = T3_IRQ_CR_ICLR | 4;
  *MCC_TIMER3_CR = TIMER3_CR_CEN; /* demarre le comptage */
}


u32 lect_mcchip_timer( void )
{
  return (*MCC_TIMER3_CNT);
}

/*      VALIDATION/INHIBITION DES INTERRUPTIONS */

int enable_ipg_it(u16 masque_it)
{
  u16 temp;
  semTake( sem_acces_ipg , WAIT_FOREVER );
  temp = ipAdr->acq; /* acquittement des its */ 
  ipAdr->it |= masque_it;
  semGive( sem_acces_ipg );
  return OK;
}

int disable_ipg_it(u16 masque_it)
{
  u16 temp;
  semTake( sem_acces_ipg , WAIT_FOREVER );
  temp = ipAdr->acq; /* acquittement des its */ 
  ipAdr->it &= ~masque_it;
  semGive( sem_acces_ipg );
  return OK;
}
