static char *SccsId="@(#)intf_v3.c	1.1 07/24/98";
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:	INTF_V3.C
-----------------
-Auteur(s): 
	Denis Ziegler
-Role: 
	Fonctions de base de pilotage de l'interface d'acquisition
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:	
	 	
-Fonctions:
	Internes au fichier:
			 	intf_init
				ipg_wr_timer
				intf_wr_timer
				start_intg
				start_hard_cad
				stop_hard_cad
				intf_wr_rctrl
				intf_rd_stat
				raz_cam
				reset_cam
				raz_intf

		 
-Commentaires:

********************************************************************;-*/
/*-----------------------------HISTORIQUE-----------------------------
   10 Mars 1999 dz
   protection contre l'acces au timer 0 ( tick de base des timers )
   dans la fonction intf_wr_timer.

   20 Juin 1998 dz
   Ajout de la fonction reset_cam. 
   Idem que raz_cam sauf qu'il n'y a aucun delai avant le retour de la fonction

  07 MAI 1996
  Ajouts des fonctions init_hard_ccd et init_hard_se

  25 AVRIL 1996
  Ajouts des fonctions start_hard_cad  et stop_hard_cad
 
  12 AVRIL 1996
  Nouvelle carte interface avec cadenceur hardware et bits du registre 
  d'etats legerement modifies. Donc:
  Modifications du tableau tab_init: Initialisation du cadenceur hard
  Modifications du tableau val_def : Cadence hard par defaut
 */

#include <vxWorks.h>
#include <taskLib.h>
#include <stdio.h>

#include <acq.h>
#include <intf.h>

typedef struct reg_init {
    U16 adr;
    U16 data;
}Reg_init;



extern ipg_drv; /* si != 0 le driver ipg LORIN est deja initialise \
                  defini dans ipg_ccd.c */
extern Tb_acq *Pt_acq; /* Pointeur sur la table d'acquisition \
                          defini dans Vme-alloc.c */
extern Tb_ctrl_cam *Pt_cam ; /* pointeur sur la table de controle des cameras\
                                defini dans Vme-alloc.c */


/*                    VALEURS D'INITIALISATION DES REGISTRES ET TIMERS              */

Reg_init tab_init[] = {
	{ RADRCAM , 0}, 
	{ R_CTRL , RAZ_INT | RAZ_CAM },
	{ R_OBT , 0xFF}, /* tous ouverts */
	{ R_START , 0 },
	{ R_INT , 0 },
	{ CWR0_2 , INIT_C0},
	{ CWR0_2 , INIT_C1},
	{ CWR0_2 , INIT_C2},
	{ CWR3_5 , INIT_C3},
	{ CWR3_5 , INIT_C4},
	{ CWR3_5 , INIT_C5},
	{ CWR6_W , INIT_C6},
	{ CWR6_W , INIT_C7},
	{ CWR6_W , INIT_CW},
        { CWR9_11, INIT_C9},
        { CWR9_11, INIT_C10},
	{ R_CTRL , MODE_AUTO}
};

/* valeurs par defaut des temps d'integrations */
Reg_init val_def[] = {
	{ C0 , T_1MILLI }, /* horloge de base */
	{ C1 , TINT_DEF }, /* temps d'integration par defaut */
	{ C2 , TINT_DEF },
	{ C3 , TINT_DEF },
	{ C4 , TINT_DEF },
	{ C5 , TINT_DEF },
	{ C6 , TINT_DEF },
	{ C7 , TINT_DEF },
	{ CWOUAF , T_WOUAF }, /* chien de garde des integrations */
        { C9 , T_CAD}, /* Cadence hard par defaut */
        { C10 , T_CAD}
};
 int size_tab_init = sizeof( tab_init ) / sizeof( Reg_init ) ;
 int size_val_def = sizeof( val_def ) / sizeof( Reg_init) ;



/*++********************************************************************
------------------
ENTETE DE FONCTION	: intf_init
------------------

-Role:
	Initialisation de la carte interface
-inclure: 
	intf.h
-Prototype:
	int intf_init( void )
-Parametres: 
-Variables globales utilisees
	Internes au fichier:
	Importees:	
		ipg_drv (ipg_ccd.c)

-Retour: OK ou ERROR 
-Description:
Initialisation de la carte interface avec les valeurs par defaut definies dans les tables val_def et tab_init decrites dans intf.c.
Cette fonction initialise aussi le driver des cartes IPG LORIN.
		
-Constantes utilisees
	Internes au fichier:
	Importees:	
	
-Fonctions utilisees
	Internes au fichier:
	Importees:
		ipg_wr_reg	(ipg_ccd.c)
		ipg_init	(ipg_ccd.c)

-Exemple:
-Commentaires:
********************************************************************--*/



int intf_init( void )
{
 int i , code ;
 if ( ipg_drv == 0 ) 
    if (ipg_init() != OK ) return (ERROR); /* si le driver LORIN n'est pas
					      initialise
					      c'est le moment de le faire */
 for ( i = 0 ; i < size_tab_init ; i++ ) {  
    code = ipg_wr_reg( tab_init[i].adr , tab_init[i].data) ;
    if ( code != OK ) return ERROR;
 }
 for ( i=0 ; i < size_val_def ; i++ ) {
    code = ipg_wr_timer(val_def[i].adr , val_def[i].data);
    if ( code != OK ) return ERROR;
 }
 return ( OK );
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	: ipg_wr_timer
------------------

-Role: fonction de bas niveau d'ecriture dans un timer de l'interface
-inclure: intf.h
-Prototype:
	int ipg_wr_timer( U16 adr , U16 data )
-Parametres:
	 	adr = adresse du timer
		data = valeur
		U16 est defini dans intf.h comme unsigned short		
-Variables globales utilisees
	Internes au fichier:
	Importees:

-Retour: OK ou ERROR
-Description: 
la valeur inscrite dans un timer est une valeur 16bits a entrer en deux etapes:
LSB d'abord puis MSB.
-Constantes utilisees
	Internes au fichier:
	Importees:
	
-Fonctions utilisees
	Internes au fichier:
	Importees:

-Exemple:
-Commentaires:
********************************************************************--*/


int ipg_wr_timer( U16 adr , U16 data )
{
 if ( ipg_wr_reg( adr , LSB(data)) != OK ) return ERROR;
 if ( ipg_wr_reg( adr , MSB(data)) != OK ) return ERROR;
 return OK;
} 

/*++********************************************************************
------------------
ENTETE DE FONCTION	:	start_intg
------------------

-Role:	Lancement d'une integration en mode automatique
-inclure:
-Prototype:
	int start_intg( Byte masque_intg )
-Parametres:	
		masque_intg = masque des integrations utilisees 
		ex: si les integrateurs 1 et 4 sont utilises,
		alors masque_intg =(0 0 0 1 0 0 1 0) en binaire.
-Variables globales utilisees
	Internes au fichier:
	Importees:

-Retour:
-Description:
	Cette fonction lance l'automate d'integrations de la carte interface. 
-Constantes utilisees
	Internes au fichier:
	Importees:
	
-Fonctions utilisees
	Internes au fichier:
	Importees:

-Exemple:
-Commentaires: Seuls les bits 1 a 7 sont utilises pour generer les integrations
********************************************************************--*/


int start_intg( Byte masque_intg )
{
  if (ipg_wr_reg(R_START,(U16) masque_intg) != OK ) return ERROR;
  if (intf_wr_rctrl(HARD_CAD,1) != OK ) return ERROR;
  taskDelay(1);
  if (intf_wr_rctrl(HARD_CAD,0) != OK ) return ERROR;  
  return OK;
}



/*++********************************************************************
------------------
ENTETE DE FONCTION	:	start_hard_cad
------------------

-Role:	Lancement du cadenceur harware
-inclure:
-Prototype:
	int start_hard_cad( U16 cadence , Byte masque )
-Parametres:
		cadence: exprime en nombre de periodes de l'horloge cadenceur
de l'interface. Je m'explique: En mode CCD, l'horloge de cadence est programmee a 1KHZ ( T=1ms ); une cadence de 300 millisecondes sera exprimee 300.
Par contre, en mode Soleil Entier, l'horloge est fixee a 100KHz; donc une 
cadence de 33ms sera exprimee 3300. Vu !!!!!!

		masque_intg = masque des integrations utilisees 
ex: si les integrateurs 1 et 4 sont utilises, alors masque_intg =(0 0 0 1 0 0 1 0) en binaire.

-Variables globales utilisees
	Internes au fichier:
	Importees:

-Retour:
-Description:
-Constantes utilisees
	Internes au fichier:
	Importees:
	
-Fonctions utilisees
	Internes au fichier:
	Importees:

-Exemple:
-Commentaires:
********************************************************************--*/
int start_hard_cad( U16 cadence , Byte masque_intg )
{
  if ( cadence == 0 ) return (ERR_PARAM);
  /* Ecriture de la cadence dans les timers appropries */
  if (ipg_wr_timer(C9 , cadence) != OK) return ERROR;
  if (ipg_wr_timer(C10 , cadence) != OK) return ERROR;
  
  if (ipg_wr_reg(R_START,(U16) masque_intg) != OK ) return ERROR;
  /* Demarrage du cadenceur */
  if (intf_wr_rctrl(HARD_CAD,FLAG_ON) != OK ) return ERROR;  
  return OK;
} 

/*++********************************************************************
------------------
ENTETE DE FONCTION	:	stop_hard_cad
------------------

-Role: Arret du cadenceur hardware
-inclure:
-Prototype:
	int stop_hard_cad( void )
-Parametres:
-Variables globales utilisees
	Internes au fichier:
	Importees:

-Retour:	OK ou ERROR
-Description:
-Constantes utilisees
	Internes au fichier:
	Importees:
	
-Fonctions utilisees
	Internes au fichier:
	Importees:

-Exemple:
-Commentaires:
********************************************************************--*/
int stop_hard_cad( void )
{
 if (intf_wr_rctrl( HARD_CAD , FLAG_OFF ) != OK) return ERROR;
 return OK;
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	: intf_wr_timer
------------------

-Role: modification d'une valeur dans un timer
-inclure: intf.h
-Prototype:
	int intf_wr_timer( Byte timer_num , U16 valeur )
-Parametres:
	timer_num: numero du timer a  initialiser (1 a 7).
			1 a 7 = timers d'integrations.
	valeur: comme son nom l'indique
-Variables globales utilisees
	Internes au fichier: 
	tb_timer[][] (table de correspondance entre le numero du timer et son adresse physique sur la carte interface)
	Importees:
		Pt_acq (pointeur sur la structure Tb_acq en memoire commune)
		

-Retour: OK ou ERROR
-Description: 
La table en memoire commune est d'abord remise a jour avec la nouvelle valeur. Le contenu du timer est ensuite modifie en utilisant la table de correspondance tb-timer.
-Constantes utilisees
	Internes au fichier:
	Importees:	NB_MAX_OBT (acq.h)
	
-Fonctions utilisees
	Internes au fichier:	ipg_wr_timer
	Importees:

-Exemple:
-Commentaires:
********************************************************************--*/

U16 tb_timer[][2] = { {0,C0},{1,C1},{2,C2},{3,C3},{4,C4},{5,C5},{6,C6},{7,C7} 
};

int intf_wr_timer( Byte timer_num , U16 valeur )
{
  if ( timer_num >= NB_MAX_OBT ) return(ERR_PARAM);
  if ( timer_num == 0 ) return(ERR_PARAM);
  Pt_acq ->dintg[timer_num] = valeur ;/* mise a jour de la table */
  if (ipg_wr_timer(tb_timer[timer_num][1] , valeur) != OK ) return (ERROR);
  return (OK);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	intf_wr_rctrl
------------------

-Role: criture d'un bit dans le registre de controle de l'interface
-inclure: intf.h
-Prototype:
	int intf_wr_rctrl( U16 masque , Byte etat )
-Parametres:
		masque: masque du bit a modifier (voir intf.h )
		etat: valeur du bit ( 0 ou 1)
-Variables globales utilisees
	Internes au fichier:
	Importees:
		Tb_ctrl_cam *Pt_cam

-Retour: OK ou ERROR
-Description:
-Constantes utilisees
	Internes au fichier:
	Importees:
	
-Fonctions utilisees
	Internes au fichier:
	Importees:
			ipg_rd_reg (ipg_ccd.c)
			ipg_wr_reg (ipg_ccd.c)

-Exemple: intf_wr_rctrl( DAM , 1 ) 
		on positionne le bit Demande d'Acces Memoire a 1
-Commentaires:
********************************************************************--*/

int intf_wr_rctrl( U16 masque , Byte etat )
{
  U16 valreg;
  /* lecture de la config actuelle dans R_STAT */
  if ( ipg_rd_reg( R_STAT , &valreg) != OK ) return (ERROR);

  if (etat) valreg |= masque ; /* ou logique pour forcer a 1 */
  else valreg &= ~masque ; /* sinon et logique avec le complement pour forcer a 0 */ 

  /* mise a jour du registre controle dans Tb_ctrl_cam */
  Pt_cam->controle = valreg ;
  /* ecriture de la nouvelle config dans R_CTRL */
  if ( ipg_wr_reg( R_CTRL , valreg ) != OK ) return (ERROR) ;
  return (OK);
}	

/*++********************************************************************
------------------
ENTETE DE FONCTION	:	intf_rd_rstat
------------------

-Role: lecture d'un bit du registre R_STAT de l'interface
-inclure: intf.h
-Prototype:
	int intf_rd_rstat( U16 masque , Byte *etat)
-Parametres:	
		masque: masque du bit a lire (voir intf.h)
		etat: etat du bit ( 0 ou 1 )
-Variables globales utilisees
	Internes au fichier:
	Importees: 
			Tb_ctrl_cam *Pt_cam

-Retour: OK ou ERROR
-Description:
-Constantes utilisees
	Internes au fichier:
	Importees:
			FLAG_ON
			FLAG_OFF
	
-Fonctions utilisees
	Internes au fichier:
	Importees:
			ipg_rd_reg

-Exemple: intf_rd_rstat( DAM , &etat ) lecture du bit DAM de l'interface
-Commentaires:
********************************************************************--*/

int intf_rd_rstat( U16 masque , Byte *etat )
{
  U16 valreg;
  if ( ipg_rd_reg( R_STAT , &valreg ) != OK ) return (ERROR);
  /* mise a jour du registre etat dans Tb_ctrl_cam */
  Pt_cam->etat = valreg & 0x777F; /* masque pour mettre a zero les bits\
                                      non utilises de R_STAT */
  if ( valreg & masque ) *etat=FLAG_ON;
  else *etat=FLAG_OFF;
  return (OK);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	raz_cam
------------------

-Role:	reset des cameras
-inclure:
-Prototype:
	int raz_cam(void)
-Parametres:
-Variables globales utilisees
	Internes au fichier:
	Importees:

-Retour: OK ou ERROR
-Description:	
Cette fonction initialise l'electronique des cameras (reset hardware) mais ne modifie en rien le contenu des registres et buffers des cameras.
-Constantes utilisees
	Internes au fichier:
	Importees:
			FLAG_ON	
			FLAG_OFF
	
-Fonctions utilisees
	Internes au fichier:
				intf_wr_rctrl
	Importees:

-Exemple:
-Commentaires:
********************************************************************--*/

int raz_cam( void )
{
  if ( intf_wr_rctrl( RAZ_CAM , FLAG_ON ) == ERROR ) return ( ERROR);
  if ( intf_wr_rctrl( RAZ_CAM , FLAG_OFF ) == ERROR ) return ( ERROR );
  taskDelay(1);  /* on laisse largement le temps a l'electronique pour
		   se recuperer */
  return ( OK );
}
/* la meme fonction que plus haut, sauf qu'on attend pas */
int reset_cam( void )
{
  if ( intf_wr_rctrl( RAZ_CAM , FLAG_ON ) == ERROR ) return ( ERROR);
  if ( intf_wr_rctrl( RAZ_CAM , FLAG_OFF ) == ERROR ) return ( ERROR );
  return OK;
}  


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	raz_intf	
------------------

-Role:	Reset de l'interface
-inclure:
-Prototype:
	int raz_intf( void )
-Parametres:
-Variables globales utilisees
	Internes au fichier:
	Importees:

-Retour: OK ou ERROR
-Description:
Cette fonction remet a zero le sequenceur hard de l'interface mais ne modifie en rien le contenu des registres internes.
		
-Constantes utilisees
	Internes au fichier:
	Importees:
			FLAG_ON 
			FLAG_OFF
	
-Fonctions utilisees
	Internes au fichier:
				intf_wr_rctrl
	Importees:

-Exemple:
-Commentaires:
********************************************************************--*/
int raz_intf( void )
{
  if ( intf_wr_rctrl( RAZ_INT , FLAG_ON ) == ERROR ) return ( ERROR);
  taskDelay(1);
  if ( intf_wr_rctrl( RAZ_INT , FLAG_OFF ) == ERROR ) return ( ERROR );
  return ( OK );
}




/*----------------------------------------------------------------------------------*/
/*				FONCTIONS DE TESTS				    */
/*----------------------------------------------------------------------------------*/
int test_rctrl( void )
{
 int i ;
 U16 valreg;
 for(i=0;i<256;i++)
 {
   if ( ipg_wr_reg( R_CTRL , i ) == ERROR ) return (ERROR);
   if ( ipg_rd_reg( R_STAT , &valreg) == ERROR ) return (ERROR);
   if ( (valreg & 0xFF) != (i & 0x7F) ) printf("\n Ecrit %x, lu %x",i&0x7f,valreg&0xff);
 }
 return (OK);
}

U16 lect_rstat( void)
{
 U16 valreg;
 if ( ipg_rd_reg( R_STAT , &valreg ) == ERROR ) return (ERROR);
 return ( valreg );
}
  
int wr_rctrl( Byte val)
{
 if ( ipg_wr_reg( R_CTRL , val)  == ERROR ) return (ERROR);
 return (OK);
}



