static char *SccsId="@(#)init_cam.c	1.1 07/24/98";
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:	INIT_CAM
-----------------
-Auteur(s):	D.ZIEGLER
-Rle:	Initialisation d'une camra et buffers associs.
	
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
				init_cam
	 
-Commentaires:

********************************************************************;-*/

#include <intf.h>
#include <stdio.h>

/*
 *			FONCTIONS INTERNES
 */
int init_cam( Byte cam_num );

/*
 *			FONCTIONS EXTERNES
 */
extern init_buf();	/*buf_v3.c */
extern detect_cam();	/*buf_v3.c */

/*++********************************************************************
------------------
ENTETE DE FONCTION	:	INIT_CAM
------------------

-Rle:	initialisation d'une camra et buffers associs
-inclure:
-Prototype:
	int init_cam( Byte cam_num )
-Paramtres:	
	cam_num: numro de la camra  initialiser
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour: OK ou ERROR	ERR_NO_BUF ( absence carte buffer)
			ERR_RCPT ( erreur reception camra )
-Description:	
		Initialisation du plan obscurit  0 (OBSC_DEFAUT)
		Initialisation du plan correctif  4096 (FLAT_DEFAUT)
		RAZ de la camra 
-Constantes utilises
	Internes au fichier:
	Importes:	
			OBSC_DEFAUT	(intf.h)
			FLAT_DEFAUT	(intf.h)
	
-Fonctions utilises
	Internes au fichier:
	Importes:	
			init_buf	

-Exemple:
-Commentaires:
********************************************************************--*/

int init_cam( Byte cam_num )
{ 
  int flag ;
  
  if ( raz_cam() == ERROR ) return ( ERROR );
  flag = detect_cam( cam_num );
  if ( flag == ERR_NO_BUF ) return ( ERR_NO_BUF );
  if ( init_buf( cam_num , PLAN_OBSC, OBSC_DEFAUT ) != OK ) return (ERROR);
  if ( init_buf( cam_num , PLAN_CORR, FLAT_DEFAUT ) != OK ) return (ERROR); 
  if ( flag == ERR_RCPT ) return ( ERR_RCPT );
   return( OK );
}

int tout_init_cam( void )
{
  int i,code;
  for ( i=1; i<NB_MAX_CAM ; i++ )
    {
      code = init_cam(i);
      if ( code == ERR_NO_BUF )
	printf("Carte buffer N:%d non detectee\n",i);
      else
	printf("Carte buffer N:%d OK\n",i);
    }
  return( OK );
}
