static char *SccsId="@(#)cmd_v3.c	1.3 07/27/98";
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:	CMD_V3.C
-----------------
-Auteur(s):Denis Ziegler
-Rle:	Regroupe les fonctions de commandes de lancement, arrt des intgrations
	demande de lecture etc.....
-Constantes
	Internes au fichier:
				SECONDE
				10_SECONDES
				T_LECT
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:	
				start_acq
				wacq
				stop_acq
				start_lect
				time_lect		
	 
-Commentaires:	pas de commentaires

********************************************************************;-*/
/*--------------------------HISTORIQUE------------------------------*/
/*
  16 Octobre 1998 dz
  S'il n'y a pas encore eu de decodage ( modob = -1 )
  start_acq et wacq sont inoperants.

  9 Octobre 1998 dz
  Modif sur wacq();
  La lecture des buffers doit etre terminee avant d'autoriser une 
  nouvelle integration. Sinon la tache de lecture en cours se trouve
  un poil perturbee et induit des bugs sur le comportement du logiciel.
  ( bugs aleatoires qui plantent le VME et pas faciles a trouver ).
  Le choix pour cette modif est d'attendre,dans la fonction wacq(),
  la fin de lecture des fenetres.
  
  27 Juillet 1998 dz
  Correction bug  ( version 1.3 )
  On vide par securite, les semaphores sem_lect_ok et sem_timout_enrg
  dans la fonction start_acq

  25 Juillet 1998 dz
  inclusion du fichier header com_ucci_vme.h
  Modifications des codes d'erreurs de retour de la fonction wacq
  conformement aux codes definis dans le fichier header predemment
  cite. 

  21 Juin 1998 dz
  Implantation de la fonction wacq() declenchee par la chaine de
  caracteres $WACQ en provenance de la ligne RS232 ( rs232_v3.c)
  Des la disponibilite  du  buffer d'ecriture , la fonction declenche
  une acquisition et retourne OK ou diverses erreurs de timout

  */

#include <vxWorks.h>
#include <semLib.h>
#include <tickLib.h>
#include <intf.h>
#include <com_ucci_vme.h>

#define SECONDE      sysClkRateGet()
#define DIX_SECONDES (10*SECONDE)
#define TIMOUT_WACQ  (180*SECONDE)
#define T_LECT       100 /* resolution temps de lecture = 1/100ieme seconde */

/*
 *			FONCTIONS INTERNES
 */
int start_acq( int attente );
int wacq( void );
int stop_acq(void);
int start_lect(void);
int time_lect(long *temps_lect);

/*
 *			FONCTIONS EXTERNES
 */
extern sysClkRateGet();
extern convert_cad();
extern zone_libre();  /* defini dans lecture_v3.c */


/*
 *			VARIABLES GLOBALES
 */

extern SEM_ID sem_start_acq; /* start acquisition (gen_intg_v3.c)*/
extern SEM_ID sem_stop_acq; /* stop acquisition  (gen_intg_v3.c) */
extern SEM_ID sem_start_ok;  /* integration correctement lance (gen_intg_v3.c) */
extern SEM_ID sem_go_lect; /* start lecture buffers (lecture_v3.c) */
extern SEM_ID sem_lect_ok; /* lecture terminee (lecture_v3.c) */
extern SEM_ID sem_timout_enrg; /* timout sur enregistrement ( lecture_v3.c) */
extern SEM_ID sem_wacq_ok; /* integration et numerisation terminees (gen_intg_v3.c) */
extern SEM_ID sem_intg_error ; /* timout sur integration ( gen_intg_v3.c) */
extern SEM_ID sem_num_error ; /* timout sur numerisation ( gen_intg_v3.c) */

 
int attente_enrg;

extern int init_acq_ok;     /* start_v3.c */
extern Tb_ctrl_cam *Pt_cam; /* Pointeur sur table de controle des cameras*/
extern Tb_acq *Pt_acq;      /* Pointeur sur table des parametres d'acquisition */
extern Tb_ctrl *Pt_ctrl;    /* pointeur sur la structure partage memoire */

extern int num_buf_vme;     /* buffer disponible pour la lecture (lecture_v3.c)
			       on l'utilise dans la fonction wacq  */

extern int test_lect;       /* lecture_v3.c  */
extern int flag_lect;       /* lecture_v3.c  */


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	START_ACQ
------------------

-Rle: demarrage d'une acquisition
-inclure:
-Prototype:
	int start_seq( int attente )
-Paramtres:
	attente: Si attente = 1, la fonction attend la fin de l'enregistrement pour se terminer.
-Variables globales utilises
	Internes au fichier:
	Importes:
		sem_start_ok
		sem_start_acq

-Retour:OK ou ERROR
-Description: 	
		La fonction rend disponible le semaphore sem_start_acq
		Les parametres necessaires a l'acquisition sont lus
		dans la table d'acquisition.
		La fonction retourne OK si les integrations ont demarre
		correctement
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:

-Commentaires:
********************************************************************--*/
/* 18 MAI 1995
 * modif pour Rayrole on attend la fin de l'enregistrement pour rendre 
 * la main ou non : ajout du parametre attente dans la fonction
 */
int start_acq( int attente )
{
  ULONG start_boucle;
  attente_enrg=attente; 
  /* Si init_acquisition n'est pas lance */
  if ( init_acq_ok == 0 )
    return(ERROR);
  /* S'il n'y a pas eu de decodage */
  if ( Pt_acq->modob == -1 )
    return(ERROR);

  if ( semGive(sem_start_acq)!= OK ) return(ERROR);
  /* attente de la reponse start_ok */
  if ( semTake(sem_start_ok , SECONDE) !=OK ) return(ERROR);
  /* attente fin de lecture et d'enregistrement */
  if ( attente )
    {
      semTake(sem_lect_ok, NO_WAIT); /* On vide les semaphores */
      semTake(sem_timout_enrg, NO_WAIT);
      start_boucle = tickGet();
      while(1)
	{
	  /* Si on est vraiment coince, on peut sortir par la */
	  if (tickGet() > start_boucle + TIMOUT_WACQ)
	    {
	      printf("\nSTART_ACQ(1): Erreur generale de timout\n");
	      attente_enrg = 0;
	      return(ERROR);
	    }
	  if( semTake(sem_lect_ok,NO_WAIT)==OK )
	    {
	      attente_enrg = 0;
	      return (OK); /*OK on sort de la boucle */
	    }
	  if( semTake(sem_timout_enrg,NO_WAIT)==OK )
	    {
	      attente_enrg = 0;
	      return (ERROR);
	    }
	  taskDelay(1); /* on va attendre un peu */
	}
    }
  return(OK);
}

/*-----------------------------------------------------------------------------*/
/* la fonction lancee par l'ucci et qui retourne quand l'integration
   est finie ou sur diverses erreurs de timout
 */

int wacq(void)
{
  ULONG start_boucle;
  long ctrac;
  int buffer_dispo;
  attente_enrg = 0; /* on ne doit pas se trouver dans le mode d'attente
		       de fin d'enregistrement avec wacq */

  ctrac=Pt_acq->ctrac; /* on sauvegarde le parametre actuel */
  semTake( sem_wacq_ok , NO_WAIT  ); /* on vide les semaphore */
  semTake( sem_intg_error, NO_WAIT);
  semTake( sem_num_error, NO_WAIT);
  /* Si init_acquisition n'est pas lance */
  if ( init_acq_ok == 0 ) return(ERR_CMD_UCCI_1); 
  /* s'il n'y a pas eu de decodage */
  if ( Pt_acq ->modob == -1 ) return(ERR_CMD_UCCI_1);

  Pt_acq->ctrac = SIMPLE; /* wacq ne peut se faire qu'en mode coup par coup */

  /* La lecture DMA doit etre terminee */

  if ( flag_lect == FLAG_ON )
    {
      start_boucle = tickGet();
      printf("\nWACQ: Attente de fin de lecture DMA\n");
      while( flag_lect == FLAG_ON )
	{
	  if ( tickGet() > start_boucle + TIMOUT_WACQ )
	    {
	      Pt_acq->ctrac = ctrac; /* on restaure le mode precedent */
	      printErr("\nWACQ: Erreur de timeout sur fin de lecture DMA\n");
	      return(ERR_CMD_UCCI_6);
	    }
	  taskDelay(1); /* on attend un peu avant de remonter tester le flag*/
	} /* fin de boucle while */
    }
      
  if ( test_lect == FLAG_OFF )
    {
      /* le prochain buffer d'ecriture doit etre disponible */

      buffer_dispo = zone_libre( Pt_ctrl , num_buf_vme );
      if ( (buffer_dispo == ERR_MEM) )
	{
	  start_boucle = tickGet();
	  printf("\nWACQ: Attente de disponibilite buffers\n");
	  while( (buffer_dispo == ERR_MEM) )
	    {
	      if ( tickGet() > start_boucle + TIMOUT_WACQ )
		{
		  Pt_acq->ctrac = ctrac; /* on restaure le mode precedent */
		  printErr("\nWACQ: Erreur de timeout sur buffers disponibles\n");
		  return(ERR_CMD_UCCI_4);
		}
	      taskDelay(1); /* on attend un peu et on reteste les flags*/
	      buffer_dispo = zone_libre( Pt_ctrl , num_buf_vme );
	    }
	}
    }


  if ( semGive(sem_start_acq)!= OK )
    {
      Pt_acq->ctrac = ctrac;  /* on restaure le mode precedent */
      return(ERR_CMD_UCCI_1);
    }
  printErr("\n WACQ: Lancement de l'integration\n");
  /* attente de la reponse intg_ok ou intg_error */
  start_boucle = tickGet();
  while(1)
    {
      /* Si on est vraiment coince, on peut sortir par la */
      if (tickGet() > start_boucle + TIMOUT_WACQ)
	{
	  Pt_acq->ctrac = ctrac; /* on restaure le mode precedent */
	  printErr("\nWACQ: Erreur Generale de timeout\n");
	  return(ERR_CMD_UCCI_5);
	}
      if(semTake( sem_wacq_ok , NO_WAIT)==OK) break; /* ok on sort de la boucle */
      if(semTake( sem_intg_error , NO_WAIT) == OK)
	{
	  Pt_acq->ctrac = ctrac;  /* on restaure le mode precedent */
	  printErr("\nWACQ: Erreur timeout sur fin d'integration \n");
	  return (ERR_CMD_UCCI_2);
	}
      if( semTake(sem_num_error, NO_WAIT)==OK)
	{
	  Pt_acq->ctrac = ctrac;  /* on restaure le mode precedent */
	  printErr("\nWACQ: Erreur timeout sur fin de numerisation \n");
	  return (ERR_CMD_UCCI_3);
	}
      taskDelay(1); /* pour ne pas boucler comme une bete */
    } 
  Pt_acq->ctrac = ctrac; /* on restaure le mode precedent */
  return(NO_ERR_CMD_UCCI);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	STOP_ACQ
------------------

-Rle: stoppe une acquisition
-inclure:
-Prototype:
	int stop_acq
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:	sem_stop_acq

-Retour: OK ou ERROR
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

int stop_acq(void)
{
  if ( init_acq_ok == 0 ) return (ERROR);
  if ( semGive( sem_stop_acq) != OK ) return (ERROR);
  return OK;
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	START_LECT
------------------

-Rle:	lancer une lecture des buffers
-inclure:
-Prototype:
	int start_lect(void)
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:	sem_go_lect, sem_lect_ok

-Retour: OK ou ERROR
-Description:	La fonction retourne OK si la lecture s'est correctement
		effectuee.
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

int start_lect(void)
{
  if ( init_acq_ok == 0 ) return (ERROR);
  if ( semGive( sem_go_lect ) != OK ) return (ERROR);
  if ( semTake( sem_lect_ok , DIX_SECONDES ) != OK ) return (ERROR) ;
  return (OK) ;
}
 

/*++********************************************************************
------------------
ENTETE DE FONCTION	:	TIME_LECT
------------------

-Rle:	calcul du temps d'execution de la fonction de lecture des buffers
-inclure:
-Prototype:
	int time_lect(long *temps_lect)
-Paramtres:	temps: temps d'execution exprime en centisecondes
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour: OK ou ERROR
-Description:	
-Constantes utilises
	Internes au fichier:	T_LECT
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:	sysClkRateGet()
			tickGet()

-Exemple:
-Commentaires: Pas de commentaires 
********************************************************************--*/

int time_lect( long *temps_lect)
{
  long start, stop ;
  if ( init_acq_ok == 0 ) return (ERROR);
  if ( semGive( sem_go_lect ) != OK ) return (ERROR); /* lancement de la lecture */
  start = tickGet();
  if ( semTake( sem_lect_ok , DIX_SECONDES ) == ERROR ) return (ERROR);
  stop = tickGet();
  *temps_lect = (stop - start)*T_LECT/SECONDE; /* temps exprime en cs */
  return(OK);
}





