static char *SccsId="%W% %G%";
/*;+********************************************************************
-----------------
ENTETE DE FICHIER       :  cmd_ucci.c    
-----------------
-Auteur(s):D.Zig
-R?le:     fonctions de traitement des commandes en provenance
           de l'UCCI
           
-Constantes
	Internes au fichier: 
		
				
		
-Variables
	Internes au fichier: 

		
-Fonctions:
	Internes au fichier:


	 
-Commentaires:	pas de commentaires

********************************************************************;-*/
/*---------------------------historique-------------------------------*/
/*
  27 Juillet 1998 dz
  Ecriture des fonctions de decodage des parametres envoyes par l'UCCI
  via la ligne RS232.

  20-03-2000 Jerome Minec
  La ligne RS232 est supprimee et remplacee par une communication par
  sockets. Les arguments des fonctions sont passes en parametre et plus
  dans un tampon (tamp_rs232[]).
  La fonction utc() est desormais obsolete.
  Je garde le flag de debuggage (pas longtemps...)

  26-01-2001 Jerome inec
  Indlamb n'est plus transmis par l'UCCI : depend desormais de la fenetre.
  */

#include <string.h>
#include <stdlib.h>
#include <acq.h> 
#include <intf.h>
#include <com_ucci_vme.h>

extern start_acq(); /*  defini dans cmd_v3.c */
extern set_utc();    /* defini dans timekeeper.c */

/* --------------------------------VARIABLES EXTERNES--------------------*/
extern Tb_acq *Pt_acq; /* Pointeur sur la table des parametres */
extern Tb_ctrl *Pt_ctrl; /* Pointeur sur la table des verrous */
extern int flag_debug_com; /*flag de debuggage rs232 vient de rs232_v3.c */

/*----------------------------------VARIABLES INTERNES----------------*/
static int tab_utc[NB_MAX_INT_PARAM]; /* pour stocker les parametres
					 hh-mn-sec de l'heure */
int demande_utc; /* actif si demande de mise a l'heure via la ligne RS232 */

int acqui( void )
{
  if ( start_acq(1) == ERROR ) return (ERR_CMD_UCCI_1);
  return( NO_ERR_CMD_UCCI );
}
/*
int utc(void) 
{  
   int nb_param,code_err; 
   nb_param = extract_int_param( tamp_rs232, sep_utc, tab_utc );
   if ( nb_param != NB_MAX_INT_PARAM ) 
     return(ERR_CMD_UCCI_1); 
   demande_utc = 1; 
   code_err = set_utc( tab_utc, nb_param ); 
   demande_utc = 0; 
   if( code_err == ERROR ) 
     return( ERR_CMD_UCCI_2 ); 
   return( NO_ERR_CMD_UCCI ); 
 } 
*/
int inde(seq_ind, ind_reg)
long seq_ind, ind_reg;
{
  Pt_acq->index.seq_ind = seq_ind;
  Pt_acq->index.ind_reg = ind_reg;
  Pt_ctrl->dyn_flags[DFLAG_INDEX] = SUN_NOT_BUSY; /* la sun peut venir lire */
  return (NO_ERR_CMD_UCCI);
}

/* ci-dessous : provisoire, il faudrait utiliser affstep, mais pas encore implemente
par UCCI et lambda est obsolete mais existe */
/* remet a 0 stepX si indlambd=0 (cas general, X axis first) et stepY sinon */

int lambda(indlambd)
long indlambd;
{
/*  Pt_acq->index.indlambd = indlambd;*/

  if(flag_debug_com)
    {
      printErr("\nPar1: %i", indlambd);
    }

  if(indlambd==0) { Pt_acq->index.indstepx = 0; }
  else { Pt_acq->index.indstepy =0; }
  Pt_ctrl->dyn_flags[DFLAG_STEP] = SUN_NOT_BUSY;


/*  Pt_ctrl->dyn_flags[DFLAG_INDLAMBD] = SUN_NOT_BUSY;*/ /* la sun peut venir lire */
  return (NO_ERR_CMD_UCCI);
}

int step(void)
{
  Pt_acq->index.indstep +=1;
  Pt_ctrl->dyn_flags[DFLAG_STEP] = SUN_NOT_BUSY;
  return( NO_ERR_CMD_UCCI );
}

int stepx(void)
{
  Pt_acq->index.indstepx +=1;
  Pt_ctrl->dyn_flags[DFLAG_STEP] = SUN_NOT_BUSY;
  return( NO_ERR_CMD_UCCI );
}

int stepy(void)
{
  Pt_acq->index.indstepy +=1;
/*  Pt_acq->index.indstepx = 0;*/
  Pt_ctrl->dyn_flags[DFLAG_STEP] = SUN_NOT_BUSY;
  return( NO_ERR_CMD_UCCI );
}

/* affecte indstepx et indstepy, donner -1 pour ne pas changer la valeur */
int affstep(a,b)
long a,b;
{
  if(a>=0) { Pt_acq->index.indstepx =a; }
  if(b>=0) { Pt_acq->index.indstepy =b; }
  Pt_ctrl->dyn_flags[DFLAG_STEP] = SUN_NOT_BUSY;
  return( NO_ERR_CMD_UCCI );
}

int ana(stokes)
long stokes;
{
  Pt_acq->index.stokes = stokes;

  if(flag_debug_com)
    {
      printErr("\nPar1: %i", stokes);
    }
 
  Pt_ctrl->dyn_flags[DFLAG_STOKES] = SUN_NOT_BUSY; /* la sun peut venir lire */
  return (NO_ERR_CMD_UCCI);
}

int ppou(alpha, delta, polarang, svector, longitud, latitud, dist_ew, dist_ns, prefente, posrot, eleva, azimuth, longcarr)
float alpha, delta, polarang, svector, longitud, latitud, dist_ew, dist_ns, prefente, posrot, eleva, azimuth, longcarr;
{
  Pt_acq->dyn.alpha = alpha;
  Pt_acq->dyn.delta = delta;
  Pt_acq->dyn.polarang = polarang;
  Pt_acq->dyn.svector = svector;
  Pt_acq->dyn.longitud = longitud;
  Pt_acq->dyn.latitud = latitud;
  Pt_acq->dyn.dist_ew = dist_ew;
  Pt_acq->dyn.dist_ns = dist_ns;
  Pt_acq->dyn.prefente = prefente;
  Pt_acq->dyn.posrot = posrot;
  Pt_acq->dyn.eleva = eleva;
  Pt_acq->dyn.azimuth = azimuth;
  Pt_acq->dyn.longcarr = longcarr;
  Pt_ctrl->dyn_flags[DFLAG_PPOU] = SUN_NOT_BUSY;
  if(flag_debug_com)
    {
      printErr("\n par0:%f\npar1:%f", alpha, delta);
      printErr("\n par2:%f", polarang);
      printErr("\nalpha= %f \ndelta= %f", Pt_acq->dyn.alpha, Pt_acq->dyn.delta);
      printErr("\npolarang= %f\nsvector= %f", Pt_acq->dyn.polarang, Pt_acq->dyn.svector);
      printErr("\nlongitud= %f\nlatitud= %f", Pt_acq->dyn.longitud, Pt_acq->dyn.latitud);
      printErr("\nprefente= %f\nposrot= %f", Pt_acq->dyn.prefente, Pt_acq->dyn.posrot);
      printErr("\ndist_ew= %f\ndist_ns= %f", Pt_acq->dyn.dist_ew, Pt_acq->dyn.dist_ns);
      printErr("\neleva= %f\nazimuth= %f", Pt_acq->dyn.eleva, Pt_acq->dyn.azimuth);
      printErr("\nlongcarr= %f", Pt_acq->dyn.longcarr);
    }
  return( NO_ERR_CMD_UCCI );
}

int da0(solar_p0, solar_b0, ngcarr, solar_n, solar_r)
float solar_p0, solar_b0, ngcarr, solar_r;
long solar_n;
{
  if(flag_debug_com)
    {
      printErr("\npar solar_p0: %f",solar_p0);
      printErr("\npar solar_b0: %f",solar_b0);
      printErr("\npar ngcarr: %f",ngcarr);

      printErr("\npar solar_n: %i",solar_n);
      printErr("\npar solar_r: %f",solar_r);
    }

  Pt_acq->dyn.solar_p0 = solar_p0;
  Pt_acq->dyn.solar_b0 = solar_b0;
  Pt_acq->dyn.ngcarr = ngcarr;
  Pt_acq->dyn.solar_n = solar_n;
  Pt_acq->dyn.solar_r = solar_r;

  if(flag_debug_com)
    {
      printErr("\nfloat solar_p0: %f",Pt_acq->dyn.solar_p0);
      printErr("\nlong solar_n: %i",Pt_acq->dyn.solar_n);
      printErr("\nfloat solar_r: %f",Pt_acq->dyn.solar_r);
    }
/*  Pt_ctrl->dyn_flags[DFLAG_PPOU] = SUN_NOT_BUSY;*/
  return( NO_ERR_CMD_UCCI );
}

int dax1(tempqwp1, tempqwp2, tempbmsp, predang, echelang)
float tempqwp1, tempqwp2, tempbmsp, predang, echelang;
{
  if(flag_debug_com)
    {
      printErr("\npar tempqwp1: %f",tempqwp1);
      printErr("\npar tempqwp2: %f",tempqwp2);
      printErr("\npar tempbmsp: %f",tempbmsp);
      printErr("\npar predang: %f",predang);
      printErr("\npar echelang: %f",echelang);
    }

  Pt_acq->dyn.tempqwp1 = tempqwp1;
  Pt_acq->dyn.tempqwp2 = tempqwp2;
  Pt_acq->dyn.tempbmsp = tempbmsp;
  Pt_acq->dyn.predang = predang;
  Pt_acq->dyn.echelang = echelang;

/*  Pt_ctrl->dyn_flags[DFLAG_PPOU] = SUN_NOT_BUSY;*/
  return( NO_ERR_CMD_UCCI );
}

int plam(posqwp1, posqwp2)
long posqwp1, posqwp2;
{
  Pt_acq->dyn.posqwp1 = posqwp1;
  Pt_acq->dyn.posqwp2 = posqwp2;

  if(flag_debug_com)
    {
      printErr("\nPar1: %i, Par2: %i", posqwp1, posqwp2);
    }
  Pt_ctrl->dyn_flags[DFLAG_PLAM] = SUN_NOT_BUSY; /* la sun peut venir lire */
  return (NO_ERR_CMD_UCCI);
}
