static char *SccsId="@(#)buf_v3.c	1.1 07/24/98";
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:	buffers_v3.c
-----------------
-Auteur(s): Denis Ziegler
-Role: fonctions d'acces aux cartes buffers des cameras
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:		
	 	
-Fonctions:
	Internes au fichier:
				init_buf
				lect_buf
				lect_buf_no_dma
				lect_buf_dma
				wr_buf	
				test_buf
				detect_cam		     
-Commentaires:
********************************************************************;-*/

#include <vxWorks.h>
#include <cacheLib.h>
#include <stdio.h>
#include <ioLib.h>
#include <acq.h>
#include <intf.h>


extern lect_stat_cam(); /* cam_v3.c */

int init_buf( Byte cam_num , Byte plan_num , Datum valeur );
int lect_buf( Coor_fen *pt_coord , Fen_info *pt_info , Datum *tableau);
int lect_buf_no_dma( Coor_fen *pt_coord , Fen_info *pt_info , Datum *tableau);
int wr_buf( char *name, int lig_deb,int col_deb,int nb_lig,int nb_col,\
	   Byte num_carte, Byte num_plan);
int detect_cam( Byte cam_num );
int test_cam(void);
int test_cam2(char *resul);


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	init_buf
------------------

-Rle: Initialisation d'un plan mmoire d'une camra  une valeur fixe
-inclure: intf.h
-Prototype:
	int init_buf( Byte cam_num , Byte plan_num , Datum valeur )
-Paramtres:	
		cam_num: numro de la camra (0  22)
		plan_num: numro du plan mmoire  initialiser (1  3)
		valeur: valeur d'initialisation
-Variables globales utilises
	Internes au fichier:
	Importes: 

-Retour: OK ou ERROR
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes: 
		ipg_wr_reg 
		ipg_wr_data

-Exemple: 
	init_buf(2,3,4096): initialisation du plan correctif 3  de la camra 2  4096
-Commentaires: 
	Dure d'excution de la fonction = xxx millisecs
********************************************************************--*/
int init_buf( Byte cam_num , Byte plan_num , Datum valeur )
{
 int i,j;
 if ( ipg_wr_reg(RADRCAM ,(U16)( plan_num<<5 | cam_num)) != OK ) return (ERROR);

 for ( j = 0 ; j < Y_SIZE_BUFFER ; j++ )
    for ( i = 0 ; i < X_SIZE_BUFFER ; i++ ) 
        if ( ipg_wr_data( j , i , valeur ) != OK ) return (ERROR);   
return (OK);
}

int init_buf_new( Byte cam_num , Byte plan_num , Datum valeur )
{
 int i,j,code;
 Datum *tampon;
 long nb_val,k;

 if ( ipg_wr_reg(RADRCAM ,(U16)( plan_num<<5 | cam_num)) != OK ) return (ERROR);

 nb_val=X_SIZE_BUFFER * Y_SIZE_BUFFER;
 tampon=( Datum *)memalign( _CACHE_ALIGN_SIZE, nb_val*sizeof(Datum)) ;
 if ( tampon == NULL )
   {
     /*la methode bete, on remplit case par case */
     for ( j = 0 ; j < Y_SIZE_BUFFER ; j++ )
       for ( i = 0 ; i < X_SIZE_BUFFER ; i++ ) 
	 if ( ipg_wr_data( j , i , valeur ) != OK ) return (ERROR); 
   }
 else
   {
     for( k=0 ; k<nb_val ; k++ ) tampon[k]=valeur;
     code=ipg_wr_bloc(0, 0, Y_SIZE_BUFFER-1, X_SIZE_BUFFER-1, tampon ,IPA_INC_LIG);
     free(tampon);
     if (code ==ERROR) return (errnoGet());
   }

return (OK);
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:	test_buf
------------------

-Rle: Test des buffers
-inclure: intf.h
-Prototype:
	int test_buf( Byte cam_num , Byte plan_num )
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description: 
	On crit dans le plan mmoire slectionn des valeurs croissantes
-Constantes utilises
	Internes au fichier:
	Importes:
		X_SIZE_BUFFER 
		Y_SIZE_BUFFER
	
-Fonctions utilises
	Internes au fichier:
	Importes:
		ipg_wr_reg 
		ipg_wr_data
	
-Exemple:
-Commentaires:
********************************************************************--*/


int test_buf( Byte cam_num , Byte plan_num )
{
 int i,j;
 if ( ipg_wr_reg(RADRCAM , (U16)(plan_num<<5 | cam_num)) != OK ) return (ERROR);
 for ( j = 0 ; j < Y_SIZE_BUFFER ; j++ )
    for ( i = 0 ; i < X_SIZE_BUFFER ; i++ ) 
        if ( ipg_wr_data( j , i , i ) != OK ) return (ERROR);    
return (OK);
} 

/*++********************************************************************
------------------
ENTETE DE FONCTION	:	lect_buf
------------------

-Rle: lecture d'une fentre dans un buffer
-inclure: intf.h
-Prototype:
	int lect_buf( Coor_fen *pt_coord , Fen_info *pt_info , Datum *tableau)
-Paramtres:
	pt_coord:	pointeur sur la structure des coordonnes de la fentre
	pt_info:	pointeur sur la structure Fen_info
	buffer:		Pointeur sur la zone mmoire  remplir	
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour: OK ou ERROR
-Description:
	Lecture en mode DMA des buffers camera
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

int lect_buf( Coor_fen *pt_coord , Fen_info *pt_info , Datum *tableau)
{
 
 long 	lig_debut, 
	lig_fin,
	col_debut, 
	col_fin,
	nb_data;

 nb_data = pt_coord->nblig *  pt_coord->nbcol;
 lig_debut = pt_coord->ligdb;
 lig_fin = lig_debut + pt_coord->nblig - 1;
 col_debut = pt_coord->coldb;
 col_fin = col_debut + pt_coord->nbcol - 1;

 if (ipg_wr_reg( RADRCAM,(U16)(pt_info->noplan<<5 | pt_info->nobuf)) != OK) 
    return (ERROR);


 if ( ipg_rd_bloc(lig_debut , col_debut , lig_fin , col_fin , tableau ,\
                   nb_data , pt_info->sens ? IPA_INC_LIG:IPA_INC_COL) !=OK )
    return (ERROR);
   


 return (OK);
}
/*++********************************************************************
------------------
ENTETE DE FONCTION	:	lect_buf_no_dma
------------------

-Rle: lecture d'une fentre dans un buffer ( sans DMA )
-inclure: intf.h
-Prototype:
	int lect_buf( Coor_fen *pt_coord , Fen_info *pt_info , Datum *tableau)
-Paramtres:
	pt_coord:	pointeur sur la structure des coordonnes de la fentre
	pt_info:	pointeur sur la structure Fen_info
	buffer:		Pointeur sur la zone mmoire  remplir	
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour: OK ou ERROR
-Description:
	Lecture ( boucle programmee ) d'une fenetre dans un plan buffer
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

int lect_buf_no_dma( Coor_fen *pt_coord , Fen_info *pt_info , Datum *tableau)
{
 int	j,i;
 long 	lig_debut, 
	lig_fin,
	col_debut, 
	col_fin;

 lig_debut = pt_coord->ligdb;
 lig_fin = lig_debut + pt_coord->nblig - 1;
 col_debut = pt_coord->coldb;
 col_fin = col_debut + pt_coord->nbcol - 1;

 if (ipg_wr_reg( RADRCAM,(U16)(pt_info->noplan<<5 | pt_info->nobuf)) != OK) 
    return (ERROR);

 /* Boucle de lecture programmee */
 if( pt_info->sens == SENS_COL ) 
   {
     for( j=lig_debut ; j<=lig_fin ; j++ )
	for( i=col_debut ; i<=col_fin ; i++)
		ipg_rd_data(j,i,tableau++);
   }
 else
   {
     for( i=col_debut ; i<=col_fin ; i++)
       for( j=lig_debut ; j<=lig_fin ; j++)
	 ipg_rd_data(j,i,tableau++);
   }
   

 return (OK);
}
/*++********************************************************************
------------------
ENTETE DE FONCTION	:	wr_buf
------------------

-Rle: Ecriture d'une fentre en mmoire commune dans les buffers d'une camra
-inclure:
-Prototype:
	<a mettre ici>
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

/*
   La chaine de caracteres doit etre exprimee completement
   c.a.d pour acceder au fichier bidule.don du repertoire /the/pc
   de la station sparc10, il faut exprimer "themis:/the/pc/bidule.don"
*/

int wr_buf( char *name, int lig_deb,int col_deb,int nb_lig,int nb_col,\
	   Byte num_carte, Byte num_plan)
{
  int fd,i,j;
  Datum val;
  if (ipg_wr_reg( RADRCAM,(U16)(num_plan<<5 | num_carte)) != OK) 
    return (ERROR);
  if ((fd = open( name , O_RDONLY , 0 )) == ERROR )
    {
      printErr("Erreur d'ouverture du fichier :%s\n", name );
      return (ERROR);
    }
  for(j = lig_deb ; j < lig_deb + nb_lig ; j++ )
    for( i = col_deb ; i < col_deb + nb_col ; i++ )
      {
	read( fd , (char *)&val , sizeof(Datum) );
	/* Si on remplit le plan obscurite, il faut d'abord multiplier
	   par 16 les valeurs. C'est comme ca !!!!! */
	if ( num_plan == PLAN_OBSC ) val = val<<4;
	ipg_wr_data( j , i , val );
      }
  close(fd);
  return( OK );
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	detect_cam
------------------

-Rle: detecter la prsence d'une carte buffer et sa camra
-inclure: intf.h
-Prototype:
	int detect_cam(Byte cam_num)
-Paramtres:
	cam_num: numro de la camra  detecter.
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	OK
	ERR_NO_BUF ( pas de carte connecte )
	ERR_RCPT ( pas de camra branche )
	ERROR
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
			FLAG_RECEPT ( intf.h )
	
-Fonctions utilises
	Internes au fichier:
	Importes:
			lect_stat_cam

-Exemple:
-Commentaires:
********************************************************************--*/
int detect_cam( Byte cam_num)
{
  U16 val_reg;
  if ( lect_stat_cam( cam_num , &val_reg ) == ERROR ) return (ERROR);
  if ( val_reg == 0 ) return ( ERR_NO_BUF );
  if ( (val_reg & (U16)FLAG_RECEPT) != 0 ) return ( ERR_RCPT );
  return( OK );
}




int test_cam(void)
{
  int i,code;
  U16 val_reg;

  raz_cam();
  for ( i = 0 ; i < 32 ; i++ )
  { 
     code = detect_cam(i);
     if ( code != ERR_NO_BUF )
     { 
        printf("Carte buffer No:%d connectee",i);
        if ( code != ERR_RCPT ) 
        {
          lect_stat_cam(i,&val_reg);
          val_reg = (val_reg & MASQUE_CAM_NUM) >> 2;
          printf(" avec la camera No:%d \n",val_reg);
        }
        else printf(" sans camera\n");
     }
  }
  return (OK) ;
}

/* meme fonction que ci-dessus, mais renvoyant une chaine 
   de caracteres, a traiter par l'IU                       */
int test_cam2(char *resul)
{
  int i,code;
  U16 val_reg;
  char ch[3];

  resul[0]=0;
  raz_cam();
  for ( i = 0 ; i < 32 ; i++ )
  { 
     code = detect_cam(i);
     if ( code != ERR_NO_BUF )
     { 
        sprintf(ch, "%d ", i);
	strcat(resul, ch);
        if ( code != ERR_RCPT ) 
        {
          lect_stat_cam(i,&val_reg);
          val_reg = (val_reg & MASQUE_CAM_NUM) >> 2;
          sprintf(ch, "%d\n",val_reg);
        }
        else sprintf(ch, "0\n");
	strcat(resul, ch);
     }
     else printf("No buffer n%2d connected.\n", i);
  }
  printf("%s\n", resul);
  return (OK) ;
}











































