h63993
s 00002/00001/00339
d D 1.3 98/08/26 15:49:15 tof 4 3
c copie dr /the/soft/bibli/acq/vme/interface ici ...
e
s 00000/00000/00340
d D 1.2 98/08/26 12:57:50 tof 3 1
c rien.
e
s 00000/00000/00000
d R 1.2 98/08/26 11:50:21 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 vme/interface/trt_err_sol.c
e
s 00340/00000/00000
d D 1.1 98/08/26 11:50:20 tof 1 0
c date and time created 98/08/26 11:50:20 by tof
e
u
U
f e 0
t
T
I 1
static char *SccsId="%w% %g%";
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:	trt_err_sol.c
-----------------
-Auteur(s):	Denis Ziegler
D 4
-Rle:	Communication par socket avec la station SUN pour envoi des erreurs du programme SOLEIL ENTIER
E 4
I 4
-Rle:	Communication par socket avec la station SUN pour envoi des erreurs du 
        programme SOLEIL ENTIER
E 4
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:	trt_err_sol
				sock_serv_create
				close_connect_sol
				msg_q_delete
				erreur_sol
	 
-Commentaires:

********************************************************************;-*/
#include <stdio.h>
#include <stdlib.h>
#include <vxWorks.h>
#include <sockLib.h>
#include <msgQLib.h>
#include <ioLib.h>
#include <in.h>
#include <string.h>
#include <the_errno.h>

/*				LES CONSTANTES				*/
#define NB_MAX_MSG 20
#define MSG_SIZE 20
#define NB_CONNECT 1
#define SOCK_PROTOCOL 0

/*				PROTOTYPES DES FONCTIONS INTERNES	*/
int trt_err_sol( void );
int sock_serv_create( int port_num );
int erreur_sol( Err_sol *erreur );

extern sysClkRateGet();

/*				LES VARIABLES GLOBALES			*/
int sock_serv_id, sock_sol_id;	/* Identificateurs sockets */
MSG_Q_ID msg_q_id;		/* Identificateur message queue  */

int connexion ; /* flag indiquant qu'une connexion socket est active */

/*++********************************************************************
------------------
ENTETE DE FONCTION	:	trt_err_sol
------------------

-Rle:  Fonction principale . Creation du serveur de communication par sockets,
	de la message queue et envoi des messages d'erreurs vers le client .
-inclure:
-Prototype:
	int trt_err_sol( void )
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:	Si retour alors ERROR
-Description:
-Constantes utilises
	Internes au fichier:	NB_MAX_MSG
				MSG_SIZE
				NB_CONNECT
				SOCK_PROTOCOL
	Importes:		PORT_ERR_SOL ( the_errno.h )
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

int trt_err_sol( void )
{

 int longueur ;
 struct sockaddr_in client_addr  ;
 char message[ MSG_SIZE ];

 msg_q_id = msgQCreate( NB_MAX_MSG , MSG_SIZE , MSG_Q_FIFO );
 if (msg_q_id == NULL) 
 {
   perror("ERREUR SUR CREATION MESSAGE QUEUE\n");
   return ( ERROR );
 }
 printf("\n Creation message queue OK!\n");
 sock_serv_id = sock_serv_create( PORT_ERR_SOL );
 if ( sock_serv_id == ERROR )
 {
   perror("ERREUR SUR CREATION DU SERVEUR COMMUNICATION PAR SOCKETS\n");
   return( ERROR ); 
 }
 printf("\n Creation serveur de communication par sockets OK!\n");

 /* Attente de connexion et envoi des messages d'erreurs */
 while(1)
 { 
   connexion = 0 ; 
   longueur =  sizeof(client_addr);
   sock_sol_id = accept( sock_serv_id , (struct sockaddr *)&client_addr ,&longueur );
   if ( sock_sol_id == ERROR ) 
   {
     perror("ERREUR SUR CONNECTION SOCKET\n");
     continue; /* on se remet en attente d'une nouvelle connexion */
   }
   connexion = 1; /* la connexion est etablie */
   while(1)
   {
     /* Attente d'un message d'erreur */
     if ( msgQReceive( msg_q_id , message , sizeof(message) , WAIT_FOREVER ) == ERROR )
     {
       perror("ERREUR SUR RECEPTION DE MESSAGE QUEUE\n");
       break;
       
     }
     /* L'arret de la connexion socket est demande par l'ecriture du code SOCK_CONNECT_OFF
        dans la message queue  */
     if ( atoi(message) == SOCK_CONNECT_OFF ) break;
     /* Envoi du message vers le client */
     if ( write( sock_sol_id , message , sizeof(message) ) == ERROR )
     {
       perror("ERREUR SUR ECRITURE DANS LA SOCKET\n");
       break;
     }

   } 
   if ( close( sock_sol_id ) == ERROR )
   {
      perror("ERREUR SUR FERMETURE DE COMMUNICATION SOCKET");
      
      return( ERROR );
   } 
 }
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	sock_serv_create
------------------

-Rle:	Creation du serveur de communication par socket
-inclure:
-Prototype:
	int sock_serv_create( int port_num )
-Paramtres:	port_num : numero du port de communication souhaite ( >5000 )
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:	sock_id ou ERROR
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/
int sock_serv_create( int port_num )
{
 struct sockaddr_in serv_addr;
 int sock_id;
 /* les preparations necessaires */
 bzero( ( char * )&serv_addr , sizeof( serv_addr ) );
 serv_addr.sin_family = AF_INET ; 
 serv_addr.sin_port = htons( port_num );
 serv_addr.sin_addr.s_addr = htonl( INADDR_ANY );
 sock_id = socket( AF_INET , SOCK_STREAM , SOCK_PROTOCOL );
 /* Ouverture socket */
 if ( sock_id == ERROR )
 {
   perror("ERREUR OUVERTURE SOCKET\n");
   return( ERROR );
 }
 /* Bind (association) d'une adresse reseaux ( ici celle du serveur ) avec la socket */
 if ( bind( sock_id , (struct sockaddr *)&serv_addr , sizeof(serv_addr) ) == ERROR )
 {
   close( sock_id );
   perror("ERREUR SUR BIND SOCKET\n");
   return( ERROR );
 }
 /* Et enfin on autorise la(les) connexions sur la socket */
 if ( listen( sock_id , NB_CONNECT ) == ERROR )
 {
   close( sock_id );
   perror("ERREUR SUR LISTEN SOCKET\n");
   return( ERROR );
 }
 /* Si tout c'est bien passe */
 return( sock_id );
}
 

/*++********************************************************************
------------------
ENTETE DE FONCTION	:	close_connect_sol
------------------

-Rle:		Fermeture de la communication socket
-inclure:
-Prototype:
	void close_connect_sol( void )
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:		SOCK_CONNECT_OFF 
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:	La fermeture de la socket se fait proprement
********************************************************************--*/

void close_connect_sol( void )
{
  Err_sol erreur ;

  if (connexion) /* on ferme la socket seulement si une connexion est deja etablie */ 
  {
    erreur.code = SOCK_CONNECT_OFF ;
    erreur.param_1 = 0 ;
    erreur_sol(&erreur);
  }
 
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	msg_q_delete
------------------

-Rle:	Effacer la message queue 
-inclure:
-Prototype:
	void msg_q_delete( void )
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/
void msg_q_delete( void )
{
 if ( msg_q_id !=NULL ) msgQDelete( msg_q_id );
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	erreur_sol
------------------

-Rle:	Transmission des erreurs Soleil Entier par message queue
-inclure:
-Prototype:
	int err_sol( Err_sol *erreur )
-Paramtres:	erreur : pointeur sur la structure Err_sol
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:	OK ou ERROR 
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

int erreur_sol( Err_sol *erreur )
{
 char tampon[ MSG_SIZE ];
 int timout = sysClkRateGet();
 bzero( tampon , sizeof(tampon) );
 sprintf(tampon,"%d,%d\n",erreur->code,erreur->param_1);
 if ( msgQSend( msg_q_id , tampon , sizeof(tampon), timout ,MSG_PRI_NORMAL ) == ERROR)
    return( ERROR );
 return ( OK );
}


void test_sock_sol()
{
 int i;
 Err_sol erreur;
 for( i=0 ; i<9 ; i++ )
 {
    erreur.code=i;
    erreur.param_1= i+100;
    erreur_sol(&erreur);
    taskDelay(sysClkRateGet());
 }
 erreur.code = SOCK_CONNECT_OFF;
 erreur.param_1=0;
 erreur_sol(&erreur);
}
E 1
