h29061
s 00001/00000/00110
d D 1.3 98/08/26 15:49:14 tof 4 3
c copie dr /the/soft/bibli/acq/vme/interface ici ...
e
s 00000/00000/00110
d D 1.2 98/08/26 12:57:49 tof 3 1
c rien.
e
s 00000/00000/00000
d R 1.2 98/08/26 11:50:20 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 vme/interface/timekeeper.c
e
s 00110/00000/00000
d D 1.1 98/08/26 11:50:19 tof 1 0
c date and time created 98/08/26 11:50:19 by tof
e
u
U
f e 0
t
T
I 4
static char *SccsId="@(#)timekeeper.c	1.1 07/24/98";
E 4
I 1

#include <stdio.h>
#include <semLib.h>
#include <timekeeper.h>

#define TIME_COR 0x6

/*---------------------------FONCTIONS INTERNES----------------------*/
int set_utc( int *tab_param , int nb_param );
Octet bin_to_bcd( Octet valeur );
Octet bcd_to_bin( Octet valeur );
int read_utc( Time_utc *pt );
int set_mk48(Octet aa, Octet mm, Octet jj, Octet hh, Octet mn, Octet ss);
unsigned long read_time( void );
void aff_utc( void );

/*--------------------------FONCTIONS EXTERNES-----------------------*/
extern sysClkRateGet();

/*---------------------------VARIABLES INTERNES----------------------*/ 

Time_utc *adr_time_utc = (Time_utc *)0xfffc1ff8;

/*---------------------------VARIABLES EXTERNES----------------------*/
extern SEM_ID sem_top_synchro; /* ipg_ccd.c */
extern int demande_utc;

/*--------------------------------------------------------------------*/


Octet bin_to_bcd( Octet valeur )
{
  return( (valeur%10) + ((valeur/10)<<4) );
}

Octet bcd_to_bin( Octet valeur )
{
  return( (valeur & 0xF) + (valeur>>4)*10 );
}

int set_utc( int *tab_param , int nb_param )
{
  int code;
  adr_time_utc->control = WRITE_MODE;
  if (nb_param==3) /* actuellement seuls les hh,mm,ss sont passees */
    {
      adr_time_utc->seconds = bin_to_bcd(tab_param[2]);
      adr_time_utc->minutes = bin_to_bcd(tab_param[1]);
      adr_time_utc->hour = bin_to_bcd(tab_param[0]);
    }
  else /* c'est qu'on est passe a 6 parametres aa,mm,jj,hh,mm,ss */
    {
      adr_time_utc->year = bin_to_bcd(tab_param[0]);
      adr_time_utc->month = bin_to_bcd(tab_param[1]);
      adr_time_utc->date = bin_to_bcd(tab_param[2]);
      adr_time_utc->hour = bin_to_bcd(tab_param[3]);
      adr_time_utc->minutes = bin_to_bcd(tab_param[4]);
      adr_time_utc->seconds = bin_to_bcd(tab_param[5]);
    }
  /* Attente du prochain top synchro de l'horloge GPS 
     pour se mettre a l'heure */
  if(semTake( sem_top_synchro , 2*sysClkRateGet()) == ERROR)
    code=ERROR;
  else 
    code = OK;
  adr_time_utc->control = TIME_COR; /* c'est mis a l'heure et corrige*/
  return ( code );
}
  
Time_utc utc;

int read_utc( Time_utc *pt )
{
  adr_time_utc->control = READ_MODE;
  pt->seconds = bcd_to_bin( adr_time_utc->seconds );
  pt->minutes = bcd_to_bin( adr_time_utc->minutes );
  pt->hour = bcd_to_bin( adr_time_utc->hour );
  pt->date= bcd_to_bin( adr_time_utc->date );
  pt->month = bcd_to_bin( adr_time_utc->month );
  pt->year = bcd_to_bin( adr_time_utc->year );
  adr_time_utc->control = TIME_COR;
  return (OK);
}

unsigned long  read_time( void )
{
  read_utc(&utc);
  return( utc.hour*3600 + utc.minutes*60 + utc.seconds );
}

void aff_utc( void )
{
  read_utc(&utc);
 printf("\nIl est %2dH %2d:%2d du %2d/%2d 19%2d\n",utc.hour,utc.minutes,\
	utc.seconds,utc.date,utc.month,utc.year);
}

int set_mk48(Octet aa, Octet mm, Octet jj, Octet hh, Octet mn, Octet ss)
{
  adr_time_utc->control = WRITE_MODE;
  adr_time_utc->year = bin_to_bcd(aa);
  adr_time_utc->month = bin_to_bcd(mm);
  adr_time_utc->date = bin_to_bcd(jj);
  adr_time_utc->hour = bin_to_bcd(hh);
  adr_time_utc->minutes = bin_to_bcd(mn);
  adr_time_utc->seconds = bin_to_bcd(ss);
  adr_time_utc->control = TIME_COR; /* c'est mis a l'heure et corrige */
  return OK;
}
  
E 1
