h56114
s 00067/00001/00137
d D 1.5 99/03/31 11:57:30 lezieg 6 5
c nouvelles fonctions pour monitorer le comportement du VME:
c -print_tab_num pour afficher les derniers temps de numerisation.
e
s 00055/00001/00083
d D 1.4 98/10/16 09:22:47 lezieg 5 4
c Ajout de fonctions pour mesurer les temps d'enregistrement :
c start_perf_enrg( nb_acquisitions, periode ( secondes) )
c print_perf_enrg( nb_acquisitions ) pour afficher les temps
e
s 00002/00000/00082
d D 1.3 98/08/26 15:49:13 tof 4 3
c copie dr /the/soft/bibli/acq/vme/interface ici ...
e
s 00000/00000/00082
d D 1.2 98/08/26 12:57:48 tof 3 1
c rien.
e
s 00000/00000/00000
d R 1.2 98/08/26 11:50:19 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 vme/interface/test_perf.c
e
s 00082/00000/00000
d D 1.1 98/08/26 11:50:18 tof 1 0
c date and time created 98/08/26 11:50:18 by tof
e
u
U
f e 0
t
T
I 4
static char *SccsId="@(#)test_perf.c	1.1 07/24/98";

E 4
I 1
/*                          TEST_PERF.C
I 6
 11 Mars 1999 dz
 deux nouveaux tableaux pour monitorer les durees de numerisation et d'integration
 tab_num et tab_intg.
 plus les fonctions adequates pour envoyer le contenu de ces tableaux sur la console
 ou un fichier ( par redirection dans le shell VxWorks ):
 print_tab_num( nb_acq ) et print_tab_intg( nb_acq ).

E 6
I 5
 13 Octobre 1998 dz
 Ajout de deux fonctions pour lancer des mesures de temps d'enregistrement
 start_perf_enrg( nb_acq, periode )
   
 print_perf_enrg( nb_acq )

E 5
 17.12.96 dz
 Creation d'un tableau pour ranger des mesures de temps
 on va essayer de sauvegarder a la demande le contenu du tableau
 sur le disque SUN sous forme binaire et/ou ascii pour faire 
 des statistiques sur les temps d'execution des taches 
 */


#include <stdio.h>
#include <vxWorks.h>
#include <memLib.h>
#include <intf.h>
I 5
#include <wdLib.h>
E 5

D 5
#define Y_PERF 1000
E 5
I 5
#define Y_PERF 2000
E 5
#define X_PERF 12
I 6
#define Y_MONITOR 200
#define X_MONITOR 2

E 6
u32 tab_perf[Y_PERF][X_PERF];
I 6
static u32 tab_num[ Y_MONITOR ][ X_MONITOR ];
static u32 tab_intg[ Y_MONITOR ][ X_MONITOR ];
static int offset ;

E 6
int cpt_start_acq ; /* compteur d'acquisition */

I 5
extern int start_acq(); /* cmd_v3.c */

E 5
/* le tableau tab_perf va pouvoir contenir 1000 champs de 12 valeurs entieres
   32 bits non signes.
   Ces valeurs entieres exprimees en microsecondes correspondent aux instants
   suivants:
    0: fin de switch_mode,juste avant de donner sem_start_intg.
    1: Reception de sem-start-intg
    2: Reception de sem_fin_intg ou demarrage de l'integrateur en mode reglage
       soleil entier
    3: Reception de sem_fin_num
    4: Debut de la lecture
    5: Fin de lecture
    6: Liberation du verrou de l'enregistrement 
    7: 1-0 Temps entre la liberation du semaphore et sa prise en compte
    8: 2-1 Duree d'integration ( vu de Vxworks )
    9: 3-2 Duree de numerisation ( vu de VxWorks )
   10: 5-4 Duree de la lecture
   11: 6-5 Duree d'enregistrement

   Les operations 7 a 11 se font dans la fonction de lecture de la table
   print_tab_perf
   */

D 6
/*        Prototypes des fonctions */
E 6
I 6
/*-----------------------------Prototypes des fonctions------------------*/
E 6
void init_tab_perf( void );
void wr_tab_perf( int num , int offset , u32 valeur );
void print_tab_perf( int nb_lig );
I 5
int start_perf_enrg( int nb_acq , int periode );
void print_perf_enrg( int nb_acq );
I 6
void init_tab_num( void );
void init_tab_intg( void );
void wr_tab_num( u32 num_acq, u32 val );
void wr_tab_intg( u32 num_acq, u32 val );
void print_tab_num( void );
void print_tab_intg( void );
E 6
E 5

I 6
/*-----------------------------------------------------------------------*/

E 6
void init_tab_perf( void )
{
  memset( (void *)tab_perf[0] , 0 , sizeof( tab_perf ) );
  printErr("Tableau des temps initialise: %d Octets\n", sizeof( tab_perf ) );
  cpt_start_acq = 0;
}

void wr_tab_perf( int num , int offset , u32 valeur )
{
  if(num < Y_PERF)
    tab_perf[num][offset] = (u32)valeur;
}


/* Pour ecrire la table tab_perf sous forme ascii dans un fichier,
   il faut utiliser la redirection. Ex: print_tab_perf() > fichier.dat */

void print_tab_perf( int nb_lig )
{
  int i,j;
  if ( nb_lig > Y_PERF ) nb_lig = Y_PERF ;
  printf("\n\r");
  for( j = 0 ; j < nb_lig ; j++ )
    {
      tab_perf[j][7] = tab_perf[j][1] - tab_perf[j][0];
      tab_perf[j][8] = tab_perf[j][2] - tab_perf[j][1];
      tab_perf[j][9] = tab_perf[j][3] - tab_perf[j][2];
      tab_perf[j][10] = tab_perf[j][5] - tab_perf[j][4];
      tab_perf[j][11] = tab_perf[j][6] - tab_perf[j][5];
      printf("%3d  ",j);
      for( i = 0 ; i < X_PERF ; i++ )
	printf("%10lu  ",tab_perf[j][i]);
      printf("\n\r");
    }
}

I 5
int start_perf_enrg( int nb_acq, int periode )
{
  ULONG clock, tps ;
  int i;
  cpt_start_acq = 0;
  printf("\nDemarrage de %d acquisitions toutes les %d secondes\n",nb_acq,periode);
  for ( i=0 ; i<nb_acq ; i++ )
    {
      clock = tickGet();
      if ( start_acq(1) == ERROR )
	{
	  printErr("\nErreur sur acquisition %d\n",i+1);
	}
      cpt_start_acq +=1;
      tps = tickGet(); /* quelle heure est il */
      /* si start_acq a dure plus longtemps que la periode, on relance tout de suite */
      if ( tps > clock + periode*sysClkRateGet() )
	{
	  continue;
	}
      while( tickGet() < clock + periode*sysClkRateGet() )
	{
	  taskDelay(1);
	}
     }
  printf("\nAcquisitions terminees\n");
  return OK;
}

void print_perf_enrg( int nb_acq )
{
  int j;
  if ( nb_acq > Y_PERF ) nb_acq = Y_PERF ;
  printf("\n\r");
  for( j = 0 ; j < nb_acq ; j++ )
    {
      printf("%3d  ",j+1);
      /* affichage de la duree d'enregistrement en millisecondes */
      printf("%5d  ",(tab_perf[j][6] - tab_perf[j][5])/1000);
      printf("\n\r");
    }
}
I 6

void init_tab_num( void )
{
  offset = 0 ;
}

void init_tab_intg( void )
{
  offset = 0 ;
}
E 6
  
I 6
void wr_tab_num( u32 num_acq , u32 val )
{
  if ( offset == Y_MONITOR ) offset = 0;
  tab_num[ offset ][ 0 ] = num_acq;
  tab_num[ offset ][ 1 ] = val;
  offset += 1;
}

void wr_tab_intg( u32 num_acq , u32 val )
{
  if ( offset == Y_MONITOR ) offset = 0;
  tab_intg[ offset ][ 0 ] = num_acq;
  tab_intg[ offset ][ 1 ] = val;
  offset += 1;
}

void print_tab_num( void )
{
  int i;
  for( i=0 ; i<Y_MONITOR ; i++ )
    {
      printf("\nAcq no: %5d Tps num: %5d",tab_num[i][0], tab_num[i][1]);
    }
}

void print_tab_intg( void )
{
  int i;
  for( i=0 ; i<Y_MONITOR ; i++ )
    {
      printf("\nAcq no: %5d Tps num: %5d",tab_intg[i][0], tab_intg[i][1]);
    }
  printf("\n");
}
E 6
E 5
E 1
