h02286
s 00004/00001/00657
d D 1.11 00/04/27 16:26:34 jeje 12 11
c 
e
s 00002/00000/00656
d D 1.10 99/08/31 16:09:48 chris 11 10
c ok
e
s 00110/00038/00546
d D 1.9 99/03/31 11:43:44 lezieg 10 9
c 1- pas mal de modifs. voir l'historique dans le fichier source.
e
s 00011/00003/00573
d D 1.8 99/02/05 12:59:56 chris 9 8
c Ajout des fonctions de tests du VME, fichier vme_spy et corrections de qq bugs
e
s 00001/00001/00575
d D 1.7 99/01/21 17:41:46 chris 8 7
c remplacement de NB_FLAGS par NB_DYN_FLAGS pour que SUN et VME utilisenet le memes ctes
e
s 00000/00000/00576
d D 1.6 98/11/04 11:07:11 chris 7 6
c aucun chgt
e
s 00014/00014/00562
d D 1.5 98/11/03 17:01:39 chris 6 5
c chgrt nocam -> nobuf
e
s 00004/00011/00572
d D 1.4 98/10/16 18:13:17 lezieg 5 4
c 
e
s 00107/00042/00476
d D 1.3 98/08/26 15:49:11 tof 4 3
c copie dr /the/soft/bibli/acq/vme/interface ici ...
e
s 00000/00000/00518
d D 1.2 98/08/26 12:57:47 tof 3 1
c rien.
e
s 00000/00000/00000
d R 1.2 98/08/26 11:50:18 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 vme/interface/start_v3.c
e
s 00518/00000/00000
d D 1.1 98/08/26 11:50:17 tof 1 0
c date and time created 98/08/26 11:50:17 by tof
e
u
U
f e 0
t
T
I 1
D 4
static char *SccsId="%W% %G%";
E 4
I 4
D 9
static char *SccsId="@(#)start_v3.c	1.3 07/28/98";
E 9
I 9
static char *SccsId=" %w%  %g%";
E 9
E 4
/*;+********************************************************************
-----------------
D 4
ENTETE DE FICHIER	:	START_V3_1b.C
E 4
I 4
ENTETE DE FICHIER	:	START_V3.C
E 4
-----------------
-Auteur(s):D.Ziegler
-Role:	Fonction principale du programme VME, allocation de Tables acq et camera 
	et de quoi stocker buffers, lancement des taches integration et
	lecture.
-Constantes
	Internes au fichier:	
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
	 
D 4
-Commentaires:	fichier en changement perpetuel
E 4
I 4
-Commentaires:	pas de commentaires
E 4

********************************************************************;-*/
I 4
/*----------------------------HISTORIQUE------------------------------*/
/*
I 10
  30 Mars 1999 dz
  l'affect_theta des cameras a 255 ( pas de refroidissement ) se fait
  au reboot du VME ( init_prog_vme ) et non plus lors du demarrage du
  programme d'acquisition ( init_acquisition ).
  
  23 Mars 1999 dz
  tests de la liaison avec le rack obturateurs dans la fonction
  init_acquisition.
  La fonction ne s'execute pas et retourne un code ERROR si pb sur la liaison.

  La modif du 21 Juillet 1998 est annulee. synchro_obt n'existe plus.

  15 Mars 1999 dz
  ajout de la fonction print_tab_fen:
  affichage des infos concernant les fenetres.
  Utilisable seulement apres decodage.

E 10
I 9
  29 Janvier 1999 dz
  tites modifs insignifiantes mais neanmoins utiles
  dans init_acquisition; on remet a zero le compteur d'acquisition
  avec la fonction reset_cpt_acq() definie dans gen_intg_v3_s.c

E 9
  27 Juillet 1998 dz
  Fonctions d'affichages des structures index et dyn dans Pt_acq.
  Modif de la fonction print_pt_ctrl pour afficher l'etat des flags
  de la table dyn_flags.
E 4

I 4
  21 Juillet 1998 dz
  implantation de synchro_obt().
  A la mise sous tension d'AE02, la transmission fibre n'est pas correctement
  synchronisee. Et ne me demandez surtout pas pourquoi !!!!
  Envoi de "pattern" sur la liaison fibre obturateur pour recuperer une liaison
  correcte si c'est possible..........!
  */

E 4
#include <vxWorks.h>
#include <taskLib.h>
#include <usrLib.h>
#include <memLib.h>
#include <fioLib.h>
#include <errnoLib.h>
#include <stdio.h>
#include <string.h>
#include <acq.h>
#include <intf.h>

I 10
/*                       CONSTANTES INTERNES   */
E 10

#define RATE_VME 100 /* Horloge sequenceur du VME a 100Hz */
I 10
#define CONFIGURATION_OBTURATEURS 0x1F /* config de depart des obturateurs */
E 10


/*			LES FONCTIONS EXTERNES	*/
extern sysClkRateget();

D 4
extern init_buf();	    /* buffers.c */
E 4
I 4
extern init_buf();	    /* buf_v3.c */
E 4
extern lect_buf();
D 4
extern detect_cam();	    /* buffers.c */
extern switch_mode();	    /* gen_intg.c */
extern gen_intg();	    /* gen_intg.c */
extern intg_se();	    /* gen_intg.c */
extern lecture();	    /* lecture.c */
extern alloc_mem();         /* vme-alloc.c */
E 4
I 4
extern detect_cam();	    /* buf_v3.c */
extern switch_mode();	    /* gen_intg_v3.c */
extern gen_intg();	    /* gen_intg_v3.c */
extern intg_se();	    /* gen_intg_v3.c */
extern lecture();	    /* lecture_v3.c */
extern alloc_mem();         /* ../init/vme-alloc.c */
E 4
extern libere_mem();
extern serveur();
extern init_tb_ctrl();	    /* init-tab.c */
D 4
extern soleil_entier();     /* soleil_entier.c */
E 4
I 4
extern soleil_entier();     /* sol_entier_v2.c */
E 4
extern close_connect_sol(); /* trt_err_sol.c */
D 4
extern init_com();          /* com_rs232.c */
E 4
I 4
extern init_com();          /* rs232_v3.c */
E 4
extern init_tab_perf();     /* test_perf.c */
D 4
extern cmde_obt();          /* obturateur_v2.c */
extern start_acq();         /* commandes.c */
E 4
I 4
extern cmde_obt();          /* obt_v3.c */
extern start_acq();         /* cmd_v3.c */
extern lect_status_camera(); /* cam_v3.c */
I 9
extern reset_cpt_acq();      /* gen_intg_v3.c */
I 10
extern init_tab_num();       /* test_perf.c */
extern init_tab_intg();      /* test_perf.c */
E 10
E 9
E 4

/*			LES FONCTIONS DU FICHIER	*/
int init_prog_vme( void );
int init_acquisition(void);
int exit_acquisition(void);
int test_reg(U16 numero , int nb_boucle); /* fonction de test de lecture */
void tb_def( void ); /* initialisation des tables communes par le vme\
			fonction de test et depannage */
void tb_se( void ); /* idem que plus haut pour manip soleil entier */
void tb_obsc_se( void ); /* manip soleil entier avec fermeture du volet d'obturation */
void tb_regl_se( void ); /* soleil entier en mode reglage */
void print_pt_acq( void ); /* affichage de la table Pt_acq */
void print_pt_ctrl( void ); /* affichage de la table Pt_ctrl */
int print_pt_cam( Byte num_cam ); /* affichage des infos d'une camera */
void print_mem_offset( void ); /* affichage des offsets sur les fenetres */
I 10
void print_tab_fen( void ); /* affichage des infos relatives aux fenetres */
E 10
int boucle_test( int nb_start );
void info_vme( void ); /* affichage des caracteristiques principales du programme */
I 4
int synchro_obt(void); /* pattern de synchronisation de la liaison fibre obturateurs */
E 4

/*			LES VARIABLES GLOBALES	*/

D 4
extern Tb_acq *Pt_acq;		/* definis dans Vme-alloc.c */
E 4
I 4
extern Tb_acq *Pt_acq;		/* definis dans  ../init/Vme-alloc.c */
E 4
extern Tb_ctrl *Pt_ctrl;		
extern Tb_ctrl_cam *Pt_cam;
extern Datum *Pt_data;
D 4
extern fd_rs232; /* defini dans com_rs232.c */
E 4
I 4
extern fd_rs232; /* defini dans rs232_v3.c */
E 4

int tid_switch_mode; /* task ID de la fonction switch_mode*/
int tid_gen_intg; /* task ID de la fonction gen_intg */
int tid_lecture;  /* task ID de la fonction lecture */
int tid_serveur; /* task ID serveur RPC */
int tid_lect_se; /* task ID de la tache de lecture soleil entier */
int tid_intg_se; /* task ID de la tache de pilotage des cameras Soleil entier\
                    en mode reglage */
int tid_com_rs232; /* task ID de la tache de communication rs232 */

/* 		variables globales pour tests des programmes VME  	*/
D 4
extern int test_lect; 		/* defini dans lecture.c */ 
extern int test_intg; 		/* defini dans gen_intg.c */
extern dma;                     /* defini dans lecture.c */
E 4
I 4
extern int test_lect; 		/* defini dans lecture_v3.c */ 
extern int test_intg; 		/* defini dans gen_intg_v3.c */
extern dma;                     /* defini dans lecture_v3.c */
E 4

I 4

E 4
int init_acq_ok;

/*-------------------------------------------------------------------------------*/

static char *infovme="
D 4
Programme d'acquisition de donnees et pilotage des cameras THEMIS
\tVersion 3.1b du 8 Juin 1998\n
E 4
I 4
\nProgramme d'acquisition de donnees et pilotage des cameras THEMIS
D 5
\tVersion 3:10\n
E 5
I 5
D 9
\tVersion 3:20\n
E 9
I 9
D 10
\tVersion 3:30\n
E 10
I 10
\tVersion 3:40\n
E 10
E 9
E 5
E 4
-22 cameras CCD 288*384, 6 cameras RETICON 1*512 , 7 obturateurs
-2 buffers d'acquisition de 6 Moctets chacun
-Vitesse de lecture = 3,2Moctets/s
D 10
-Temps d'integration programmable  de 1 a 65535 millisecondes par pas de 1ms
E 10
I 10
-Temps d'integration programmable  de 5 a 65535 millisecondes par pas de 1ms
E 10
-Cadence d'acquisition programmable de 1 a 65535 millisecondes par pas de 1ms 
D 4
Differences par rapport a la precedente version:
\t-Synchronisation par l'UCCI via la commande $WACQ
\t-L'etat des obturateurs utilises est verifie avant chaque start_acq
\t s'ils ne sont pas fermes, le prog VME les ferme et les laisse ferme 
";
E 4
I 4
-Synchronisation des acquisitions par l'UCCI via les commandes $WACQ et $ACQI
D 9
-Prise en compte des parametres dynamiques via l'UCCI\n";
E 9
I 9
-Prise en compte des parametres dynamiques via l'UCCI
D 10
-Fichier espion validable par la fonction valid_spy(\"nom de fichier\")\n";
E 10
I 10
-Fichier espion validable par la fonction open_spy(\"nom de fichier\")\n";
E 10
E 9
E 4
/*------------------------------------------------------------------------------*/

/*
 *			ALLOCATION MEMOIRE ET LANCEMENT DES TACHES
 */
int init_prog_vme(void)
{
I 10
  int i;
E 10
  sysClkRateSet( RATE_VME ); 

  tid_serveur = sp( (FUNCPTR)serveur,0,0,0,0,0,0,0,0,0);
  if (tid_serveur == ERROR) 
    {
      printf("\n Erreur creation tache serveur Sun-Vme");
      return(ERROR);
    }
  printf("\n Lancement serveur Sun-Vme OK!!\n");

  /* initialisation des drivers interface et carte LORIN */
  if (intf_init() != OK)
    {
      printf("\n Erreur d'initialisation cartes Lorin et interface");
      return(ERROR);
    }
  printf("\n Initialisation interface OK!!\n");

  /* allocation memoire commune */
  if ( alloc_mem(TAB_SIZE ) !=OK )
    {
      printf("\n Erreur d'allocation memoire");
      return(ERROR);
    }
  printf("\n Allocation memoire data = %ld entiers 16 bits\n",\
         TAB_SIZE);

  tid_com_rs232=sp( (FUNCPTR)init_com,0,0,0,0,0,0,0,0,0);
  if( tid_com_rs232 == ERROR ) return (ERROR);
  printf("\n Lancement tache de communication RS232 OK\n");
I 10

  /* on affecte l'obturateur 0 a toutes les cameras
     et pas d'asservissement en temperature */
   for ( i=1 ; i<NB_MAX_CAM ; i++ )
    {
      if ( i !=  CAMERA_SOLEIL_ENTIER )
	Pt_cam->tab_reg_cam[i].n_obt = 0;
      Pt_cam->tab_reg_cam[i].theta = 255;
    }

E 10
  return OK;
}


int init_acquisition(void)
D 4
{
  /* on initialise par defaut en mode CCD */
  tb_def();
  test_lect = 0;
  init_tb_ctrl( Pt_ctrl, TAB_SIZE/NB_STOCKES_EMPL, NB_STOCKES_EMPL );
  init_tab_perf();
  dma=1; /* Validation de la lecture en mode DMA si = 1*/
  /* si init_acq_ok = 1 c'est que la fonction a deja ete lancee */
  if ( init_acq_ok ) return OK ;

E 4
I 4
{ 
  int i;
  U16 etat;
I 10
  Byte flag;
E 10
  /* les initialisations elementaires */
E 4
  if (intf_init() != OK)
    {
D 10
      printf("\n Erreur d'initialisation cartes Lorin et interface");
E 10
I 10
      printf("\nErreur d'initialisation cartes Lorin et interface");
      printf("\nPROGRAMME ACQUISITION NON INSTALLE\n");
E 10
      return(ERROR);
    }
D 10
  printf("\n Initialisation carte OK!!\n");
E 10
I 10
  printf("\n Initialisation carte IPG et INTERFACE : OK!! \n");
E 10
I 4
 
  tb_def(); /* init par defaut em mode CCD */
  test_lect = 0;
I 12
printf("avant init_tb_ctrl...\n");
E 12
  init_tb_ctrl( Pt_ctrl, TAB_SIZE/NB_STOCKES_EMPL, NB_STOCKES_EMPL );
  init_tab_perf();
I 9
  reset_cpt_acq();
I 10
  init_tab_num();
  init_tab_intg();
E 10
E 9
  dma=1; /* Validation de la lecture en mode DMA si = 1*/
I 10
  
I 12
printf("avant config d'origine sur les obturateurs...\n");

E 12
  /* config d'origine sur les obturateurs */
  ipg_wr_reg( R_OBT, CONFIGURATION_OBTURATEURS );
  taskDelay(sysClkRateGet()/4); /* on attend un poil */
E 10
E 4

I 10
  /* test de la liaison avec le rack des obturateurs (AE02) */
  intf_rd_rstat( RECEPT_OBT, &flag );
  ipg_rd_reg( R_OBT, &etat );
I 11
  
E 11

I 11
  
E 11
  if ( (flag == 0) || (etat == 0) )
    {
      printf("\nERREUR LIAISON RACK OBTURATEURS.!!!!");
      printf("\nVerifier la connexion fibre et l'alimentation sur AE02");
      printf("\nPROGRAMME ACQUISITION NON INSTALLE\n");
      return(ERROR);
    }

E 10
I 4
  if ( init_acq_ok ) return OK ;
E 4
D 12

E 12
I 12
printf("avant le lancement des taches...\n");
E 12
I 4
  /* Lancement des taches */

E 4
  tid_switch_mode = sp( (FUNCPTR)switch_mode,0,0,0,0,0,0,0,0,0);
  if (tid_switch_mode== ERROR) return (ERROR);

  tid_gen_intg = sp( (FUNCPTR)gen_intg,0,0,0,0,0,0,0,0,0);
  if (tid_gen_intg == ERROR) return (ERROR);
  printf("\n Lancement tache generateur d'integrations OK\n");
  tid_lecture = sp( (FUNCPTR)lecture,0,0,0,0,0,0,0,0,0);
  if (tid_lecture == ERROR) return(ERROR);
  printf("\n Lancement tache lecture OK\n");
  tid_lect_se = sp( (FUNCPTR)soleil_entier,0,0,0,0,0,0,0,0,0);
  if (tid_lect_se == ERROR) return (ERROR);
  printf("\n Lancement tache de lecture soleil entier OK\n");
  tid_intg_se = sp( (FUNCPTR)intg_se,0,0,0,0,0,0,0,0,0);
  if ( tid_intg_se == ERROR) return (ERROR);
  printf("\n Lancement tache pilotage cameras Soleil Entier OK\n");
D 4
  init_acq_ok = 1 ;
  printf("\n PROGRAMME ACQUISITION VME Ver:3.1b \n");
E 4
I 4
D 5
  printf("\n -PROGRAMME ACQUISITION VME Ver:3.10 du 28 Juillet 1998- \n");
E 4
  printf("Pour en savoir plus, tapez info_vme \n");
E 5
I 5
D 10
  printf("\n -PROGRAMME ACQUISITION VME Ver:3.20 du 16 Octobre 1998- \n");
E 10
I 10
  printf("\n -PROGRAMME ACQUISITION VME Ver:3.40 du 16 Mars 1999- \n");
E 10
E 5
I 4

D 5
  /* test de la liaison fibre obturateurs */
  if (synchro_obt() != OK)
    {
      printf("\n ERREUR sur la liaison fibre obturateurs\n");
      printf("Verifier la liaison et taper synchro_obt sur le terminal VME\n");
    }
  
E 5
I 5
   
E 5
  /* on va chercher les infos status des cameras eventuellement branchees
     pour mettre a jour la table Pt_cam  */
  raz_cam();
D 10
  for(i=1 ; i< NB_MAX_CAM ; i++) lect_status_camera(i,&etat);
E 10

I 10
  for(i=1 ; i< NB_MAX_CAM ; i++) lect_status_camera(i,&etat);
  
E 10
  init_acq_ok = 1 ;
E 4
  return OK;
}

/*--------------------------------------------------------------------*/

int exit_acquisition(void)
{
  if ( init_acq_ok == 1 )
    {
      td( tid_lecture );
      td( tid_intg_se );
      td( tid_gen_intg);
      td( tid_switch_mode );
      td(tid_lect_se);
I 10
      intf_init(); /* remise en mode d'origine de l'interface */
E 10
      init_acq_ok = 0 ;
      test_lect = 0;
      test_intg = 0 ;
      dma=0;
      close_connect_sol();
    }
  printf("\nexit_acquisition: Arret programme VME\n");
  return (OK);
}

/*-------------------PARAMETRES PAR DEFAUT EN MODE CCD--------------*/

void tb_def( void )
{
D 10
  int i;
E 10
  /* Mise a zero des tables communes */
  memset( Pt_acq , 0 , sizeof( Tb_acq ) );
  memset( Pt_cam , 0 , sizeof( Tb_ctrl_cam ) ); 
  Pt_acq->modob=MODE_RAO; /* Mode camera CCD */
  Pt_acq->nbfen = 1;
  Pt_acq->enfen = 6 ;
  Pt_acq->tab_fen[0].ligdb=1; 
  Pt_acq->tab_fen[0].coldb=1;
  Pt_acq->tab_fen[0].nblig=286;
  Pt_acq->tab_fen[0].nbcol=382;
D 6
  Pt_acq->tab_info_fen[0].nocam=1;
E 6
I 6
  Pt_acq->tab_info_fen[0].nobuf=1;
E 6
  Pt_acq->tab_info_fen[0].sens=SENS_COL;
  Pt_acq->tab_info_fen[0].noplan=2;
  Pt_acq->dintg[7]=300; /* temps d'integration en millisecondes
			 obturateur 7 ( obturateur "null") */
D 4
  Pt_acq->nbacq = 0; /* acquisition en continu en mode cadenceur */
  Pt_acq->cadac=2000; /* cadence en millisecondes */
E 4
  Pt_acq->ctrac=0; /*Mode d'acquisition simple */
D 4
  /* on affecte l'obturateur 0 a toutes les cameras */
E 4
I 4

D 10
  /* on affecte l'obturateur 0 a toutes les cameras sauf la 1 */
  
E 4
  for ( i=1 ; i<NB_MAX_CAM ; i++ )
    {
D 4
      if ( i <  CAMERA_SOLEIL_ENTIER )
E 4
I 4
      if ( i !=  CAMERA_SOLEIL_ENTIER )
E 4
	Pt_cam->tab_reg_cam[i].n_obt = 0;
      Pt_cam->tab_reg_cam[i].theta = 255;
    }
  Pt_cam->tab_reg_cam[1].n_obt = 7;
E 10
}


void tb_se( void )
{
  /* Mise a zero des tables communes */
  memset( Pt_acq , 0 , sizeof( Tb_acq ) );
  memset( Pt_cam , 0 , sizeof( Tb_ctrl_cam ) ); 
  Pt_acq->nbfen = 6; 
D 6
  Pt_acq->tab_info_fen[0].nocam=0;
  Pt_acq->tab_info_fen[1].nocam=1;
  Pt_acq->tab_info_fen[2].nocam=2;
  Pt_acq->tab_info_fen[3].nocam=3;
  Pt_acq->tab_info_fen[4].nocam=4;
  Pt_acq->tab_info_fen[5].nocam=5;
E 6
I 6
  Pt_acq->tab_info_fen[0].nobuf=0;
  Pt_acq->tab_info_fen[1].nobuf=1;
  Pt_acq->tab_info_fen[2].nobuf=2;
  Pt_acq->tab_info_fen[3].nobuf=3;
  Pt_acq->tab_info_fen[4].nobuf=4;
  Pt_acq->tab_info_fen[5].nobuf=5;
E 6
  Pt_acq->npix = 512;
  Pt_ctrl->nb_empl = 50;
  Pt_acq->nbacq =4000 ; /* 4000 acquisitions */
  Pt_acq->cadac= 66000; /* cadence en microsecondes */
  Pt_acq->modob=MODE_SOL; /* Mode soleil entier */
  Pt_acq->ctrac=0; /* Mode non simule*/
  Pt_acq->monit=1; /* DMA valide*/
}

void tb_obsc_se( void )
{
  /* Mise a zero des tables communes */
  memset( Pt_acq , 0 , sizeof( Tb_acq ) );
  memset( Pt_cam , 0 , sizeof( Tb_ctrl_cam ) ); 
  Pt_acq->nbfen = 6; 
D 6
  Pt_acq->tab_info_fen[0].nocam=0;
  Pt_acq->tab_info_fen[1].nocam=1;
  Pt_acq->tab_info_fen[2].nocam=2;
  Pt_acq->tab_info_fen[3].nocam=3;
  Pt_acq->tab_info_fen[4].nocam=4;
  Pt_acq->tab_info_fen[5].nocam=5;
E 6
I 6
  Pt_acq->tab_info_fen[0].nobuf=0;
  Pt_acq->tab_info_fen[1].nobuf=1;
  Pt_acq->tab_info_fen[2].nobuf=2;
  Pt_acq->tab_info_fen[3].nobuf=3;
  Pt_acq->tab_info_fen[4].nobuf=4;
  Pt_acq->tab_info_fen[5].nobuf=5;
E 6
  Pt_acq->npix = 512;
  Pt_ctrl->nb_empl = 50;
  Pt_acq->nbacq =200; /* 200 acquisitions */
  Pt_acq->cadac= 66000; /* cadence en microsecondes */
  Pt_acq->modob=MODE_SOL; /* Mode soleil entier */
  Pt_acq->obscur=1;/* Demande de courant d'obscurite */
  Pt_acq->ctrac=0; /* Mode non simule*/
  Pt_acq->monit=1; /* DMA valide*/
}

void tb_regl_se( void )
{
  /* Mise a zero des tables communes */
  memset( Pt_acq , 0 , sizeof( Tb_acq ) );
  memset( Pt_cam , 0 , sizeof( Tb_ctrl_cam ) );
  Pt_acq->modob=MODE_REGL_SE; /* Mode reglage soleil entier */
  Pt_acq->nbfen = 1;
  Pt_acq->enfen = 6 ;
  Pt_acq->tab_fen[0].ligdb=0; 
  Pt_acq->tab_fen[0].coldb=0;
  Pt_acq->tab_fen[0].nblig=512;
  Pt_acq->tab_fen[0].nbcol=6;
  
D 6
  Pt_acq->tab_info_fen[0].nocam=CAMERA_SOLEIL_ENTIER;
E 6
I 6
  Pt_acq->tab_info_fen[0].nobuf=CAMERA_SOLEIL_ENTIER;
E 6
  Pt_acq->tab_info_fen[0].sens=SENS_LIG;
  Pt_acq->tab_info_fen[0].noplan=2;
  
  Pt_acq->cadac = 66; /* cadence en millisecondes */
  Pt_acq->monit = 1 ;
}

I 4
/*------------------------------------------------------------------------*/
E 4

I 4
D 5
#define CONFIG_OBT 0x9E /* actuellement seuls les obturateurs 1,2,3,4,7
E 5
I 5
D 10
#define CONFIG_OBT 0x8E /* actuellement seuls les obturateurs 1,2,3,7
E 5
			   sont branches et le volet No 0 n'est pas 
			   teste */
static U16 pattern[]={0x55,0xAB,0x9F};
E 10

D 10
int synchro_obt(void)
{
  int i, size;
  U16 config;
  size= sizeof(pattern)/sizeof(U16);
  for(i=0 ; i< size ; i++)
    {
      ipg_wr_reg( R_OBT, pattern[i]);
      taskDelay(sysClkRateGet()/4); /* attente 1/4s */
    }
  i-- ; /* repositionne au dernier element du tableau */
  ipg_rd_reg( R_OBT , &config ); /* lecture de l'etat des obturateurs */
  if ( (config & CONFIG_OBT) != (pattern[i]& CONFIG_OBT) ) return ERROR;
  return OK;
}


E 10
E 4
/*---------------------------------------------------------------------------*/

int test_reg(U16 numero , int nb_boucle)
{
  U16 valeur;
  int i;
  for( i=0 ; i<nb_boucle ; i++ )
  {
     if ( ipg_rd_reg( numero , &valeur) !=OK ) return (ERROR);
     printf("\n Registre = %x\n ",valeur);
  }
  return (OK);
}


/*---------------------------------------------------------------------------*/
/*
   test des plans buffers.
   Si masque n'est pas precise, le test des memoires se fait avec les valeurs
   0x000, 0xAAAA, 0x5555 et 0xFFFF.
   Si masque est precise, le test n'est fait qu'avec la valeur specifiee
*/

U16 tb_masque[]={0x0000,0xaaaa,0x5555,0xffff};
int tb_masque_size= sizeof(tb_masque)/sizeof(U16);

int test_buffer( Byte numcam , U16 masque )
{
 int i,j,lig,col,flag;
 long int erreur;
 U16 val;
 raz_cam();
 flag = detect_cam( numcam);
 if (flag == ERROR )
 {
   printf("\n Erreur sur detection de la carte");
   return(ERROR);
 }
 if ( flag == ERR_NO_BUF )
 {
   printf("\n carte No: %d non connectee\n",numcam);
   return(ERROR);
 }
 if (flag == ERR_RCPT) printf("\n Camera non connectee");
 else printf("\n Connexion fibre OK");
 printf("\n Test des 7 integrations");
 for( i=1 ; i<NB_MAX_OBT ; i++ )
 {
   affect_obt( numcam , i );
   start_intg(0xFE);
   taskDelay( sysClkRateGet() );
 }
 if ( masque == 0 )
   {
     printf("\n Test des plans memoires\n");
     for(i=1 ; i<=3 ; i++)
       {
	 for(j=0 ; j< tb_masque_size ; j++)
	   {
	     init_buf( numcam , i , tb_masque[j]);
	     erreur=0;
	     for(lig=0 ; lig < MAX_LIG_CCD ; lig++)
	       {
		 for( col=0 ; col < MAX_COL_CCD ; col++)
		   {
		     ipg_rd_data(lig , col, &val);
		     if (val != tb_masque[j]) 
		       {
			 erreur++;
		       }
		   }
	       }
	     if (erreur) printf("\n %ld erreurs trouvees pour %x",erreur,tb_masque[j]);
	     else printf("\n Plan buffer %d OK pour %x",i,tb_masque[j]);
	   }
       }
   }
 else 
   {
 
     for( i=1 ; i<=3 ; i++ )
       {
	 init_buf( numcam , i , masque );
	 erreur=0;
	 for(lig=0 ; lig < MAX_LIG_CCD ; lig++)
	   {
	     for( col=0 ; col < MAX_COL_CCD ; col++)
	       {
		 ipg_rd_data(lig , col, &val);
		 if (val != masque) 
		   {
		     erreur++;
		   }
	       }
	   }
       }
     if (erreur) printf("\n %ld erreurs trouvees pour %x",erreur,masque);
     else printf("\n Plan buffer %d OK pour %x",i,tb_masque[j]);
   }
 printf("\n");
 return(OK);
}


/*--------------------------------------------------------------------------*/
int cad_se, nbacq_se;
void test_soleil_entier( void )
{
  tb_se();
  Pt_acq->cadac = cad_se;
  Pt_acq->nbacq = nbacq_se;
  test_lect = 1;
  start_acq(0);
}

int lect_bloc_se( Byte num_cam , Byte num_plan )
{
  ipg_wr_reg( RADRCAM,(U16)num_plan<<5 | num_cam );  
  if ( ipg_rd_bloc(0,0,511,5,Pt_data,3072,0) != OK ) return (errnoGet());
  return OK;
}

void lect_se( Byte num_cam , Byte num_plan)
{
 int i,j;
 Datum *pt = Pt_data;
 ipg_wr_reg( RADRCAM,(U16)num_plan<<5 | num_cam );
 for(i=0 ; i<512 ; i++)
   for(j=0; j<8 ; j++) ipg_rd_data(i,j,pt++);
}



void print_pt_acq(void)
{
  int i;
I 10
  if( Pt_acq->modob == -1 )
    {
      printf("\nDecodage ( cmdsun 3 ) non effectue\n");
      return;
    }
E 10
  printf(" enfen: %d\n\r",Pt_acq->enfen);
  printf(" nbfen: %d\n\r",Pt_acq->nbfen);
  printf(" nbcam: %d\n\r",Pt_acq->nbcam);
  printf(" nbacq: %d\n\r",Pt_acq->nbacq);
  printf(" cadac: %d\n\r",Pt_acq->cadac);
  printf(" ctrac: %d\n\r",Pt_acq->ctrac);
  printf(" modob: %d\n\r",Pt_acq->modob);
  printf("  meca: %d\n\r",Pt_acq->meca);
  printf(" monit: %d\n\r",Pt_acq->monit);
  printf("  npix: %d\n\r",Pt_acq->npix);
  printf("obscur: %d\n\r",Pt_acq->obscur);
  printf(" vison: %d\n\r",Pt_acq->vison);
  for( i=1 ; i<NB_MAX_OBT ; i++ )
    {
      printf(" Tps intg %d: %d\n\r", i, Pt_acq->dintg[i]);
    }
}


void print_pt_ctrl( void )
{
  int i;
I 10
  if( Pt_acq->modob == -1 )
    {
      printf("\nDecodage ( cmdsun 3 ) non effectue\n");
      return;
    }
E 10
  printf("    nb_empl: %d\n\r",Pt_ctrl->nb_empl);
  printf("taille_empl: %d\n\r",Pt_ctrl->taille_empl);
  if ( Pt_ctrl->nb_empl )
    {
      printf("Etats verrous:\n\r");
      for(i=0 ; i<Pt_ctrl->nb_empl ; i++)
	{
	  if((i% 10 ) == 0) printf("\n\r");
	  printf("%2d", Pt_ctrl->verrou[i]);
	}
      printf("\n\r");
    }
I 4
  printf("Etats des flags des parametres dynamiques:\n\r");
D 8
  for(i=0;i<NB_FLAGS;i++)
E 8
I 8
  for(i=0;i<NB_DYN_FLAGS;i++)
E 8
    printf("%2d",Pt_ctrl->dyn_flags[i]);
  printf("\n\r");
E 4
}

int  print_pt_cam( Byte num_cam)
{
I 10
  if( Pt_acq->modob == -1 )
    {
      printf("\nDecodage ( cmdsun 3 ) non effectue\n");
      return( ERROR );
    }
E 10
  if ( num_cam >= NB_MAX_CAM ) return (ERR_PARAM);
  printf("etat        : %x\n\r",Pt_cam->tab_reg_cam[ num_cam].etat);
  printf("obturateur  : %d\n\r",Pt_cam->tab_reg_cam[ num_cam].n_obt);
  printf("theta       : %d\n\r",Pt_cam->tab_reg_cam[ num_cam].theta);
  return OK;
}

void print_mem_offset( void )
{
 int i;
I 10
 if( Pt_acq->modob == -1 )
   {
     printf("\nDecodage ( cmdsun 3 ) non effectue\n");
     return;
   }
E 10
 if( (Pt_acq->nbfen == 0) || (Pt_acq->nbfen > NB_MAX_FEN) ) return ;
 for( i=0; i<Pt_acq->nbfen; i++)
   printf("\nFenetre %d Offset memoire=%ld Octets",i,Pt_acq->tab_info_fen[i].mem_offset);
}

I 10
void print_tab_fen(void)
{
  int i;
  long nobuf,nocam,no_obt,ligdb,coldb,nblig,nbcol;
  if( Pt_acq->modob == -1 )
    {
      printf("\nDecodage ( cmdsun 3 ) non effectue\n");
      return;
    }
  for( i=0 ; i<Pt_acq->nbfen ; i++ )
    {
      nobuf = Pt_acq->tab_info_fen[i].nobuf;
      nocam = Pt_acq->tab_info_fen[i].nocam;
      no_obt = Pt_cam->tab_reg_cam[nobuf].n_obt;
      ligdb = Pt_acq->tab_fen[i].ligdb;
      coldb = Pt_acq->tab_fen[i].coldb;
      nblig = Pt_acq->tab_fen[i].nblig;
      nbcol = Pt_acq->tab_fen[i].nbcol;
      printf("\nFen:%2d Buf:%2d Cam:%2d Obt:%2d",\
	     i,nobuf,nocam,no_obt );
      printf(" ligdb:%3d coldb:%3d nblig:%3d nbcol:%3d",\
	     ligdb,coldb,nblig,nbcol );
    }
  printf("\n");
      
}


E 10
int  boucle_test( int nb_start )
{
  int i=0;
  for( i=0 ; i< nb_start ; i++ )
    { 
      if ( start_acq(1)== ERROR ) return(ERROR);
    }
  return(OK);
}

void info_vme( void )
{
  puts(infovme);
I 4
}

void taille(void)
{
  printf("\nfloat = %d Octets",sizeof(float));
  printf("\ndouble = %d Octets",sizeof(double));
  printf("\nlong = %d Octets",sizeof(long));
  printf("\nint = %d Octets",sizeof(int)); 
E 4
}
E 1
