h15770
s 00007/00007/00485
d D 1.3 98/08/26 15:49:12 tof 4 3
c copie dr /the/soft/bibli/acq/vme/interface ici ...
e
s 00000/00000/00492
d D 1.2 98/08/26 12:57:46 tof 3 1
c rien.
e
s 00000/00000/00000
d R 1.2 98/08/26 11:50:18 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 vme/interface/sol_entier_v2.c
e
s 00492/00000/00000
d D 1.1 98/08/26 11:50:17 tof 1 0
c date and time created 98/08/26 11:50:17 by tof
e
u
U
f e 0
t
T
I 1
static char *SccsId="%w% %g%";
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:	SOL_ENTIER_V2.C
-----------------
-Auteur(s):	Denis Ziegler
-Rle:	fonction principale d'acquisition VME en mode SOLEIL ENTIER
-Constantes
	Internes au fichier:
		R_TICKS_SE		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
				soleil_entier
				
				
	 
-Commentaires:	


********************************************************************;-*/
/*
   28 Avril 1997: DZ
                  en cas d'erreur sur la fonction de lecture,on remonte
		  ERR_LECT et errnoGet vers la SUN.
*/


#include <vxWorks.h>
#include <stdio.h>
#include <semLib.h>
#include <taskLib.h>
#include <usrLib.h>
#include <tickLib.h>
#include <errnoLib.h>
#include <time.h>
#include <acq.h>
#include <intf.h>
#include <the_errno.h>


#define R_TICKS_SE  1000000L

/*
 *				FONCTIONS EXTERNES
 */
D 4
extern calcul_adr_zone();	/* lecture.c */
extern zone_libre();		/* lecture.c */
extern zone_libre_vis();	/* lecture.c */
extern lock_zone();		/* lecture.c */
E 4
I 4
extern calcul_adr_zone();	/* lect_v3.c */
extern zone_libre();		/* lect_v3.c */
extern zone_libre_vis();	/* lect_v3.c */
extern lock_zone();		/* lect_v3.c */
E 4
extern sysClkRateGet();
extern erreur_sol();		/* trt_err_sol.c */
D 4
extern detect_cam();		/* buffers.c */
E 4
I 4
extern detect_cam();		/* buf_v3.c */
E 4
extern read_time();             /* timekeeper.c */
/*
 *				FONCTIONS INTERNES
 */

int soleil_entier( void );
int lecture_se( Datum *pt , Tb_acq *pt_acq);
int lecture_se_dma( Datum *pt , Tb_acq *pt_acq );
int sim_lecture_se( Datum *pt , Tb_acq *pt_acq);
int stop_se( void );
void simulation_se( int cadence );



/*
 *				VARIABLES EXTERNES
 */
extern Tb_acq *Pt_acq;	/* les structures communes */
extern Datum *Pt_data;
extern Tb_ctrl *Pt_ctrl;
D 4
extern SEM_ID sem_start_se; /* defini dans gen_intg.c */
E 4
I 4
extern SEM_ID sem_start_se; /* defini dans gen_intg_v3.c */
E 4
extern SEM_ID sem_fin_num;
extern SEM_ID sem_stop_acq;
extern SEM_ID sem_start_ok;

D 4
extern test_lect; /* defini dans lecture.c . Si test_lect=1 on shunte la\
E 4
I 4
extern test_lect; /* defini dans lect_v3.c . Si test_lect=1 on shunte la\
E 4
			synchro avec l'enregistrement */
extern int attente_enrg; /* defini dans commandes.c  Si attente_enrg=1\
			 la fonction lecture se met en attente de la\
			 liberation du verrou donc de la fin d'enregistrement */



/*
 *				VARIABLES INTERNES
 */
Datum *pt_buffer_se[ NB_MAX_EMPL ]; /* table d'adresses des tampons memoire */
SEM_ID sem_lect_se; /* semaphore d'autorisation de lecture en \
			mode SOLEIL ENTIER */


int tid_simul_se ; /* tid de la tache de simulation du cadenceur */


/*---------------------------------------------------------------------------------*/

int soleil_entier( void )
{
  int compteur_acq , zone ,premier_fin_num , perte_visu , code ,obscurite;
  int nb_buf;
  int err_obt;
  int dma_se;	/* Si dma_se = 1 ; on switche en lecture dma 29/11/96*/
  int simul;   /* Si simul = 1 ; on simule les cameras RETICONS */
  int forever; /* pour faire tourner les acquisitions en continu */
  int se_timout;
  Err_sol erreur ;
  unsigned long heure_actuelle ;
  Byte flag;

  if ( ( sem_lect_se = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY) ) == NULL )
    {
      perror("SOLEIL ENTIER : ERREUR SUR CREATION DE SEMAPHORE");
      return ( ERR_SEM );
    }
  /* DEBUT DE LA GRANDE BOUCLE */
   
  while (1) 
    {

      /* Blocage sur l'ordre de demarrage */
      semTake( sem_start_se , WAIT_FOREVER );
      simul = Pt_acq->ctrac;
      if (simul == FLAG_ON ) 
	printErr("Soleil entier: mode: simulation\n");
      else 
	printErr("Soleil entier: mode: acquisition sur cameras\n");
      dma_se = Pt_acq->monit;
      if ( dma_se == FLAG_ON ) 
	printErr("Soleil entier: lecture en mode DMA\n");
      else 
	printErr("Soleil entier: lecture en mode NON DMA\n");
      err_obt = FLAG_OFF;
      forever = ( Pt_acq->nbacq == 0 ) ? 1 : 0 ;
      if ( forever )
	printErr("Acquisitions en continu. Arret sur stop_acq\n");

      semGive(sem_start_ok);

      /*Avant de commencer ,on verifie l'etat des cameras et de la liaison 
       avec les obturateurs */
      if (simul != FLAG_ON )
	{
	  printErr("Soleil entier: Verification des cameras\n");
	  code = detect_cam( CAMERA_SOLEIL_ENTIER );
	  if ( code == ERR_NO_BUF )
	    {
	      printErr("Soleil Entier : Absence de carte buffers\n");
	      erreur.code = code;
	      erreur.param_1 = 0 ;
	      erreur_sol( &erreur ) ;
	      continue; /* on revient en attente de sem_start_se */
	    }
	  if ( code == ERR_RCPT )
	    {
	      printErr("Soleil Entier : Cameras non connectees \n");
	      erreur.code = code;
	      erreur.param_1 = 0 ;
	      erreur_sol( &erreur ) ;
	      continue; /* on revient en attente de sem_start_se */
	    }
	  /* Test de la liaison fibre obturateurs */
	  intf_rd_rstat( RECEPT_OBT , &flag );
	  if ( flag  == FLAG_OFF )
	    {
	      err_obt = FLAG_ON;
	      printErr("Soleil Entier : Erreur sur liaison obturateurs\n");
	      erreur.code = ERR_RECEPT_OBT;
	      erreur.param_1 = 0 ;
	      erreur_sol( &erreur ) ;
	      /* cette erreur n'entraine pas d'arret */
	    }
	      
	  /* COMMANDE DU VOLET D'OBTURATION EN FONCTION DE PT_ACQ->OBSCUR */
	  if ( err_obt == FLAG_OFF )
	    {
	      if ( Pt_acq->obscur == FLAG_ON ) 
		{
		  printErr("Soleil entier: Fermeture du volet d'obturation\n");
		  code=cmde_obt(V_OBTURATION , FERME);
		  if (code== ERR_TIMOUT_OBT)
		    {
		      printErr("Erreur de timout sur fermeture volet d'obturation\n");
		      erreur.code = code;
		      erreur.param_1 = 0;
		      erreur_sol(&erreur);
		      /* cette erreur n'entraine pas d'arret */
		    }
		  else 
		    {
		      printErr("Volet d'obturation ferme\n");
		      obscurite = FLAG_ON; 
		    }
		}
	      else 
		{
		  lect_obt(V_OBTURATION , &flag );
		  if (flag == FERME )
		    {
		      printErr("Soleil entier: Ouverture du volet d'obturation\n");
		      code = cmde_obt(V_OBTURATION , OUVERT);
		      if (code== ERR_TIMOUT_OBT)
			{
			  printErr("Erreur de timout sur ouverture du volet d'obturation\n");
			  erreur.code = code;
			  erreur.param_1 = 0;
			  erreur_sol(&erreur);
			  /* cette erreur n'entraine pas d'arret */
			}
		      else printErr("Volet d'obturation ouvert\n");
		    }
		}
	    }
	}
      
      nb_buf= Pt_ctrl->nb_empl;
      /* calcul des pointeurs sur les nb_buf tampons memoire */
      calcul_adr_zone( pt_buffer_se , Pt_data , Pt_ctrl );
      se_timout = Pt_acq->cadac*2*sysClkRateGet()/R_TICKS_SE;
     
      /* DEMARRAGE DU CADENCEUR */

      if((Pt_acq->meca == FLAG_ON) && (Pt_acq->obscur != FLAG_ON))
	{
	  heure_actuelle = read_time();/* retourne l'heure courante en nombre de secondes
					  depuis minuit */
	  if (1) 
	    {
	      unsigned long sec,mn1, mn, hr;
	      sec = Pt_acq->sec_dep % 60;
	      mn1 = Pt_acq->sec_dep / 60;
	      mn = mn1 % 60;
	      hr = mn1 / 60;
	      printErr(" Attente de demarrage a %dh %d:%d\n",hr,mn,sec);
	    }
	  /* ATTENTE DE DEMARRAGE A L'HEURE H */
	  while( Pt_acq->sec_dep > heure_actuelle )
	    {
	      heure_actuelle = read_time();
	    }
	}

      /* Demarrage du cadenceur */ 
      /* l'horloge est a 200kHz actuellement 29/06/96 */
      printErr("Demarrage bande Soleil Entier\n");
      if( simul != FLAG_ON ) 
	{
	  enable_ipg_it( IT_INTG | IT_NUM ); /* validation des interruptions*/
	  start_hard_cad(Pt_acq->cadac/5 , 0 );
	  printErr("Nb periodes sur cadenceur:%d\n",Pt_acq->cadac/5);
	}
      else
	{
	  /* demarrage du cadenceur simulation */
	  tid_simul_se = sp( (FUNCPTR)simulation_se,Pt_acq->cadac,0,0,0,0,0,0,0,0);
	  if ( tid_simul_se == ERROR )
	    {
	      printErr("Soleil Entier : Erreur de creation de tache de simulation\n");
	      continue;
	    }
	}
      compteur_acq = 0;
      perte_visu=0;
      premier_fin_num = 0;
      
      /* LA LECTURE */
      while(1)
	{
	  /* Attente de la fin de numerisation */
	  if ( semTake( sem_lect_se , se_timout) == ERROR )
	    {
	      printErr("Soleil Entier :Erreur timout sur attente de fin de numerisation\n");
	      erreur.code = ERR_TIMOUT_NUM;
	      erreur.param_1 = 0;
	      erreur_sol(&erreur);
	      break; /* sortie de la boucle  */
	    }

	  /* on saute et on ne lit pas le premier fin de numerisation */
	  if (premier_fin_num == 0) 
	    {
	      premier_fin_num = 1;
	      continue;
	    }
	 
	  /* Indice du buffer disponible */
	  zone = zone_libre(Pt_ctrl , compteur_acq % nb_buf);
	  /* rajout de la condition && !forever pour J.B */
	  if ( (zone == ERR_MEM) && (!forever ) )
	    {
	      printErr("\n Soleil Entier : Buffer no:%d  acq: %d  non disponible\n",\
		       compteur_acq % nb_buf, compteur_acq);
	      erreur.code = ERR_MEM;
	      erreur.param_1 = 0;
	      erreur_sol(&erreur);
	      break; /* sortie de la boucle */
	    }
	  else
	    {
	      if ( Pt_acq->vison == FLAG_ON)   /* Si la visu est activee   */
		{
		  if ( zone_libre_vis(Pt_ctrl , compteur_acq % nb_buf) == ERR_MEM) 
		    {
		      perte_visu += 1;
		      if ( perte_visu >=nb_buf )
			{
			  printErr("Perte visu, acq:%6d\n", compteur_acq);
			  erreur.code = ERR_VISU ;
			  erreur.param_1 = perte_visu ;
			  erreur_sol(&erreur) ;
			  perte_visu = 0;
			}
		    }
		}

	      /* Lecture des donnees */
	      if ( simul != FLAG_ON ) 
		{
		  if ( dma_se  == FLAG_ON)
		    code = lecture_se_dma( pt_buffer_se[ zone ], Pt_acq );
		  else 
		    code = lecture_se( pt_buffer_se[ zone ], Pt_acq );
		  if ( code == ERROR )
		    {
		      code = errnoGet();
		      printErr("Soleil entier : Erreur sur lecture :%x \n",\
			       code);
		      
		      erreur.code = ERR_LECT;
		      erreur.param_1 = code;
		      erreur_sol(&erreur);
		      break; /* on sort de la boucle */
		    }
		}
	      
	      else sim_lecture_se( pt_buffer_se[ zone ], Pt_acq );
	     
	      if (test_lect == 0 ) lock_zone( Pt_ctrl , zone , SUN_NOT_BUSY );

	    }
	  if ( semTake( sem_stop_acq , NO_WAIT ) == OK )
	    {
	      printErr("Soleil Entier : Sortie sur stop_acq\n");
	      break; /* On peut toujours sortir par la si on est coince */
	    }
	  if ( !forever ) /* si on n'est pas en boucle continu
			     il va falloir s'arreter au bout de nbacq */
	    {
	      compteur_acq++;
	      if ( compteur_acq >= Pt_acq->nbacq )
		break;
	    }
	} /* FIN DE LA BOUCLE DE LECTURE */
      
      /* ARRET DE LA BANDE */
      printErr("Soleil Entier :Arret cadenceur\n");
      if ( simul != FLAG_ON ) 
	{
	  stop_hard_cad();
	  disable_ipg_it( IT_INTG | IT_NUM ); /* inhibition des its */

	  /* pour l'instant, je sais pas trop pourquoi mais, en fin
	     de bande, j'ai sem_fin_num qui est positionne FULL.
	     Et c'est pas normal, Docteur !!!!! */
	  semTake(sem_fin_num,NO_WAIT);

	  /* Et si un courant d'obscurite vient d'etre fait, on ouvre le volet */
	  if ( err_obt == FLAG_OFF )
	    {
	      if ( obscurite == FLAG_ON )
		{
		  printErr("Ouverture du volet d'obturation\n");
		  code = cmde_obt( V_OBTURATION , OUVERT );
		  if (code== ERR_TIMOUT_OBT)
		    {
		      printErr("Erreur de timout sur ouverture du volet d'obturation\n");
		      erreur.code = code;
		      erreur.param_1 = 0;
		      erreur_sol(&erreur);
		      /* cette erreur n'entraine pas d'arret */
		    }
		  else printErr("Volet d'obturation ouvert\n");
		  obscurite = FLAG_OFF;
		}
	    }
	}
	 	    
      else stop_se();     
      
    } /* FIN DE LA GRANDE BOUCLE */
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	: lecture_se
------------------

-Rle:	Lecture du buffer soleil entier et extraction des voies choisies
-inclure:
-Prototype:
	int lecture_se( Datum *pt , Tb_acq *pt_acq)
-Paramtres:
	Datum *pt:	Adresse de stockage des voies
	Tb_acq *pt_acq:	Pointeur sur la table d'acquisition
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:	OK ou ERROR
-Description: 
	La lecture se fait en fonction des consignes places dans la table d'acquisition: 
	Nombre et numro des voies  acqurir.
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:	Cette fonction n'utilise pas le DMA
	
********************************************************************--*/
int lecture_se_dma( Datum *pt , Tb_acq *pt_acq )
{
  int i,nb_data;
  int lig_debut, col_debut, lig_fin, col_fin;
  lig_debut = 0;
  lig_fin = pt_acq->npix - 1;
  nb_data = pt_acq->npix;
  if( ipg_wr_reg( RADRCAM,P2<<5 | CAMERA_SOLEIL_ENTIER ) !=OK) return (ERROR);
  for( i = 0 ; i < pt_acq->nbfen ; i++, pt += nb_data )
  {
     col_debut = pt_acq->tab_info_fen[i].nocam;
     col_fin = col_debut;
     if ( ipg_rd_bloc(lig_debut , col_debut , lig_fin , col_fin , pt ,\
		      nb_data ,IPA_INC_LIG) !=OK )
     return (ERROR);
  }
  return OK;
}

int lecture_se( Datum *pt , Tb_acq *pt_acq )
{
  int i,j,num_voie;
  if( ipg_wr_reg( RADRCAM, P2<<5 | CAMERA_SOLEIL_ENTIER) != OK) return (ERROR);
  for ( i=0 ; i< pt_acq->nbfen ; i++ )
    {
      num_voie = pt_acq->tab_info_fen[i].nocam;
      for ( j=0 ; j<pt_acq->npix ; j++ )
	ipg_rd_data(j,num_voie,pt++);
    }
  return OK;
}


int sim_lecture_se( Datum *pt , Tb_acq *pt_acq )
{
  Datum *pt_buf = pt;
  int i,j;
  for( i = 0 ; i < pt_acq->nbfen ; i++ )
     for( j = 0 ; j < pt_acq->npix ; j++ )
        *pt_buf++ = j + 10 * pt_acq->tab_info_fen[ i ].nocam;
  return OK;
}

/*---------------------------------------------------------------------------------*/
int stop_se( void )
{
 td( tid_simul_se );
 return OK ;
}

void simulation_se( int cadence )
{
  int nb_ticks = (long)cadence * sysClkRateGet() / R_TICKS_SE ;
  printErr("Nb ticks d'horloge = %d\n",nb_ticks );
  while (1)
  {
     taskDelay( nb_ticks );
     semGive( sem_lect_se);
  }
}



E 1
