h12829
s 00001/00013/00300
d D 1.7 99/06/30 11:38:10 chris 9 7
i 8
c Merged changes between child workspace "/home/devel/fils1_travail" and
c  parent workspace "/home/devel/travail".
c 
e
s 00024/00003/00277
d D 1.5.1.1 99/06/30 10:30:50 chris 8 6
c debug
e
s 00017/00003/00277
d D 1.6 99/06/30 10:24:57 chris 7 6
c avant dev formatage 3
e
s 00001/00001/00279
d D 1.5 99/02/05 12:59:56 chris 6 5
c Ajout des fonctions de tests du VME, fichier vme_spy et corrections de qq bugs
e
s 00064/00003/00216
d D 1.4 98/10/12 12:59:43 lezieg 5 4
c Passage a 19200Bds sur la liaison RS232 avec l'UCCI
e
s 00084/00118/00135
d D 1.3 98/08/26 15:49:10 tof 4 3
c copie dr /the/soft/bibli/acq/vme/interface ici ...
e
s 00000/00000/00253
d D 1.2 98/08/26 12:57:46 tof 3 1
c rien.
e
s 00000/00000/00000
d R 1.2 98/08/26 11:50:17 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 vme/interface/rs232_v3.c
e
s 00253/00000/00000
d D 1.1 98/08/26 11:50:16 tof 1 0
c date and time created 98/08/26 11:50:16 by tof
e
u
U
f e 0
t
T
I 1

static char *SccsId="%w% %g%";
/*;+********************************************************************
-----------------
ENTETE DE FICHIER       :  rs232_v3.c     
-----------------
-Auteur(s):D.Zig
-Rle:
-Constantes
	Internes au fichier: 
		
				
		
-Variables
	Internes au fichier: 

		
-Fonctions:
	Internes au fichier:


	 
-Commentaires:	

********************************************************************;-*/

D 4
/* 4 Juin 1998 : Ajout de la commande WACQ 
E 4
I 4
/*------------------------------HISTORIQUE--------------------------
I 5
  9 Octobre 1998 dz Bonne fete Denis !! Merci, c'est sympa, MERCI
  GRAND DEBUGGING D'AUTOMNE 

  Ajout de la fonction debug_com( flag ) et de plein de printErr partout
  pour debugger la tache en cas de problemes.
  debug_com(1) valide tous les printErr.
  debug_com(0) les inhibe.
  Plus d'autres lignes de codes pour debugger.

  8 Octobre 1998 dz
  Ajout d'un compteur de commandes recues par la ligne RS232 pour debug
  2 fonctions :
    raz_cpt_cmd() : raz du compteur
    print_cpt_cmd() : affichage du contenu du compteur

E 5
  28 Juillet 1998 dz
  Si init_acquisition n'a pas ete lance, on retourne directement un
  code d'erreur generale. Voir la chaine err_ae24.

  25Juillet 1998 dz
  Profonde modification du fichier.
  Creation du fichier header com_ucci_vme.h qui contient les constantes
  de parametrage de la liaison rs232 et la definition de la structure
  Cmd_ucci_vme.
  Le decodage des infos,actions en provenance de l'UCCI se font maintenant
  en scrutant une table de structures de type Cmd_ucci_vme.

  24 Juillet 1998 dz
  Correction d'un bug sur la chaine de caracteres recue dans tamp_rs232
  Si les taches ne sont pas lancees par init_acquisition, j'ai un caractere
  pirate ( 0x0d ) qui se place avant la commande envoyee par l'ucci dans
  la chaine tamp_rs232 ou le buffer d'entree et qui fausse le decodage
  La correction s'effectue dans la fonction decode().

  4 Juin 1998 : Ajout de la commande WACQ 

E 4
 */

#include <vxWorks.h>
#include <stdio.h>
#include <ioLib.h>
#include <taskLib.h>
#include <string.h>
#include <intf.h>
I 4
#include <com_ucci_vme.h>
E 4

D 4
/*-------------------------------CONSTANTES---------------------------*/
#define RS232_0 "/tyCo/0"
#define RS232_1 "/tyCo/1"
#define SPEED_RS232 9600
#define NB_MAX_BYTES 80
#define NB_MAX_PARAM 3
#define NB_CHAR 3
#define ACQI 1
#define UTC  2
#define WACQ 3
#define CMD_UNKNOW 255
 
/*------------------------------FONCTIONS INTERNES---------------------*/
int init_rs232( char *port) ;
int test_rd_rs232( char *port );
int test_wr_rs232( char *port );
int init_com( void );
int decode( char *chaine );
int integration( void );
void write_rs232( char *msg );
void read_rs232( char *msg );
int extract_param( char *chaine , int *dest);
E 4
I 4
#include "tab_cmd_ucci.c"
E 4


D 4
/*-----------------------------FONCTIONS EXTERNES----------------------*/
E 4
I 4
/*-----------------------------VARIABLES GLOBALES----------------------*/
E 4

D 4
extern start_acq();
extern wacq();     
extern quelle_heure();
extern set_utc(); /* timekeeper.c */
E 4
I 4
char tamp_rs232[NB_MAX_BYTES]; /* tampon de reception du message */
static char *msg = "Hola caballero, como esta ??\n\r";
E 4

D 4
/*-----------------------------VARIABLES GLOBALES----------------------*/
E 4
I 4
static char *cmd_unknow = "?ERR=81,\"\"\\\\AE24\n\r"; /* commande inconnue  */
static char *cmd_ok = "\n\r<\n\r";            /* commande recue     */
static char *cmd_done="\n\r>\n\r";            /* commande effectuee */
static char *err_ae24 = "?ERR=1,\"\"\\\\AE24\n\r"; /* Erreur generale
						      init_acquisition n'est
						      pas lancee */
E 4

D 4
static char tamp_rs232[NB_MAX_BYTES]; /* tampon de reception du message */
int  tab_param[NB_MAX_PARAM];/* table des valeurs AA,MM,JJ,HH,MnMn,SS */
char *msg = "Salut Dugenou, como esta ??\n\r";
E 4

D 4
char *cmd_unknow = "?ERR=81,\"\"\\\\AE24\n\r"; /* commande inconnue  */
char *cmd_ok = "\n\r<\n\r";            /* commande recue     */
char *cmd_done="\n\r>\n\r";            /* commande effectuee */
char *cmd_acqi="$ACQI";
char *cmd_wacq="$WACQ";
char *cmd_utc="$UTC";
char *err_acqui="?ERR=1,\"\\\\AE24\\ACQI()\"\n\r"; /* erreur sur commande ACQI */
char *err_utc_1="?ERR=1,\"\\\\AE24\\UTC()\"\n\r";/* erreur sur parametres */
char *err_utc_2="?ERR=2,\"\\\\AE24\\UTC()\"\n\r";/* erreur sur mise a l'heure*/
char *err_wacq_1="?ERR=1,\"\\\\AE24\\WACQ()\"\n\r"; /* erreur sur commande WACQ 
						       fonction non lancee */
char *err_wacq_2="?ERR=2,\"\\\\AE24\\WACQ()\"\n\r"; /* erreur sur commande WACQ 
						       timout sur fin de intg */
char *sep_utc="$UTC(),\n\r";
E 4


I 4

E 4
int demande_rs232; /* actif si demande d'acquisition via la ligne RS232 */
int demande_utc;   /* actif si demande de mise a l'heure via la ligne RS232 */
int fd_rs232; /* file descriptor de la liaison RS232 */

D 4
/*-----------------------------VARIABLES EXTERNES----------------------*/
extern Tb_ctrl_cam *Pt_cam; /* Pointeur sur la table de controle des cameras */
extern SEM_ID sem_fin_intg; /* fin d'integration (ipg_ccd.c) */
E 4
I 4
extern int init_acq_ok ; /* actif si le programme d'acquisition est lance
			    start_v3.c */

I 5
static int cpt_cmd; /* compteur de commandes recues via la ligne RS232 */
D 6
static flag_debug_com; /* flag pour debug de la tache de communication serie */
E 6
I 6
int flag_debug_com; /* flag pour debug de la tache de communication serie */
E 6
E 5

E 4
/*---------------------------------------------------------------------*/

int init_rs232(char *port)
{
  int fd;
  if ( (fd = open( port , O_RDWR , 0 )) == ERROR )
    {
      printf(" Erreur ouverture de communication sur port RS232 %s\n",port );
      return ( ERROR );
    }
  ioctl(fd,FIOBAUDRATE,SPEED_RS232);
  ioctl(fd,FIOSETOPTIONS, OPT_LINE ); /* line mode*/
  ioctl(fd,FIOFLUSH,0);	/* Vidage des buffers IN et OUT */
  taskDelay(2);
  return( fd );
}

int test_rd_rs232( char *port )
{
  int fd , nb_bytes , i ;
  if ( (fd = init_rs232( port )) == ERROR ) return ( ERROR );
  nb_bytes = read( fd , tamp_rs232 , NB_MAX_BYTES);
  printf(" %d Caracteres recus\n", nb_bytes);
  if ( nb_bytes )
    for( i=0 ; i<nb_bytes ; i++) printf("%c",tamp_rs232[i]);
  printf("\n");
  close(fd);
  return ( OK );
}

int test_wr_rs232( char *port )
{
  int fd , nb_bytes , i ;
  if ( (fd = init_rs232( port )) == ERROR ) return ( ERROR );
  nb_bytes = write( fd , msg , strlen(msg));
  printf(" %d Caracteres envoyes\n", nb_bytes);
  if ( nb_bytes )
    for( i=0 ; i<nb_bytes ; i++) printf("%c",msg[i]);
  printf("\n");
  close(fd);
  return ( OK );
}



int init_com( void )
 {
D 4
  int code, nb_param;
E 4
I 4
  int code,cmd_valide,code_err;
  int i;
I 5
  ULONG  first_time ,second_time, delta ; /* pour faire des mesures de temps */
  flag_debug_com =0;
  first_time = second_time = 0;
E 5
E 4
  if ( (fd_rs232 = init_rs232(RS232_1)) == ERROR ) return (ERROR);
  while (1)
    {
      demande_rs232=0;
D 4
      ioctl(fd_rs232 , FIORFLUSH , 0); /* Vide le buffer IN */
      memset(tamp_rs232,0,sizeof(tamp_rs232));
E 4
I 4
      cmd_valide = 0;
I 7
D 9
      if (flag_debug_com)
	printErr("\n avant ioctl");
E 9

E 7
I 8
D 9

E 9
      if (flag_debug_com)
	printErr("\n--------> Avant ioctl\n");

E 8
      ioctl(fd_rs232 , FIORFLUSH , 0); /* Vide le buffer IN  */
I 7
D 9
      if (flag_debug_com)
	printErr("\n avant read_rs232");
E 9

E 7
I 8
D 9

E 9
      if (flag_debug_com)
	printErr("\n------------> Avant read\n");
E 8
E 4
      read_rs232( tamp_rs232 );
I 8
      
      if (flag_debug_com)
	printErr("\n------------> Apres read\n");
      
E 8
D 4
      printf("\nRecu sur ligne RS232 : %s ",tamp_rs232);
      code = decode(tamp_rs232);
E 4
I 4
D 5
      printf("\nRecu sur ligne RS232 : %s \n",tamp_rs232);
E 5
I 5
      cpt_cmd ++ ; /* increment du compteur de commandes recues */
      if (flag_debug_com)
	{
	  second_time = tickGet();
	  delta = second_time - first_time ;
	  first_time = second_time ;
D 7
D 8
	  printErr("\nRecu: %s \nTemps:%ld cs",tamp_rs232, delta);
E 7
I 7
	  printErr("\nRecu: %s \napres read, Temps:%ld cs",tamp_rs232, delta);
E 7
E 8
I 8
	  printErr("\nRecu: --%s-- \nTemps:%ld cs",tamp_rs232, delta);
E 8
	}
I 8

      if (flag_debug_com)
	printErr("\n---------------> Avant write recu\n");
E 8
E 5
E 4
      write_rs232( cmd_ok );
I 8

E 8
I 5
      if (flag_debug_com)
D 7
	printErr("\nEnvoi: %s",cmd_ok);
E 7
I 7
D 9
	printErr("\napres write cmd ok, Envoi: %s",cmd_ok);
E 9
I 9
	printErr("\nEnvoi: %s",cmd_ok);
E 9
E 7
E 5
D 4
      if ( code != CMD_UNKNOW )
E 4
I 4

      /* si le prog d'acquisition n'est pas lance, ce n'est pas la peine
	 d'aller plus loin */
      if ( init_acq_ok == 0 )
E 4
	{
D 4
	  switch(code)
	    {
	    case ACQI: 
	      demande_rs232=1;
	      if (start_acq(1) == ERROR) 
		write_rs232( err_acqui );
	      write_rs232( cmd_done );
	      demande_rs232 = 0;
	      break;  
	    case WACQ: /* integration lancee par l'UCCI */
	      demande_rs232=1;
	      code=wacq();
	      if(code != OK)
		{
		  if(code == ERROR) write_rs232(err_wacq_1);
		  if(code == ERR_TIMOUT_OBT) write_rs232(err_wacq_2);
		}
	      write_rs232( cmd_done );
	      demande_rs232=0;
	      break;
	    case UTC:
	      nb_param=extract_param(tamp_rs232,tab_param);
	      if(nb_param != NB_MAX_PARAM)
		{
		  /* erreur sur le nombre de parametres passes */
		  write_rs232(err_utc_1); 
		  write_rs232( cmd_done);
		}
	      else 
		{
		  demande_utc=1;
		  code=set_utc(tab_param,nb_param);
		  demande_utc=0;
		  if (code == ERROR)
		    write_rs232(err_utc_2); /* erreur sur la mise a l'heure  */
		  write_rs232(cmd_done);
		}
	    default:
	      break;
	    }
	}
      else
	{
	  write_rs232( cmd_unknow);
E 4
I 4
	  write_rs232( err_ae24 );
I 5
	  if (flag_debug_com)
	    printErr("\nEnvoi: %s",err_ae24);
E 5
E 4
	  write_rs232( cmd_done );
I 5
	  if (flag_debug_com)
	    printErr("\nEnvoi: %s",cmd_done);
E 5
I 4
	  continue;
E 4
	}
D 4
    }
E 4
I 4
      for( i=0 ; i<nb_cmd_ucci_vme ; i++ )
	{
	  code=decode(tamp_rs232, tab_cmd_ucci[i].chaine);
D 8
	  /*printf("\nCode= %d pour la chaine %s",code,tab_cmd_ucci[i].chaine );*/
E 8
I 8
	  /*	  printf("\nCode= %d pour la chaine %s",code,tab_cmd_ucci[i].chaine );
	   */
E 8
	  if (code == OK)
	    {
	      cmd_valide=1; /* la commande est trouvee */
I 5
	      if (flag_debug_com)
		printErr("\nExecution commande");
E 5
	      code_err =(tab_cmd_ucci[i].pt_fonc)(); /* la fonction associee est lancee*/
	      if ( code_err !=NO_ERR_CMD_UCCI ) /* Si retour d'erreur,on l'envoie
						   sur la ligne RS232 */
D 5
		write_rs232( tab_cmd_ucci[i].erreur[code_err - 1] );
E 5
I 5
		{
		  write_rs232( tab_cmd_ucci[i].erreur[code_err - 1] );
		  if (flag_debug_com)
		    printErr("\nEnvoi: %s",tab_cmd_ucci[i].erreur[code_err -1]);
		}
E 5
	      break; /* et on sort de la boucle for*/
	    }
	} /* fin de boucle for */

I 7
D 9
      if (flag_debug_com)
	printErr("\n apres recherche mot cle");

E 9
E 7
      if( cmd_valide == 0 ) 
D 5
	write_rs232( cmd_unknow ); /* la commande n'est pas connue */
E 5
I 5
	{
I 7
	  if (flag_debug_com)
D 9
	    printErr("\n avant cmd unknown");
      
E 7
I 8
	  if (flag_debug_com)
E 9
	    printErr("\n-------------------> Avant cmd unknown \n");
E 8
	  write_rs232( cmd_unknow ); /* la commande n'est pas connue */
	  if (flag_debug_com)
	    printErr("\nEnvoi: %s",cmd_unknow);
	}
D 7
D 8
      
E 7
I 7
      if (flag_debug_com)
	printErr("\n avant cmd done");

E 7
E 8
I 8
      if (flag_debug_com)
	printErr("\n-----------------------> Avant cmd done\n");
E 8
E 5
      write_rs232( cmd_done);
I 5
      if (flag_debug_com)
	printErr("\nEnvoi: %s",cmd_done);
E 5
    } /* fin de  boucle while(1) */
I 8

  printErr("\nALAAAARM !!!! Plantage tache lecture rs232");
E 8
E 4
 }


D 4
int decode(char *chaine )
E 4
I 4
int decode(char *chaine, char *table )
E 4
  {
D 4
    if ( strncmp(cmd_acqi , chaine , strlen(cmd_acqi) ) == 0 ) return ( ACQI );
    if ( strncmp( cmd_utc , chaine , strlen(cmd_utc) ) == 0 ) return( UTC );
    if ( strncmp( cmd_wacq , chaine , strlen(cmd_wacq) ) == 0 ) return( WACQ );
    return( CMD_UNKNOW );
E 4
I 4
    int code;
    char *string=chaine;
    /* Si le buffer commence par des caracteres indesirables
       du genre \n et/ou \r , on les saute ......Hop !! */
    while( (*string == CR) || ( *string == NL ) )
      {
	string +=1;
      }
    code = strncmp(table , string , strlen(table)  );
    if (code ==0 ) return ( OK );
    return (ERROR);
E 4
  }



void write_rs232( char *msg )
{
  write( fd_rs232 , msg , strlen(msg) );
}

void read_rs232( char *msg)
{
D 4
  read( fd_rs232 , msg , NB_MAX_BYTES );
E 4
I 4
  int nb_char;
  nb_char = read( fd_rs232 , msg , NB_MAX_BYTES );
  msg[nb_char] = 0 ; /* Pour terminer une chaine de caracteres */
E 4
} 

I 5
void raz_cpt_cmd( void )
{
  cpt_cmd = 0 ;
}

void print_cpt_cmd( void )
{
  printf("\nNbre de commandes recues = %d\n", cpt_cmd);
}

void debug_com( int flag )
{
  flag_debug_com = flag;
}

E 5
I 4
/*----------------------------------------------------------------------------*/
E 4

D 4
int extract_param( char *chaine , int *dest)
{
  int i;
  char tampon[NB_MAX_BYTES];
  char *p;
  strcpy(tampon,chaine);
  /* extraction des parametres de la chaine UTC */
  for( p=tampon,i=0 ; (p=strtok(p,sep_utc)) != NULL ; p=NULL,i++)
    dest[i] = atoi(p);
  return (i);
}
E 4

D 4

E 4


    
 



 
 

 


E 1
