h46350
s 00014/00005/00225
d D 1.4 99/03/10 16:43:44 lezieg 5 4
c anti_rebond logiciel sur cmde_obt reecrit.
e
s 00000/00000/00230
d D 1.3 98/08/26 15:49:06 tof 4 3
c copie dr /the/soft/bibli/acq/vme/interface ici ...
e
s 00000/00000/00230
d D 1.2 98/08/26 12:57:45 tof 3 1
c rien.
e
s 00000/00000/00000
d R 1.2 98/08/26 11:50:16 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 vme/interface/obt_v3.c
e
s 00230/00000/00000
d D 1.1 98/08/26 11:50:15 tof 1 0
c date and time created 98/08/26 11:50:15 by tof
e
u
U
f e 0
t
T
I 1
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	: OBT_V3.C
-----------------
-Auteur(s):Denis Ziegler
-Role: manipulation des obturateurs
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier: 
				obt_timeout
	 	
-Fonctions:
	Internes au fichier:
			 	lect_obt
				cmde_obt
				force_obt
				restaure_obt
	 
-Commentaires:

********************************************************************;-*/
I 5
/*---------------------------HISTORIQUE------------------------------
  10 Mars 1999 dz
  reecriture de la fonction cmde_obt:
  l'anti_rebond logiciel n'etait pas correctement ecrit et pouvait parfois
  retourner en erreur de timout alors que l'execution etait correcte.
E 5

I 5
 */
E 5

/* 
 *                           FICHIERS A INCLURE
 */ 

#include <vxWorks.h>
#include <tickLib.h>
#include <taskLib.h>
#include <usrLib.h>
#include <stdio.h>
#include <semLib.h>
#include <intf.h>
#include <acq.h>

int lect_obt( Byte num , Byte *flag);
int cmde_obt( Byte num , Byte flag );
int force_obt( U16 masque , Byte valeur );
int restaure_obt( void );
int test_obt(void);
void stop_test_obt(void);
int obt_test(void);

extern sysClkRateGet();

static U16 config_obt;

/*++********************************************************************
------------------
ENTETE DE FONCTION	:	lect_obt
------------------

-Role: lecture de l'etat d'un obturateur
-inclure: intf.h
-Prototype:
	int lect_obt( Byte num , Byte *flag )
-Parametres:	
	num: numero de l'obturateur a lire ( 0 a NB_MAX_OBT-1 )
	flag: etat de l'obturateur (OUVERT/FERME)
	OUVERT/FERME sont definis dans intf.h
-Variables globales utilisees
	Internes au fichier: 
	Importees:

-Retour: OK ou ERROR ou ERR_PARAM
-Description:
-Constantes utilisees
	Internes au fichier:
	Importees:
	
-Fonctions utilisees
	Internes au fichier:
	Importees: 
		ipg_rd_reg (ipg_ccd.c)

-Exemple: 
-Commentaires:
********************************************************************--*/



int lect_obt(Byte num , Byte *flag)
{ 
 U16 status;
 if ( num >= NB_MAX_OBT ) return(ERR_PARAM);
 if ( ipg_rd_reg(R_OBT,&status) != OK ) return (ERROR);
 *flag=(Byte)( status >> num & 1 );/* decalage et masque pour isoler l'info*/
 return (OK);
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:	cmde_obt
------------------

-Role: Commande d'un obturateur
-inclure: intf.h
-Prototype:
	int cmde_obt( Byte num , Byte flag )
-Parametres:
	num: numero de l'obturateur ( 0 a NB_MAX_OBT-1 )
	flag: etat de l'obturateur ( OUVERT/FERME)
-Variables globales utilisees
	Internes au fichier: 
				obt_timeout
	Importees:

-Retour: OK , ERROR ou ERR_TIMOUT_OBT ou ERR_PARAM
-Description: 
Commande d'un obturateur. Si la commande n'a pas abouti dans le laps de temps fixe par obt_timeout, la fonction retourne  ERR_TIMOUT_OBT.
-Constantes utilisees
	Internes au fichier:
	Importees:
	
-Fonctions utilisees
	Internes au fichier:
	Importees: 
		ipg_wr_reg 
		tickGet 
		sysClkRateGet

-Exemple:
-Commentaires:
********************************************************************--*/



int cmde_obt( Byte num , Byte flag  )
{

 U16 config ,etat1, etat2,etat;
 ULONG watch_start;
 int obt_timeout;
 
 if ( num >= NB_MAX_OBT ) return(ERR_PARAM);

 obt_timeout= 2*sysClkRateGet(); /* timeout de 2 secondes */
 /* Si on manoeuvre le volet d'obturation , le timout est augmente
    because il lui faut 4 secondes pour sa manoeuvre */
 if ( num == V_OBTURATION ) obt_timeout = 6*sysClkRateGet();
 if ( ipg_rd_reg(R_OBT,&config) != OK) return (ERROR);/* Lecture de la configuration */
 if (flag) config |= 1 << num;/* masque pour forcer a 1 */
 else config &= ~(1 << num ); /* masque pour forcer a 0 */
 if ( ipg_wr_reg(R_OBT,config) != OK ) return (ERROR);
 watch_start= tickGet();
D 5
 etat = ~config;
E 5
I 5
 etat = ~(U16)flag;
E 5
 do 
   {
     /* anti rebond logiciel et chien de garde */
D 5
     if ( tickGet() >  watch_start + obt_timeout) return ( ERR_TIMOUT_OBT);
     if ( ipg_rd_reg( R_OBT , &etat1) != OK ) return (ERROR);  
E 5
I 5
     if ( tickGet() >  watch_start + obt_timeout) 
       return ( ERR_TIMOUT_OBT);
     if ( ipg_rd_reg( R_OBT , &etat1) != OK ) return (ERROR); 
     etat1 = ( etat1 >> num ) & 1;
E 5
     taskDelay( sysClkRateGet()/10 ); /* attente de 1/10 ieme de seconde */
     if ( ipg_rd_reg( R_OBT , &etat2) != OK ) return (ERROR);
D 5
     if ((etat1==etat2) && (etat2 == config)) etat= config;
E 5
I 5
     etat2 = ( etat2 >> num ) & 1;
     if ((etat1==etat2) && (etat2 == (U16)flag )) etat= (U16)flag ;
E 5

D 5
   } while ( etat != config );
E 5
I 5
   } while ( etat != (U16)flag );
E 5
 return (OK);
}

static int modif_obt;

int force_obt( U16 masque , Byte valeur )
{
  U16 new_config;
  /* lecture de l'etat des obturateurs */
  if ( ipg_rd_reg(R_OBT,&config_obt) !=OK ) return (ERROR);
  if ( valeur ) /* ouverture */
    new_config = config_obt | masque ;
  else /* sinon fermeture */
    new_config = config_obt & ~masque ;
  
  if ( ipg_wr_reg(R_OBT,new_config) != OK ) return (ERROR);
  modif_obt = 1;
  return (OK);
}
 
int restaure_obt( void )
{
  if( modif_obt ) /* il faut qu'il y ai eu au moins un
		     force_obt fait */
    {
      if ( ipg_wr_reg(R_OBT,config_obt) != OK ) return (ERROR);
    }
  return (OK);
}

/*--------------------POUR TESTER LA TRANSMISSION VERS AE02-----------------*/

SEM_ID sem_stop_obt;
int tid_test_obt; /* task id de la tache test_obt */

int obt_test( void )
{
  int i;
  if ( (sem_stop_obt = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL )
      return (ERROR);
  while(1)
    {
      for(i=0 ; i<8 ; i++ )
	{
	  ipg_wr_reg(R_OBT , 1<<i );
	  taskDelay(sysClkRateGet()); /* pause de 1 seconde */
	}
      if( semTake( sem_stop_obt , NO_WAIT ) == OK ) break;
    }
  semDelete( sem_stop_obt ); /* on flingue le semaphore */
  td( tid_test_obt );        /* et la tache aussi */
  return OK;
}

int  test_obt( void )
{
  tid_test_obt = sp( (FUNCPTR)obt_test,0,0,0,0,0,0,0,0,0);
  if (tid_test_obt == ERROR) 
    {
      printf("\n Erreur creation tache de tests obturateurs");
      return(ERROR);
    }
  return OK;
}

void stop_test_obt( void )
{
  semGive( sem_stop_obt ); /* on arrete */
}

    
E 1
