h44531
s 00024/00006/00434
d D 1.6 99/03/31 11:13:05 lezieg 7 6
c protection de la fonction de lecture contre une fenetre non initialisee
e
s 00005/00003/00435
d D 1.5 98/10/16 18:16:04 lezieg 6 5
c version d'apres mission fiabilisation d'octobre 1998
e
s 00053/00005/00385
d D 1.4 98/10/12 12:57:28 lezieg 5 4
c Ajout du flag global flag_lect, il sert a savoir, dans les autres taches, si la tache de lecture
c est active ou non.
e
s 00033/00016/00357
d D 1.3 98/08/26 15:49:08 tof 4 3
c copie dr /the/soft/bibli/acq/vme/interface ici ...
e
s 00000/00000/00373
d D 1.2 98/08/26 12:57:44 tof 3 1
c rien.
e
s 00000/00000/00000
d R 1.2 98/08/26 11:50:16 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 vme/interface/lecture_v3.c
e
s 00373/00000/00000
d D 1.1 98/08/26 11:50:15 tof 1 0
c date and time created 98/08/26 11:50:15 by tof
e
u
U
f e 0
t
T
I 1
D 4
static char *SccsId="%W% %G%";
E 4
I 4
static char *SccsId="@(#)lecture_v3.c	1.3 07/28/98";
E 4
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:	LECTURE_V3.C
-----------------
-Auteur(s):	Denis Ziegler
-Role:	
	Tache  de lecture des buffers en mode acquisitions CCD
-Constantes
	Internes au fichier:
						
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:	
				lecture
				
				calcul_adr_zone
				zone_libre
				zone_libre_vis
				lock_zone
				wr_total_data
I 5
				debug_lect
E 5
	 
Commentaires:	
Ce fichier contient la fonction principale de lecture des buffers em mode CCD.
La nouvelle disposition des donnees en memoire ( plus d'entete de fenetres et debut 
des fenetres a un offset calcule because DMA ) impose ce nouveau fichier.

********************************************************************;-*/
/*
I 7
  15 Mars 1999 dz
  en cas d'erreur sur lecture DMA, on affiche le numero de la fenetre

E 7
I 6
  13 Octobre 1998 dz
  La constante de timout sur enregistrement passe a 10 secondes

E 6
I 5
  9 Octobre 1998 dz
  Ajout de la fonction debug_lect( flag ) et de plein de printErr
  partout pour debugger la tache de lecture si necessaire.
  debug_lect(1) valide les printErr.
  debug_lect(0) les inhibe.

E 5
I 4
  28 Juillet 1998 dz
  reset des cartes buffers avant la lecture. C'est surtout utile
  en mode cadenceur ou on ne peut pas faire de reset n'importe quand
  surtout pas en cours de DMA.

  27 Juillet 1998 dz
  Correction bug.  ( version 1.2 )
  Si en cours de lecture, on a une erreur de timout sur enregistrement,
  il ne faut pas auussi donner le semaphore sem_lect_ok. Vu !!!!!!

E 4
  17.12.96 dz
  on fait des mesures de temps avec la fonction wr_tab_perf
  Voir test_perf.c
  */

#include <vxWorks.h>
#include <errnoLib.h>
#include <stdio.h>
#include <fioLib.h>
#include <semLib.h>
#include <tickLib.h>
#include <acq.h>
#include <intf.h>

I 5
/*-----------------------CONSTANTES INTERNES --------------------*/
E 5

I 5
D 6
#define TIMOUT_ENRG_SUN  (5*sysClkRateGet())
E 6
I 6
#define TIMOUT_ENRG_SUN  (10*sysClkRateGet())
E 6

/*---------------------------------------------------------------*/

E 5
D 4
extern lect_buf();        /* buffers.c */
extern lect_buf_no_dma(); /* buffers.c */
E 4
I 4
extern lect_buf();        /* buf_v3.c */
extern lect_buf_no_dma(); /* buf_v3.c */
E 4
extern wr_tab_perf();     /* test_perf.c */
/*
 *		FONCTIONS INTERNES AU FICHIER
 */
void calcul_adr_zone( Datum **pt_zone , Datum *pt ,Tb_ctrl *pt_ctrl );
int zone_libre( Tb_ctrl *pt_ctrl , int base );
void lock_zone( Tb_ctrl *pt_ctrl , int zone , int lock );


/*
 *			VARIABLES GLOBALES
 */


extern Tb_acq *Pt_acq; /* Pointeur sur Tab_acq */
extern Datum *Pt_data; /* Pointeur sur zone des donnees */
extern Tb_ctrl *Pt_ctrl; /* pointeur sur la structure partage memoire */
extern int attente_enrg; /* defini dans commandes.c  Si attente_enrg=1\
			    la fonction lecture se met en attente de la\
			    liberation du verrou */
extern int reglage_se;  /* defini dans gen_intg.c Utilise pour ne pas prendre \
                           le premier fin de numerisation en mode reglage des \
                           cameras Soleil Entier */


extern int cpt_start_acq; /* test_perf.c */

SEM_ID sem_go_lect; /* semaphore d'autorisation de lecture */
SEM_ID sem_lect_ok; /* semaphore lecture effectuee */
SEM_ID sem_timout_enrg; /* semaphore de timout sur enregistrement */

Datum *pt_zone_data[ NB_MAX_EMPL ];
int test_lect; /* test interne . Si test_lect=1 on ne teste pas la \
                  disponibilite des zones memoires */

int dma;  /* Si on positionne DMA a 1 --> lecture des buffers en mode DMA */
I 4
int num_buf_vme; /* le numero du buffer de stockage des fenetres */
I 5

int flag_lect; /* Indicateur de lecture en cours */

static flag_debug_lect; /* flag pour autoriser les affichages ( debug) */

E 5
E 4
/*++********************************************************************
------------------
ENTETE DE FONCTION	:	lecture
------------------

-Role:	fonction principale de lecture des buffers
-inclure:
-Prototype:
	int lecture(void)
-Parametres:
-Variables globales utilisees
	Internes au fichier:
	Importees:

-Retour: si retour alors ERROR
-Description:	
Creation des semaphores utilises par la tache de lecture.
Lecture des buffers selon le contenu de la table d'acquisition
		
-Constantes utilisees
	Internes au fichier:
	Importees:
	
-Fonctions utilisees
	Internes au fichier:
	Importees:
D 4
		intf_wr_rctrl ( intf.c)
		lect_buf ( buffers.c)
E 4
I 4
		intf_wr_rctrl ( intf_v3.c)
		lect_buf ( buf_v3.c)
E 4

-Exemple:
-Commentaires:
	Si la variable attente_enrg est positionnee a 1 la fonction de lecture 
	attend la fin de l'enregistrement ( disponibilite du verrou).
********************************************************************--*/
int lecture(void)
{
D 4
  int i,code, zone_active;
  int num_buf;
E 4
I 4
  int i,code, zone_active,err_lect;
E 4
  Datum *pt_buffer,*pt_fenetre;
D 7
  long nbvaleur; /* nombre de valeurs a lire par fenetre */
E 7
I 7
  double nbvaleur; /* nombre de valeurs a lire  */
E 7
D 5
  long start_enrg , end_enrg; /* pour test de temps d'enregistrement */
E 5
I 5
  long start_enrg;
E 5
D 7
  long start_lect, end_lect; /* pour mesurer le temps de lecture */
E 7
I 7
  long start_lect, end_lect, lect ; /* pour mesurer le temps de lecture */
E 7
I 5
  long start_sun, end_sun; /* pour mesurer le temps d'execution du
			      process de lecture SUN */
E 5
  
  if ( ((sem_go_lect = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL) ||\
       (( sem_lect_ok = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL) ||\
       (( sem_timout_enrg = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL))\
     return (ERR_SEM);
  
  /* DEBUT DE LA GRANDE BOUCLE SANS FIN */
D 4
  num_buf = 0;
E 4
I 4
  num_buf_vme = 0;
I 5
  flag_debug_lect = 0;
E 5
E 4
  while(1)
    {
I 5
      flag_lect = FLAG_OFF;
E 5
      /* Calcul des pointeurs sur les NB_MAX_EMPL zones de stockage */
      calcul_adr_zone( pt_zone_data,Pt_data , Pt_ctrl );
I 5
      if ( flag_debug_lect)
	printErr("\nAttente nouvelle lecture");
E 5
      
D 4
      semTake( sem_lect_ok , NO_WAIT ); /* On vide le semaphore */
E 4
      semTake(sem_go_lect,WAIT_FOREVER); /* blocage sur l'autorisation de lecture*/
I 4
      semTake( sem_lect_ok , NO_WAIT ); /* On vide le semaphore */
I 5
      flag_lect = FLAG_ON;

      if ( flag_debug_lect)
	printErr("\nStart lecture");
E 5
      reset_cam(); /*reset des cartes buffers */
      err_lect = FLAG_OFF; /* raz du flag */
E 4

      /* Si on est en mode reglage avec les cameras Soleil Entier, on ne lit 
	 pas apres le premier fin de numerisation mais apres le deuxieme 
	 c'est comme ca */
      if ( (Pt_acq->modob == MODE_REGL_SE) && (reglage_se != 2) ) continue;
      /* 
       * 	Test de disponibilite memoire
       */
      if ( test_lect == FLAG_OFF ) 
	{
	  /* test de disponibilite des tampons */
D 4
	  zone_active = zone_libre( Pt_ctrl,num_buf );
E 4
I 4
	  zone_active = zone_libre( Pt_ctrl,num_buf_vme );
E 4
	  if (zone_active == ERR_MEM)
	    {
I 4
	      err_lect = FLAG_OFF;
E 4
	      logMsg("Buffers data non libres ?\n",0,0,0,0,0,0);
	      continue;		/* Dans ce cas c'est pas la peine de lire */
	    }
	  else pt_buffer = pt_zone_data[ zone_active ] ; /* on pointe au debut de la\
							    zone memoire disponible */
        
	}
      else pt_buffer = pt_zone_data[0] ; /* si test_lect est positionne a 1
					    on ecrit systematiquement dans 
					    le premier tampon */
      
D 4
      /* LA LECTURE */
E 4
I 4
      /*------------------------------LA LECTURE-------------------------*/
E 4
      intf_wr_rctrl( DAM ,BUSY ); /* on prend le controle des buffers */
I 5
      if ( flag_debug_lect)
	printErr("\nOccupation buffers (DAM=1)");
E 5
      pt_fenetre=pt_buffer;
      /* on mesure l'instant de demarrage de la lecture */
      wr_tab_perf( cpt_start_acq , 4 , start_lect = lect_mcchip_timer() );
I 4
D 7

E 7
I 7
      nbvaleur = 0.0;
E 7
E 4
      for(i = 0 ; i < Pt_acq->nbfen ; i++) 
	{
D 7
	  nbvaleur = Pt_acq->tab_fen[i].nblig * Pt_acq->tab_fen[i].nbcol;
E 7
I 7
	  if ( Pt_acq->tab_info_fen[i].nobuf  == -1 )
	    {
	      printErr("\nDefaut d'initialisation de la fenetre no:%2d",i);
	      printErr("\nVerifier votre paracq.don !!!!!!!!!\n");
	      break; /* on arrete le processus de lecture */
	    }

	  nbvaleur  += (double)(Pt_acq->tab_fen[i].nblig * Pt_acq->tab_fen[i].nbcol);
E 7
	  /* l'offset de debut de la fenetre est determine par le 
	     programme SUN */
	  if ( test_lect == FLAG_OFF )
	    pt_fenetre=pt_buffer+(Pt_acq->tab_info_fen)[i].mem_offset/2;
	  else 
	    pt_fenetre = pt_buffer;

	  if (dma)
            code=lect_buf(&Pt_acq->tab_fen[i], &Pt_acq->tab_info_fen[i],\
			  pt_fenetre);
	  else        
            code=lect_buf_no_dma(&Pt_acq->tab_fen[i], &Pt_acq->tab_info_fen[i],\
				 pt_fenetre);

	  if (code == ERROR)
	    { 
	      logMsg("\n Erreur sur lecture DMA: code 0x%x\n",errnoGet(),0,0,0,0,0 );
I 7
	      printErr("\nFenetre no:%2d  Buffer no:%2d",\
		       i, Pt_acq->tab_info_fen[i].nobuf );
	      printErr(" Adresse VME no: %lu ( %X )\n",\
		       pt_fenetre, pt_fenetre );
	      break; /* vaut mieux sortir */
E 7
	    }
	  
D 4
	}
E 4
I 4
	} /* fin de la boucle for */

E 4
      /* on repere la fin de lecture */
      wr_tab_perf( cpt_start_acq,5,end_lect=lect_mcchip_timer());
D 5
      printErr("\nDuree de lecture: %d microsecondes\n",\
	       end_lect-start_lect);
E 5
I 5
D 7
      printErr("\nDuree de lecture DMA: %d millisecondes\n",\
	       (end_lect-start_lect) /1000 );
E 7
I 7

      /* lect exprime en millisecondes */
      lect = (end_lect - start_lect + 500)/1000 ;
      printErr("\nDuree de lecture DMA: %d millisecondes ( %2.2f Mo/s )\n",\
	       lect, nbvaleur*2./lect/1000 );
E 7
E 5
      intf_wr_rctrl( DAM , NOT_BUSY ); /* on rend les buffers */
D 5
      
E 5
I 5
      if ( flag_debug_lect)
	printErr("\nLiberation buffers (DAM=0)");

E 5
      /* positionnement du flag "lecture terminee" */

      if ( test_lect == FLAG_OFF ) 
	{
	  
	  lock_zone( Pt_ctrl , zone_active , SUN_NOT_BUSY );
I 5
	  if ( flag_debug_lect)
	    printErr("\nPositionnement flag SUN_NOT_BUSY ( Ok pour la SUN)");
E 5
	  
	  if (attente_enrg)
	    {
	      start_enrg = tickGet();
I 5
	      start_sun = lect_mcchip_timer();
E 5
	      /* attente de fin d'enregistrement avec un chien 
D 6
	       de garde de 5 secondes */
E 6
I 6
	       de garde de 10 secondes */
E 6
	      /* On vide le semaphore de timout sur enregistrement */
	      semTake( sem_timout_enrg , NO_WAIT );
	      while ( Pt_ctrl->verrou[zone_active] != VME_NOT_BUSY )
		{
D 5
		  if (tickGet() >= start_enrg + 5*sysClkRateGet())
E 5
I 5
		  if (tickGet() >= start_enrg + TIMOUT_ENRG_SUN )
E 5
		    {
		      logMsg("\n Erreur de timout sur enregistrement\n"\
			     ,0,0,0,0,0,0);
I 4
		      err_lect = FLAG_ON ;
E 4
		      semGive( sem_timout_enrg );
		      break;
		    }
		}
	      /* on mesure l'instant de fin de l'enregistrement */
	      wr_tab_perf( cpt_start_acq ,6, lect_mcchip_timer() );
I 5
	      if ( flag_debug_lect)
		{
		  end_sun = lect_mcchip_timer() - start_sun ;
		  end_sun = (end_sun + 500)/1000; /* en millisecondes */
		  printErr("\nEnregistrement termine. Duree= %d millisecondes", end_sun);
		}
E 5
	    }
	  /* Positionnement sur le prochain buffer a remplir */
D 4
	  num_buf +=1;
	  if( num_buf == Pt_ctrl->nb_empl) num_buf = 0;
E 4
I 4
	  num_buf_vme +=1;
	  if( num_buf_vme == Pt_ctrl->nb_empl) num_buf_vme = 0;
E 4
	}
D 6
      cpt_start_acq += 1;
E 6
D 4
      semGive( sem_lect_ok);	/* liberation du semaphore lecture terminee */
E 4
I 4
      if (err_lect == FLAG_OFF)
	semGive( sem_lect_ok);	/* liberation du semaphore lecture terminee */
I 5
      flag_lect = FLAG_OFF ;
      if ( flag_debug_lect)
	printErr("\nFin de lecture");
E 5
E 4
      
D 4
    }
E 4
I 4
    }/* fin de la boucle while(1) */
E 4
}



/*++********************************************************************
------------------
ENTETE DE FONCTION	:	calcul_adr_zone
------------------

-Role:
Calcul des adresses des NB_MAX_EMPL buffers de donnees definis en memoire commune.
-inclure:
-Prototype:
	void calcul_adr_zone( Datum **pt_zone,Datum *pt,Tb_ctrl *pt_ctrl)
-Parametres:	
		pt_zone : pointeur sur l'adresse du 1er buffer reserve
		pt: pointeur sur la zone commune reservee
		pt_ctrl: pointeur sur la structure partage memoire
-Variables globales utilisees
	Internes au fichier:
	Importees:

-Retour:
-Description:
-Constantes utilisees
	Internes au fichier:
	Importees:
	
-Fonctions utilisees
	Internes au fichier:
	Importees:

-Exemple:
-Commentaires:
********************************************************************--*/


void calcul_adr_zone( Datum **pt_zone , Datum *pt , Tb_ctrl *pt_ctrl )
{
  int i;
  long taille_zone = pt_ctrl->taille_empl;
  for( i = 0 ; i < pt_ctrl->nb_empl ; i++ ) pt_zone[i] = pt + i * taille_zone ;
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	zone_libre
------------------

-Role: 
retourne la  zone de donnees en memoire commune qui est non occupee par la SUN
-inclure:
-Prototype:
	int zone_libre( Tb_ctrl *pt_ctrl , int base)
-Parametres:	
	pt_ctrl: pointeur sur la table de partage memoire
	base = numero de la zone de donnees que l'on veut tester
-Variables globales utilisees
	Internes au fichier:
	Importees:

-Retour: l'indice de la zone libre ou ERR_MEM
-Description:
-Constantes utilisees
	Internes au fichier:
	Importees:	
			VME_NOT_BUSY (acq.h)
	
-Fonctions utilisees
	Internes au fichier:
	Importees:

-Exemple:
-Commentaires:
********************************************************************--*/

int zone_libre( Tb_ctrl *pt_ctrl ,int base )
{
  if ( pt_ctrl->verrou[base] == VME_NOT_BUSY ) return ( base );
  else return ( ERR_MEM);
}

int zone_libre_vis( Tb_ctrl *pt_ctrl ,int base )
{
  if ( pt_ctrl->vervis[base] == VME_NOT_BUSY ) return ( base );
  else return ( ERR_MEM);
}



/*++********************************************************************
------------------
ENTETE DE FONCTION	:	lock_zone
------------------

-Role: positionne un verrou dans la structure partage memoire	
-inclure:
-Prototype:
	void lock_zone( Tb_ctrl *pt_ctrl , int zone , int lock )
-Parametres:	
	pt_ctrl:pointeur sur la structure de controle du partage memoire
	zone:	indice de la zone a verrouiller
	lock:	valeur du verrou
			VME_NOT_BUSY : la memoire est disponible pour le VME
			SUN_NOT_BUSY: la memoire est disponible pour la SUN
			Ces constantes sont definies dans acq.h
-Variables globales utilisees
	Internes au fichier:
	Importees:

-Retour:
-Description:
-Constantes utilisees
	Internes au fichier:
	Importees:
	
-Fonctions utilisees
	Internes au fichier:
	Importees:

-Exemple:
-Commentaires:
********************************************************************--*/
void lock_zone (Tb_ctrl *pt_ctrl,int zone,int lock)
{
   pt_ctrl->verrou[ zone ] = lock ;
   pt_ctrl->vervis[ zone ] = lock ;
	
}
I 5

void debug_lect( int flag )
{
  flag_debug_lect = flag;
}
E 5
 







E 1
