h02836
s 00005/00004/00093
d D 1.3 98/08/26 15:49:05 tof 4 3
c copie dr /the/soft/bibli/acq/vme/interface ici ...
e
s 00000/00000/00097
d D 1.2 98/08/26 12:57:41 tof 3 1
c rien.
e
s 00000/00000/00000
d R 1.2 98/08/26 11:50:13 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 vme/interface/init_cam.c
e
s 00097/00000/00000
d D 1.1 98/08/26 11:50:12 tof 1 0
c date and time created 98/08/26 11:50:12 by tof
e
u
U
f e 0
t
T
I 1
D 4
static char *SccsId="%W% %G%";
E 4
I 4
static char *SccsId="@(#)init_cam.c	1.1 07/24/98";
E 4
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:	INIT_CAM
-----------------
-Auteur(s):	D.ZIEGLER
-Rle:	Initialisation d'une camra et buffers associs.
	
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
				init_cam
	 
-Commentaires:

********************************************************************;-*/

#include <intf.h>
I 4
#include <stdio.h>
E 4

/*
 *			FONCTIONS INTERNES
 */
int init_cam( Byte cam_num );

/*
 *			FONCTIONS EXTERNES
 */
D 4
extern init_buf();	/*buffers.c */
extern detect_cam();	/*buffers.c */
E 4
I 4
extern init_buf();	/*buf_v3.c */
extern detect_cam();	/*buf_v3.c */
E 4

/*++********************************************************************
------------------
ENTETE DE FONCTION	:	INIT_CAM
------------------

-Rle:	initialisation d'une camra et buffers associs
-inclure:
-Prototype:
	int init_cam( Byte cam_num )
-Paramtres:	
	cam_num: numro de la camra  initialiser
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour: OK ou ERROR	ERR_NO_BUF ( absence carte buffer)
			ERR_RCPT ( erreur reception camra )
-Description:	
		Initialisation du plan obscurit  0 (OBSC_DEFAUT)
		Initialisation du plan correctif  4096 (FLAT_DEFAUT)
		RAZ de la camra 
-Constantes utilises
	Internes au fichier:
	Importes:	
			OBSC_DEFAUT	(intf.h)
			FLAT_DEFAUT	(intf.h)
	
-Fonctions utilises
	Internes au fichier:
	Importes:	
			init_buf	

-Exemple:
-Commentaires:
********************************************************************--*/

int init_cam( Byte cam_num )
{ 
  int flag ;
  
  if ( raz_cam() == ERROR ) return ( ERROR );
  flag = detect_cam( cam_num );
  if ( flag == ERR_NO_BUF ) return ( ERR_NO_BUF );
  if ( init_buf( cam_num , PLAN_OBSC, OBSC_DEFAUT ) != OK ) return (ERROR);
  if ( init_buf( cam_num , PLAN_CORR, FLAT_DEFAUT ) != OK ) return (ERROR); 
  if ( flag == ERR_RCPT ) return ( ERR_RCPT );
   return( OK );
}

int tout_init_cam( void )
{
  int i,code;
D 4
  for ( i=0 ; i<32 ; i++ )
E 4
I 4
  for ( i=1; i<NB_MAX_CAM ; i++ )
E 4
    {
      code = init_cam(i);
      if ( code == ERR_NO_BUF )
	printf("Carte buffer N:%d non detectee\n",i);
      else
	printf("Carte buffer N:%d OK\n",i);
    }
  return( OK );
}
E 1
