h48743
s 00029/00001/00697
d D 1.7 99/03/31 11:09:52 lezieg 8 7
c Ajout de fonctions de "monitoring" pour le mouchard
e
s 00007/00004/00691
d D 1.6 99/02/05 12:59:55 chris 7 6
c Ajout des fonctions de tests du VME, fichier vme_spy et corrections de qq bugs
e
s 00079/00011/00616
d D 1.5 99/02/04 12:42:32 chris 6 5
c avant la correction des bugs sur les flags
e
s 00014/00003/00613
d D 1.4 98/10/16 18:12:40 lezieg 5 4
c revalidation de la fermeture des obturateurs utlises avant chaque acquisition
e
s 00036/00024/00580
d D 1.3 98/08/26 15:49:03 tof 4 3
c copie dr /the/soft/bibli/acq/vme/interface ici ...
e
s 00000/00000/00604
d D 1.2 98/08/26 12:57:39 tof 3 1
c rien.
e
s 00000/00000/00000
d R 1.2 98/08/26 11:50:12 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 vme/interface/gen_intg_v3.c
e
s 00604/00000/00000
d D 1.1 98/08/26 11:50:11 tof 1 0
c date and time created 98/08/26 11:50:11 by tof
e
u
U
f e 0
t
T
I 1
D 4

E 4
I 4
D 6
static char *SccsId="@(#)gen_intg_v3.c	1.1 07/24/98";
E 6
I 6
static char *SccsId=" %w% %g%";
E 6
E 4
/*;+********************************************************************
-----------------
D 4
ENTETE DE FICHIER       :       GEN_INTG_V3_1b.C
E 4
I 4
ENTETE DE FICHIER       :       GEN_INTG_V3.C
E 4
-----------------
-Auteur(s):Denis Ziegler
-Role: Taches generateur d'integrations en mode CCD ou SOLEIL ENTIER
-Constantes
	Internes au fichier: 
		RESOLUTION RATE
				
		
-Variables
	Internes au fichier: 
			test, mode, cadac
		
-Fonctions:
	Internes au fichier:
			switch_mode
			gen_intg
			intg_se
			convert_cad
			prepare_intgs
			mode_soleil_entier
			mode_ccd

	 
-Commentaires: Version 3 du generateur d'integration, utilisation du
               cadenceur hardware.

********************************************************************;-*/

D 4
/*
E 4
I 4
/*---------------------------HISTORIQUE------------------------------
I 8
   11 Mars 1999 dz
   ajout des fonctions ecrites dans test_perf.c pour monitorer les
   durees de numerisation et d'integration
   
E 8
I 6
   29 Janvier 99 dz
   Incorporation des fonctions d'ecriture dans le mouchard
   et tests un peu plus approfondis lors des erreurs sur timout
   
E 6
I 5
   16 Octobre 98 dz
  
   Dans la fonction prepare_intg():
   S'ils ne le sont pas deja, on ferme les obturateurs utilises avant
   de lancer une acquisition. Dans ce cas, on attend 1/2 seconde avant de
   lancer l'integration.

E 5
   20 Juillet 98 dz
   Dans prepare_intgs(), la fermeture des obturateurs utilises est
   desactivee pour l'instant.

   17 juilet 98 dz
   les semaphores sem_fin_num et sem_fin_intg sont vides avant chaque
   start.

E 4
   8 Juin 98 dz
   les obturateurs utilises sont fermes avant chaque start_acq 

   14/01/97 dz
   ajout des fonctions de validation/inhibition des interruptions
   de la carte IP dans les fonctions passage de modes 
   mode_soleil_entier et mode_ccd

   17.12.96 dz
   on fait des mesures de temps avec la fonction wr_tab_perf
   Voir test_perf.c
   
   */


#include <vxWorks.h>
#include <stdio.h>
#include <semLib.h>
#include <taskLib.h>
#include <tickLib.h>
#include <usrLib.h>
#include <acq.h>
#include <intf.h>

/*
 *                      CONSTANTES INTERNES
 */


#define RESOLUTION 1000 /* la cadence est exprimee en millisecondes */

/*                      
 *                      FONCTIONS INTERNES
 */
long convert_cad(long cadac);
int prepare_intgs(void);
void mode_soleil_entier( void );
void mode_ccd( void );

/*
 *                      FONCTIONS EXTERNES
 */
extern init_tb_ctrl();		/* init_tab.c */
extern sysClkRateGet();
extern sysClkRateSet();
D 4
extern write_rs232(); /* rs232_v3_1.c */
extern wr_tab_perf(); /* test_perf.c */
extern read_time(); /* timekeeper.c */
E 4
I 4
extern write_rs232();           /* rs232_v3.c */
extern wr_tab_perf();           /* test_perf.c */
extern read_time();             /* timekeeper.c */
I 6
extern spy_context();           /* spy_vme.c */
extern spy_error();             /* spy_vme.c */
I 8
extern init_tab_num();          /* test_perf.c */
extern init_tab_intg();         /* test_perf.c */
extern wr_tab_num();            /* test_perf.c */
extern wr_tab_intg();           /* test_perf.c */
E 8
E 6
E 4
/*
 *                      VARIABLES GLOBALES EXTERNES
 */

extern Tb_ctrl_cam *Pt_cam; /* Pointeur sur table de controle des cameras*/
extern Tb_acq *Pt_acq; /* pointeur sur table d'acquisition */
extern Tb_ctrl *Pt_ctrl; /* pointeur sur table de controle */
D 4
extern SEM_ID sem_fin_num; /* ipg_ccd.c */
extern SEM_ID sem_fin_intg; /* ipg_ccd.c */
E 4
I 4
extern SEM_ID sem_fin_num;       /* ipg_ccd_v3.c */
extern SEM_ID sem_fin_intg;      /* ipg_ccd_v3.c */
E 4

D 4
extern int cpt_start_acq; /* test_perf.c */
E 4
I 4
extern int cpt_start_acq;        /* test_perf.c */
E 4

/*---------------------VARIABLES GLOBALES---------------------------*/

SEM_ID sem_start_acq;/* semaphore de lancement d'acquisition*/
SEM_ID sem_start_se;/* semaphore de lancement soleil entier*/
SEM_ID sem_start_intg; /* semaphore start integration sur cameras CCD */
SEM_ID sem_stop_acq; /* semaphore stop acquisition*/
SEM_ID sem_start_ok; /* semaphore de retour . Indique que le start\
                        a ete correctement lancee. */
SEM_ID sem_reglage_se; /* Pour utiliser les cameras Soleil Entier comme des\
                          cameras classiques  */

D 4
SEM_ID sem_intg_ok; /* indique que l'integration s'est bien terminee
E 4
I 4
SEM_ID sem_wacq_ok; /* indique que l'integration s'est bien terminee
E 4
		       le semaphore est utilisee par la fonction wacq()
D 4
		       dans rs232_v3_1.c ( lancement d'une integration par
E 4
I 4
		       dans rs232_v3.c ( lancement d'une integration par
E 4
		       l'UCCI */
SEM_ID sem_intg_error; /* erreur de timout sur l'integration
			  utilise par wacq() */
I 4
SEM_ID sem_num_error; /* erreur de timout sur l'integration
			  utilise par wacq() */
E 4


int mode_manuel; /* Variable pour tests */

int test_intg; /* Si test_intg =1,  les valeurs eventuellement\
             prises en memoire commune sont inutilisees et remplacees par\
             des variables utilisables en interactif sous le shell VxWorks */

int mode,cadac; /*Pour test mode et cadac sont places globales \
                  pour pouvoir les changer en interactif sous VxWorks */

int lect_ccd; /* si le mode d'acquisition est positionne sur CCD lect_ccd = 1\
		cette variable est utilisee pour valider ou non la tache de \
		lecture en mode CCD */


int reglage_se; /* utilise pour ne pas prendre le premier fin de numerisation\
                   en mode reglage des cameras Soleil Entier */

I 6
static int cpt_acq; /* compteur d'acquisition */

E 6
/*++********************************************************************
------------------
ENTETE DE FONCTION	:	switch_mode	
------------------

-Role:	preparation et initialisation des tableaux memoire selon le mode
	d'observation.
	Initialisation hardware des timers et registres de l'interface selon
	les recepteurs utlises ( CCDs ou cameras RETICON soleil entier) 
	
-inclure:
-Prototype:
	int (void)
-Parametres:
-Variables globales utilisees
	Internes au fichier:
	Importees:

-Retour: OK ou ERR_SEM 
-Description:	
Creation de tous les semaphores utilises pour les taches d'integration et initialisation de la tache integration "CCD" ou "SOLEIL_ENTIER" suivant le mode de fonctionnement.
-Constantes utilisees
	Internes au fichier:
	Importees:
			MODE_SOL ( th_form.h)
			MODE_REGL_SE ( th_form.h )
	
-Fonctions utilisees
	Internes au fichier:
	Importees:
			charge_tb_obt
			deselect_tb_obt

-Exemple:
-Commentaires:
********************************************************************--*/

int switch_mode(void)
{
  long taille_buf;
  int nb_buf;
 /* 
  * creation et initialisation des semaphores lies a l'integration
  */
 if (((sem_start_intg = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL) ||\
     ((sem_stop_acq= semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL) ||\
     ((sem_start_acq = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL ) ||\
     ((sem_start_se = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL ) ||\
     ((sem_reglage_se = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL ) ||\
D 4
     ((sem_intg_ok = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL ) ||\
E 4
I 4
     ((sem_wacq_ok = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL ) ||\
E 4
     ((sem_intg_error = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL ) ||\
I 4
     ((sem_num_error = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL ) ||\
E 4
     ((sem_start_ok = semBCreate(SEM_Q_PRIORITY, SEM_EMPTY)) == NULL ) )
   return (ERR_SEM);


 while(1)
 {
    semTake( sem_start_acq , WAIT_FOREVER ); /* Blocage sur start acq */
D 5

E 5
I 5
	
E 5
D 6
    start_mcchip_timer(0);/* mise a zero du comteur de temps */
E 6
I 6
    start_mcchip_timer(0);/* mise a zero du compteur de temps */
E 6

    /* Si on utilise les cameras RETICON ( Soleil Entier ) */

    if ( (Pt_acq->modob == MODE_SOL) || (Pt_acq->modob == MODE_REGL_SE) ) 
    {
      mode_soleil_entier();
      if ( Pt_acq->modob == MODE_SOL ) /* Init de la memoire pour le mode\
					  Soleil Entier */
      {
         taille_buf = Pt_acq->nbfen * Pt_acq->npix;
         nb_buf = Pt_ctrl->nb_empl;
         init_tb_ctrl(Pt_ctrl, taille_buf , nb_buf);
         lect_ccd = 0 ; 
         semGive( sem_start_se );
      }
      else /* En mode reglage les cameras Soleil Entier sont vues comme des
              cameras THEMIS classiques */
      {
         lect_ccd = 1;
         semGive( sem_reglage_se );
      }
    }
    else  /* On utilise les cameras CCDs THEMIS */
    {
      mode_ccd();
      lect_ccd = 1 ;
      /* C'est parti pour les mesures de temps */
      wr_tab_perf( cpt_start_acq , 0 , lect_mcchip_timer() );
      semGive( sem_start_intg );
    }
 }
}



/*++********************************************************************
------------------
ENTETE DE FONCTION      :  gen_intg
------------------

-Role: generateur d'integration en mode cameras CCD
-inclure:
-Prototype:
	void gen_intg(void);
-Parametres:
-Variables globales utilisees
	Internes au fichier: 
			test_intg
			mode
			cadac
	Importees:

-Retour: que dalle
-Description:
-Constantes utilisees
	Internes au fichier:

	Importees:
			CADENCEUR 
			CONTINU	
			SIMPLE
-Fonctions utilisees
	Internes au fichier:
	Importees: 

-Exemple:
-Commentaires:
********************************************************************--*/

void gen_intg(void)
{
  long cadence,mode_acq;
  int forever,nb_acq, code_err;
I 6
  Byte  flag; /* infos  du registre d'etat de l'interface */
I 8
  u32 start, end ;
E 8
E 6

  /*
   * generateur d'integration.
   * 3 modes de fonctionnement possibles :
   * SIMPLE: generation d'une integration et une seule
   * CADENCEUR: generation d'integrations en cadence et arret sur demande
   * CONTINU: generation ininterrompue et arret sur demande
   */
  /* LA GRANDE BOUCLE */
  while (1)
    {
      semTake( sem_stop_acq , NO_WAIT ); /* On vide le semaphore */
I 4
      semTake(sem_start_ok, NO_WAIT ); /* Vidage de celui ci aussi */
E 4
      semTake(sem_start_intg, WAIT_FOREVER); /* blocage sur le start */
      /* on mesure l'instant de reception du semaphore */
      wr_tab_perf( cpt_start_acq , 1 , lect_mcchip_timer() );
      nb_acq = Pt_acq->nbacq;
      
      /* lecture de la cadence et du mode d'acquisition */
      cadence =(test_intg)? cadac : Pt_acq->cadac;
      mode_acq = (test_intg)? mode : Pt_acq->ctrac ;
      if ( mode_acq == SIMPLE ) nb_acq = 1;
      forever = ( nb_acq == 0 ) ? 1 : 0 ;

      /* On effectue toutes les preparations necessaires */
      if ( prepare_intgs() != OK ) 
	{
	  logMsg(" Erreur sur prepare_intg() ?????\n",0,0,0,0,0,0);
	  continue;		/* si problemes on retourne dans l'attente d'un\
				   nouveau start*/
	}
      semGive(sem_start_ok);
      
      switch ( mode_acq )
	{
	case CADENCEUR:
	  /* On vide sem_fin_num et sem_fin_intg */
	  /* au cas ou il en trainerait encore  */
	  semTake( sem_fin_intg, NO_WAIT );
	  semTake( sem_fin_num, NO_WAIT );
	  start_hard_cad( cadence , Pt_cam->go ); /* lancement du cadenceur hard */
	  while(1)
	    {
	      code_err = semTake( sem_fin_intg , convert_cad(cadence) );
D 6
	      /* om mesure l'instant d'apparition de fin intg */
E 6
I 6
	      /* on mesure l'instant d'apparition de fin intg */
	      cpt_acq +=1 ; /* increment du compteur */
I 8
	      start = lect_mcchip_timer();
E 8
E 6
	      wr_tab_perf( cpt_start_acq , 2 , lect_mcchip_timer() );
	      if ( code_err == ERROR)
		{
D 4
		  logMsg("Mode cadenceur: Erreur de timout sur fin d'intg\n"\
E 4
I 4
D 6
		  logMsg("Mode cadenceur:timout sur fin d'intg\n"\
E 4
			 ,0,0,0,0,0,0);
E 6
I 6
		  spy_context(Pt_acq,Pt_cam, cpt_acq);
		  spy_error("Mode cadenceur: Timout sur fin d'integration\n");

		  /* on va voir l'etat des integrations */
		  intf_rd_rstat( SOM_INTG , &flag );
		  if ( flag == FLAG_ON )
		    spy_error("integration bloquee\n");
		  else
		    spy_error("Absence d'integration\n");

		  /* on va voir si la liaison fibre obturateurs est OK */
		  intf_rd_rstat( RECEPT_OBT , &flag );
D 7
		  if ( flag == FLAG_ON )
E 7
I 7
		  /* Si flag = 0 erreur */
		  if ( flag == FLAG_OFF )
E 7
		    spy_error("Erreur sur liaison fibres obturateurs\n");

E 6
		  break;	/* on sort de la boucle while */
		}

	      code_err = semTake( sem_fin_num , convert_cad(2*TPS_NUM) );
	      /* on mesure l'instant d'apparition de fin num */
I 8
	      end = lect_mcchip_timer();
	      /* on ecrit la duree de num en ms dans tab_num */
	      wr_tab_num( (u32)cpt_acq , (end - start)/1000 );
E 8
	      wr_tab_perf( cpt_start_acq ,3 , lect_mcchip_timer() );
	      if ( code_err == ERROR )
		{
D 4
		  logMsg("Mode cadenceur: Erreur de timout sur fin de numerisation\n"\
E 4
I 4
D 6
		  logMsg("Mode cadenceur:timout sur fin de numerisation\n"\
E 4
			 ,0,0,0,0,0,0);
E 6
I 6
		  spy_context(Pt_acq , Pt_cam,cpt_acq);
		  spy_error("Mode cadenceur: Timout sur fin de numerisation\n");

		  /* on va voir sur la numerisation est bloquee */
		  intf_rd_rstat( MEMOCC , &flag );
I 7
		  /* si ce flag = 0 -> blocage de num */
E 7
		  if ( flag == FLAG_OFF )
		    spy_error("numerisation bloquee\n");
		  else
		    spy_error("Absence de numerisation\n");

		  /* On va voir si on est en erreur de numerisation */
		  intf_rd_rstat( ERRNUM , &flag );
D 7
		  if ( flag == FLAG_ON )
E 7
I 7
		  /* si ce flag = 0 -> erreur de num */
		  if ( flag == FLAG_OFF )
E 7
		    spy_error("erreur de numerisation\n");
D 8

E 8
I 8
		  /* test sur INTNA : integration non autorisee */
		  intf_rd_rstat( INTNA , &flag );
		  if ( flag == FLAG_OFF )
		    spy_error("Blocage sur INTNA\n");
E 8
E 6
		  break;	/* on sort de la boucle while */
		}

	      /* on peut sortir par la, si on veut */
	      if ( semTake( sem_stop_acq , NO_WAIT ) == OK ) break;
	      if (!forever) 
		{
		  nb_acq -=1;
		  if ( nb_acq == 0 ) break;
		}
	    } /* fin de la boucle while */

	  stop_hard_cad();	/* arret du cadenceur hard */
	  break;		/* on sort du switch */

	default :		/* on est en mode CONTINU ou SIMPLE */
	  while(1) 
	    {
	      /* On vide sem_fin_num et sem_fin_intg */
	      /* au cas ou il en trainerait encore  */
	      semTake( sem_fin_intg, NO_WAIT );
	      semTake( sem_fin_num, NO_WAIT ); 
	      start_intg( Pt_cam->go );
I 8
	      start = lect_mcchip_timer();
E 8
	      code_err = semTake( sem_fin_intg , convert_cad(Pt_cam->watchdog) );
	      /* om mesure l'instant d'apparition de fin intg */
I 6
	      cpt_acq +=1 ; /* increment du compteur */
I 8
	      end = lect_mcchip_timer();
	      wr_tab_intg( (u32)cpt_acq, (end - start)/1000 );
	      start = lect_mcchip_timer();
E 8
E 6
	      wr_tab_perf( cpt_start_acq ,2 , lect_mcchip_timer() );
	      if ( code_err == ERROR)
		{
D 4
		  logMsg("Mode CCD: Erreur de timout sur fin d'intg\n"\
E 4
I 4
D 6
		  logMsg("Mode Simple: timout sur fin d'integration\n"\
E 4
			 ,0,0,0,0,0,0);
E 6
I 6
		  spy_context(Pt_acq , Pt_cam, cpt_acq);
		  spy_error("Mode simple: Timout sur fin d'integration\n");
		  
		  /* on va voir l'etat des integrations */
		  intf_rd_rstat( SOM_INTG , &flag );
		  if ( flag == FLAG_ON )
		    spy_error("integration bloquee\n");
		  else
		    spy_error("Absence d'integration\n");
		  
		  /* on va voir si la liaison fibre obturateurs est OK */
		  intf_rd_rstat( RECEPT_OBT , &flag );
D 7
		  if ( flag == FLAG_ON )
E 7
I 7
		  if ( flag == FLAG_OFF )
E 7
		    spy_error("Erreur sur liaison fibres obturateurs\n");

E 6
		  semGive( sem_intg_error ); /* pb sur integration */
		  break;	/* on sort de la boucle while */
		}
D 4
	      else semGive( sem_intg_ok ); /* integration correctement effectuee */

E 4
I 4
	      
E 4
	      code_err = semTake( sem_fin_num , convert_cad(2*TPS_NUM) );
	      /* on mesure l'instant d'apparition de fin num */
I 8
	       end = lect_mcchip_timer();
	      /* on ecrit la duree de num en ms dans tab_num */
	      wr_tab_num( (u32)cpt_acq , (end - start)/1000 );
E 8
	      wr_tab_perf( cpt_start_acq ,3 , lect_mcchip_timer() );
	      if ( code_err == ERROR )
		{
D 4
		  logMsg("Mode CCD: Erreur de timout sur fin de numerisation\n"\
E 4
I 4
D 6
		  logMsg("Mode Simple:timout sur fin de numerisation\n"\
E 4
			 ,0,0,0,0,0,0);
E 6
I 6
		  spy_context(Pt_acq , Pt_cam, cpt_acq);
		  spy_error("Mode simple: Timout sur fin de numerisation\n");

		  /* on va voir sur la numerisation est bloquee */
		  intf_rd_rstat( MEMOCC , &flag );
		  if ( flag == FLAG_OFF )
		    spy_error("numerisation bloquee\n");
		  else
		    spy_error("Absence de numerisation\n");

		  /* On va voir si on est en erreur de numerisation */
		  intf_rd_rstat( ERRNUM , &flag );
D 7
		  if ( flag == FLAG_ON )
E 7
I 7
		  if ( flag == FLAG_OFF )
E 7
		    spy_error("erreur de numerisation\n");
I 8
		  /* test sur INTNA : integration non autorisee */
		  intf_rd_rstat( INTNA , &flag );
		  if ( flag == FLAG_OFF )
		    spy_error("Blocage sur INTNA\n");

E 8
E 6
D 4

E 4
I 4
		  semGive( sem_num_error ); /* pb sur fin de num */
E 4
		  break;	/* on sort de la boucle while */
		}
I 4
	      else semGive( sem_wacq_ok ); /* integration correctement effectuee */
E 4
	      /* on peut sortir par la, si on veut */
	      if ( mode_acq == CONTINU )
		if ( semTake( sem_stop_acq , NO_WAIT ) == OK ) break;
	      if (!forever) 
		{
		  nb_acq -=1;
		  if ( nb_acq == 0 ) break; /* On sort du while */
		}
	    } /* fin de la boucle while */

	  break;
	}
    }
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	intg_se
------------------

-Role:	Pour piloter les cameras RETICON Soleil Entier comme une camera THEMIS
-inclure:
-Prototype:
	void intg_se( void )
-Parametres:
-Variables globales utilisees
	Internes au fichier:
	Importees:

-Retour:
-Description:
-Constantes utilisees
	Internes au fichier:		
	Importees:
	
-Fonctions utilisees
	Internes au fichier:
	Importees:
			start_hard_cad ( intf.c )
			stop_hard_cad  ( intf.c )

-Exemple:
-Commentaires:
********************************************************************--*/

void intg_se( void )
{
 int timout;
 while(1)
 {
   semTake( sem_reglage_se , WAIT_FOREVER );
   reglage_se = 0;
   timout = convert_cad(Pt_acq->cadac) * 2 ;
   start_hard_cad( Pt_acq->cadac * 200, 0 ); /*cadac en millis et horloge a 200kHz*/
   /* on mesure l'instant de demarrage du cadenceur */
   wr_tab_perf( cpt_start_acq , 2 , lect_mcchip_timer() );
   do
   {
     if (semTake( sem_fin_num , timout ) == ERROR)
       {
	 logMsg("Camera Soleil Entier en mode reglage\n"\
		,0,0,0,0,0,0);
	 logMsg("Erreur de timout sur fin de numerisation No:%d\n"\
		,reglage_se+1,0,0,0,0,0);
	 break;
       }
     /* on mesure l'instant d'apparition de fin num */
     wr_tab_perf( cpt_start_acq ,3 , lect_mcchip_timer() );
     reglage_se++;
   } while ( reglage_se < 2 );
   stop_hard_cad();
   semGive( sem_start_ok);
 }
}



/*++********************************************************************
------------------
ENTETE DE FONCTION      :   convert_cad
------------------

-Rle:
conversion de la valeur cadence exprime en ms dans la table d'acquisition
en nombre de ticks d'horloge.
-inclure:
-Prototype:
	long convert_cad(long cadac)
-Paramtres: 
	cadac= cadence exprime en millisecondes
-Variables globales utilises
	Internes au fichier:
	Importes: 

-Retour: cadence exprime en nombre de ticks d'horloge.
-Description:
-Constantes utilises
	Internes au fichier: 
			RESOLUTION
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/
long convert_cad(long cadac) 
{
 return (cadac*sysClkRateGet()/RESOLUTION);
}
 
 


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	prepare_intgs
------------------

-Rle: 
initialisations des timers, chien de garde et registres de lancement des intgrations. 
-inclure:
-Prototype:
	int prepare_intgs(void)
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:	
			Tb_acq *Pt_acq  Pointeur sur table d'acquisition
			Tb_ctrl_cam *Pt_cam Pointeur sur la table de contrle des camras


-Retour: OK ou ERROR
-Description:
Cette fonction initialise les registres timers de l'interface avec les valeurs de 
temps d'intgration inscrites dans la table d'acquisition.
Le chien de garde des obturateurs est calcul  partir du plus long temps 
d'intgration utilis.
Le masque des timers utiliss est calcul  partir des valeurs temps d'intgration 
de la table d'acquisition. Ex: si Pt_acq->dintg[2] = 0 alors le timer 2 ne sera 
pas utilis.

On n'en profite aussi pour verifier et eventuellement fermer les obturateurs
utilises

-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:	
			sysClkRateGet 
			ipg_wr_reg  
			intf_wr_timer	
-Exemple:
-Commentaires:	temps d'excution de la fonction = 32 microsecondes
********************************************************************--*/
I 5
static char *obturateurs =
"\nFermeture des obturateurs utilises ( tels que definis dans paracq.don )\n
Attention, ils resteront fermes en fin d'observation.\n";
E 5



int prepare_intgs(void)
{
 U16 tps_intg,status ;
 int i;
 Pt_cam->watchdog = 0 ; 
 Pt_cam->go = 0 ;

 for( i = 1 ; i < NB_MAX_OBT ; i++ )
 {
   tps_intg = Pt_acq->dintg[i] ;/* les Tps int sont exprimes\
                                              en ms dans la table */
   /* si le temps d'integration est non nul, on initialise le timer et on\
      fabrique le masque des timers */
   if (tps_intg)
   {
      if ( intf_wr_timer( i , tps_intg ) != OK ) return (ERROR);
      Pt_cam->go |= 1 << i ; /* fabrication du masque des timers */
   }
   
   /* calcul du plus long temps d'integration */
   if ( tps_intg >= Pt_cam->watchdog ) Pt_cam->watchdog = tps_intg ;
 }
D 4
 /* si les obturateurs utilises ne sont pas fermes, on les ferme */
E 4
I 4
 /*si les obturateurs utilises ne sont pas fermes, on les ferme */
D 5
 /*
E 5
I 5

E 5
E 4
 if ( ipg_rd_reg(R_OBT,&status) !=OK ) return ERROR;
D 4
 status &= 0xFE; /* le bit du volet d'obturation n'est pas significatif */
E 4
I 4
 status &= 0xFE;  
E 4
 if ( status & (U16)Pt_cam->go )
   {
D 4
     printf("\nFermeture des obturateurs utilises\n");
E 4
     force_obt( (U16)Pt_cam->go , FERME );
I 5
     puts(obturateurs);
E 5
D 4
     taskDelay(sysClkRateGet()/2); /* attente 1/2 seconde */
E 4
I 4
     taskDelay(sysClkRateGet()/2);
E 4
   }
D 4

E 4
I 4
D 5
 */
E 5
I 5

E 5
E 4
 /* Initialisation du chien de garde des obturateurs avec 1s de rab */
 Pt_cam->watchdog += 1000;                     
 if ( ipg_wr_reg( CWOUAF , Pt_cam->watchdog ) != OK ) return (ERROR);
 return (OK);
}



/*----------------------------------------------------------------------*/

void mode_ccd(void)
{
  disable_ipg_it(IT_INTG | IT_NUM); /* inhibition des its */
  ipg_wr_timer(C0 , T_1MILLI);	/* Horloge de l'interface a 1KHz */
  intf_wr_rctrl(SOL_ENTIER , 0); 
  affect_obt(CAMERA_SOLEIL_ENTIER , 0);
  raz_intf();
  raz_cam();
  charge_tb_obt(Pt_cam);	/* affectation des obturateurs aux cameras CCD*/
  enable_ipg_it(IT_INTG | IT_NUM); /* reactivation des its */
}

void mode_soleil_entier( void )
{
  disable_ipg_it(IT_INTG | IT_NUM); /* inhibition des its */
  ipg_wr_timer(C0 , T_5MICRO);	/* Horloge de l'interface a 200KHz */
  intf_wr_rctrl(SOL_ENTIER , 1 );
  affect_obt(CAMERA_SOLEIL_ENTIER , 1);
  raz_intf();
  raz_cam();
  deselect_tb_obt();		/* deselection de tous les obturateurs sur les 
				   cameras CCD*/
  enable_ipg_it(IT_INTG | IT_NUM); /* reactivation des its */
}

void go_se( void )
{
 semGive( sem_reglage_se );
}

I 6

void reset_cpt_acq( void )
{
  cpt_acq = 0 ;
}

E 6


E 1
