h07696
s 00001/00001/00425
d D 1.6 00/03/31 13:15:10 chris 7 6
c 
e
s 00049/00027/00377
d D 1.5 98/10/16 18:11:25 lezieg 6 5
c start_acq et wacq ne se lancent pas et retourne un code d'erreur
c si il n'y a pas eu de decodage auparavant ( test sur modob = -1 )
e
s 00035/00004/00369
d D 1.4 98/10/12 12:55:07 lezieg 5 4
c wacq est maintenant correctement synchronise avec les taches de lecture et d'enregistrement
c . Maintenant la fonction rend la main en fin de numerisation et attend que la lecture et/ou l'enregistrement
c soit termine pour lancer une integration.
e
s 00089/00018/00284
d D 1.3 98/08/26 15:49:00 tof 4 3
c copie dr /the/soft/bibli/acq/vme/interface ici ...
e
s 00000/00000/00302
d D 1.2 98/08/26 12:57:38 tof 3 1
c rien.
e
s 00000/00000/00000
d R 1.2 98/08/26 11:50:11 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 vme/interface/cmd_v3.c
e
s 00302/00000/00000
d D 1.1 98/08/26 11:50:10 tof 1 0
c date and time created 98/08/26 11:50:10 by tof
e
u
U
f e 0
t
T
I 1
D 4
static char *SccsId="%W% %G%";
E 4
I 4
static char *SccsId="@(#)cmd_v3.c	1.3 07/27/98";
E 4
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:	CMD_V3.C
-----------------
-Auteur(s):Denis Ziegler
-Rle:	Regroupe les fonctions de commandes de lancement, arrt des intgrations
	demande de lecture etc.....
-Constantes
	Internes au fichier:
				SECONDE
				10_SECONDES
				T_LECT
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:	
				start_acq
				wacq
				stop_acq
				start_lect
				time_lect		
	 
D 4
-Commentaires:	En cours de remplissage.
E 4
I 4
-Commentaires:	pas de commentaires
E 4

********************************************************************;-*/
I 4
/*--------------------------HISTORIQUE------------------------------*/
/*
I 6
  16 Octobre 1998 dz
  S'il n'y a pas encore eu de decodage ( modob = -1 )
  start_acq et wacq sont inoperants.

E 6
I 5
  9 Octobre 1998 dz
  Modif sur wacq();
  La lecture des buffers doit etre terminee avant d'autoriser une 
  nouvelle integration. Sinon la tache de lecture en cours se trouve
  un poil perturbee et induit des bugs sur le comportement du logiciel.
  ( bugs aleatoires qui plantent le VME et pas faciles a trouver ).
  Le choix pour cette modif est d'attendre,dans la fonction wacq(),
  la fin de lecture des fenetres.
  
E 5
  27 Juillet 1998 dz
  Correction bug  ( version 1.3 )
  On vide par securite, les semaphores sem_lect_ok et sem_timout_enrg
  dans la fonction start_acq
E 4

I 4
  25 Juillet 1998 dz
  inclusion du fichier header com_ucci_vme.h
  Modifications des codes d'erreurs de retour de la fonction wacq
  conformement aux codes definis dans le fichier header predemment
  cite. 

  21 Juin 1998 dz
  Implantation de la fonction wacq() declenchee par la chaine de
  caracteres $WACQ en provenance de la ligne RS232 ( rs232_v3.c)
  Des la disponibilite  du  buffer d'ecriture , la fonction declenche
  une acquisition et retourne OK ou diverses erreurs de timout

  */

E 4
#include <vxWorks.h>
#include <semLib.h>
#include <tickLib.h>
#include <intf.h>
I 4
#include <com_ucci_vme.h>
E 4

#define SECONDE      sysClkRateGet()
D 4
#define DIX_SECONDES  (10*SECONDE)
E 4
I 4
#define DIX_SECONDES (10*SECONDE)
D 7
#define TIMOUT_WACQ  (10*SECONDE)
E 7
I 7
#define TIMOUT_WACQ  (180*SECONDE)
E 7
E 4
#define T_LECT       100 /* resolution temps de lecture = 1/100ieme seconde */

/*
 *			FONCTIONS INTERNES
 */
int start_acq( int attente );
int wacq( void );
int stop_acq(void);
int start_lect(void);
int time_lect(long *temps_lect);

/*
 *			FONCTIONS EXTERNES
 */
extern sysClkRateGet();
extern convert_cad();
I 4
extern zone_libre();  /* defini dans lecture_v3.c */
E 4


/*
 *			VARIABLES GLOBALES
 */

extern SEM_ID sem_start_acq; /* start acquisition (gen_intg_v3.c)*/
extern SEM_ID sem_stop_acq; /* stop acquisition  (gen_intg_v3.c) */
extern SEM_ID sem_start_ok;  /* integration correctement lance (gen_intg_v3.c) */
extern SEM_ID sem_go_lect; /* start lecture buffers (lecture_v3.c) */
extern SEM_ID sem_lect_ok; /* lecture terminee (lecture_v3.c) */
extern SEM_ID sem_timout_enrg; /* timout sur enregistrement ( lecture_v3.c) */
D 4
extern SEM_ID sem_intg_ok; /* integration terminee (gen_intg_v3.c) */
E 4
I 4
extern SEM_ID sem_wacq_ok; /* integration et numerisation terminees (gen_intg_v3.c) */
E 4
extern SEM_ID sem_intg_error ; /* timout sur integration ( gen_intg_v3.c) */
I 4
extern SEM_ID sem_num_error ; /* timout sur numerisation ( gen_intg_v3.c) */
E 4

 
int attente_enrg;

D 4
extern int init_acq_ok;    /* start_v3.c */
E 4
I 4
extern int init_acq_ok;     /* start_v3.c */
E 4
extern Tb_ctrl_cam *Pt_cam; /* Pointeur sur table de controle des cameras*/
extern Tb_acq *Pt_acq;      /* Pointeur sur table des parametres d'acquisition */
I 4
extern Tb_ctrl *Pt_ctrl;    /* pointeur sur la structure partage memoire */
E 4

I 4
extern int num_buf_vme;     /* buffer disponible pour la lecture (lecture_v3.c)
			       on l'utilise dans la fonction wacq  */
E 4

I 4
extern int test_lect;       /* lecture_v3.c  */
I 5
extern int flag_lect;       /* lecture_v3.c  */
E 5


E 4
/*++********************************************************************
------------------
ENTETE DE FONCTION	:	START_ACQ
------------------

-Rle: demarrage d'une acquisition
-inclure:
-Prototype:
	int start_seq( int attente )
-Paramtres:
	attente: Si attente = 1, la fonction attend la fin de l'enregistrement pour se terminer.
-Variables globales utilises
	Internes au fichier:
	Importes:
		sem_start_ok
		sem_start_acq

-Retour:OK ou ERROR
-Description: 	
		La fonction rend disponible le semaphore sem_start_acq
		Les parametres necessaires a l'acquisition sont lus
		dans la table d'acquisition.
		La fonction retourne OK si les integrations ont demarre
		correctement
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:

-Commentaires:
********************************************************************--*/
/* 18 MAI 1995
 * modif pour Rayrole on attend la fin de l'enregistrement pour rendre 
 * la main ou non : ajout du parametre attente dans la fonction
 */
int start_acq( int attente )
{
  ULONG start_boucle;
  attente_enrg=attente; 
  /* Si init_acquisition n'est pas lance */
D 6
  if ( init_acq_ok == 0 ) return(ERROR); 
E 6
I 6
  if ( init_acq_ok == 0 )
    return(ERROR);
  /* S'il n'y a pas eu de decodage */
  if ( Pt_acq->modob == -1 )
    return(ERROR);

E 6
  if ( semGive(sem_start_acq)!= OK ) return(ERROR);
  /* attente de la reponse start_ok */
  if ( semTake(sem_start_ok , SECONDE) !=OK ) return(ERROR);
  /* attente fin de lecture et d'enregistrement */
  if ( attente )
    {
I 4
      semTake(sem_lect_ok, NO_WAIT); /* On vide les semaphores */
      semTake(sem_timout_enrg, NO_WAIT);
E 4
      start_boucle = tickGet();
      while(1)
	{
	  /* Si on est vraiment coince, on peut sortir par la */
D 4
	  if (tickGet() > start_boucle + DIX_SECONDES) return(ERROR);
	  if(semTake(sem_lect_ok,NO_WAIT)==OK) break; /*OK on sort de la boucle */
	  if(semTake(sem_timout_enrg,NO_WAIT)==OK) return (ERROR);
E 4
I 4
	  if (tickGet() > start_boucle + TIMOUT_WACQ)
	    {
	      printf("\nSTART_ACQ(1): Erreur generale de timout\n");
I 6
	      attente_enrg = 0;
E 6
	      return(ERROR);
	    }
D 6
	  if( semTake(sem_lect_ok,NO_WAIT)==OK ) return (OK); /*OK on sort de la boucle */
	  if( semTake(sem_timout_enrg,NO_WAIT)==OK ) return (ERROR);
E 6
I 6
	  if( semTake(sem_lect_ok,NO_WAIT)==OK )
	    {
	      attente_enrg = 0;
	      return (OK); /*OK on sort de la boucle */
	    }
	  if( semTake(sem_timout_enrg,NO_WAIT)==OK )
	    {
	      attente_enrg = 0;
	      return (ERROR);
	    }
E 6
E 4
	  taskDelay(1); /* on va attendre un peu */
	}
    }
  return(OK);
}

/*-----------------------------------------------------------------------------*/
/* la fonction lancee par l'ucci et qui retourne quand l'integration
D 4
 est finie ou sur l'erreur de timout
E 4
I 4
   est finie ou sur diverses erreurs de timout
E 4
 */

int wacq(void)
{
  ULONG start_boucle;
  long ctrac;
I 4
  int buffer_dispo;
I 5
D 6
  Byte flag;
E 6
I 6
  attente_enrg = 0; /* on ne doit pas se trouver dans le mode d'attente
		       de fin d'enregistrement avec wacq */

E 6
E 5
E 4
  ctrac=Pt_acq->ctrac; /* on sauvegarde le parametre actuel */
D 4
  semTake( sem_intg_ok , NO_WAIT  ); /* on vide le semaphore */
  semTake( sem_intg_error, NO_WAIT); /* on vide le semaphore */
E 4
I 4
  semTake( sem_wacq_ok , NO_WAIT  ); /* on vide les semaphore */
  semTake( sem_intg_error, NO_WAIT);
  semTake( sem_num_error, NO_WAIT);
E 4
  /* Si init_acquisition n'est pas lance */
D 4
  if ( init_acq_ok == 0 ) return(ERROR); 
E 4
I 4
  if ( init_acq_ok == 0 ) return(ERR_CMD_UCCI_1); 
I 6
  /* s'il n'y a pas eu de decodage */
  if ( Pt_acq ->modob == -1 ) return(ERR_CMD_UCCI_1);

E 6
E 4
  Pt_acq->ctrac = SIMPLE; /* wacq ne peut se faire qu'en mode coup par coup */
I 4

D 6
  /* le buffer d'ecriture doit etre disponible et on ne doit pas etre en 
D 5
   mode de test depuis le VME ( variable globale test_lect positionnee) */
E 5
I 5
     mode de test depuis le VME ( variable globale test_lect positionnee) */
                
E 6
I 6
  /* La lecture DMA doit etre terminee */

  if ( flag_lect == FLAG_ON )
    {
      start_boucle = tickGet();
      printf("\nWACQ: Attente de fin de lecture DMA\n");
      while( flag_lect == FLAG_ON )
	{
	  if ( tickGet() > start_boucle + TIMOUT_WACQ )
	    {
	      Pt_acq->ctrac = ctrac; /* on restaure le mode precedent */
	      printErr("\nWACQ: Erreur de timeout sur fin de lecture DMA\n");
	      return(ERR_CMD_UCCI_6);
	    }
	  taskDelay(1); /* on attend un peu avant de remonter tester le flag*/
	} /* fin de boucle while */
    }
      
E 6
E 5
  if ( test_lect == FLAG_OFF )
    {
I 6
      /* le prochain buffer d'ecriture doit etre disponible */

E 6
      buffer_dispo = zone_libre( Pt_ctrl , num_buf_vme );
D 5
      if ( buffer_dispo == ERR_MEM ) /* le buffer n'est pas libere */
E 5
I 5
      if ( (buffer_dispo == ERR_MEM) )
E 5
	{
	  start_boucle = tickGet();
D 5
	  printf("\nWACQ: Attente de buffer disponible\n");
E 5
I 5
	  printf("\nWACQ: Attente de disponibilite buffers\n");
E 5
D 6
	  while( buffer_dispo == ERR_MEM )
E 6
I 6
	  while( (buffer_dispo == ERR_MEM) )
E 6
	    {
	      if ( tickGet() > start_boucle + TIMOUT_WACQ )
		{
		  Pt_acq->ctrac = ctrac; /* on restaure le mode precedent */
D 5
		  printErr("\nWACQ: Erreur de timeout sur buffer disponible\n");
E 5
I 5
		  printErr("\nWACQ: Erreur de timeout sur buffers disponibles\n");
E 5
		  return(ERR_CMD_UCCI_4);
		}
D 6
	      taskDelay(1); /* on attend un peu */
E 6
I 6
	      taskDelay(1); /* on attend un peu et on reteste les flags*/
E 6
	      buffer_dispo = zone_libre( Pt_ctrl , num_buf_vme );
	    }
	}
    }
I 5

D 6
  /* la lecture DMA doit etre terminee */
  flag = flag_lect ;
  if ( flag == FLAG_ON )
    {
      start_boucle = tickGet();
      printf("\nWACQ: Attente de fin de lecture DMA\n");
      while(  flag== FLAG_ON )
	{
	  if ( tickGet() > start_boucle + TIMOUT_WACQ )
	    {
	      Pt_acq->ctrac = ctrac; /* on restaure le mode precedent */
	      printErr("\nWACQ: Erreur de timeout sur buffers disponibles\n");
	      return(ERR_CMD_UCCI_4);
	    }
	  taskDelay(1); /* on attend un peu */
	  flag = flag_lect ;
	}
    }
E 6
E 5

E 4
  if ( semGive(sem_start_acq)!= OK )
    {
      Pt_acq->ctrac = ctrac;  /* on restaure le mode precedent */
D 4
      return(ERROR);
E 4
I 4
      return(ERR_CMD_UCCI_1);
E 4
    }
I 4
  printErr("\n WACQ: Lancement de l'integration\n");
E 4
  /* attente de la reponse intg_ok ou intg_error */
  start_boucle = tickGet();
  while(1)
    {
      /* Si on est vraiment coince, on peut sortir par la */
D 4
      if (tickGet() > start_boucle + DIX_SECONDES)
E 4
I 4
      if (tickGet() > start_boucle + TIMOUT_WACQ)
E 4
	{
	  Pt_acq->ctrac = ctrac; /* on restaure le mode precedent */
D 4
	  return(ERROR);
E 4
I 4
	  printErr("\nWACQ: Erreur Generale de timeout\n");
	  return(ERR_CMD_UCCI_5);
E 4
	}
D 4
      if(semTake( sem_intg_ok , NO_WAIT)==OK) break; /* ok on sort de la boucle */
E 4
I 4
      if(semTake( sem_wacq_ok , NO_WAIT)==OK) break; /* ok on sort de la boucle */
E 4
      if(semTake( sem_intg_error , NO_WAIT) == OK)
	{
	  Pt_acq->ctrac = ctrac;  /* on restaure le mode precedent */
D 4
	  return (ERR_TIMOUT_OBT);
E 4
I 4
	  printErr("\nWACQ: Erreur timeout sur fin d'integration \n");
	  return (ERR_CMD_UCCI_2);
E 4
	}
I 4
      if( semTake(sem_num_error, NO_WAIT)==OK)
	{
	  Pt_acq->ctrac = ctrac;  /* on restaure le mode precedent */
	  printErr("\nWACQ: Erreur timeout sur fin de numerisation \n");
	  return (ERR_CMD_UCCI_3);
	}
E 4
      taskDelay(1); /* pour ne pas boucler comme une bete */
    } 
  Pt_acq->ctrac = ctrac; /* on restaure le mode precedent */
D 4
  return(OK);
E 4
I 4
  return(NO_ERR_CMD_UCCI);
E 4
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	STOP_ACQ
------------------

-Rle: stoppe une acquisition
-inclure:
-Prototype:
	int stop_acq
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:	sem_stop_acq

-Retour: OK ou ERROR
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

int stop_acq(void)
{
  if ( init_acq_ok == 0 ) return (ERROR);
  if ( semGive( sem_stop_acq) != OK ) return (ERROR);
  return OK;
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	START_LECT
------------------

-Rle:	lancer une lecture des buffers
-inclure:
-Prototype:
	int start_lect(void)
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:	sem_go_lect, sem_lect_ok

-Retour: OK ou ERROR
-Description:	La fonction retourne OK si la lecture s'est correctement
		effectuee.
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

int start_lect(void)
{
  if ( init_acq_ok == 0 ) return (ERROR);
  if ( semGive( sem_go_lect ) != OK ) return (ERROR);
  if ( semTake( sem_lect_ok , DIX_SECONDES ) != OK ) return (ERROR) ;
  return (OK) ;
}
 

/*++********************************************************************
------------------
ENTETE DE FONCTION	:	TIME_LECT
------------------

-Rle:	calcul du temps d'execution de la fonction de lecture des buffers
-inclure:
-Prototype:
	int time_lect(long *temps_lect)
-Paramtres:	temps: temps d'execution exprime en centisecondes
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour: OK ou ERROR
-Description:	
-Constantes utilises
	Internes au fichier:	T_LECT
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:	sysClkRateGet()
			tickGet()

-Exemple:
-Commentaires: Pas de commentaires 
********************************************************************--*/

int time_lect( long *temps_lect)
{
  long start, stop ;
  if ( init_acq_ok == 0 ) return (ERROR);
  if ( semGive( sem_go_lect ) != OK ) return (ERROR); /* lancement de la lecture */
  start = tickGet();
  if ( semTake( sem_lect_ok , DIX_SECONDES ) == ERROR ) return (ERROR);
  stop = tickGet();
  *temps_lect = (stop - start)*T_LECT/SECONDE; /* temps exprime en cs */
  return(OK);
}





E 1
