h20601
s 00048/00032/00332
d D 1.4 99/02/05 12:59:55 chris 5 4
c Ajout des fonctions de tests du VME, fichier vme_spy et corrections de qq bugs
e
s 00067/00006/00297
d D 1.3 98/08/26 15:48:59 tof 4 3
c copie dr /the/soft/bibli/acq/vme/interface ici ...
e
s 00000/00000/00303
d D 1.2 98/08/26 12:57:38 tof 3 1
c rien.
e
s 00000/00000/00000
d R 1.2 98/08/26 11:50:10 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 vme/interface/cam_v3.c
e
s 00303/00000/00000
d D 1.1 98/08/26 11:50:09 tof 1 0
c date and time created 98/08/26 11:50:09 by tof
e
u
U
f e 0
t
T
I 1
D 4
static char *SccsId="%W% %G%";
E 4
I 4
D 5
static char *SccsId="@(#)cam_v3.c	1.1 07/24/98";
E 5
I 5
static char *SccsId=" %w%  %g%";
E 5
E 4
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:	camera_v3.c
-----------------
-Auteur(s): Denis Ziegler
-Rle:	Fonctions d'accs aux registres des camras
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
				affect_obt
				affect_theta
				lect_stat_cam
I 4
				lect_status_camera
				rd_err_rcpt
				rd_err_num
D 5
				read_stat_cam
E 5
I 5
				rd_num_cam
E 5
E 4
				charge_tb_obt
				charge_tb_theta
				deselect_tb_obt
	 
-Commentaires:	
D 4
Toutes ces fonctions modifient le contenu du registre RADRCAM de l'interface. Elles remettent aussi  jour, eventuellement, la valeur adquate dans la structure Tb_ctrl_cam pointe par Pt_cam.
E 4
I 4
Toutes ces fonctions modifient le contenu du registre RADRCAM de l'interface.
Elles remettent aussi  jour, eventuellement, la valeur adquate dans la structure 
Tb_ctrl_cam pointe par Pt_cam.
E 4
 ********************************************************************;-*/

I 4
/*------------------------------HISTORIQUE-----------------------------
I 5
  29 Janvier 1999 dz
  ajout de la fonction rd_num_cam
  rd_num_cam( num_buf, *etat )
  lecture du numero d'identification d'une camera

E 5
  23 Juillet 1998 dz
  fonction lect_status_camera()
  La meme chose que lect_stat_cam mais sans le raz_cam, pour que ca aille 
  plus vite. 

  20 Juillet 1998 dz
  Dans la fonction affect_theta, on effectue 2 fois l'ecriture de la consigne
  dans le registre de la camera. Certaines cameras ne valident pas du premier coup
  la consigne dans le circuit DAC.

  20 Juillet 1998 dz
  deux nouvelles fonctions.
D 5
  rd_err_rcpt(num_cam, *flag) : lecture du flag d'erreur de reception sur une camera
  rd_err_num( num_cam, *flag) : lecture du flag d'erreur de numerisation sur une camera
E 5
I 5
  rd_err_rcpt(num_buf, *flag) : lecture du flag d'erreur de reception sur une camera
  rd_err_num( num_buf, *flag) : lecture du flag d'erreur de numerisation sur une camera
E 5

  */

E 4
#include <intf.h>
#include <acq.h>

extern Tb_ctrl_cam *Pt_cam; /* Pointeur sur la structure en memoire commune */


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	affect_obt
------------------

-Rle: Affectation d'un obturateur  la camra selectionne
-inclure: 
	intf.h
-Prototype:
D 5
	int affect_obt( Byte num_cam , Byte num_obt )
E 5
I 5
	int affect_obt( Byte num_buf , Byte num_obt )
E 5
-Paramtres:
D 5
	num_cam: camra selectionne ( 1  31 maxi )
E 5
I 5
	num_buf: carte buffer  selectionne ( 1  31 maxi )
E 5
	num_obt: numro de l'obturateur attribu ( 1  7 )
-Variables globales utilises
	Internes au fichier:
	Importes:
		 

-Retour: OK ou ERROR
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier: 
	Importes:
D 4
			ipg_wr_reg	(ipg_ccd.c)
			ipg_wr_data	(ipg_ccd.c)
E 4
I 4
			ipg_wr_reg	(ipg_ccd_v3.c)
			ipg_wr_data	(ipg_ccd_v3.c)
E 4

-Exemple:
-Commentaires:
********************************************************************--*/

D 5
int affect_obt( Byte num_cam , Byte num_obt )
E 5
I 5
int affect_obt( Byte num_buf , Byte num_obt )
E 5
{
D 5
 if( (num_cam > NB_MAX_CAM) || ( num_obt > NB_MAX_OBT) ) return (ERR_PARAM); 
E 5
I 5
 if( (num_buf > NB_MAX_CAM) || ( num_obt > NB_MAX_OBT) ) return (ERR_PARAM); 
E 5
 /* On pointe sur le plan 0 de la camera selectionnee) */
D 5
 if ( ipg_wr_reg(RADRCAM ,(U16)num_cam ) != OK ) return (ERROR);
E 5
I 5
 if ( ipg_wr_reg(RADRCAM ,(U16)num_buf ) != OK ) return (ERROR);
E 5
 if (ipg_wr_data(0,CAM_REG_OBT,(U16)num_obt) != OK ) return (ERROR);
D 5
 Pt_cam->tab_reg_cam[num_cam].n_obt = (long)num_obt; /* mise a jour table */
E 5
I 5
 Pt_cam->tab_reg_cam[num_buf].n_obt = (long)num_obt; /* mise a jour table */
E 5
 return (OK);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:	affect_theta
------------------

-Rle:	Modification de la consigne de temprature sur la camra selectionne
-inclure: intf.h
-Prototype:
D 5
	int affect_theta( Byte num_cam , Byte theta )
E 5
I 5
	int affect_theta( Byte num_buf , Byte theta )
E 5
-Paramtres:
D 5
		num_cam: camra selectionne (0  31 maxi)
E 5
I 5
		num_buf: carte buffer selectionne (1  31 maxi)
E 5
		theta: consigne de temprature 
-Variables globales utilises
	Internes au fichier:
	Importes:
			 Tb_ctrl_cam *Pt_cam


-Retour: OK ou ERROR
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier: 
	Importes:
D 4
			ipg_wr_reg 	(ipg_ccd.c)
			ipg_wr_data	(ipg_ccd.c)
E 4
I 4
			ipg_wr_reg 	(ipg_ccd_v3.c)
			ipg_wr_data	(ipg_ccd_v3.c)
E 4

-Exemple:
-Commentaires: 
La consigne de temprature est ici exprime sur un octet.
S'il y a conversion,elle doit tre faite avant l'appel  cette fonction.
********************************************************************--*/

D 5
int affect_theta( Byte num_cam , Byte theta )
E 5
I 5
int affect_theta( Byte num_buf , Byte theta )
E 5
{
D 5
 if( num_cam > NB_MAX_CAM ) return (ERR_PARAM);
E 5
I 5
 if( num_buf > NB_MAX_CAM ) return (ERR_PARAM);
E 5
 /* On pointe sur le plan 0 de la camera selectionnee) */
D 5
 if ( ipg_wr_reg(RADRCAM ,(U16)num_cam ) != OK ) return (ERROR);
E 5
I 5
 if ( ipg_wr_reg(RADRCAM ,(U16)num_buf ) != OK ) return (ERROR);
E 5
 if (ipg_wr_data(0,CAM_REG_THETA,(U16)theta) != OK ) return (ERROR);
I 4
 if (ipg_wr_data(0,CAM_REG_THETA,(U16)theta) != OK ) return (ERROR);
E 4
D 5
 Pt_cam->tab_reg_cam[num_cam].theta = (long)theta; /* mise a jour table */
E 5
I 5
 Pt_cam->tab_reg_cam[num_buf].theta = (long)theta; /* mise a jour table */
E 5
 return (OK);
}

int affect_tout_theta( Byte consigne )
{
  int i;
  for ( i = 1 ; i < NB_MAX_CAM ; i++ ) 
    if ( i != CAMERA_SOLEIL_ENTIER )
      if ( affect_theta( i , consigne ) != OK ) return (ERROR);
  return (OK); 
}
  

/*++********************************************************************
------------------
ENTETE DE FONCTION	:	lect_stat_cam
------------------

-Rle:	Lecture du registre d'tat de la camra selectionne
-inclure: intf.h
-Prototype:
D 5
	int lect_stat_cam( Byte num_cam , U16 *etat )
E 5
I 5
	int lect_stat_cam( Byte num_buf , U16 *etat )
E 5
-Paramtres:
D 5
		num_cam: camra selectionne (0  31 maxi)
E 5
I 5
		num_buf: carte buffer selectionne (1  31 maxi)
E 5
		etat: mot d'tat de la camra selectionne
-Variables globales utilises
	Internes au fichier:
	Importes:
			Tb_ctrl_cam *Pt_cam

-Retour: OK ou ERROR
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier: 
	Importes:
			ipg_wr_reg	(ipg_ccd.c)
			ipg_rd_data	(ipg_ccd.c)

-Exemple:
-Commentaires:
********************************************************************--*/
D 5
int lect_stat_cam( Byte num_cam , U16 *etat)
E 5
I 5
int lect_stat_cam( Byte num_buf , U16 *etat)
E 5

{ 
D 5
  if ( num_cam > NB_MAX_CAM ) return (ERR_PARAM);
E 5
I 5
  if ( num_buf > NB_MAX_CAM ) return (ERR_PARAM);
E 5
  if (raz_cam() == ERROR) return (ERROR); /* Reset sur les cameras */
  /* On pointe sur le plan 0 de la camera selectionnee) */
D 5
  if ( ipg_wr_reg(RADRCAM ,(U16)num_cam ) != OK ) return (ERROR);
E 5
I 5
  if ( ipg_wr_reg(RADRCAM ,(U16)num_buf ) != OK ) return (ERROR);
E 5
  if (ipg_rd_data(0,CAM_REG_STAT,etat) != OK ) return (ERROR);
D 5
  Pt_cam->tab_reg_cam[num_cam].etat = *etat; /* mise a jour table */
E 5
I 5
  Pt_cam->tab_reg_cam[num_buf].etat = *etat; /* mise a jour table */
E 5
  return (OK);
}

I 4
D 5
int lect_status_camera( Byte num_cam , U16 *etat )
E 5
I 5
int lect_status_camera( Byte num_buf , U16 *etat )
E 5
{ 
D 5
  if ( num_cam > NB_MAX_CAM ) return (ERR_PARAM);
E 5
I 5
  if ( num_buf > NB_MAX_CAM ) return (ERR_PARAM);
E 5
  /* On pointe sur le plan 0 de la camera selectionnee) */
D 5
  if ( ipg_wr_reg(RADRCAM ,(U16)num_cam ) != OK ) return (ERROR);
E 5
I 5
  if ( ipg_wr_reg(RADRCAM ,(U16)num_buf ) != OK ) return (ERROR);
E 5
  if (ipg_rd_data(0,CAM_REG_STAT,etat) != OK ) return (ERROR);
D 5
  Pt_cam->tab_reg_cam[num_cam].etat = *etat; /* mise a jour table */
E 5
I 5
  Pt_cam->tab_reg_cam[num_buf].etat = *etat; /* mise a jour table */
E 5
  return (OK);
}
E 4

I 4
D 5
int rd_err_rcpt( Byte num_cam, Byte *flag )
E 5
I 5
int rd_err_rcpt( Byte num_buf, Byte *flag )
E 5
{
  U16 etat;
D 5
  if ( num_cam > NB_MAX_CAM ) return(ERR_PARAM);
E 5
I 5
  if ( num_buf > NB_MAX_CAM ) return(ERR_PARAM);
E 5
  /* On pointe sur le plan 0 de la camera selectionnee) */
D 5
  if ( ipg_wr_reg(RADRCAM ,(U16)num_cam ) != OK ) return (ERROR);
E 5
I 5
  if ( ipg_wr_reg(RADRCAM ,(U16)num_buf ) != OK ) return (ERROR);
E 5
  if (ipg_rd_data(0,CAM_REG_STAT,&etat) != OK ) return (ERROR); 
  if ( etat & FLAG_RECEPT ) *flag=FLAG_ON;
  else *flag=FLAG_OFF;
  return (OK);
}

D 5
int rd_err_num( Byte num_cam , Byte *flag )
E 5
I 5
int rd_err_num( Byte num_buf , Byte *flag )
E 5
{
  U16 etat;
D 5
  if ( num_cam > NB_MAX_CAM ) return(ERR_PARAM);
E 5
I 5
  if ( num_buf > NB_MAX_CAM ) return(ERR_PARAM);
E 5
  /* On pointe sur le plan 0 de la camera selectionnee) */
D 5
  if ( ipg_wr_reg(RADRCAM ,(U16)num_cam ) != OK ) return (ERROR);
E 5
I 5
  if ( ipg_wr_reg(RADRCAM ,(U16)num_buf ) != OK ) return (ERROR);
E 5
  if (ipg_rd_data(0,CAM_REG_STAT,&etat) != OK ) return (ERROR); 
  if ( etat & FLAG_NUM ) *flag=FLAG_ON;
  else *flag=FLAG_OFF;
  return(OK);
}
I 5

int rd_num_cam( Byte num_buf , Byte *flag )
{
  U16 etat;
  if ( num_buf > NB_MAX_CAM ) return(ERR_PARAM);
  /* On pointe sur le plan 0 de la camera selectionnee) */
  if ( ipg_wr_reg(RADRCAM ,(U16)num_buf ) != OK ) return (ERROR);
  if (ipg_rd_data(0,CAM_REG_STAT,&etat) != OK ) return (ERROR); 
  *flag = (Byte)(( etat & MASQUE_CAM_NUM ) >> 2);
  return(OK);
}
E 5




E 4
/*++********************************************************************
------------------
ENTETE DE FONCTION	:	charge_tb_obt
------------------

-Rle:
Charger tous les registres d'affectation des obturateurs  partir des valeurs 
contenues dans  Tb_ctrl_cam
-inclure:	intf.h
-Prototype:
	int charge_tb_obt(Tb_ctrl_cam *pointeur)
-Paramtres:
		pointeur: pointeur sur Tb_ctrl_cam
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour: OK ou ERROR
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier: 
				affect_obt
	Importes:

-Exemple:
-Commentaires: temps d'excution  de la fonction = 350 microsecs
********************************************************************--*/

int charge_tb_obt(Tb_ctrl_cam *pointeur)
{
  int i;
  for ( i = 1 ; i < NB_MAX_CAM ; i++ ) 
    if( i != CAMERA_SOLEIL_ENTIER )
      if ( affect_obt( i , (Byte)pointeur->tab_reg_cam[i].n_obt ) != OK ) return (ERROR);
  return (OK);
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:	charge_tb_theta
------------------

-Rle: 
Charger tous les registres temprature des camras avec les valeurs contenues
dans Tb_ctrl_cam
-inclure: intf.h
-Prototype:
	int charge_tb_theta( Tb_ctrl_cam *pointeur )
-Paramtres:
		pointeur: Pointeur sur la structure Tb_ctrl_cam
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour: OK ou ERROR
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
				affect_theta
	Importes:

-Exemple:
-Commentaires: temps d'execution de la fonction  = 350 microsecs
********************************************************************--*/

int charge_tb_theta(Tb_ctrl_cam *pointeur)
{
  int i;
  for ( i = 1 ; i < NB_MAX_CAM ; i++ ) 
     if ( affect_theta( i , pointeur->tab_reg_cam[i].theta ) != OK ) return (ERROR);
  return (OK);
}
/*++********************************************************************
------------------
ENTETE DE FONCTION	:	deselect_tb_obt
------------------

-Rle: 
	Charger tous les registres d'affectations des obturateurs avec la valeur nulle
	 C'est une facon de dselecter toutes les camras CCD avant la manip SOLEIL ENTIER
-inclure: intf.h
-Prototype:
	int deselect_tb_obt( void )
-Paramtres:
		
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour: OK ou ERROR
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
				affect_obt
	Importes:

-Exemple:
-Commentaires: 
********************************************************************--*/
int deselect_tb_obt( void )
{
  int i;
  for ( i = 1 ; i < NB_MAX_CAM ; i++ ) 
    if ( i != CAMERA_SOLEIL_ENTIER )
      if ( affect_obt( i , 0 ) != OK ) return (ERROR);
  return (OK);
}






E 1
