static char *SccsId="@(#)";
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:test-lecture-pont.c
-----------------
-Auteur(s):	Christian Miguel
-Rle:		
	Les fonctions de ce fichier permettent de tester la lecture et 
	l'criture dans la mmoire Vme  travers le pont de bus.
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
 	Internes au fichier:
		prn_tbacq
		prn_tab_fen
		prn_tab_info
		prn_data
	 
-Commentaires: ********************************************************************;-*/


#include <stdio.h>

#include "acq.h"


extern Tb_point    *Pt_point;
extern Tb_acq      *Pt_acq;
extern Tb_ctrl_cam *Pt_cam;
extern Datum       *Pt_data;
extern Tb_ctrl	   *Pt_ctrl;
	

/*++********************************************************************
------------------
ENTETE DE FONCTION	:prn_tbacq
------------------

-Rle:
	Cette fonction affiche plus ou moins le contenu de la table de la 
	mmoire commune.
-inclure:
-Prototype:
	void prn_tbacq()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:
		Tb_acq	*Pt_acq (Sun-inst-pont.c) pointeur sur la table
		d'acquisition

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


void prn_tbacq()
{
	printf("\nTABLE D'ACQUISITION\n");
	
	printf("\n enfen :%ld",Pt_acq->enfen);
	printf("\n nbfen :%ld",Pt_acq->nbfen);
	printf("\n modob :%ld",Pt_acq->modob);
	printf("\n cadac :%ld",Pt_acq->cadac);
	printf("\n ctrac :%ld\n",Pt_acq->ctrac);
	printf("\n meca  :%ld",Pt_acq->meca);
	printf("\n monit :%ld\n",Pt_acq->monit);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:prn_tab_fen
------------------

-Rle:
	Affichage sommaire des donnes relatives  la dfinition des fentres.
-inclure:
-Prototype:
	void prn_tab_fen()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:
	Tb_acq *Pt_acq	(Sun-inst-pont.c) pointeur sur la table d'acquisition.
	

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		NB_MAX_FEN	(th_form.h)
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


void prn_tab_fen()
{
int i;	

	printf("\nTABLE DES COORDONNEES DES FENETRES\n");
	
	printf("\nnumero	ligdb	coldb	nblig	nbcol\n");
	
	for(i=0;i<NB_MAX_FEN;i++)
	{

	printf("\n%d",(Pt_acq->tab_fen[i]).ligdb);
	printf("	%d",Pt_acq->tab_fen[i].coldb);
	printf("	%d",Pt_acq->tab_fen[i].nblig);
	printf("	%d",Pt_acq->tab_fen[i].nbcol);
	}
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:prn_tab_info
------------------

-Rle:
	Affiche les informations relatives aux fentre comme le sens de lecture
	etc...
-inclure:
-Prototype:
	void prn_tab_info()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:
	Tb_acq	*Pt_acq		(Sun-inst-pont.c) pointeur sur la table 
	d'acquisition.

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		NB_MAX_FEN	(th_form.h)	
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


void prn_tab_info()
{
int i;
	printf("\nTABLE DES INFOS DES FENETRES\n");
	
	printf("\nsens	nocam	noplan	type	nbcol\n");
	
	for(i=0;i<NB_MAX_FEN;i++)
	{
		printf("\n%d",Pt_acq->tab_info_fen[i].sens);
		printf("	%d",Pt_acq->tab_info_fen[i].nocam);
		printf("	%d",Pt_acq->tab_info_fen[i].noplan);
		printf("	%d",Pt_acq->tab_info_fen[i].type);
	}
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:prn_data
------------------

-Rle:
	Cette fonction affiche les donnes de la mmoire commune  l'endroit
	demand.
-inclure:
-Prototype:
	int prn_data()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:
	Datum *Pt_data (Sun-inst-pont.c)  pointeur sur le tableau des pointeurs

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
	Cette fonction demande  l'utilisateur de rentrer l'indice de la 
	donne dans le tableau et l'affiche, cela jusqu' ce que l'utilisateur
	rentre la valeur -1 pour cette indice.
********************************************************************--*/


int prn_data()
{
int val;
	while(1)
	{
	printf("\n Entrer un indice entier :  ");
	scanf("%i",&val);

		switch(val)
		{
		case -1 :
			{
			return(0);
			break;
			}
		default:
			{
			printf("Valeur de Pt_data[%d] :%d",val,Pt_data[val]);
			break;
			}
		}
	}
} 
