static char *SccsId="%w% %g%";
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:Vme-alloc.c
-----------------
-Auteur(s):	Christian Miguel
-Rle:	
	Le fichier regroupe les fonctions de base de l'allocation de la mmoire
	du VME.
  
		
-Variables
	Internes au fichier:
		Tb_point 	*Pt_point;      pointe sur les tables du VME  
		Tb_acq 		*Pt_acq;       
		Tb_ctrl_cam	*Pt_cam;	
		Datum		*Pt_data;
		Tb_ctrl		*Pt_ctrl
	 	
-Fonctions:
	Internes au fichier:
		alloc_mem
		adresse_tb_point
		libere_mem
	 
-Commentaires:
	Les fonctions dfinies dans ce fichier sont regroupes dans la 
	librairie VME Vme-alloc.a dans /the/soft/lib.

	Elles sont normalement appeles par la SUN par un accs au rseau
	et sont lances dans le VME par le serveur Vme-serv.o.
	Il est possible aussi de les utiliser directement  partir d'un
	programme VME.

********************************************************************;-*/


#include 	<vxWorks.h>
#include 	<stdio.h>
#include 	<stdlib.h>
#include	<cacheLib.h>

#include 	<Vme-alloc.h>
#include 	<acq.h>
#include 	<tb_ctrl_cam.h>



Tb_point	*Pt_point=NULL;		 
Tb_acq		*Pt_acq=NULL;
Tb_ctrl_cam	*Pt_cam=NULL;
Datum		*Pt_data=NULL;
Tb_ctrl		*Pt_ctrl=NULL;


/*++********************************************************************
------------------
ENTETE DE FONCTION	:alloc_mem
------------------

-Rle:
	Cette fonction alloue dans le VME, la place mmoire utile pour les tables 
	telles que Tb_acq Tb_point etc... et pour les donnes.

-inclure:	Vme-alloc.h pour les constantes de tailles mmoire.
-Prototype:
	int alloc_mem(long taille_data)
-paramtres:
	long taille_data: la taille de l'espace mmoire  rserver pour les 
	donnes. Ce paramtre correspond au nombre de pixels maximum que l'on
	peut stocker em mmoire commune. (1 pixel = 2 octets)
	
-Variables globales utilises
	Internes au fichier:
		Tb_point 	*Pt_point 
		Tb_acq   	*Pt_acq
		Tb_ctrl_cam	*Pt_cam
		Datum		*Pt_datum
		Pt_ctrl		*Pt_ctrl

-Retour:
	le code d'erreur: 0 si tout va bien

-Constantes utilises
	Importes:
		 
	
-Commentaires: 	
********************************************************************--*/


int alloc_mem(taille_data)
int taille_data;
{
	int	data_size ;

	Pt_point=(Tb_point *) malloc(sizeof(Tb_point));

	Pt_acq=(Tb_acq *)malloc(sizeof(Tb_acq));
	Pt_cam=(Tb_ctrl_cam *)malloc(sizeof(Tb_ctrl_cam));

	/* allouer un buffer aligne et multiple de la taille d'une */
	/* ligne de cache */
	data_size = taille_data*sizeof(Datum) + _CACHE_ALIGN_SIZE ;
	data_size = (data_size / _CACHE_ALIGN_SIZE) * _CACHE_ALIGN_SIZE ;
	Pt_data=(Datum *)  memalign (_CACHE_ALIGN_SIZE, data_size) ;

/*	Ancienne version avant le DMA IP
	Pt_data=(Datum *)malloc(taille_data*sizeof(Datum));
*/
	Pt_ctrl=(Tb_ctrl *)malloc(sizeof(Tb_ctrl));

	/*en attendant d'adopter un formalisme de retour d'erreur*/

	if((Pt_point==NULL)||(Pt_acq==NULL)||(Pt_cam==NULL)||(Pt_data==NULL)
		||(Pt_ctrl==NULL))
	{
		printf("err alloc tables");
		return(-100);
	}

	Pt_point->pt_tab_acq=Pt_acq;
	Pt_point->pt_cam=Pt_cam;
	Pt_point->pt_data=Pt_data;
	Pt_point->pt_ctrl=Pt_ctrl;

	return(0);
}



/*++********************************************************************
------------------
ENTETE DE FONCTION	:adresse_tb_point
------------------

-Rle:	Retourne la valeur du pointeur sur la table des pointeurs qui
	donne un accs  toutes les autres tables. Cette fonction sert
	 la station SUN, cela lui permet, par un appel rseau de connatre
	l'adresse de la table des pointeurs pour faire un mapping sur la 
	mmoire VME. Cette mmoire devient apres cette opration semblable
	 une mmoire de la station SUN.

-inclure:
-Prototype:
	u_long adresse_tb_point()
 
-Variables globales utilises
	Internes au fichier:
		Tb_point *Pt_point : pointeur sur la table
	Importes:

-Retour:	le pointeur Pt_point
********************************************************************--*/

u_long adresse_tb_point()
{
	return((u_long )Pt_point);
}




/*++********************************************************************
------------------
ENTETE DE FONCTION	:libere_mem
------------------

-Rle:
	Cette fonction libre la mmoire alloue dans le VME.
-Prototype:
	int libere_mem()

-Variables globales utilises
	Internes au fichier:
		Tb_point 	*Pt_point 
		Tb_acq   	*Pt_acq
		Tb_ctrl_cam	*Pt_cam
		Datum		*Pt_datum
		Tb_ctrl		*Pt_ctrl

	Importes:

-Exemple:
-Commentaires:
	Il faut toujours librer la mmoire du VME alloue par alloc_mem
	par cette fonction avant de quitter un programme ayant les rfrences	
	de cette mmoire, sinon, on est oblig de rebooter le VME pour librer
	la mmoire...
********************************************************************--*/


int libere_mem()
{
	free(Pt_cam);
	free(Pt_acq);
	free(Pt_data);
	free(Pt_point);
	free(Pt_ctrl);
	Pt_cam=NULL;
	Pt_acq=NULL;
	Pt_data=NULL;
	Pt_point=NULL;
	Pt_ctrl=NULL;
	return(0);
}

