/*
 *	server.c
 *
 * objet : serveur de sockets pour VME
 * auteur : Jerome Minec
 * date : 18-04-2000
 *
 * 
 *
 */

/*#include <stdio.h>*/
/*#include <sys/types.h>*/
/*#include <sys/ioctl.h>*/
#include <netinet/in.h>
/*#include <fcntl.h>*/
#include "../../sun/src/sock2/comm.h"
#include "type_vme.h"

#define SERVER_WORK_PRIORITY 100 /* priorite du process fils */
#define SERVER_STACK_SIZE 10000 

/* Variables globales */

extern int init_acq_ok ; /* actif si le programme d'acquisition est lance */

static char *err_ae24 = "?ERR=1,\"\\\\AE24\"\n\r"; /* Erreur generale : init_acquisition n'est pas lancee */
static char *cmd_unknown = "?ERR=81,\"\\\\AE24\"\n\r"; /* commande inconnue */
static char *erreur_gen = "?ERR=99,\"\\\\AE24\"\n\r"; /* erreur generale */

/* Creation d'un socket */
int creersock( port, type)
int *port;
int type;
{
  int desc;
  struct sockaddr_in nom;
  int longueur = sizeof(nom);

  if ((desc = socket(AF_INET, type, 0)) == -1) {
    perror( "creation socket impossible"); exit(2);
  }

  memset( (char *) &nom,0, longueur );
  nom.sin_port = *port;
  nom.sin_addr.s_addr = INADDR_ANY;
  nom.sin_family = AF_INET;

  if ( bind( desc, (struct sockaddr *)&nom, longueur ) ) {
    perror ("nommage socket impossible"); exit(3);
  }
  if ( getsockname(desc, (struct sockaddr *)&nom, &longueur) ) {
    perror ("obtention nom socket"); exit(4);
  }
  *port = ntohs(nom.sin_port);
  return(desc);
}

service(sock, adr)
int sock;
struct sockaddr_in adr;
{
  char rep[LGREP], cmd[LGMSG], res[LGMSG] = "";
  char inetaddr[20];
  
  int n = 0, comm_finie = 0;
  u_long resul;

  /* parametres */
  int w, x, y, z, aa, bb; 
  Byte a, b;
  /*   Datum */ U16 d; 
  U16 u;
  int bool;
  u_long taille_data;
  long l, m;
  float f[13];
  char nom[100];

  inet_ntoa_b(adr.sin_addr, inetaddr);
  printf("nouvelle connection de %s:%d\n", inetaddr, adr.sin_port);

  while( ! comm_finie ) {

    res[0] = 0;
    n = getnext(sock, rep, n, cmd);

    /* accuse de reception */
    envoi(sock, ack_cmd);

    if( !strncmp(cmd, fin_comm, 1+LGCMD) ) 
      comm_finie = 1;
    /* pour le test de connexion */
    else if( !strncmp(cmd, "$INFO", 1+LGCMD) ) { }

    /* commande non reconnue */
    else strcpy(res, cmd_unknown); 
    
    if ( strlen(res) > 0 ) {
      /* envoi de la reponse a la socket */
      envoi(sock, res); 
      /* resultat a l'ecran */
      printf("resultat : %s", res);
    }
    /* fin du traitement */
    envoi(sock, fin_cmd);
  }
  printf("fin de la connection de %s:%d\n", inetaddr, adr.sin_port);
  close(sock);
  
  return;
} 

progserver()
{
  int sock_ecoute, sock_service;
  int port = PORT;
  struct sockaddr_in adr;
  int len = sizeof(adr);

  /* numero de port */
  printf("port : %d\n", port);

  /* creation de la socket d'ecoute */
  if ( (sock_ecoute = creersock( &port, SOCK_STREAM ) ) == -1 ) {
    perror ("echec creation/liaison socket\n"); exit(7);
  }

  /* creation de la file de connexions pendantes */
  if (listen(sock_ecoute, 5) < 0) {
    perror("listen"); close(sock_ecoute); exit(8); 
  }

  /* boucle infini : ecoute des demandes de sockets*/
  while(1) {
    if ((sock_service = accept(sock_ecoute, (struct sockaddr *)&adr, &len)) < 0) {
      perror("accept\n"); close(sock_ecoute); exit(9);
    };

    /* traitement de la socket */
    if (taskSpawn("tService", SERVER_WORK_PRIORITY, 0, SERVER_STACK_SIZE, service, sock_service, adr) < 0) {
      perror("taskSpawn"); close(sock_service);
    }        
  }
  close(sock_service);
}


