static char *SccsId="%w% %g%";
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:vme_fonc_trt.c
-----------------
-Auteur(s):Christian Miguel
-Rle:
Regroupe les fonctions de traitement des erreurs
-Constantes
	Internes au fichier:
		trt_err_defaut
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
	 
-Commentaires:
Pour l'instant le comportement du VME en cas d'erreur, deux cas sont a prevoir si il s'agit d'une erreur grave, on previent tout de suite la station, sinon, on met l'erreur dans l'historique et on choisit un moment pour transmettre les erreurs a la station. Si le comportement doit se compliquer (plus de deux configurations, on adoptera la structure de traitement de la station)
********************************************************************;-*/

#include 	<stdio.h>
#include	<unistd.h>
#include	<sys/types.h>
#include 	<sys/socket.h>
#include 	<netinet/in.h>

#include	<errno.h>
#include	<the_errno.h>


extern Erreur	the_errno;
extern int	the_nb_err;
extern Erreur	*historique_err;


/*++********************************************************************
------------------
ENTETE DE FONCTION	:trt_err_defaut
------------------

-Rle:
Cette fonction sert  prevenir la station suivant le type de l'erreur
-inclure:
-Prototype:
	int trt_err_defaut(erreur)
-Paramtres:
	Erreur *erreur;
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
OK ou ERROR
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
Lorsqu'une erreur est remonte de fonctions appeles aux fonctions appelantes, elle arrive  un endroit o elle ne peut plus remonter. On utilise alors une fonction de traitement.
********************************************************************--*/

int trt_err_defaut(erreur)
     Erreur *erreur;
{
  if(ERROR==add_erreur_histo(0,erreur))
    return(ERROR);

  if(erreur->code <ERR_CRIT_VME)
    {
      printf("\ndans trt_err_defaut va vider histo");
      if(ERROR==vide_histo())
	return(ERROR);
    }
  return(OK);

}
