/*;+********************************************************************
-----------------
ENTETE DE FICHIER       :  tab_ucci_vme.c     
-----------------
-Auteur(s):D.Zig
-Rle:     Definition du tableau des  commandes en provenance de l'UCCI
           Le tableau de structures contient pour chaque element:
	   -1: La chaine de caracteres a reconnaitre
	   -2: la fonction associee a executer
	   -3: le tableau de definitions des  erreurs retournees par la
               fonction.
           
-Constantes
	Internes au fichier: 
		
				
		
-Variables
	Internes au fichier: 

		
-Fonctions:
	Internes au fichier:


	 
-Commentaires:	Si ca compile et que ca marche du premier coup, 
                je suis franchement bon !!!!!!!!

********************************************************************;-*/
#include <com_ucci_vme.h>

extern int wacq(); /* definie dans cmd_v3.c */

static char *err_acqi[]=
{
  "?ERR=1,\"\\\\AE24\\ACQI()\"\n\r" /* erreur sur commande ACQI */
};

static char *err_wacq[]=
{
  "?ERR=1,\"\\\\AE24\\WACQ()\"\n\r", /* erreur sur commande WACQ 
					fonction non lancee */
  "?ERR=2,\"\\\\AE24\\WACQ()\"\n\r", /* erreur sur commande WACQ 
					timout sur fin de intg */
  "?ERR=3,\"\\\\AE24\\WACQ()\"\n\r", /* erreur sur commande WACQ 
					timout sur fin de numerisation */
  "?ERR=4,\"\\\\AE24\\WACQ()\"\n\r", /* erreur sur commande WACQ 
				       timout sur disponibilite du buffer */
  "?ERR=5,\"\\\\AE24\\WACQ()\"\n\r", /* erreur sur commande WACQ 
				       timout sur disponibilite des semaphores */
  "?ERR=6,\"\\\\AE24\\WACQ()\"\n\r" /* erreur sur commande WACQ 
				       timout sur fin de lecture */
};

static char *err_utc[]=
{
  "?ERR=1,\"\\\\AE24\\UTC()\"\n\r", /* erreur sur parametres */
  "?ERR=2,\"\\\\AE24\\UTC()\"\n\r" /* erreur sur mise a l'heure*/
};

static char *err_inde[]=
{
  "?ERR=1,\"\\\\AE24\\INDE()\"\n\r"
};

static char *err_lambda[]=
{
  "?ERR=1,\"\\\\AE24\\LAMB()\"\n\r"
};

static char *err_step[]=
{
  "?ERR=1,\"\\\\AE24\\STEP()\"\n\r"
};

static char *err_ana[]=
{
  "?ERR=1,\"\\\\AE24\\ANA()\"\n\r"
};

static char *err_ppou[]=
{
  "?ERR=1,\"\\\\AE24\\PPOU()\"\n\r"
};

static char *err_plam[]=
{
  "?ERR=1,\"\\\\AE24\\PLAM()\"\n\r"
};

/*-------------------------------------LA TABLE---------------------------------*/
Cmd_ucci_vme tab_cmd_ucci[] =

{
  {
    "$ACQI",       /* la chaine a reconnaitre */
    acqui,         /* la fonction associee */
    err_acqi       /* la table des erreurs */
  },
  { "$WACQ", wacq, err_wacq },
  { "$UTC", utc, err_utc },
  { "$INDE", inde, err_inde },
  { "$LAMB", lambda, err_lambda },
  { "$STEP", step, err_step },
  { "$IANA", ana, err_ana },
  { "$PPOU", ppou, err_ppou },
  { "$PLAM", plam, err_plam }
};

int nb_cmd_ucci_vme = sizeof(tab_cmd_ucci)/sizeof(Cmd_ucci_vme);
