/*
 *	server.c
 *
 * objet : serveur de sockets pour VME
 * auteur : Jerome Minec
 * date : 25-04-2000
 *
 * 
 *
 */

/*#include <stdio.h>*/
/*#include <sys/types.h>*/
/*#include <sys/ioctl.h>*/
#include <netinet/in.h>
/*#include <fcntl.h>*/
#include "../../sun/src/sock2/comm.h"
#include "type_vme.h"
#include "../../sun/include/com_ucci_vme.h"

#define SERVER_WORK_PRIORITY 100 /* priorite du process fils */
#define SERVER_STACK_SIZE 10000 

/* Variables globales */

extern int init_acq_ok ; /* actif si le programme d'acquisition est lance */

static char *err_ae24 = "?ERR=1,\"\\\\AE24\"\n\r"; /* init_acquisition n'est pas lancee */
static char *erreur_param = "?ERR=7,\"\\\\AE24\"\n\r"; /* mauvais parametrage */
static char *cmd_unknown = "?ERR=81,\"\\\\AE24\"\n\r"; /* commande inconnue */

/* Creation d'un socket */
int creersock( port, type)
int *port;
int type;
{
  int desc;
  struct sockaddr_in nom;
  int longueur = sizeof(nom);

  if ((desc = socket(AF_INET, type, 0)) == -1) {
    perror( "creation socket impossible"); exit(2);
  }

  memset( (char *) &nom,0, longueur );
  nom.sin_port = *port;
  nom.sin_addr.s_addr = INADDR_ANY;
  nom.sin_family = AF_INET;

  if ( bind( desc, (struct sockaddr *)&nom, longueur ) ) {
    perror ("nommage socket impossible"); exit(3);
  }
  if ( getsockname(desc, (struct sockaddr *)&nom, &longueur) ) {
    perror ("obtention nom socket"); exit(4);
  }
  *port = ntohs(nom.sin_port);
  return(desc);
}

service(sock, adr)
int sock;
struct sockaddr_in adr;
{
  char rep[LGREP] = "", cmd[LGMSG] = "", res[LGMSG] = "";
  char inetaddr[20];
  
  int n = 0;
  u_long resul;

  /* parametres */
  int w, x, y, z, aa, bb; 
  Byte a, b;
  /*   Datum */ U16 d; 
  U16 u;
  int bool;
  u_long taille_data;
  long l, m;
  float f[20];
  char nom[100];

  inet_ntoa_b(adr.sin_addr, inetaddr);
  printf("nouvelle connection de %s:%d, socket %d\n", inetaddr, adr.sin_port, sock);

  while( 1 ) {

    res[0] = 0;
    getnext(sock, rep, cmd);

    if ( ( strlen(cmd) == 0 ) || ( !strncmp(cmd, fin_comm, 1+LGCMD) ) )
      break;

    printf("commande recue : %s", cmd);

    /* accuse de reception */
    envoi(sock, ack_cmd);

    /* pour le test de connexion */
    if( !strncmp(cmd, "$INFO", 1+LGCMD) ) { }

    else if( !strncmp(cmd, "$TINC", 1+LGCMD) ) {
      if ( (resul = tout_init_cam()) != 0 )
	sprintf(res, "?ERR=%d,\"\\\\AE24\\TINC\"\n\r", resul);
    }

    /* commandes pour la Sun */
    else if( !strncmp(cmd, "$IACQ", 1+LGCMD) )
      sprintf(res, "%d%s", init_acquisition(), sep_cmd);

    else if( !strncmp(cmd, "$AMEM", 1+LGCMD) )
      sprintf(res, "%d%s", alloc_mem(&taille_data), sep_cmd);
    
    else if( !strncmp(cmd, "$ATBP", 1+LGCMD) )
      sprintf(res, "%ld%s", adresse_tb_point(), sep_cmd);
    
    else if( !strncmp(cmd, "$ATHE", 1+LGCMD) ) /* pour le VME */
      if(sscanf(&cmd[1+LGCMD], "(%d,%d", &aa, &bb) == 0) strcpy(res, erreur_param); 
      else { 
	a = aa; b = bb;
	if ( (resul = affect_theta(a, b)) != 0 )
	  sprintf(res, "?ERR=%d,\"\\\\AE24\\ATHE\"\n\r", resul);
      }
    
    else if( !strncmp(cmd, "$ICAM", 1+LGCMD) ) 
      if(sscanf(&cmd[1+LGCMD], "(%d", &aa) == 0) strcpy(res, erreur_param); 
      else { 
	a = aa;
	sprintf(res, "%d%s", init_cam(a), sep_cmd);
      }
    
    else if( !strncmp(cmd, "$TCAM", 1+LGCMD) ) {
      if (w=(test_cam2(res))==OK) 
	strcat(res, sep_cmd);
      else sprintf(res, "%d%s", w, sep_cmd);
    }
    
    /* si le prog d'acquisition n'est pas lance, ce n'est pas la peine d'aller plus loin */
    else if (init_acq_ok == 0) strcpy(res, err_ae24); 
    
    else if( !strncmp(cmd, "$LMEM", 1+LGCMD) )
      sprintf(res, "%d%s", libere_mem(), sep_cmd);
    
    else if( !strncmp(cmd, "$EACQ", 1+LGCMD) )
      sprintf(res, "%d%s", exit_acquisition(), sep_cmd);
    
    /* commandes pour la RAO */
    else if( !strncmp(cmd, "$IINI", 1+LGCMD) )
      sprintf(res, "%d%s", intf_init(), sep_cmd);
    
    else if( !strncmp(cmd, "$IWRT", 1+LGCMD) ) 
      if(sscanf(&cmd[1+LGCMD], "(%d,%hu", &aa, &u) == 0) strcpy(res, erreur_param); 
      else { 
	a = aa;
	sprintf(res, "%d%s", intf_wr_timer(a, u), sep_cmd);
      }
    
    else if( !strncmp(cmd, "$TLEC", 1+LGCMD) ) 
      sprintf(res, "%d%s", time_lect(&l), sep_cmd);
    
    else if( !strncmp(cmd, "$LOBT", 1+LGCMD) ) 
      if(sscanf(&cmd[1+LGCMD], "(%d", &aa) == 0) strcpy(res, erreur_param); 
      else { 
	a = aa;
	sprintf(res, "%d%s", lect_obt(a, &b), sep_cmd);
      }
    
    else if( !strncmp(cmd, "$COBT", 1+LGCMD) ) 
      if(sscanf(&cmd[1+LGCMD], "(%d,%d", &aa, &bb) == 0) strcpy(res, erreur_param); 
      else { 
	a = aa; b = bb;
	sprintf(res, "%d%s", cmde_obt(a, b), sep_cmd);
      }
    
    else if( !strncmp(cmd, "$AOBT", 1+LGCMD) ) 
      if(sscanf(&cmd[1+LGCMD], "(%d,%d", &aa, &bb) == 0) strcpy(res, erreur_param); 
      else { 
	a = aa; b = bb;
	sprintf(res, "%d%s", affect_obt(a, b), sep_cmd);
      }
    
    else if( !strncmp(cmd, "$LSTC", 1+LGCMD) ) 
      if(sscanf(&cmd[1+LGCMD], "(%d", &aa) == 0) strcpy(res, erreur_param); 
      else { 
	a = aa;
	sprintf(res, "%d%s", lect_stat_cam(a, &u), sep_cmd);
      }
    
    else if( !strncmp(cmd, "$TACQ", 1+LGCMD) ) 
      if(sscanf(&cmd[1+LGCMD], "(%d", &bool) == 0) strcpy(res, erreur_param); 
      else 
	sprintf(res, "%d%s", start_acq(bool), sep_cmd);
    
    else if( !strncmp(cmd, "$PACQ", 1+LGCMD) ) 
      sprintf(res, "%d%s", stop_acq(), sep_cmd);
    
    else if( !strncmp(cmd, "$SLEC", 1+LGCMD) )
      sprintf(res, "%d%s", start_lect(), sep_cmd);
    
    else if( !strncmp(cmd, "$IBUF", 1+LGCMD) ) 
      if(sscanf(&cmd[1+LGCMD], "(%d,%d,%d", &aa, &bb, &d) == 0) strcpy(res, erreur_param); 
      else { 
	a = aa; b = bb;
	sprintf(res, "%d%s", init_buf(a, b, d), sep_cmd);
      }
    
    else if( !strncmp(cmd, "$WBUF", 1+LGCMD) ) 
      if(sscanf(&cmd[1+LGCMD], "(%s,%d,%d,%d,%d,%d,%d", nom, &w, &x, &y, &z, &aa, &bb) == 0) strcpy(res, erreur_param); 
      else { 
	a = aa; b = bb;
	sprintf(res, "%d%s", wr_buf(nom, w, x, y, z, a, b), sep_cmd);
      }  
    
    /* commandes pour l'UCCI */
    else if( !strncmp(cmd, "$INDE", 1+LGCMD) ) 
      if(sscanf(&cmd[1+LGCMD], "(%ld,%ld", &l, &m) < 2) strcpy(res, erreur_param); 
      else { if ( (resul = inde(l,m)) != 0 )
	sprintf(res, "?ERR=%d,\"\\\\AE24\\INDE\"\n\r", resul); 
      }
    else if( !strncmp(cmd, "$LAMB", 1+LGCMD) ) 
      if(sscanf(&cmd[1+LGCMD], "(%ld", &l) < 1) strcpy(res, erreur_param); 
      else { if ( (resul = lambda(l)) != 0 )
	sprintf(res, "?ERR=%d,\"\\\\AE24\\LAMB\"\n\r", resul); 
      }
    else if( !strncmp(cmd, "$STEP", 1+LGCMD) ) {
      if ( (resul = step()) != 0 )
	sprintf(res, "?ERR=%d,\"\\\\AE24\\STEP\"\n\r", resul);
    }
    else if( !strncmp(cmd, "$PASX", 1+LGCMD) ) {
      if ( (resul = stepx()) != 0 )
	sprintf(res, "?ERR=%d,\"\\\\AE24\\PASX\"\n\r", resul);
    }
    else if( !strncmp(cmd, "$PASY", 1+LGCMD) ) {
      if ( (resul = stepy()) != 0 )
	sprintf(res, "?ERR=%d,\"\\\\AE24\\PASY\"\n\r", resul);
    }
    else if( !strncmp(cmd, "$ASTE", 1+LGCMD) )
      if(sscanf(&cmd[1+LGCMD], "(%ld,%ld", &l, &m) <2) strcpy(res, erreur_param);
      else {
        if ( (resul = affstep(l, m)) != 0 )
          sprintf(res, "?ERR=%d,\"\\\\AE24\\ASTE\"\n\r", resul);
      }
    else if( !strncmp(cmd, "$IANA", 1+LGCMD) ) 
      if(sscanf(&cmd[1+LGCMD], "(%ld", &l) < 1) strcpy(res, erreur_param); 
      else { if ( (resul = ana(l)) != 0 )
	sprintf(res, "?ERR=%d,\"\\\\AE24\\IANA\"\n\r", resul);
      }
    else if( !strncmp(cmd, "$PPOU", 1+LGCMD) ) {
      resul = sscanf(&cmd[1+LGCMD], "(%e %e %e %e %e %e %e %e %e %e %e %e %e %e %e %e",&f[0],&f[1],&f[2],&f[3],&f[4],&f[5],&f[6],&f[7],&f[8],&f[9],&f[10],&f[11],&f[12],&f[13],&f[14],&f[15]);
      if (resul < 16) { 
        /* strcpy(res, erreur_param); */
        sprintf(res, "%s\nNb de param lus : %d.", erreur_param, resul); 
      } 
      else { if ( (resul = ppou(f[3],f[4],f[5],f[6],f[7],f[8],f[9],f[10],f[11],f[12],f[13],f[14],f[15])) != 0 )
	sprintf(res, "?ERR=%d,\"\\\\AE24\\PPOU\"\n\r", resul);
      }
    }
    else if( !strncmp(cmd, "$PLAM", 1+LGCMD) ) 
      if(sscanf(&cmd[1+LGCMD], "(%ld,%ld", &l, &m) < 2) strcpy(res, erreur_param); 
      else { if ( (resul = plam(l,m)) != 0 )
	sprintf(res, "?ERR=%d,\"\\\\AE24\\PLAM\"\n\r", resul);
      }    
    else if( !strncmp(cmd, "$WACQ", 1+LGCMD) ) {
      if ( (resul = wacq()) != 0 )
	sprintf(res, "?ERR=%d,\"\\\\AE24\\WACQ\"\n\r", resul);
    }    
    else if( !strncmp(cmd, "$ACQI", 1+LGCMD) ) {
      if ( (resul = acqui()) != 0 )
	sprintf(res, "?ERR=%d,\"\\\\AE24\\ACQI\"\n\r", resul);
    }
    else if( !strncmp(cmd, "$DA3", LGCMD) ) {
      if(sscanf(&cmd[LGCMD], "(%e %e %e %e %e %e %e %e %e %ld %e",&f[0],&f[1],&f[2],&f[3],&f[4],&f[5],&f[6],&f[7],&f[8],&l,&f[10]) < 11) strcpy(res, erreur_param); 
      else {
	if ( (resul = da0(f[6],f[7],f[8],l,f[10])) != 0 )
		sprintf(res, "?ERR=%d,\"\\\\AE24\\DA0\"\n\r", resul);
      }
    }

    /* commande non reconnue */
    else strcpy(res, cmd_unknown); 
    
    if ( strlen(res) > 0 ) {
      /* envoi de la reponse a la socket */
      envoi(sock, res); 
      /* resultat a l'ecran */
      printf("resultat : %s", res);
    }
    /* fin du traitement */
    envoi(sock, fin_cmd);
  }
  printf("fin de la connection de %s:%d\n", inetaddr, adr.sin_port);
  close(sock);
  
  return;
} 

progserver()
{
  int sock_ecoute, sock_service;
  int port = PORT;
  struct sockaddr_in adr;
  int len = sizeof(adr);

  /* numero de port */
  printf("port : %d\n", port);

  /* creation de la socket d'ecoute */
  if ( (sock_ecoute = creersock( &port, SOCK_STREAM ) ) == -1 ) {
    perror ("echec creation/liaison socket\n"); exit(7);
  }

  /* creation de la file de connexions pendantes */
  if (listen(sock_ecoute, 5) < 0) {
    perror("listen"); close(sock_ecoute); exit(8); 
  }

  /* boucle infini : ecoute des demandes de sockets*/
  while(1) {
    if ((sock_service = accept(sock_ecoute, (struct sockaddr *)&adr, &len)) < 0) {
      perror("accept\n"); close(sock_ecoute); exit(9);
    };

    /* traitement de la socket */
    if (taskSpawn("tService", SERVER_WORK_PRIORITY, 0, SERVER_STACK_SIZE, service, sock_service, adr) < 0) {
      perror("taskSpawn"); close(sock_service);
    }        
  }
  close(sock_service);
}


