
static char *SccsId="@(#)Sun-inst-pont.c	1.4 18 Dec 1996";

/*;+********************************************************************
-----------------
HEAD OF FILE	:Sun-inst-pont_visu.c
-----------------
-Auteur(s):	Christian Miguel
-Role:
	 
-Comments:
same as Sun-inst-pont but the variables are extern here and must be
declared in the file containing the function called by IDL

********************************************************************;-*/


#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <fcntl.h>
#include <sys/mman.h>		/* pour les cstes utiles a mmap  */
#include <unistd.h>
#include <errno.h>

#include	<sun.h>
#include	<Sun-inst-pont.h>
#include 	<acq.h>
#include	<the_errno.h>



extern void 		*Pt_vme_base;

extern Tb_point	*Pt_point;
extern Tb_acq		*Pt_acq;
extern Tb_ctrl_cam	*Pt_cam;
extern Tb_ctrl		*Pt_ctrl;
extern Datum		*Pt_data;

int 		desc_pont;


extern Erreur the_errno;


/*++********************************************************************
------------------
HEAD OF FUNCTION	:open_driver_pont
------------------


********************************************************************--*/


int open_driver_pont()
{
	return(open(DRIVER_PONT,O_RDWR));

}





/*++********************************************************************
------------------
HEAD OF FUNCTION	:close_driver_pont
------------------


********************************************************************--*/


int close_driver_pont()
{
	return(close(desc_pont));
}






/*++********************************************************************
------------------
HEAD OF FUNCTION	:add_point
------------------



********************************************************************--*/


void *add_point(base,offset)
void *base;
void *offset;
{
	return((void *)((u_long)offset+(u_long)base));
}


/*++********************************************************************
------------------
HEAD OF FUNCTION	:sub_point
------------------



 ********************************************************************--*/


void *sub_point(base,offset)
void *base;
void *offset;
{
	return((void *)((u_long)base-(u_long)offset));
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:Map_Memory
------------------

-Rle:
	Cette fonction permet de voir du cot de la SUN, la mmoire du VME
	comme si celle-ci faisait partie de la mmoire de la SUN.
	mapping d'une zone mmoire passe en paramtre.

-inclure:
-Prototype:
	caddr_t Map_Memory(
			     int taille_mem,
			     int desc_pont,
			     u_long offset_port)

-Paramtres:
	taille_mem est la taille de l'espace  mapper
	desc_pont est le descripteur du driver.
	offset_port est l'adresse physique de la mmoire  mapper

-Retour:
	0 si tout va bien	
-Commentaires:
	Cette fonction ne doit pas tre appel directement par un programme.
********************************************************************--*/

   

caddr_t Map_Memory(taille_mem,desc_pont,offset_port)
int desc_pont,taille_mem;
u_long offset_port;
{
 return(  mmap(	0,
		taille_mem,
		PROT_READ|PROT_WRITE,
		MAP_SHARED,
		desc_pont,
		offset_port));     
}




 
/*++********************************************************************
------------------
ENTETE DE FONCTION	:map_mem
------------------

-Rle:
Map une partie de mmoire du VME et fait correspondre les adresses de plusieurs objets essentiels du cot SUN et VME.

-Prototype:
	int map_mem(u_long offset, int desc)
-Paramtres:
offset est l'adresse physique de la table des pointeurs dans la mmoire du VME. desc est le descripteur du driver du pont de bus.

-Variables globales utilises
	Internes au fichier:
		Pt_vme_base	@ virtuelle du debut de la zone de donnees
		Pt_point	@ virtuelle de la table des pointeurs
		Pt_acq		@ virtuelle de la table d'acquisition
		Pt_ctrl		@ virtuelle de la table de controle
		Pt_data		@ virtuelle du debut de zone de donnees
		Pt_cam		@ virtuelle de la table de ctrl des cameras
	Importes:

-Retour:OK ou ERROR et affecte  the_errno le code d'erreur correspondant

-Description:
La fonction map aussi un registre de la carte du pont qui est dans le VME afin de le programmer. Ici, on indique  la carte quelle fentre de mmoire de la station SUN, on utilise pour le mapping.
-Constantes utilises
	Internes au fichier:
	Importes:
		TAILLE_MEM_COM		(Sun-inst-pont.h)
		OFFSET_PORT_VME
	
-Fonctions utilises
	Internes au fichier:
	Importes:
		map_registres (int_reg.c)

-Exemple:
-Commentaires:
	Ne doit pas tre appel directement.
********************************************************************--*/

int map_mem(offset,desc) 
u_long offset;
int desc;
{
  caddr_t Registres;
  int	i;


	 	
  if(ERROR == map_registres())
    return(ERROR);
  

  Pt_vme_base=mmap(0,TAILLE_MEM_COM,PROT_READ|PROT_WRITE,MAP_SHARED,desc,OFFSET_PORT_VME);

 

  
        
  if((int)Pt_vme_base == MAP_FAILED)
    {
      printf("\n ERROR map memoire");
      the_errno.code=errno;
      return(ERROR);	
    }
  
 	
  Pt_point=add_point(Pt_vme_base,(void *)offset);
  printf("\n Apres l'affectation de Pt_point");
  
  Pt_acq=(Tb_acq *)add_point(Pt_point->pt_tab_acq,Pt_vme_base);
  Pt_ctrl=(Tb_ctrl *)add_point(Pt_point->pt_ctrl,Pt_vme_base);
  Pt_data=(Datum *)add_point(Pt_point->pt_data,Pt_vme_base);
  Pt_cam=(Tb_ctrl_cam *)add_point(Pt_point->pt_cam,Pt_vme_base);
  
 
  return(OK);
}

/*++********************************************************************
------------------
HEAD OF FUNCTION	:unmap_mem
------------------



********************************************************************--*/


int unmap_mem()
{
	return(munmap(Pt_vme_base,TAILLE_MEM_COM));

}

/*++********************************************************************
------------------
HEAD OF FUNCTION	:map_mem_fils
------------------


********************************************************************--*/


int map_mem_fils(ex_base,offset,desc)
u_long ex_base;
u_long offset;
int desc;
{
  u_short *Registres;
  int i;

  Pt_vme_base=mmap(0,TAILLE_MEM_COM,PROT_READ|PROT_WRITE,MAP_SHARED,desc,OFFSET_PORT_VME);

	
	
	
  if((int)Pt_vme_base == -1)
    return(ERROR); 
  
  Pt_point=add_point(Pt_vme_base,(void *)offset);
  
  Pt_acq=(Tb_acq *)add_point(Pt_point->pt_tab_acq,
			     sub_point(Pt_vme_base,(void *)ex_base));
  Pt_ctrl=(Tb_ctrl *)add_point(Pt_point->pt_ctrl,
			       sub_point(Pt_vme_base,(void *)ex_base));
  Pt_data=(Datum *)add_point(Pt_point->pt_data,
			     sub_point(Pt_vme_base,(void *)ex_base));
  Pt_cam=(Tb_ctrl_cam *)add_point(Pt_point->pt_cam,
				  sub_point(Pt_vme_base,(void *)ex_base));
  return(OK);
}





/*++********************************************************************
------------------
ENTETE DE FONCTION	:installe_pont
------------------


********************************************************************--*/

Tb_point *installe_pont(offset)
u_long offset;
{ 
	desc_pont=open_driver_pont();

	if(ERROR==desc_pont)
	{
		printf("\n Erreur ouverture");
		the_errno.code=errno;
		return(NULL);
	}
	
	if(map_mem(offset,desc_pont)==ERROR)
	{
		printf("\n Erreur map");
		return(NULL);
	}
	


/* On met les adresses SUN dans la table des pointeurs */


	Pt_point->pt_tab_acq=Pt_acq;
	Pt_point->pt_ctrl=Pt_ctrl;
	Pt_point->pt_data=Pt_data;
	Pt_point->pt_cam=Pt_cam;
 	
	return(Pt_point);
}





/*++********************************************************************
------------------
HEAD OF FUNCTION	:ferme_pont
------------------

********************************************************************--*/

int ferme_pont()
{	
int ret;
	
/* on remet les adresses VME dans la table des pointeurs */

	Pt_point->pt_tab_acq=sub_point(Pt_acq,Pt_vme_base);
	Pt_point->pt_ctrl=sub_point(Pt_ctrl,Pt_vme_base);
	Pt_point->pt_data=sub_point(Pt_data,Pt_vme_base);
	Pt_point->pt_cam=sub_point(Pt_cam,Pt_vme_base);		
	 
	if(ERROR==munmap(Pt_vme_base,TAILLE_MEM_COM))
	{
		the_errno.code=errno;
		return(ERROR);
	}
 		
 	
	close(desc_pont);
	return(OK);
		
}





