h41006
s 00000/00000/00467
d D 1.6 98/03/11 17:57:58 chris 7 6
c 
e
s 00000/00000/00467
d D 1.5 98/03/11 17:57:15 chris 6 5
c 
e
s 00000/00000/00467
d D 1.4 97/08/28 12:22:17 chris 5 4
c correction ar rv ...
e
s 00000/00000/00467
d D 1.3 97/08/27 22:43:22 chris 4 3
c fst
e
s 00003/00001/00464
d D 1.2 96/11/29 13:13:55 devel 3 1
c Introduction de SID et mise a jour du makefile
e
s 00000/00000/00000
d R 1.2 96/11/28 16:11:18 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 sun/src/util-tab/util-tab.c
e
s 00465/00000/00000
d D 1.1 96/11/28 16:11:17 devel 1 0
c date and time created 96/11/28 16:11:17 by devel
e
u
U
f e 0
t
T
I 1
D 3
static char *SccsId="%w% %g%";
E 3
I 3

static char *SccsId="%W% %G%";

E 3
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:util_tab.c
-----------------
-Auteur(s):Monique Savinelli
-Rle:
Le fichier regroupe les fonctions utiles pour la manipulation de tableaux de donnes. 

-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
		add_tab
		init_tab
		affiche_tab
		div_tab
		min_max
		in_tab
		init_tableau
		replace
	 
-Commentaires:
********************************************************************;-*/


#include 	<stdio.h>
#include 	<sys/types.h>
#include	<errno.h>

#include	<sun.h>
#include 	<the_errno.h>

extern 	Erreur	the_errno;


/*++********************************************************************
------------------
ENTETE DE FONCTION	:add_tab
------------------

-Rle:
	Cette fonction ajoute une fentre  une autre de mme taille
-inclure:
-Prototype:
	void add_tab(nblig,nbcol,fen1,fen2)
-Paramtres:
	int nblig; nombre de lignes des fentres
	int nbcol; nombre de colonnes des fentres
	u_long *fen1;
	Datum *fen2;
		pointeurs sur les fentres.
		fen2 est pass par valeur
		fen1 est pass par valeur rsultat.
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
	Ajoute pixel par pixel les fentres et met le rsultat dans fen1.
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

void add_tab(nblig,nbcol,fen1,fen2)
int nblig;
int nbcol;
u_long *fen1;
Datum  *fen2;
{
int i;
long nbval = nblig * nbcol;


	for(i = 0;i < nbval;i++)
		fen1[i] += fen2[i];

}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:init_tab
------------------

-Rle:
	Initialiser une fentre !
-inclure:
-Prototype:
	u_long *init_tab(nblig,nbcol)
-Paramtres:
	int nblig,nbcol;
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour: 
	Le pointeur sur la fentre.
	NULL en cas d'erreur.
-Description:
	effectue un malloc pour allouer le pointeur sur la fentre et met des 0
	partout dans la zone alloue.

-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

u_long *init_tab(nblig,nbcol)
int nblig,nbcol;
{
long nbval = nblig*nbcol;
u_long *fen;
int i; 

	fen = (u_long*)malloc(sizeof(u_long)*nbval);
	if(fen == NULL)
		return(NULL);

	for(i = 0; i < nbval; i++)
		fen[i] = 0;
	return(fen);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:affiche_tab
------------------

-Rle:
	Affichage d'une fentre pour tester le dveloppement des programmes.
-inclure:
-Prototype:
	void affiche_tab(fen,nblig,nbcol)
-Paramtres:
	u_long	*fen;
	int	nblig,nbcol;
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	rien du tout.
-Description:
	on fait des "print", soit de toute la fentre, soit d'une petite partie,
	car les fentres relles ne peuvent pas tre affiches (elles sont trop
	grosses). Cependant, on peut tout afficher, si on travaille sur des 
	petites fentres pour tester le programme.
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

void affiche_tab(fen,nblig,nbcol)
u_long	*fen;
int	 nblig,nbcol;
{
int icol = 10;			/*nbre de colonnes d'impression*/
int ival, i = 0;
long nbval = nblig*nbcol;

	for(ival = 0;ival < nbval; ival++)
	{ 
		if((i % icol) == 0) printf("\n");
		printf("%ld", fen[ival]);
		i++;
	}
 
}




/*++********************************************************************
------------------
ENTETE DE FONCTION	:div_tab
------------------

-Rle:
	Effectue une moyenne sur la fentre.
-inclure:
-Prototype:
	int div_tab(nblig,nbcol,nbfen,fen)
-Paramtres:
	int nblig,nbcol; dimension de la fentre.
	int nbfen:	Ce par quoi il faut diviser
	u_long	*fen;
		la fentre pass par rsultat et par valeur.
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	ERROR si problme(division par 0)
	OK sinon.
-Description:
	On divise chaque pixel par nbfen.
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
	Cette fonction sert  effectuer la moyenne. Lorsque l'on a ajout
	toutes les fentres et stock le rsultat, on divise par le nombre
	de fentres que l'on a ajout.
********************************************************************--*/

int div_tab(nblig,nbcol,nbfen,fen)
int 	nblig,nbcol;
int 	nbfen;
u_long *fen;
{
long nbval = nblig * nbcol;
int i;

	if(nbfen == 0) 
	{
		the_errno.code=EINVAL;
		return(ERROR);
	}

	for (i = 0; i < nbval; i++)
		fen[i] = fen[i] / nbfen;
	return(OK);
}
 


/*++********************************************************************
------------------
ENTETE DE FONCTION	:min_max
------------------

-Rle:
	trouve le minimum et le maximum dans un tableau
-inclure:
-Prototype:
	void min_max(Pt_tab,taille,min,max)
-Paramtres:
	Datum *Pt_tab (th_form.h) pointeur sur le tableau
	long taille    taille du tableau
	Datum min      min du tableau, passage par rsultat.
	Datum max	max du tableau, passage par rsultat. 
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

void min_max(fen2,taille,min,max)
Datum *fen2;
long taille;
Datum *min;
Datum *max;
{
long i;
	*min = fen2[0];
	*max = fen2[0];

	for(i = 0; i < taille; i++)
	{
		if(*min > fen2[i]) 
			*min = fen2[i];
		else
		{
			if(*max < fen2[i])
				*max = fen2[i];
		}
	}
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:in_tab
------------------

-Rle:
	teste si un nombre est dans un tableau.
-inclure:
-Prototype:
	int in_tab(nombre,tab,taille_tab)
-Paramtres:
	long nombre;
	long *tab; pointeur sur le tableau
	long taille_tab; taille du tableau

-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	l'indice du tableau o se trouve le nombre si le nombre est dans le
	 tableau,  0 s'il n'y est pas.
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


long in_tab(nombre,tab,taille_tab)

long nombre;
long *tab;
long taille_tab;
{
long i;
 
	for(i=0;i<taille_tab;i++)
	{
		if(tab[i] == nombre)
			return(i);
	}
	return(ERROR);
}



/*++********************************************************************
------------------
ENTETE DE FONCTION	:init_tableau
------------------

-Rle:
	Initialise un tableau avec une valeur passe en paramtre
-inclure:
-Prototype:
	init_tableau(valeur,tab,taille_tab)
-Paramtres:
	long valeur;
	long tab;
	long taille_tab;
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/



void init_tableau(valeur,tab,taille_tab)

long valeur;
long *tab;
long taille_tab;
{
long i;

	for(i=0;i<taille_tab;i++)
		tab[i]=valeur;
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:replace
------------------

-Rle:
	Remplace dans un tableau de valeurs un nombre (le premier) par un autre
	(le deuxime).
-inclure:
-Prototype:
	replace(nombre1,nombre2,tab,taille_tab)
-Paramtres:
	long nombre1,nombre2
	long *tab;
	long taille_tab;
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

void replace(nombre1,nombre2,tab,taille_tab)

long nombre1,nombre2;
long *tab;
long taille_tab;
{
long i;

	for(i=0;i<taille_tab;i++)
	{
		if(tab[i]==nombre1)
			tab[i]=nombre2;
	}
}

E 1
