
static char *SccsId="@(#)utile_time.c	1.7 01/12/98";
/*********************************************************************;;#h#>
-----------------
HEAD_OF_FILE: utile_time.c
-----------------
-Authors:	Christian Miguel
-Library:
         the_time.a
-Purpose:	
	
	Contains all the functions related with time computation, performances
	measurement etc...
		
-Variables:
		int time_out;
	 	
-Functions:


		hand_timeout
		chrono_instr
		start_time_out
		stop_time_out
		to_time
		micro_sleep

-Keywords:

 time.

;;#h#<*********************************************************************/


#include	<stdio.h>
#include        <errno.h>
#include	<sys/time.h>
#include	<signal.h>


#include	<sun.h>
#include	<the_time.h>
#include	<the_errno.h>


extern Erreur the_errno;
int time_out=NO_TIME_OUT;

/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION: hand_timeout
------------------

-Purpose:
	Handler for a time out. This function is launched for a time out and 
	uses a flag.

-Prototype:
	void hand_timeout(s);

-Parameters:
	int s: signal.

-UsesVariables:
		int time_out;

;;#f#<*********************************************************************/

void hand_timeout(s)
int s;
{
	printf("\n handler d'alarm: un time out arriv");
	time_out=TIME_OUT;

}

/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION: chrono_instr
------------------

-Purpose:
	This function allows to start an instruction and to evaluate its 
	computation time which is printed on the screen.

-Prototype:
	void chrono_instr(sec,procedure);

-Parameters:
	long sec : Number of seconds and micro-seconds which are decremented.
	void (*procedure)(): Name of the procedure on which will be performed
	the computation time evaluation.

-Comments:
	This function uses a counter which decrements time. Time is decremented
	using the parameter 'sec'. Thus, the use of this function requires to 
	majorate the estimated computation time.
 
;;#f#<*********************************************************************/
 
void chrono_instr(sec,procedure)
long sec;
void (*procedure)();
{

struct 	itimerval	time_set;
struct	itimerval	time_get;
struct	timeval		val_time;
struct	timeval		int_time;

	int_time.tv_sec=0;
	int_time.tv_usec=0;

	val_time.tv_sec=sec;
	val_time.tv_usec=0;

	time_set.it_interval=int_time;
	time_set.it_value=val_time;

	setitimer(ITIMER_REAL,&time_set,NULL);	

	(procedure)();

	getitimer(ITIMER_REAL,&time_get);
	
	printf("\nSec=%d, Micro=%ld",(sec -time_get.it_value.tv_sec),
				(1000000- time_get.it_value.tv_usec));
}


/*********************************************************************;;#h#>
------------------
HEAD_OF_FUNCTION: start_time_out
------------------

-Purposee:

This functions decrements a timer and sends an alarm signal when the timer is
finished.

-Prototype:
	int start_time_out(sec,micro_sec);

-Parameters:
	long sec : seconds
	long micro_sec : micro-seconds

-Comments:
	The timer is stopped thanks to stop_time_out.
;;#f#<*********************************************************************/

int start_time_out(sec,micro_sec)
long sec,micro_sec;
{
struct 	itimerval	time_set;
struct	timeval		val_time;
struct	timeval		int_time;

	int_time.tv_sec=0;
	int_time.tv_usec=0;

	val_time.tv_sec=sec;
	val_time.tv_usec=micro_sec;

	time_set.it_interval=int_time;
	time_set.it_value=val_time;

	return(setitimer(ITIMER_REAL,&time_set,NULL));

}



/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:stop_time_out
------------------

-Purpose:
	Stop the timer...

-Prototype:
	void stop_time-out();

-Comments:
This functions is used when the time used to set the time out didn't expire.
;;#f#<*********************************************************************/

void stop_time_out()
{
struct itimerval time_get;

	getitimer(ITIMER_REAL,&time_get);

}


/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION: to_time
------------------

-Purpose:
This function is used to transform the time structure passed in parameter into
a lisible string.

-Prototype:
	int *to_time(time,ch_time,offset);
-Parameters:
	struct timeval *time : time structure
	char *ch_time : the result
	int offset : integer shift of the time

-Return:
OK ou ERROR

-Comments:
This function is used for the trace file during the error tracking of the 
acquisition software with the 'Stockesmetre' mode.
;;#f#<*********************************************************************/

int to_time(time,ch_time,offset)

struct timeval 	*time;
char		*ch_time;
int		offset;
{
long 	sec_in_day;
int 	sec_of_day;
int 	min_of_day,hour;

char ch_nombre[4];

	sec_in_day=time->tv_sec%86400;

	sec_of_day=sec_in_day%60;
	min_of_day=(sec_in_day-sec_of_day)%3600;

	hour=(sec_in_day-sec_of_day-min_of_day)/3600;
		
	strcpy(ch_time,strcat(ch_time," a "));
	sprintf(ch_nombre,"%d",hour+offset);
	strcpy(ch_time,strcat(ch_time,ch_nombre));
	strcpy(ch_time,strcat(ch_time,":"));
	
	sprintf(ch_nombre,"%d",min_of_day/60);
	strcpy(ch_time,strcat(ch_time,ch_nombre));
	strcpy(ch_time,strcat(ch_time,":"));

	sprintf(ch_nombre,"%d",sec_of_day);
	strcpy(ch_time,strcat(ch_time,ch_nombre));

	return(OK);
}

/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION: micro_sleep
------------------

-Purpose:

Equivalent to the sleep function but with a micro-second precision. Note that
a shift must be considered: it is implied by the time to call the function.

-Prototype:
	int micro_sleep(sec,micro_sec);
-Parameters:
	long sec: seconds
	long microsec: micro seconds

;;#f#<*********************************************************************/

void hand_bid()
{}

int micro_sleep(sec,micro_sec)
     long sec;
     long micro_sec;
{
  struct 	itimerval	time_set;
  struct	timeval		val_time;
  struct	timeval		int_time;
  void	(*old_hand)();
  sigset_t	ens,ens_ancien;
  struct sigaction act,oact;


  
  sigfillset(&ens);
  sigdelset(&ens,SIGINT);
  sigprocmask(SIG_SETMASK,&ens,&ens_ancien);

  sigemptyset(&ens);

  int_time.tv_sec=0;
  int_time.tv_usec=0;
  val_time.tv_sec=sec;
  val_time.tv_usec=micro_sec; 
  time_set.it_interval=int_time;
  time_set.it_value=val_time;  
  act.sa_mask=ens;
  act.sa_handler=hand_bid;
  act.sa_flags=0;
  

  if(ERROR==sigaction(SIGALRM,&act,&oact))
    {
      the_errno.code=errno;
      return(ERROR);
    }

  setitimer(ITIMER_REAL,&time_set,NULL);

  sigsuspend(&ens);

  sigprocmask(SIG_SETMASK,&ens_ancien,NULL);
  
  if(ERROR==sigaction(SIGALRM,&oact,NULL))
    {
      the_errno.code=errno;
      return(ERROR);
    }

  return(OK);
  
}
