
static char *SccsId="@(#)test_time.c	1.7 07/24/98";

/*********************************************************************;;#h#>
-------------
HEAD_OF_FILE: test_time.c
-------------

-Purpose: 
 Test the functions of the "the_time" module located in the_time.a library.

-Functions:
    test_micro
    hand_alarm
    test_assoc

    main

-Comments:
This file contains a 'main' in order to generate (thanks to the makefile) the
executable test_time. 

;;#h#<**********************************************************************/
#include <stdio.h>
#include <signal.h>
#include <the_time.h>

#include <sun.h>
#include <the_errno.h>


Erreur the_errno;

/*********************************************************************;;#f#>
HEAD_OF_FUNCTION: test_micro

-Purpose:
Test the function 'micro_sleep' in the the_time.a library.
-Prototype:
    void test_micro();
-UsesVariables:
    TIME_SLEEP_ENR (the_time.h)
-UsesFunctions:
    micro_sleep (the_time.a)



;;#f#<*********************************************************************/
void test_micro()
{
 
  int quit=1;
  int compteur=0;

  while(quit)
    {
      if(ERROR==micro_sleep(0,TIME_SLEEP_ENR))
	{
	  quit=0;
	  printf("\n Erreur %d",the_errno.code);
	}
      else
	{
	  compteur++;
	}

      if(compteur % 100 == 0)
	printf("\n Compteur %d",compteur);
    }


}
/*
void test_usleep()
{
  int compteur=0;

  printf("\n Teste usleep recherche de bibli");

  while(compteur<500000)
    {
      usleep(TIME_SLEEP_ENR);
      compteur++;
    }
  
}
*/

/*********************************************************************;;#f#>
HEAD_OF_FUNCTION:hand_alarm

-Purpose:
  Handle alarm signal.

-Prototype:
    void hand_alarm(s);

-Parameters:
 int s: alarm.

;;#f#<**********************************************************************/
void hand_alarm(s)
int s;
{

  printf("\n Je suis le handler ALRM");


}

/*********************************************************************;;#f#>
HEAD_OF_FUNCTION: test_assoc

-Purpose:
Function which tests micro_sleep and the use of the alarm signal. 
-Prototype:

         void test_assoc();

-UsesFunctions:

        micro_sleep (the_time.a)
	hand_alarm  

-Comments:
In order to test the alarm signal, first associate (thanks to sigaction()) the
signal SIGALRM to the alarm handle function (here 'hand_alaram'). Then do the
call alarm(x) and check that the alarm is handle by the function after the
emission of the signal SIGALRM (when the time x ) has expired.

;;#f#<*********************************************************************/
void test_assoc()
{
  int compteur;
  struct sigaction action;
  sigset_t ens;

  sigemptyset(&(action.sa_mask));
  action.sa_handler=hand_alarm;
  action.sa_flags=0;
  sigaction(SIGALRM,&action,NULL);

  printf("\n Effectue   1000 attentes");

  for(compteur=0;compteur<1000;compteur++)
    {
      micro_sleep(0,TIME_SLEEP_ENR);
    }

  printf("\n Effectue un sleep doit recevoir un message");
  alarm(5);
  sleep(10);
  alarm(0);

  printf("\n Effectue 1000 attentes");
  for(compteur=0;compteur<1000;compteur++)
    micro_sleep(0,TIME_SLEEP_ENR);


  printf("\nLes attentes sont finies, les tests aussi");

}


void test_micro_sleep()
{
  double i;

  while(1)
    {
      micro_sleep(0,TIME_SLEEP_ENR);
      printf("\n%f",i++);
    }
}


/***********************************************************************;;#f#>
HEAD_OF_FUNCTION: main

-Purpose:
Launch the test functions...
-UsesFunctions:
    test_micro
-Comments:
Here, only test_micro is used.

;;#f#<***********************************************************************/

void main()
{

  the_errno.code=0;
  
  test_micro_sleep();
}


