/*
 *	server.c
 *
 * objet : serveur de sockets pour Sun
 * auteur : Jerome Minec
 * date : 26-04-2000
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include </usr/include/netdb.h>	/* pour gethostbyaddr() */
#include <fcntl.h>
#include <errno.h>	/* pour errno de fopen */

#include <sun.h>
#include <process.h>
#include <the_time.h>
#include <errno.h>
#include <the_errno.h>
#include <enrg.h>
#include <visu.h>
#include <acq.h>
#include "comm.h"

#ifndef OK
#define OK		0
#endif

extern Tb_acq 		*Pt_acq;	/*sur la table d'acquisition */
extern Tb_ctrl		*Pt_ctrl;	/* sur la table de controle */
extern Tb_ctrl_cam	*Pt_cam;
extern 	Source_mcle	Mcle_tout[NB_MCLE_TOUT];

extern long       *Pt_sem;	/*pour debugage */

extern FILE *fd_spy;

int sock_vme;

char *nom_prog = "";

/* Les erreurs */
static char *cmd_unknown = "?ERR=81,\"\\\\SUN\"\n\r"; /* commande inconnue */
static char *erreur_param = "?ERR=7,\"\\\\SUN\"\n\r"; /* erreur de parametre */

/* Creation d'une socket */
int creersock( port, type)
int *port;
int type;
{
  int desc;
  struct sockaddr_in nom;
  int longueur;

  if ((desc = socket(AF_INET, type, 0)) == -1) {
    perror( "creation socket impossible"); exit(2);
  }

  memset( (char *) &nom,0, sizeof(nom) );
  nom.sin_port = *port;
  nom.sin_addr.s_addr = INADDR_ANY;
  nom.sin_family = AF_INET;

  if ( bind( desc, (struct sockaddr *)&nom, sizeof(nom) ) ) {
    perror ("nommage socket impossible"); exit(3);
  }
  longueur = sizeof(nom);
  if ( getsockname(desc, (struct sockaddr *)&nom, &longueur) ) {
    perror ("obtention nom socket"); exit(4);
  }
  *port = ntohs(nom.sin_port);
  return(desc);
}

service(sock, adr)
int sock;
struct sockaddr_in adr;
{
  char rep[LGREP] = "", cmd[LGMSG] = "", res[LGMSG] = "";
  char nomfic[40] = "";
  int n = 0, resul;
  int m, i;
  Tb_enrg *Pt_enrg;	
  Tb_visu *Pt_visu; 
  Tb_acq *Pt_acq;
  Tb_ctrl_cam *Pt_cam;
  FILE	*desc_fich;
  
  printf("nouvelle connection de %s/%s:%d, socket %d\n", gethostbyaddr((char *)&adr.sin_addr, sizeof(adr.sin_addr), AF_INET)->h_name, inet_ntoa(adr.sin_addr), adr.sin_port, sock); 
/*   printf("nouvelle connection de %s, port %d\n", inet_ntoa(adr.sin_addr), adr.sin_port); */
  while( 1 ) {

    res[0] = 0;
    n = getnext(sock, rep, cmd);
    
    if ( ( strlen(cmd) < 1+LGCMD ) || ( !strncmp(cmd, fin_comm, 1+LGCMD) ) )
      break;

    printf("commande recue : %s", cmd);

    /* accuse de reception */
    envoi(sock, ack_cmd);

    /* pour le test de connexion */
    if ( !strncmp(cmd, "$INFO", 1+LGCMD) ) { }

    /* demande du nom du programme */
    if ( !strncmp(cmd, "$NAME", 1+LGCMD) ) { 
      sprintf(res, nom_prog);
    }

    /* commandes */
    else if( !strncmp(cmd, "$RAOE", 1+LGCMD) ) {
      if (resul = rao_enrg())
	sprintf(res, "?ERR=%d,\"\\\\SUN\\RAOE\"\n\r", resul);
    }
    else if( !strncmp(cmd, "$RAOS", 1+LGCMD) ) {
      if (resul = rao_stop())
	sprintf(res, "?ERR=%d,\"\\\\SUN\\RAOS\"\n\r", resul);
    }
    else if( !strncmp(cmd, "$DECO", 1+LGCMD) ) {
      if (resul = decode())
	sprintf(res, "?ERR=%d,\"\\\\SUN\\DECO\"\n\r", resul);
    } 
    else if( !strncmp(cmd, "$DEC2", 1+LGCMD) ) {
      if (resul = decode2())
	sprintf(res, "?ERR=%d,\"\\\\SUN\\DEC2\"\n\r", resul);
    } 
    else if( !strncmp(cmd, "$OBSE", 1+LGCMD) ) {
      if (resul = obs_enrg())
	sprintf(res, "?ERR=%d,\"\\\\SUN\\OBSE\"\n\r", resul);
    }   
    else if( !strncmp(cmd, "$OBSS", 1+LGCMD) ) {
      if (resul = obs_stop())
	sprintf(res, "?ERR=%d,\"\\\\SUN\\OBSS\"\n\r", resul);
    }

    /* pour les parametres (paracq.*) */
    else if( !strncmp(cmd, "$CPAR", 1+LGCMD) ) {
      if ( (resul = check_param(Pt_acq,Pt_enrg,Pt_cam,Pt_visu)) != 0 )
	sprintf(res, "?ERR=%d,\"\\\\SUN\\CPAR\"\n\r", resul);
    }
    else if( !strncmp(cmd, "$ITBA", 1+LGCMD) ) {
      if ( (resul = init_tb_acq(Pt_acq, OK)) != 0 )
	sprintf(res, "?ERR=%d,\"\\\\SUN\\ITBA\"\n\r", resul);
    }
    else if( !strncmp(cmd, "$ITBE", 1+LGCMD) ) {
      if ( (resul = init_tb_enrg(Pt_enrg, OK)) != 0 )
	sprintf(res, "?ERR=%d,\"\\\\SUN\\ITBE\"\n\r", resul);
    }
    else if( !strncmp(cmd, "$ITBC", 1+LGCMD) ) {
      if ( (resul = init_tb_ctrl_cam(Pt_cam)) != 0 )
	sprintf(res, "?ERR=%d,\"\\\\SUN\\ITBC\"\n\r", resul);
    }
    else if( !strncmp(cmd, "$ITBV", 1+LGCMD) ) {
      if ( (resul = init_tb_visu(Pt_visu)) != 0 )
	sprintf(res, "?ERR=%d,\"\\\\SUN\\ITBV\"\n\r", resul);
    }
    else if( !strncmp(cmd, "$MCLE", 1+LGCMD) ) {
      if(sscanf(&cmd[1+LGCMD], "(%d,", &m) == 0) strcpy(res, erreur_param);
      else {
	strcpy(nomfic, FILE_RAO_PAR);
	printf("criture du fichier %s (%d lignes)\n", nomfic, m);
	desc_fich = fopen(nomfic, "wt");
	if (desc_fich == 0) {
	  perror("ouverture du fichier");
	  m = 0;  
	  sprintf(res, "?ERR=%d,\"\\\\SUN\\MCLE\"\n\r", errno);	  
	}
	for (i = 1; i <= m; i++) {
	  n = getnext(sock, rep, cmd);
/*	  cmd[strlen(cmd) - 1] = 0;*/
	  fprintf(desc_fich, cmd);
printf("i=%d, cmd='%s'", i, cmd);
	}
	fclose(desc_fich);
/*	printf("server.c:service %d commandes recues\n",m);
	resul = decode2();
	printf("server.c:service decode2=%d\n",resul);
	if ( resul != 0 )
	  sprintf(res, "?ERR=%d,\"\\\\SUN\\DECO\"\n\r", resul);
*/      }
    }
/*    else if ( resul = etudie_ligne(Mcle_tout, NB_MCLE_TOUT, &cmd[1], Pt_enrg, Pt_visu, Pt_acq, Pt_cam) )
*/
/* il y a 1 caractere '_' avant */
/*      sprintf(res, "?ERR=%d,\"\\\\SUN\\\"\n\r", resul);*/
			    
    /* commande non reconnue : deja traite ci -dessus */
        else strcpy(res, cmd_unknown); 
    
    if ( strlen(res) > 0 ) {
      /* envoi de la reponse a la socket */
      envoi(sock, res); 
      /* copie a l'ecran */
      printf("reponse:'%s'\n", res);
    }
    /* fin du traitement */
    envoi(sock, fin_cmd);

  }
  printf("fin de la connection de %s:%d\n", inet_ntoa(adr.sin_addr), adr.sin_port);
  close(sock);
  
  return;
} 

main(argc, argv)
int argc;
char *argv[];
{
  int sock_ecoute, sock_service;
  int port = PORT;
  struct sockaddr_in adr;
  int len = sizeof(adr);

  if(fd_spy == NULL)   
    fd_spy=fopen(FILE_SPY,"a");

  if(fd_spy == NULL)
    {
      printf("\n erreur ouverture fichier spy %d",errno);
      printf("\n chemin de merde : %s");
    }
  else message_spy(fd_spy, "\n---------->\ndebut de server.c");

  strcpy(nom_prog, argv[0]);

  /* numero de port */
  if (argc < 2) port = PORT;
  else sscanf(argv[1], "%d", &port);
  printf("port : %d\n", port);

  /* creation de la socket d'ecoute */
  if ( (sock_ecoute = creersock( &port, SOCK_STREAM ) ) == -1 ) {
    perror ("echec creation/liaison socket\n"); exit(7);
  }

  /* creation de la file de connexions pendantes */
  if (listen(sock_ecoute, 5) < 0) {
    perror("listen"); close(sock_ecoute); exit(8); 
  }

  /* boucle infini : ecoute des demandes de sockets*/
  while(1) {
    /*    printf("attente de connection...\n");*/
    if ((sock_service = accept(sock_ecoute, (struct sockaddr *)&adr, &len)) < 0) {
      perror("accept\n"); exit(8);
    };

    /* traitement de la socket */
/*    if(fork() == 0) {
      close(sock_ecoute);
*/
      service(sock_service, adr);

/*      exit(0);
    }*/
    close(sock_service);
  }
}

