/*
 *	server.c
 *
 * objet : serveur de sockets pour Sun
 * auteur : Jerome Minec
 * date : 14-04-2000
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include </usr/include/netdb.h> /* pour gethostbyaddr() */
#include <fcntl.h>

#include "comm.h"

int sock_vme;

/* Les erreurs */
static char *cmd_unknown = "?ERR=81,\"\\\\SUN\"\n\r"; /* commande inconnue */
static char *erreur_gen = "?ERR=99,\"\\\\SUN\"\n\r"; /* erreur generale */

/* Creation d'une socket */
int creersock( port, type)
int *port;
int type;
{
  int desc;
  struct sockaddr_in nom;
  int longueur;

  if ((desc = socket(AF_INET, type, 0)) == -1) {
    perror( "creation socket impossible"); exit(2);
  }

  memset( (char *) &nom,0, sizeof(nom) );
  nom.sin_port = *port;
  nom.sin_addr.s_addr = INADDR_ANY;
  nom.sin_family = AF_INET;

  if ( bind( desc, (struct sockaddr *)&nom, sizeof(nom) ) ) {
    perror ("nommage socket impossible"); exit(3);
  }
  longueur = sizeof(nom);
  if ( getsockname(desc, (struct sockaddr *)&nom, &longueur) ) {
    perror ("obtention nom socket"); exit(4);
  }
  *port = ntohs(nom.sin_port);
  return(desc);
}

service(sock, adr)
int sock;
struct sockaddr_in adr;
{
  char rep[LGREP], cmd[LGMSG], res[LGMSG];
  int n = 0, resul, comm_finie = 0;
  
  printf("nouvelle connection de %s/%s:%d, socket %d\n", gethostbyaddr((char *)&adr.sin_addr, sizeof(adr.sin_addr), AF_INET)->h_name, inet_ntoa(adr.sin_addr), adr.sin_port, sock); 

  while( ! comm_finie ) {
    res[0] = 0;
    n = getnext(sock, rep, n, cmd);
    
    /* accuse de reception */
    envoi(sock, ack_cmd);
    /* commandes */
    if( !strncmp(cmd, "$INFO", 1+LGCMD) ) { }

    /* fin de communication */
    else if( !strncmp(cmd, fin_comm, 1+LGCMD) )
      comm_finie = 1;
			    
    /* commande non reconnue */
    else strcpy(res, cmd_unknown); 
    
    if ( strlen(res) > 0 ) {
      /* envoi de la reponse a la socket */
      envoi(sock, res); 
      /* copie a l'ecran */
      printf(res);
    }
    /* fin du traitement */
    envoi(sock, fin_cmd);
  }
  printf("fin de la connection de %s:%d\n", inet_ntoa(adr.sin_addr), adr.sin_port);
  close(sock);
  
  return;
} 

main(argc, argv)
int argc;
char *argv[];
{
  int sock_ecoute, sock_service;
  int port = PORT;
  struct sockaddr_in adr;
  int len = sizeof(adr);

  /* numero de port */
  if (argc < 2) port = PORT;
  else sscanf(argv[1], "%d", &port);
  printf("port : %d\n", port);

  /* creation de la socket d'ecoute */
  if ( (sock_ecoute = creersock( &port, SOCK_STREAM ) ) == -1 ) {
    perror ("echec creation/liaison socket\n"); exit(7);
  }

  /* creation de la file de connexions pendantes */
  if (listen(sock_ecoute, 5) < 0) {
    perror("listen"); close(sock_ecoute); exit(8); 
  }

  /* boucle infini : ecoute des demandes de sockets*/
  while(1) {
    /*    printf("attente de connection...\n");*/
    if ((sock_service = accept(sock_ecoute, (struct sockaddr *)&adr, &len)) < 0) {
      perror("accept\n"); exit(8);
    };

    /* traitement de la socket */
    if(fork() == 0) {
      close(sock_ecoute);

      service(sock_service, adr);

      exit(0);
    }
    close(sock_service);
  }
}

