/*
 *			client.c
 *
 * objet :	client de communication par sockets envoyant une commande  un serveur (VME ou Sun)
 * auteur :	Jrome Minec
 * date :       10-03-2000
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <netdb.h>
#include <netinet/in.h>
#include <fcntl.h>
#include "comm.h"

#define SERVEUR "hera"	/* nom du serveur par defaut */

int port = PORT;
char * serveur = SERVEUR;

usage()
{
  printf("Usage : client CMDE [serveur] [port#]\n");
  /*  printf("INFO :\t\t(test de communication)\n");
  printf("\tpour le VME :\n");
  printf("AMEM :\t\talloc_mem(@taille_data)\n");
  printf("LMEM :\t\tlibere_mem()\n");
  printf("ATBP :\t\tadresse_tb_point()\n");
  printf("IACQ :\t\tinit_acquisition()\n");
  printf("EACQ :\t\texit_acquisition()\n");
  printf("IERR :\t\tinit_err()\n");
  printf("FERR :\t\tfin_err()\n");
  printf("IINI :\t\tintf_init()\n");
  printf("IWRT(x,y) :\tintf_wr_timer(timer_num,val)\n");
  printf("TLEC :\t\ttime_lect(@temps)\n");
  printf("LOBT(x) :\tlect_obt(num,@flag)\n");
  printf("COBT(x,y) :\tcmde_obt(num,flag)\n");
  printf("AOBT(x,y) :\taffect_obt(num_cam,num_obt)\n");
  printf("ATHE(x,y) :\taffect_theta(num_cam,theta)\n");
  printf("LSTC(x) :\tlect_stat_cam(num_cam,@etat)\n");
  printf("TACQ(x) :\tstart_acq(bool)\n");
  printf("PACQ :\t\tstop_acq()\n");
  printf("SLEC :\t\tstart_lect()\n");
  printf("ICAM(x) :\tinit_cam(no)\n");
  printf("IBUF(x,y,z) :\tinit_buf(num_cam,num_plan,valeur)\n");
  printf("WBUF(a,b,c,d,e,f,g) :\twr_buf(nom_fichier,lig_deb,col-deb,nb_lig,nb_col,num_cam,num_plan)\n");
  printf("INDE :\t\tindex()\n");
  printf("LAMB :\t\tlambda()\n");
  printf("IANA :\t\tana()\n");
  printf("PLAM :\t\tplam()\n");
  printf("PPOU :\t\tppou()\n");*/
  printf("\tpour la Sun :\n");
  printf("RAOE :\t\trao_enrg()\n");
  printf("RAOS :\t\trao_stop()\n");
  printf("DECO :\t\tdecode()\n");
  printf("OBSE :\t\tobs_enrg()\n");
  printf("OBSS :\t\tobs_stop()\n");
  /*  printf("CPAR :\t\tcheck_param()\n");
  printf("ITBA :\t\tinit_tb_acq()\n");
  printf("ITBE :\t\tinit_tb_enrg()\n");
  printf("ITBC :\t\tinit_tb_ctrl_cam()\n");
  printf("ITBV :\t\tinit_tb_visu()\n");
  printf("MCLE(n) :\tecriture sur paracq.don+decode()\n");
  printf("ligne_de_mot_cle :\tetudie_ligne()\n");
  */
  exit(1);
}

int lance_socket()
{
  int sock;
  struct sockaddr_in adr;
  struct hostent *hp;

  if ( (hp = gethostbyname( serveur )) == NULL ) {
    perror("nom de machine inconnu"); exit(3);
  }
  memset(&adr, 0, sizeof(adr));
  if((sock = socket( AF_INET, SOCK_STREAM, 0)) == -1) {
    perror("cration de la socket"); exit(2);
  }
  adr.sin_family = AF_INET;
  adr.sin_port = htons(port);
  memcpy( &adr.sin_addr, hp->h_addr, hp->h_length);
  
  if(connect(sock, (struct sockaddr *)&adr, sizeof(adr)) == -1) {
    perror("connect"); exit(4);
  }

  return sock;
}

main(argc, argv)
int argc;
char ** argv;
{
  int sock;
  int n, i;
  char rep[LGREP], msg[LGMSG];

  if(argc < 2) usage();

  /* nom du serveur */
  if(argc > 2)
    sscanf(argv[2], "%s", serveur); 
  printf("serveur : %s\n", serveur); 

  /* numero de port */
  if(argc > 3)
    sscanf(argv[3], "%d", &port); 
  printf("port : %d\n", port);

  /* initialisation de la socket */
  sock = lance_socket();

  /* envoi de la commande */
  sprintf(rep, "$%s\n\r", argv[1]);
  envoi(sock, rep);

  /* reception : < */
  rep[0] = 0;
  n = getnext(sock, rep, msg);

  while(strncmp(msg, "<", 1)) {
    n = getnext(sock, rep, msg);
/*     printf("message=%s\n", msg); */
  }
  printf("(accus de rception)\n");

  /* reception : x ou chaine ou ?ERR=... */
  n = getnext(sock, rep, msg);
  printf("rponse  la commande : %s", msg);

  /* reception : > */
/*   n = getnext(sock, rep, msg); */
  while(strncmp(msg, ">", 1)) {
    n = getnext(sock, rep, msg);
/*     printf("message=%s", msg); */
  }
  printf("fin du traitement\n");

  envoi(sock, fin_comm); 
  close(sock);

  return;
}
