
static char *SccsId="@(#)sock_serv.c	1.4 03/11/98";

/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:sock_serv.c
-----------------
-Auteur(s):Christian Miguel
-Rle:

Regroupe les fonctions de base d'utilisation de socket pour le fonctionnement du traitement des erreurs par la station du SUN des erreurs VME. Ce fichier contient la partie client, ie pour la station SUN qui est en coute des arrives des erreurs du VME.

-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
		init_vme_err
	 
-Commentaires:

********************************************************************;-*/

#include 	<stdio.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netdb.h>
#include	<fcntl.h>

#include	<errno.h>
#include	<sun.h>
#include	<the_errno.h>




extern	Erreur	the_errno;

/*++********************************************************************
------------------
ENTETE DE FONCTION	:init_vme_err
------------------

-Rle:
mettre en place la communication des erreurs vme avec la station Sun qui centralise toutes les erreurs et les traite.
-inclure:
-Prototype:
	int init_vme_err()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:ERROR ou le descripteur de socket. En cas d'erreur the_errno contient le code.
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
La communication se fait par socket TCP (en mode connect). La lecture et l'criture des erreurs se fait par des appels au fonction read et write avec en paramtre la variable the_errno contenant les informations relatives  l'erreur.
********************************************************************--*/


int init_vme_err()
{
int sock_vme,sock_con;
struct sockaddr_in	clientadr;
 
	bzero(myaddr,sizeof(struct sockaddr_in));

	myaddr.sin_family= AF_INET;
	myaddr.sin_port = htons (PORT_SERV_ERR);
	myaddr.sin_addr.s_addr= htonl (INADDR_ANY);

	sock_vme=socket(AF_INET, SOCK_STREAM, 0);
	if(sock_vme==ERROR)
	{
		the_errno.code=errno;
		return(ERROR);
	}

	if(bind(sock_vme,(struct sockaddr *)&myaddr,sizeof(struct sockaddr))<0)
	{
		the_errno.code=errno;
		close(sock_vme);
		return(ERROR);
	}

	if(listen(sock_vme,2)==ERROR)
	{
		the_errno.code=errno;
		close(sock_vme);
		return(ERROR);
	}

	sock_con=accept(sock_vme,NULL,NULL);
	if(sock_con==ERROR)
	{
		close(sock_vme);
		return(ERROR);
	}

	close(sock_vme);
	return(sock_con);
}

