
static char *SccsId="@(#)Sun-serv.c	1.3 03/11/98";

/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:Sun-serv.c
-----------------
-Auteur(s):
	Christian Miguel
-Rle:
	Regroupe les foncions appelables par le pc RAO par rseau.
	Les fonctions sont appels par protocole rpc.
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
		rao_enrg
		rao_stop
		decode
		obs_enrg
		obs_stop
	 
-Commentaires:

********************************************************************;-*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/signal.h>

#include <sun.h>
#include <process.h>
#include <the_time.h>
#include <errno.h>
#include <the_errno.h>

extern Erreur the_errno;
static int	time_out=0;

long	pid_stk[NB_PROC+1]={NOTH,NOTH,NOTH};

long	*Pt_sem;
FILE     *fd_err;
int nb_err_serv;

/*++********************************************************************
------------------
ENTETE DE FONCTION	:rao_enrg
------------------

-Rle:
-inclure:
-Prototype:
	int rao_enrg()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		TIME_SLEEP_SERV	(the_time.h)
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


int rao_enrg()
{

  if(install_serv()==ERROR)
    {
      nb_err_serv=1;
      printf("\n Erreur dans le serveur %d",the_errno.code);
      write_histo(&the_errno,&nb_err_serv,fd_err);
      return(ERROR);
    }
  else
    {
      printf("\n L'installation du serveur s'est bien passee");
    }
 
  if(pid_stk[CTRL]==NOTH)
    {
      pid_stk[CTRL]=fork();
      
      switch(pid_stk[CTRL])
	{
	case ERROR:
	  printf("\n Erreur fork ");
	  return(ERROR);
	  break;

	case OK:
	  printf("\n Lancement du programme");
	  process_ctrl();
	  break;

	default:
	  if (OK!=demarage())
	    {
	      nb_err_serv=1;
	      write_histo(&the_errno,&nb_err_serv,fd_err);
	      return(ERROR);
	    }
	  break;
	}
    }
  return(OK);
}



/*++********************************************************************
------------------
ENTETE DE FONCTION	:rao_stop
------------------

-Rle:
	Arreter le programme d'enregistrement et de visualisation.
-inclure:
-Prototype:
	int rao_stop()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/



int rao_stop()
{
int time_out=0;
sigset_t	ens;
sigemptyset(&ens);
sigaddset(&ens,SIGINT);
sigaddset(&ens,SIGUSR1);

	sigprocmask(SIG_SETMASK,&ens,NULL);	

	Pt_sem[CTRL_ACTION]=ACTION_DIE;
	
	while (((Pt_sem[CTRL]!=SYNCHRO)||
		(Pt_sem[ENRG_ETAT]!=ETAT_DEAD)||
		(Pt_sem[VISU_ETAT]!=ETAT_DEAD))&&
		(time_out != TIME_OUT_STOP))
	{
		micro_sleep(0,TIME_SLEEP_SERV);
		time_out++;
	}


	if(time_out == TIME_OUT_STOP)
	  kill_brutal(pid_stk);

	pid_stk[ENRG]=NOTH;
	pid_stk[VISU]=NOTH;
	pid_stk[CTRL]=NOTH;
	
	return(OK);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:decode
------------------

-Rle:
Lance le programme de dcodage du fichier de paramtres d'acquisition, ce qui a pour effet de mettre de nouvelles valeurs issues du fichier dans les tables de la mmoire commune et de la mmoire SUN.
-inclure:
-Prototype:
	int decode()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
	Le dcodage doit tre fait en moins de 2 s sinon c'est trop tard.
********************************************************************--*/



int decode()
{
  int time_out=0;
  int retour;

  Pt_sem[CTRL_ACTION]=ACTION_DECODE;

	
  while( (Pt_sem[CTRL_ACTION]==ACTION_DECODE) &&
	(time_out != TIME_OUT_DECODE) )
    {	
      micro_sleep(0,TIME_SLEEP_SERV);
      time_out++;
    }
	 
  if(time_out == TIME_OUT_DECODE)
    {
      the_errno.code=E_TIME_OUT;
      the_errno.where=PROC_SERV;
      nb_err_serv=1;
      write_histo(&the_errno,nb_err_serv,fd_err);
      return(ERROR);
    }
  else
    {
      if(retour=Pt_sem[VISU_COD_ERR]!=0)
	{
	  retour=Pt_sem[VISU_COD_ERR];
	  Pt_sem[VISU_COD_ERR]=0;
	}

      if(retour=Pt_sem[ENRG_COD_ERR]!=0)
	{
	  retour=Pt_sem[ENRG_COD_ERR];
	  Pt_sem[ENRG_COD_ERR]=0;
	}
    }

  return(retour);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:obs_enrg
------------------

-Rle:
	rien n'est fait ici.
-inclure:
-Prototype:
	int obs_enrg()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


int obs_enrg()
{
	system("clear");
	printf("\n Le serveur de la station SUN est ok");
	return(10);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:obs_stop
------------------

-Rle:
-inclure:
-Prototype:
	int obs_stop()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


int obs_stop()
{
	printf("\n Exit du serveur");
	exit(0);
}













