
static char *SccsId="%W% %G%";
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:visu.c
-----------------
-Auteur(s):	Christian Miguel
-Rle:
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
		visu
		visu_attente
		visu_action
		process_visu
	 
-Commentaires:
	Il faut virer les idl_debut et fin dans ficher visu-idl
	plutot faire une bibli en arrangeant les fonctions.

********************************************************************;-*/


#include 	<stdio.h>
#include 	<sys/time.h>
#include 	<sys/types.h>
#include 	<sys/signal.h>
#include	<sys/file.h>
#include        <errno.h>

#include 	<idl.h>

#include	<sun.h>
#include 	<acq.h>
#include 	<Vme-alloc.h>
#include	<process.h>
#include 	<visu.h>
#include	<param.h>
#include	<enrg.h>
#include	<the_time.h>
#include	<the_errno.h>
 

/*	Les variables globales du processus de visualisation */

 
   

 
Tb_visu			*Pt_visu;	/* sur la table de visualisation */

extern Tb_acq		*Pt_acq;	/*sur la table d'acquisition */
extern Tb_point		*Pt_point;	/*sur la table des pointeurs */
extern Tb_ctrl		*Pt_ctrl;	/* sur la table de controle */
extern Datum		*Pt_data;	/*sur la zone de donnees */
extern void		*Pt_vme_base;	/* sur le debut de la memoire vme*/
extern Source_mcle	Mcle_spe[NB_MCLE_SPE];
extern int		sock_visu[2];


CLIENT		*client=NULL;	/* sur le client rpc */
FILE            *fdvisu;        /* fichier visu */
extern	Erreur 		the_errno;

extern 	u_long		*Pt_synchro;	/* sur une table de verrous */




/*++********************************************************************
------------------
ENTETE DE FONCTION	:visu_decode
------------------

-Rle:
Regroupe et lance toutes les oprations ncessaires pour le dcodage.
-inclure:
-Prototype:
	int visu_decode()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:
		init_tb_visu (decode.a)
		analyseur_fich ""
		check_param
		create_max_win (visu-idl.a)

-Exemple:
-Commentaires:
********************************************************************--*/


int visu_decode()

{
  int retour;

  init_tb_visu(Pt_visu);
	
  retour=analyseur_fich(Mcle_spe,NB_MCLE_SPE,FILE_RAO_PAR,NULL,Pt_visu,NULL,
			NULL);
  if(retour==0)
    retour=check_param(Pt_acq,NULL,NULL,Pt_visu);

  if(retour!=0)
    {
      Pt_synchro[ENRG_COD_ERR]=retour;
      Pt_synchro[VISU_ETAT]=ETAT_WAIT;
    }
  else
    {

      Pt_synchro[VISU_ETAT]=ETAT_OK;
      Pt_synchro[VISU_COD_ERR]=0;
      
      printf("\n  Creation des fenetres");
      if(ERROR==delete_max_win(Pt_visu,client))
	return(ERROR);
      if(ERROR==create_max_win(Pt_visu,client))
	return(ERROR);
    }
  return(retour);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:visu_action
------------------

-Rle:
	Cette fonction lance la fonction correspondante  la demande de
	l'utilisateur.
-inclure:
-Prototype:
	int visu_action()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
	Pas fini de documenter
********************************************************************--*/

int visu_action()
{
int retour;

	switch(Pt_synchro[VISU_ACTION])
	{
		case	ACTION_DECODE:
		{
 			if(visu_decode()!=OK)
			{
				write(sock_visu[0],&the_errno,sizeof(Erreur));
				bzero(&the_errno,sizeof(Erreur));
			}
		 
			Pt_synchro[VISU_ACTION]=ACTION_RIEN;
			break;
		}

		case	ACTION_WAIT:
		{
			Pt_synchro[VISU_ACTION]=ACTION_RIEN;
			Pt_synchro[VISU_ETAT]=ETAT_WAIT;
			break;
		}

		case	ACTION_DIE:
		{
			Pt_synchro[VISU_ETAT]=ETAT_OK;
			break;
		}

		default:
		{
			Pt_synchro[VISU_ACTION]=ACTION_RIEN;
			break;
		}
	}
return(OK);
}

	

/*++********************************************************************
------------------
ENTETE DE FONCTION	:visu_attente
------------------

-Rle:
Le rle de cette fonction est de placer le processus de visualisation dans un tat d'attente d'ordre de l'utilisateur.
-inclure:
-Prototype:
	int visu_attente()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
	Pas fini de commmenter.
********************************************************************--*/


int visu_attente()
{
printf("\nVISU: Debut d'etat attente");


	while(Pt_synchro[VISU_ETAT]==ETAT_WAIT)
	{
	  init_tb_visu(Pt_visu);

	  while(Pt_synchro[VISU_ACTION]==ACTION_RIEN)
	    {
	      micro_sleep(0,TIME_SLEEP_VISU);
	    }
	
	  visu_action();
	}
printf("\nVISU: fin d'etat attente");
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:visu
------------------

-Rle:
Cette fonction permet de mettre le processus de visualisation en opration, celui-ci se met donc  l'coute pour savoir quand afficher des images.
-inclure:
-Prototype:
	int visu()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:OK ou ERROR the_errno est affecte
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
	Pas fini de documenter.
********************************************************************--*/


int visu()
{
  int i=0,j;
 
  u_long		indice_fen;
 
  if(ERROR == openr(FILE_UNIT_IDL,FILE_VISU,client))
     return(ERROR);
  
  while((Pt_synchro[VISU_ACTION]==ACTION_RIEN)||
	(Pt_synchro[VISU_ACTION]==0)||
	(Pt_synchro[VISU_ACTION]==1) )
    {
  
      micro_sleep(0,TIME_SLEEP_VISU);
		 
      if((Pt_synchro[VISU_ACTION]==0)||(Pt_synchro[VISU_ACTION]==1))
	{	
	  rewind(fdvisu);
	  for(i=0;i<NB_MAX_FEN;i++)
	    {
	      
	      if(Pt_visu->numfen[i]!=NOTH)
		{
		  
		  if(record_fen(Pt_acq,i,fdvisu,Pt_synchro[VISU_ACTION])!=OK)
		    {
		      the_errno.where=FICH_VISU;
		      return(ERROR);
		    }
		}
	  
	    }
	  rewind_lun(FILE_UNIT_IDL,client);
	  clean_plot(Pt_visu,client);
	  display_max_donnees(Pt_visu,client);
	  Pt_synchro[VISU_ACTION]=ACTION_RIEN;
	} 
     
		
    }
  if(ERROR == close_idl(FILE_UNIT_IDL,client))
    return(ERROR);
  printf("\n sort de visu");
  return(OK);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:process_visu
------------------

-Rle:	fonction principale du processus de visualisation.
	Elle doit lancer et controler la visualisation des fenetres.
-inclure:
-Prototype:
	void process_visu
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


void process_visu()
{

  int 		zone=0;
  int		desc;    
  int i;


  /* initialisation */
 	
  alarm(TIME_OUT_VISU);
  printf("\n lance get ready visu");
  if(ERROR==get_ready_visu())
    {
      printf("\n Erreur get-ready-visu %d",the_errno.code);
      write(sock_visu[0],&the_errno,sizeof(Erreur));
		
      fin_visu();
    }	
  printf("\n Avant connexion idl");
  alarm(0);

  client=idl_debut(IDL_PORT_STK); 
  if(client==NULL)
    {
      printf("\n Erreur idl_debut %d",the_errno.code);
      write(sock_visu[0],&the_errno,sizeof(Erreur));
      fin_visu();
    }
  
  /* pour indiquer au seerveur qu'il y a un processus de +*/
  Pt_synchro[CTRL_EXT]++;


  fdvisu = fopen(FILE_VISU,"wb");
  if ( fdvisu== NULL)
    {
      the_errno.code=errno;
      the_errno.where=FICH_VISU;
      fin_visu();
    }

  /* boucle principale */

  printf("\n boucle principale de visu");

  while(Pt_synchro[VISU_ACTION]!=ACTION_DIE)
    {			
      Pt_synchro[VISU_ETAT]=ETAT_WAIT;
      visu_attente();
      printf("\n sorti de visu attente , lance visu");
      if(visu()==ERROR)
	{
	  write(sock_visu[0],&the_errno,sizeof(Erreur));
	  bzero(&the_errno,sizeof(Erreur));
	}
    }
  printf("\n Va exexuter fin_visu");
  fin_visu();
}







