
static char *SccsId="@(#)ready-enrg.c	3.11 04/27/00";

/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:ready-enrg.c
-----------------
-Auteur(s):	Christian Miguel
-Rle:
	Regroupe les fonctions d'initialisation et de fermeture de 
	l'enregistrement.
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
		fin_enrg
		fin_enrg_sig
		hand_enrg
		initialise_rao
		get-ready-enrg
	 
-Commentaires:

********************************************************************;-*/

#include 	<stdio.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	<sys/file.h>
#include	<signal.h>

#include	<sun.h>
#include	<Sun-inst-pont.h>
#include 	<acq.h>
#include	<enrg.h>
#include        <visu.h>
#include	<process.h>
#include	<errno.h>
#include	<the_errno.h>
#include	<tb_ctrl_cam.h>


extern FILE *fd_spy;


extern	Tb_point	*Pt_point;
extern 	Tb_enrg		*Pt_enrg;
extern  Tb_visu         *Pt_visu;
extern 	Tb_acq		*Pt_acq;
extern  Tb_ctrl_cam	*Pt_cam;
extern 	long		*Pt_synchro;
u_long                    *Pt_shm_pid;
extern 	int		desc_pont;
extern	void		*Pt_vme_base;

extern 	Erreur	the_errno;



int	desc;


 

/*++********************************************************************
------------------
ENTETE DE FONCTION	:fin_enrg()
------------------

-Rle:
Cette fonction arrte la tche d'enregistrement en prenant soin de librer, nettoyer, bref elle fait le mnage avant de faire _exit.

-inclure:
-Prototype:
	void fin_enrg()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:
		Tb_point	*Pt_point
		Tb-enrg		*Pt_enrg
		long		*Pt_synchro	
		le pointeur pour synchroniser les processus et les faire communiquer.
-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		ENRG_ETAT	(process.h)
		
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


void fin_enrg()
{ 
  
  if(Pt_point == NULL)
    message_spy(fd_spy,"\nENRG: PAS de netoyage avant l'arret");
  else
    {
      message_spy(fd_spy,"\nENRG netoyage	avant l'arret");
      munmap(Pt_vme_base,TAILLE_MEM_COM);
      close(desc);
      Pt_point=NULL;
    }

  if(Pt_enrg!=NULL)
    {
      free(Pt_enrg);
      Pt_enrg=NULL;
    }

  if(Pt_visu!=NULL)
    {
      free(Pt_visu);
      Pt_visu=NULL;
    }
	
  if(Pt_synchro!=NULL)
    {
      Pt_synchro[ENRG_PID]=NOTH;
      Pt_synchro[ENRG_ETAT]=ETAT_DEAD;
      Pt_synchro[ENRG_ACTION]=ACTION_RIEN;
      Pt_synchro[ENRG]=SYNCHRO;
      Pt_synchro[CTRL_EXT]=-NB_PROC;
      Pt_synchro[VISU_COMPT]=NOTH;
      Pt_synchro[VISU_ACTION]=ACTION_RIEN;
      shmdt(Pt_synchro);
      Pt_synchro=NULL;
    }
  _exit(0);
}
/*++********************************************************************
------------------
ENTETE DE FONCTION	:fin_enrg_sig()
------------------

-Rle:
Cette fonction arrte la tche d'enregistrement en prenant soin de librer, nettoyer, bref elle fait le mnage avant de faire _exit.

-inclure:
-Prototype:
	void fin_enrg_sig()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:
		Tb_point	*Pt_point
		Tb-enrg		*Pt_enrg
		long		*Pt_synchro le pointeur pour synchroniser les processus et les faire communiquer.
-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		ENRG_ETAT	(process.h)
		
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
Cette fonction,  la diffrence de fin_enrg n'utilise pas Pt_synchro pour prvenir les autres procesus de son tat.
********************************************************************--*/


void fin_enrg_sig()
{ 
  
  if(Pt_point == NULL)
    message_spy(fd_spy,"\nENRG PAS de netoyage avant l'arret");
  else
    {
      message_spy(fd_spy,"\nENRG netoyage	avant l'arret");
      munmap(Pt_vme_base,TAILLE_MEM_COM);
      close(desc);
      Pt_point=NULL;
    }

  if(Pt_enrg!=NULL)
    {
      free(Pt_enrg);
      Pt_enrg=NULL;
    }


  if(Pt_visu!=NULL)
    {
      free(Pt_visu);
      Pt_visu=NULL;
    }

	
  if(Pt_synchro!=NULL)
    {
      Pt_synchro[ENRG_PID]=NOTH;
      Pt_synchro[ENRG_ETAT]=ETAT_DEAD;
      Pt_synchro[ENRG_ACTION]=ACTION_RIEN;
      Pt_synchro[ENRG]=SYNCHRO;
      Pt_synchro[CTRL_EXT]=-NB_PROC;
      Pt_synchro[VISU_COMPT]=NOTH;
      Pt_synchro[VISU_ACTION]=ACTION_RIEN;
      shmdt(Pt_synchro);
      Pt_synchro=NULL;
    }
  _exit(0);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:hand_enrg
------------------

-Rle:
	En cas d'erreur logicielle du genre Segmentation fault... 
	le processus n'est pas tu du premier coup, il rsiste un peu
	en passant par cette fonction et nettoie un peu son environement.
-inclure:
-Prototype:
	void hand_enrg(int s)
-Paramtres:
	s est le numro du signal recu. (ex SIGSEGV pour Segmentation Fault)
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:
		fin_enrg()	(ready-enrg.c)

-Exemple:
-Commentaires:
********************************************************************--*/


void hand_enrg(s)
int s;
{
  switch(s)
    {
    case SIGBUS:
      message_spy(fd_spy,"\n\nENRG Bus error...");
      break;	
    case SIGSEGV:
      message_spy(fd_spy,"\n\nENRG Segmentation fault...");
      break;
    case SIGALRM:
      message_spy(fd_spy,"\n\nENRG ALARM, TIME OUT init");
      kill(getppid(),SIGINT);
      break;
    case SIGUSR1:
      message_spy(fd_spy,"\n\nENRG SIGUSR1...");
      fin_enrg_sig();
      break;
    }

  fin_enrg();
}



/*++********************************************************************
------------------
ENTETE DE FONCTION	:initialise_rao
------------------

-Rle:
	alloue la table d'enregistrement.
-inclure:
-Prototype:
	initialise_rao()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importees:
		Tb_enrg *Pt_enrg; (enrg.c)

-Retour: OK ou ERROR
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
			
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/



int initialise_rao()
{
  short i;
 
  if(Pt_enrg == NULL)
    Pt_enrg=(Tb_enrg *)malloc(sizeof(Tb_enrg));

  if(Pt_visu == NULL)
    Pt_visu=(Tb_visu *)malloc(sizeof(Tb_visu));



  if((Pt_enrg==NULL)||(Pt_visu==NULL))
    {
      the_errno.code=errno;
      the_errno.ctxt=INIT;
      return(ERROR);
    }
  init_tb_enrg(Pt_enrg,NOTH);
  init_tb_visu(Pt_visu);
  return(OK);		
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:get_ready_enrg()
------------------

-Rle:
	Cette fonction un peu comme initialise_rao met enrg dans de bonnes
	conditions pour commencer  bosser.
	Elle lui permet d'avoir accs  la mmoire commune en se synchronisant
	avec ses camarades visu et ctrl pour le partage de la ressource: driver
	du pont de bus.
-inclure:
-Prototype:
	void get_ready_enrg()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:
		Tb_point	*Pt_point;	(Sun-inst-pont.c)
		long		*Pt_synchro;	(controle.c)

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		ENRG		(process.h)
		CTRL		"
	
-Fonctions utilises
	Internes au fichier:
	Importes:
		open_driver_pont	(Sun-inst-pont.a)
		map_mem_fils		(Sun-inst-pont.a)
		adresse_tb_point	(Sun-clnt-vme.a)

-Exemple:
-Commentaires:
	
********************************************************************--*/


int get_ready_enrg()
{
  u_long		adresse;
  sigset_t	ens;

  signal(SIGBUS,hand_enrg);
  signal(SIGSEGV,hand_enrg);
  signal(SIGALRM,hand_enrg);
  signal(SIGUSR1,hand_enrg);

  sigemptyset(&ens);
  sigaddset(&ens,SIGINT);

  if(sigprocmask(SIG_SETMASK,&ens,NULL)==ERROR)
    {
      the_errno.code=errno;
      the_errno.ctxt=INIT;
      return(ERROR);
    }
	

  Pt_synchro=NULL;
  Pt_point=NULL;
  Pt_synchro=(long *)shared_segment(CLE,NB_SH_SEG);
  Pt_shm_pid=shared_segment(CLE_RT,NB_SH_SEG_RT);
  message_spy(fd_spy,"\n ready enrg en attente du sem de controle ");
     
  if(Pt_synchro!=NULL)
    {
      while(Pt_synchro[CTRL]==SYNCHRO)
	{
	  if(Pt_synchro[ENRG_ACTION]==ACTION_DIE)
	    fin_enrg();
	}
    }
  else
    return(ERROR);

  message_spy(fd_spy,"\n ready enrg, ouverture du pont");

  desc=open_driver_pont();
  if(desc==ERROR)
    return(ERROR);

  adresse=adresse_tb_point();
  if(adresse==NULL)
    return(ERROR);

  if(map_mem_fils(Pt_synchro[CTRL],adresse,desc)==ERROR)
    return(ERROR);

  message_spy(fd_spy,"\n ready enrg init des tables");

  init_tb_acq(Pt_acq,NOTH);
  init_tb_ctrl_cam(Pt_cam);

  message_spy(fd_spy,"\n ready enrg apres init des tables");

/* pour dire a la visu qu'elle peut avoir acces au pont de bus */

  Pt_synchro[VISU_ADRES]=adresse;


  Pt_synchro[ENRG]=(long)Pt_vme_base;

}






