
static char *SccsId="%W% %G%";

/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:rao-file.c
-----------------
-Auteur(s):	Christian Miguel
-Rle:
	Ce fichier regroupe les fonctions permettant d'enregistrer les 
	fentres dans des fichiers: les fonctions d'criture.
	
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
		record_rao
		record_fen
		record_obs
	 
-Commentaires:
	Actuellement, le fichier contient les fonctions d'criture dans le fichier
	dedi au mode de reglage (par dfaut paracq.don).

********************************************************************;-*/


#include	<stdio.h>
#include	<sys/types.h>
#include	<fcntl.h>

#include	<sun.h>
#include 	<acq.h>
#include 	<enrg.h>
#include        <visu.h>
#include	<errno.h>
#include        <the_time.h>
#include	<the_errno.h>
#include        <param.h>


extern 	Tb_ctrl		*Pt_ctrl;
extern	Tb_acq		*Pt_acq;
extern  Datum		*Pt_data;
extern  chfits          Liste_instrume[NB_INSTRUME];
extern  chfits          Liste_obs_mode[NB_OBS_MODE];
extern	Erreur		the_errno;

extern  Mem_header      *Pt_top_header;
extern  Mem_header      *Pt_dyn_header;
extern  Param_info      Tb_header_dyn [NB_LI_BLOC_FITS+NB_LI_BLOC_FITS*NB_MAX_FEN];
extern  Param_info      Tb_header_princ[NB_MCLE+NB_MCLE_DEPEND_FEN*NB_MAX_FEN];
extern  Ind_mcle        Liste_ordo[NB_TYPE_HEADER][TAILLE_MAX_LIST_ORDO];


extern FILE             *fd_spy;



/******************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION: get_filename
------------------

;;#f#<*********************************************************************/
int get_filename(nofen,Pt_acq,Pt_enrg,filename,filedate,time2)
int nofen; /*numero de la fenetre*/
Tb_acq *Pt_acq;
Tb_enrg *Pt_enrg;
char *filename;
char *filedate;
struct timeval time2;
{
  

  int retour,index;
  time_t cl1,cl2;
  struct tm *filetime;
  int year,month,day,hr,mn,sc,msc;

  chfits instrume, obsmode;
  long nocam,num_seq=0;
  char mode_fits[2],seq[4],imtyp[6],mi[3],t,ext[4],cc[3],ff[3];


  message_spy(fd_spy,"\n Entre dans get_filename()");
  
  /*initialisation */

  clean_erreur();
  if((filetime=(struct tm*)malloc(sizeof(struct tm))) == NULL)
    {
      the_errno.code=errno;
      return(ERROR);
    }

  /* FILENAME : inst_imtyp_mi_yyyymmdd_hhmmss:ss_t.ext*/
  /*recuperation de imtyp...format: dccff ou cc=camera et ff=fenetre*/
  
  nocam = Pt_acq->tab_info_fen[nofen].nocam;
  if(nocam < 0)
    {
      /*Le numero de camera associe a la fenetre n'est pas specifie*/
      sprintf(cc,"XX\0",nocam);
    }
  else
    {
      if(nocam < 10)
	{
	  sprintf(cc,"0%1.1d\0",nocam);
	}
      else
	{
	  sprintf(cc,"%2.2d\0",nocam);
	}
    }
  
  if(nofen < 10)
    {
      sprintf(ff,"0%1.1d\0",nofen);
    }
  else
    {
      sprintf(ff,"%2.2d\0",nofen);
    }

  sprintf(imtyp,"b%2s%2s",cc,ff);
  
  /*recuperation de mi*/
 
  /*teste l'existence du mot cle*/
  if(Pt_enrg->tab_phy.instrume != NULL)
    {
      strcpy(instrume,Pt_enrg->tab_phy.instrume);
      index = 0;
      while((strstr(instrume,Liste_instrume[index]) == NULL)&&(index<NB_INSTRUME))
	{
	 index++;
	}
      
      switch(index)
	{
	case FULLDISK:
	  {
	    strcpy(mi,"fd\0");
	    break;
	  }
	
	case MSDP:
	  {
	    strcpy(mi,"ms\0");
	    break;
	  }
	
	case SPECTRA :
	  {
	    strcpy(mi,"sp\0");
	    break;
	  }
	
	case IPM:
	  {
	    strcpy(mi,"ip\0");
	    break;
	  }
	
	case F1:
	  {
	    strcpy(mi,"f1\0");
	    break;
	  }
	
	case F2:
	  {
	    strcpy(mi,"f2\0");
	    break;
	  }
	default:
	  {
	    strcpy(mi,"XX\0");
	    break;
	  }          
	}
    }
  else
    {
      strcpy(mi,"XX\0");
    }

  
  
  /*recuperation de t*/
  
  if(Pt_acq->themisff == FITS0)
    {
      t = 'a';
    }
  else
    {
      if(Pt_enrg->tab_phy.obs_mode != NULL)
	{
	  strcpy(obsmode,Pt_enrg->tab_phy.obs_mode);
	  index = 0;
	  while((strstr(obsmode,Liste_obs_mode[index]) == NULL)&&(index<NB_OBS_MODE))
	    {
	      index++;
	    }
	  
	  switch(index)
	    {
	    case FULLSUN:
	      {
		t = 'l';
		break;
	      }	    
	    case RFLAT:
	      {
		t = 'y';
		break;
	      }
	    case RDARK:
	      {
		t = 'x';
		break;
	      }
	    case RFSTOP:
	      {
		t = 'z';
		break;
	      }
	    case MFLAT:
	      {
		t = 'f';
		break;
	      }
	    case MDARK:
	      {
		t = 'd';
		break;
	      }
	    case MFSTOP:
	      {
		t = 's';
		break;
	      }
	    case CALIB:
	      {
		t = 'c';
		break;
	      }
	    default :
	      {
		t = 'b';
		break;
	      }
	    }
	}
      else
	{
	  t = 'X';
	}
    }
  
  /*recuperation de ext*/
  
  switch(Pt_acq->themisff)
    {
    case FITS0:
      {
	strcpy(ext,"bin\0");
	break;
      }
    case FITS1:
      {
	strcpy(ext,"fts\0");
	break;
      }
    case FITS2:
      {
	strcpy(ext,"fts\0");
	break;
      }
    case FITS3:
      {
	strcpy(ext,"fts\0");
	break;
      }
    default :
      {
	return(ERROR);
	break;
      }
    }
  /* recuperation du temps */
  

  
  /* mise en forme */
  
  cl2=time2.tv_sec;
  filetime = gmtime(&cl2);
  
  year=filetime->tm_year;
  if(year < 20)
    {
      year+=SIECLE+100;
    }
  else
    {
      year+=SIECLE;
    }
  month=filetime->tm_mon+1;
  day=filetime->tm_mday;
  hr=filetime->tm_hour;
  mn=filetime->tm_min;
  sc=filetime->tm_sec;
  msc=time2.tv_usec/10000;

  num_seq = (Pt_acq->index).seq_ind;
  if((num_seq >= 1000)|| (num_seq < 0 ))
    {
      sprintf(seq,"XXX\0");
    }
  else
    {
      if(num_seq < 10)
	{
	  sprintf(seq,"00%1.1d\0",num_seq);
	}
      else
	{
	  if(num_seq < 100)
	    {
	      sprintf(seq,"0%2.2d\0",num_seq);
	    }
	  else
	    {
	      sprintf(seq,"%3.3d\0",num_seq);
	    }
	}
    }

  sprintf(mode_fits,"%1.1d\0",Pt_acq->themisff);

  sprintf(filename,"t%3.3s_%5.5s_%2.2s_%i%.2i%.2i_%.2i%.2i%.2i%.2i_%c%1.1s.%3.3s\0",
	 seq,imtyp,mi,year,month,day,hr,mn,sc,msc,t,mode_fits,ext);
  sprintf(filedate,"%i-%.2i-%.2iT%.2i:%.2i:%.2i.%.2i\0",year,month,day,hr,mn,sc,msc);
  free(filetime);
  
  return(OK);


}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:record_rao
------------------

-Rle:
Cette fonction se charge de faire l'enregistrement d'une acquisition dans le fichier par dfaut du mode reglage. Elle enregistre les fentres qui sont spcifies dans la table d'enregistrement. Pour chaque fentre  energistrer,elle lance la fonction d'enregistrement d'une fenetre.
-inclure:
-Prototype:
	int record_rao(base ,Pt_enrg)
-Paramtres:
	int	base		Numro de la zone d'acquisition (0 ou 1)
	Tb_enrg	*Pt_enrg	Pointeur sur Tb_enrg
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour: OK ou ERROR
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		NB_MAX_FEN	(th_form.h)
		FILE_RAO_ACQ	(enrg.h)(nom de fichier par defaut)
	
-Fonctions utilises
	Internes au fichier:
		record_fen
	Importes:

-Exemple:
-Commentaires:
il n y a ni entte d'acquisition ni entte de fentre comme il y aura en mode d'observation.
********************************************************************--*/


int record_rao(base,Pt_enrg,Pt_acq)

int base;
Tb_enrg *Pt_enrg;
Tb_acq  *Pt_acq;
{
  FILE  *fd_images;
  int i;
  int taille_zone=Pt_ctrl->taille_empl;

  if(Pt_enrg->nbfen != 0)
    {

      fd_images=fopen(FILE_RAO_ACQ,"wb");
      if(fd_images==NULL)
	{
	  the_errno.code=errno;
	  the_errno.where=FICH_DON;
	  return(ERROR);
	}

      for(i=0;i<NB_MAX_FEN;i++)
	{
	  if(Pt_enrg->numfen[i]==1)
	    {
	      message_spy(fd_spy,"\n dans record_rao lance record_fen");

	      if(record_fen(Pt_acq,i,fd_images,base)==ERROR)
		{
		  the_errno.where=FICH_DON;
		  return(ERROR);
		}
       
	    } 
	}
			
      return(fclose(fd_images));
    }

  return(OK);
}






int record_visu(base,Pt_acq)

int base;
Tb_acq  *Pt_acq;
{
  FILE  *fd_visu;
  int i;
  int taille_zone=Pt_ctrl->taille_empl;



  fd_visu=fopen(FILE_VISU,"wb");
  if(fd_visu==NULL)
    {
      message_spy(fd_spy,"\n RECORD VISU impossible ouvrir fichier");
      the_errno.code=errno;
      the_errno.where=FICH_VISU;
      return(ERROR);
    }
  
  for(i=0;i<NB_MAX_FEN;i++)
    {
      if((Pt_acq->tab_fen[i].nblig!=ZERO)&&(Pt_acq->tab_fen[i].nbcol!=ZERO))
	{
	  if(record_fen(Pt_acq,i,fd_visu,base)==ERROR)
	    {
	      the_errno.where=FICH_VISU;
	      return(ERROR);
	    }
	} 
    }
  
  fclose(fd_visu);
  return(OK);
}





/*++********************************************************************
------------------
ENTETE DE FONCTION	:record_fen
------------------

-Rle:
Fonction qui enregistre une fenetre pure, sans entete dans le fichier dont le descripteur de file est passee en parametre.
-inclure:
-Prototype:
	int record_fen(indice,fd_images,base)
-Paramtres:
	int 	indice		numro de la fentre  enregistrer
	FILE	*fd_images	descripteur de fichier
	u_long	base		numro de la zone d'acquisition (0 ou 1)

-Variables globales utilises
	Internes au fichier:
	Importes:
		Tb_ctrl	*Pt_ctrl;
		Datum	*Pt_data;

-Retour: OK ou ERROR
-Description:
-Constantes utilises
	Internes au fichier:

	Importes:
		TAILLE_ENT_ACQ	(enrg.h) taille de l'entte de la zone d'acquisition.
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


int record_fen(Pt_acq,indice,fd_images,base)
     Tb_acq *Pt_acq;
     int indice;
     FILE *fd_images;
u_long base;
{
  u_long start;
  size_t	nb_elem;



  nb_elem= (Pt_acq->tab_fen)[indice].nbcol*(Pt_acq->tab_fen)[indice].nblig;	
  start=base*Pt_ctrl->taille_empl+(Pt_acq->tab_info_fen)[indice].mem_offset/sizeof(short);


  if(nb_elem!=fwrite(&Pt_data[start],sizeof(Datum),nb_elem,fd_images))
    {
      the_errno.code=errno;
      return(ERROR);
    }
  return(OK);
}



/*++********************************************************************
------------------
ENTETE DE FONCTION	:record_obs
------------------

-Rle:
	Effectue l'enregistrement d'une acquisition en mode observation.
-inclure:
-Prototype:
	int record_obs(base,total,Pt_enrg)
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
	En test
********************************************************************--*/




int record_obs(base,Pt_enrg,Pt_acq)
int base;
Tb_enrg *Pt_enrg;
Tb_acq  *Pt_acq;
{
  int i;
  int taille_zone=Pt_ctrl->taille_empl;
  long start=-1,taille_data=-1;

  FILE *fd_null;

 
	 
  for(i=0;i<NB_MAX_FEN;i++)
    {
      if(Pt_enrg->numfen[i]==1)
	{
	  if(record_fen(Pt_acq,i,(Pt_enrg->fich)[i],base)==ERROR)
	    {
	      the_errno.where=FICH_OBS;
	      return(ERROR);
	    }
	}
    }


  return(OK);	
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:open_file
------------------

-Rle:
Ouverture des fichiers pour l'enregistrement en mode observation
-inclure:
-Prototype:
	int record_obs(Pt_enrg)
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour: OK ou ERROR
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
	En test
********************************************************************--*/




int open_file(Pt_enrg)
Tb_enrg *Pt_enrg;
{
int i;
char filename[TAILLE_FILENAME];
char abs_filename[TAILLE_FILENAME];
char tmp_filename[TAILLE_FILENAME];
char filedate[TAILLE_DATEFICH];
char message[TAILLE_MES];
struct timeval time2;

message_spy(fd_spy,"\n Entre dans openfile");

strcpy(abs_filename,DISK1);
strcpy(abs_filename,strcat(abs_filename,PATH_ACQ));

message_spy(fd_spy,"\n 1 ");
message_spy(fd_spy,abs_filename);


 
 if ((gettimeofday(&time2,NULL))== ERROR)
   {
     the_errno.code=errno;	     
     return(ERROR);
   }

  for(i=0;i<NB_MAX_FEN;i++)
    {
      if(Pt_enrg->numfen[i] == 1)
	{
	  sprintf(message,"----------> indice de fenetre a enreg %i",i);
	  message_spy(fd_spy,message);
	  /*initialisation*/
	  strcpy(filename,"\0");
	  strcpy(filedate,"\0");

	  if(ERROR == get_filename(i,Pt_acq,Pt_enrg,filename,filedate,time2))
	    {
	      return(ERROR);
	    }
	  strcpy(tmp_filename,"\0");
	  strcpy(tmp_filename,abs_filename);
	  strcat(tmp_filename,filename);
	  
	  message_spy(fd_spy,"\n 2 ");
	  message_spy(fd_spy,tmp_filename);
	  
	  /*le file-descriptor*/
	  (Pt_enrg->fich)[i]=fopen(tmp_filename,"wb");
	  if(NULL == Pt_enrg->fich[i])
	    {
	      the_errno.code=errno;
	      the_errno.where=FICH_OBS;
	      the_errno.ctxt=FENETRES;
	      the_errno.numero=i;
	      return(ERROR);
	    }
	  
	  /*le nom du fichier*/
	  strcpy((Pt_enrg->nomfich)[i],"\0");
	  strcpy((Pt_enrg->nomfich)[i],filename);
	  
	  /*la date du fichier*/
	  strcpy((Pt_enrg->datefich)[i],"\0");
	  strcpy((Pt_enrg->datefich)[i],filedate);
	}
    }
return(OK);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:close_file
------------------

-Rle:
Ouverture des fichiers pour l'enregistrement en mode observation
-inclure:
-Prototype:
	int record_obs(Pt_enrg)
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour: OK ou ERROR
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
	En test
********************************************************************--*/

int close_file(Pt_enrg)
Tb_enrg *Pt_enrg;
{
  int i;
  
  message_spy(fd_spy,"\n Entre dans close_file()");

  for(i=0;i<NB_MAX_FEN;i++)
    {
      if(Pt_enrg->numfen[i] == 1)
	{
	  if(OK != fclose(Pt_enrg->fich[i]) )
	    {
	      the_errno.code=errno;
	      the_errno.where=FICH_OBS;
	      the_errno.ctxt=FENETRES;
	      the_errno.numero=i;
	      return(ERROR);
	    }
	}
    }
return(OK);
}


/*****************************************************************;;#f#>
-----------------
HEAD_OF_FUNCTION:record_fits1
-----------------
-Purpose:

Effectue l'enregistrement des images au format FITS1.

-Prototype:

int record_fits1(base,Pt_enrg,Pt_acq);

-Parameters:

int base:
Tb_enrg *Pt_enrg:
Tb_acq  *Pt_acq:

-Return:
Ok si tout va bien...sinon ERROR.

;;#f#<*****************************************************************/

int record_fits1(base,Pt_enrg,Pt_acq)
int base;
Tb_enrg *Pt_enrg;
Tb_acq  *Pt_acq;
{
  int i,retour,ligne;
 
  message_spy(fd_spy,"\n Entre dans record_fits1");
  
  /*ouverture des fichiers a enregistrer*/
  if(ERROR == open_file(Pt_enrg))
    {
      the_errno.where=FICH_OBS;
      return(ERROR);
    }

  
  ligne=Pt_enrg->nb_li_princ;

  /*Re-construction du tableau pour les informations dynamiques (sous-entetes)*/
  retour = build_Tb_header_dyn(Tb_header_princ,Pt_acq,Pt_enrg,Pt_ctrl,TOP_HEADER);
  if(retour == ERROR)
    {
      return(ERROR);
    }
    

  /*Creation de l'entete fits principale en memoire*/
  retour = gen_header(Pt_top_header,Tb_header_princ,Pt_enrg,Liste_ordo,TOP_HEADER);
  if(retour == ERROR)
    {
      free_Mem_header(Pt_top_header);
      free_Mem_header(Pt_dyn_header);
      return(ERROR);
    }

 /* Remet le bon nombre de ligne sans les parametres dyn... car on va les ecrire le coup suivant */
  Pt_enrg->nb_li_princ=ligne;

  /*Suppression des champs FILENAME, FILORIG, DATE et DATE_END (si ils*/
  /*existent) de la structure Pt_top_header afin de mettre ceux correspondant*/
  /*au nouveaux fichiers*/

  if(ERROR == clean_mem_header_princ_before_complete(Pt_top_header,Pt_enrg))
    {      
      return(ERROR);
    }

  /*ajout des informations disponibles uniquement apres ouvertures des fichiers*/
  /*i.e. FILENAME,FILORIG,DATE,DATE_END.*/
  if(ERROR == complete_mem_header_princ(Pt_top_header,Pt_enrg))
    {
      return(ERROR);
    }
  
  /*Generation des entetes fits dynamiques en zone memoire*/  
  /*  retour = gen_header(Pt_dyn_header,Tb_header_dyn,Pt_enrg,Liste_ordo,DYN_HEADER);
  if(retour == ERROR)
    {
      return(ERROR);
    }
    */
  
  /*Enregistrement des fenetres dans les fichiers associes*/
  for(i=0;i<NB_MAX_FEN;i++)
    {
      if(Pt_enrg->numfen[i]==1)
	{

	  /*Ecritures des entetes: la principale et la dynamique*/
	  if(ERROR == write_fits_header_in_file(Pt_top_header,i,(Pt_enrg->fich)[i]))
	    return(ERROR);
	  /* 
	  if(ERROR == write_fits_header_in_file(Pt_dyn_header,i,(Pt_enrg->fich)[i]))
	  return(ERROR);
	  */
	  
	  /*Ecritures des donnees de la fenetre dans le fichier..au format fits!*/
	  if(write_fits_data_in_file(Pt_acq,i,(Pt_enrg->fich)[i],base,FITS1)==ERROR)
	    {
	      the_errno.where=FICH_OBS;
	      return(ERROR);
	    }
	  
	}
    }
  
  /*Fermetures des fichiers ...*/
  if(ERROR == close_file(Pt_enrg))
    return(ERROR);

  return(OK);	

}
/*************************************************************************;;#f#>
-----------------
HEAD_OF_FUNCTION:record_fits2
-----------------
-Purpose:

Effectue l'enregistrement des images au format FITS2

-Prototypes:

int record_fits2(base,Pt_enrg,Pt_acq);

-Parameters:

int base:
Tb_enrg *Pt_enrg:
Tb_acq  *Pt_acq:

-Return:
Ok..ou ERROR s'il y a un probleme.

;;#f#<*************************************************************************/
int record_fits2(base,Pt_enrg,Pt_acq,type_header)
int base;
Tb_enrg *Pt_enrg;
Tb_acq  *Pt_acq;
int type_header;
{
  int i,retour;
  
  message_spy(fd_spy,"\n Entre dans record_fits2");
  
  if(type_header == DYN_HEADER)
    {
      /*Re-construction du tableau pour les informations dynamiques (sous-entetes)*/
      retour = build_Tb_header_dyn(Tb_header_dyn,Pt_acq,Pt_enrg,Pt_ctrl,DYN_HEADER);
      if(retour == ERROR)
	{
	  return(ERROR);
	}
      /*Generation des entetes fits dynamiques en zone memoire*/  
      retour = gen_header(Pt_dyn_header,Tb_header_dyn,Pt_enrg,Liste_ordo,DYN_HEADER);
      if(retour == ERROR)
	{
	  return(ERROR);
	}
    }
  
  
  /*Enregistrement des fenetres dans les fichiers associes*/
  for(i=0;i<NB_MAX_FEN;i++)
    {
      if(Pt_enrg->numfen[i]==1)
	{
	  /*Ecritures des entetes dynamiques*/
	  if(type_header == DYN_HEADER)
	    {
	      if(ERROR == write_fits_header_in_file(Pt_dyn_header,i,(Pt_enrg->fich)[i]))
		return(ERROR);
	    }
	  
	  /*Ecritures des donnees de la fenetre dans le fichier..au format fits!*/
	  if(write_fits_data_in_file(Pt_acq,i,(Pt_enrg->fich)[i],base,FITS2)==ERROR)
	    {
	      the_errno.where=FICH_OBS;
	      return(ERROR);
	    }
	}
    }
  
  
  return(OK);
}

/*************************************************************************;;#f#>
-----------------
HEAD_OF_FUNCTION:record_fits3
-----------------
-Purpose:

Effectue l'enregistrement des images au format FITS3

-Prototypes:

int record_fits3(base,Pt_enrg,Pt_acq);

-Parameters:

int base:
Tb_enrg *Pt_enrg:
Tb_acq  *Pt_acq:

-Return:
OK...ou ERROR en cas de probleme.

;;#f#<*************************************************************************/
int record_fits3(base,Pt_enrg,Pt_acq)
int base;
Tb_enrg *Pt_enrg;
Tb_acq  *Pt_acq;
{
  int i;
	 
  message_spy(fd_spy,"\n Entre dans record_fits3()");
  
  for(i=0;i<NB_MAX_FEN;i++)
    {
      if(Pt_enrg->numfen[i]==1)
	{

	  if(write_fits_data_in_file(Pt_acq,i,(Pt_enrg->fich)[i],base,FITS3)==ERROR)
	    {
	      the_errno.where=FICH_OBS;
	      return(ERROR);
	    }
	}
    }


  return(OK);	
}
/*************************************************************************;;#f#>
-----------------
HEAD_OF_FUNCTION: write_fits_header_in_all_files
-----------------
-Purpose:

Ecrit le header fits (Top ou Dyn!!!) de chaque fenetres dans le fichier
d'enregistrement qui lui est associe.

-Prototype:

int write_fits_header_in_all_files(Pt_header,Pt_enrg);

-Parameters:
Mem_header *Pt_header:
Tb_enrg *Pt_enrg:

-Return:
Ok ou bien ERROR s'il y a un probleme.

;;#f#<*************************************************************************/
int write_fits_header_in_all_files(Pt_header,Pt_enrg)
Mem_header *Pt_header;
Tb_enrg *Pt_enrg;
{
  int ii;
  

  
  for(ii=0;ii<NB_MAX_FEN;ii++)
    {
      if(Pt_enrg->numfen[ii] == 1)
	{
	  if(ERROR == write_fits_header_in_file(Pt_header,ii,(Pt_enrg->fich)[ii]))
	    {
	      return(ERROR);
	    }
	}
    }
  return(OK);
}

/*************************************************************************;;#f#>
-----------------
HEAD_OF_FUNCTION: write_fits_header_in_file
-----------------
-Purpose:

Ecrit un header fits (Top ou Dyn!!!) dans un fichier.

-Prototype:

-Parameters:

-Return:
Ok ou bien ERROR s'il y a un probleme.

-Comments:

La completion du header fits a un multiple de 2880 octets est effectuee ici!

;;#f#<*************************************************************************/
int write_fits_header_in_file(Pt_header,num_fen,fd_file)
Mem_header *Pt_header;
long num_fen;
FILE *fd_file;
{
  
  long ii,taille_entete, taille_buf;
  char *entete;
  char buf_tmp[TAILLE_LIGNE];
 

  
  
  /*allocation de la memoire de 'entete' en fonction de la taille de Pt_header (Dyn ou Top)*/
  if((entete = (char*) malloc((Pt_header->common_size)*sizeof(char)+sizeof(Pt_header->de_fen[num_fen]))) == NULL)
    {
      the_errno.code = errno;
      the_errno.ctxt = FORMATAGE;
      return(ERROR);
    }

  /*initialisation de l'entete*/
  strcpy(entete,"\0");

  /*Creation de l'entete complete: info par fenetre + common*/
  strcat(entete,Pt_header->de_fen[num_fen]);
  strcat(entete,Pt_header->common);
  
  /*Completion de l'entete a un multiple de TAILLE_BLOC_FITS = 2880 octets*/
  taille_entete = strlen(entete);
    
  taille_buf = (TAILLE_BLOC_FITS - (taille_entete % TAILLE_BLOC_FITS)) % TAILLE_BLOC_FITS;
      
  for(ii=taille_entete;ii<(taille_entete+taille_buf);ii++)
    {
      entete[ii] = 0X20;
    }

  /*terminaison propre*/
  entete[(taille_entete+taille_buf)] = '\0';
  
  /*Ecriture du header dans le fichier*/
  if(fprintf(fd_file,"%s",entete)< 0)
    {
      free(entete);
      the_errno.code = errno;
      the_errno.ctxt = FORMATAGE;
      return(ERROR);
    }
  
  /*Liberation de la memoire: entete...*/
  free(entete);
 
  
  return(OK);
}


/*************************************************************************;;#f#>
-----------------
HEAD_OF_FUNCTION:write_fits_data_in_file
-----------------

-Purpose:

Write the data (image) of a window into a file respecting with the FITS format.

-Prototype:

int write_fits_data_in_file(Pt_acq,num_fen,fd_file,base);

-Parameters:

Tb_acq *Pt_acq:
int num_fen:
FILE *fd_file:
u_long base:

-Return:

Ok...ou ERROR si lil y a un probleme.

-Comments:

this function is excactly the same as record_fen except that the data is completed
(with blank) up to a multiple of 2880 bytes before writting.

;;#f#<************************************************************************/
int write_fits_data_in_file(Pt_acq,num_fen,fd_file,base,mode)
Tb_acq *Pt_acq;
int num_fen;
FILE *fd_file;
u_long base;
int mode;
{
  u_long  start;
  size_t  nb_elem;
  long taille_data,taille_buf_ajoute,ii;
  void *Pt_buf_ajoute;
  char message[TAILLE_MES];


  
  nb_elem= (Pt_acq->tab_fen)[num_fen].nbcol*(Pt_acq->tab_fen)[num_fen].nblig;	
  start=base*Pt_ctrl->taille_empl+(Pt_acq->tab_info_fen)[num_fen].mem_offset/sizeof(short);
  
  taille_data = nb_elem * sizeof(Datum);

  taille_buf_ajoute = (TAILLE_BLOC_FITS -(taille_data % TAILLE_BLOC_FITS));
  
  /*Allocation de la memoire pour le buffer contenant le complement a ajouter */
  /*a l'image afin d'ecrire une taille multiple de 2880 octets.*/
  Pt_buf_ajoute = (void*) malloc(taille_buf_ajoute);
  
  /*initialisation de ce buffer avec des zeros*/
  bzero(Pt_buf_ajoute,taille_buf_ajoute);

  /*Ecriture de l'image utile dans le fichier*/
  if(nb_elem!=fwrite(&Pt_data[start],sizeof(Datum),nb_elem,fd_file))
    {
      the_errno.code=errno;
      the_errno.ctxt=FENETRES;
      the_errno.numero=num_fen;
      return(ERROR);
    }
  /*Ajout des zeros pour completer l'image a un multiple de 2880 octets*/

  if(mode == FITS2)
    {
      if(taille_buf_ajoute!=fwrite(Pt_buf_ajoute,1,taille_buf_ajoute,fd_file))
	{
	  the_errno.code=errno;
	  the_errno.ctxt=FENETRES;
	  the_errno.numero=num_fen;
	  return(ERROR);
	}
    }

  /*Liberation de la memoire du buffer temporaire*/
  free(Pt_buf_ajoute);
  
  return(OK); 
}
