
static char *SccsId="%W% %G%";

/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:enrg.c
-----------------
-Auteur(s):	Christian Miguel

-Rle:	


-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
		Tb_enrg	*Pt_enrg;	Pointeur sur la table d'enregistrement.
	 	
-Fonctions:
	Internes au fichier:
		rao
		obs
		enrg_attente
		enrg_decode
		enrg_action
		process_enrg
	 
-Commentaires:
Le processus d'enregistrement doit pouvoir changer de mode de fonctionement en tant l'esclave du processus de contrle. Il doit pouvoir passer d'un mode d'attente  un mode de travail en rao ou  un mode de travail en observation. Chaque mode de travail correspond tout de mme  une attente, pas d'ordres du processus de ctrl mais de donnes disponibles dans la mmoire commune.
********************************************************************;-*/



#include 	<stdio.h>
#include	<sys/types.h>
#include	<sys/time.h>
#include 	<sys/signal.h>
#include	<sys/file.h>
#include	<fcntl.h>
#include 	<string.h>

#include	<sun.h>
#include 	<acq.h>
#include 	<enrg.h>
#include        <visu.h>
#include	<the_time.h>

#include	<Vme-alloc.h>

#include 	<process.h>
#include	<param.h>
#include	<errno.h>
#include	<the_errno.h>


extern FILE *fd_spy;


extern Tb_point 	*Pt_point;	/*sur la table des pointeurs */
extern Datum  		*Pt_data;	/*sur la zone de donnees */
extern Tb_acq 		*Pt_acq;	/*sur la table d'acquisition */
extern Tb_ctrl		*Pt_ctrl;	/* sur la table de controle */
extern Tb_ctrl_cam	*Pt_cam;
Tb_enrg *Pt_enrg=NULL;			/* sur la table d'enregistrement */
Tb_visu *Pt_visu=NULL;                  /* sur la table de visu */
extern 	void 		*Pt_vme_base;	/* sur le debut de la memoire vme*/

extern 	int 		tab_pid[NB_PROC];	/* numero des process fils */
extern 	u_long		*Pt_synchro;		/* sur la table de verrous */
extern  u_long          *Pt_shm_pid;    /* pour le mode RT */
extern 	Source_mcle	Mcle_tout[NB_MCLE_TOUT];
extern 	Source_mcle	Mcle_spe[NB_MCLE_SPE];
extern  Source_mcle     Mcle_fix[NB_MCLE_FIX];
extern  Source_mcle     Mcle_sem[NB_MCLE_SEM];
extern  Source_mcle     Mcle_phy[NB_MCLE_PHY];
extern	int		sock_enrg[2];

extern	Erreur		the_errno;

extern  Mem_header      *Pt_top_header;
extern  Mem_header      *Pt_dyn_header;
extern  Param_info      Tb_header_dyn [NB_LI_BLOC_FITS+NB_LI_BLOC_FITS*NB_MAX_FEN];
extern  Param_info      Tb_header_princ[NB_MCLE+NB_MCLE_DEPEND_FEN*NB_MAX_FEN];
extern  Ind_mcle        Liste_ordo[NB_TYPE_HEADER][TAILLE_MAX_LIST_ORDO];

int 	base=0;				/* numero de la zone d'enregistrement*/ 


/*++********************************************************************
------------------
ENTETE DE FONCTION	:enrg_decode
------------------

-Rle:
Regroupe tout ce qu'il faut faire pour lire et dcoder le fichier de paramtres d'acquisition.
-inclure:
-Prototype:
	int enrg_decode()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour: OK ou ERROR
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:
		analyseur_fich (decode.a)
		check_param (decode.a)
		init_tb_acq ""
		init_tb_enrg ""
		init_tb_ctrl_cam ""
-Exemple:
-Commentaires:
********************************************************************--*/


int enrg_decode()
{
  int retour;
  char message[TAILLE_MES];


  init_tb_acq(Pt_acq,OK);
  init_tb_enrg(Pt_enrg,OK);
  init_tb_ctrl_cam(Pt_cam);
  init_tb_visu(Pt_visu);


  retour=analyseur_fich(Mcle_spe,NB_MCLE_SPE,FILE_RAO_PAR,
			Pt_enrg,Pt_visu,Pt_acq,Pt_cam);


  if(((Pt_acq->themisff == FITS3)||
      (Pt_acq->themisff == FITS2)||
      (Pt_acq->themisff == FITS1))
     &&(retour==OK))
    {

      retour=analyseur_fich(Mcle_fix,NB_MCLE_FIX,FILE_RAO_FIX,
			     Pt_enrg,NULL,NULL,NULL);
      if(retour==OK)
	{
	retour=analyseur_fich(Mcle_sem,NB_MCLE_SEM,FILE_RAO_SEM,
			      Pt_enrg,NULL,NULL,NULL);

	if(retour==OK)
	  {
	  retour=analyseur_fich(Mcle_phy,NB_MCLE_PHY,FILE_RAO_PHY,
				Pt_enrg,NULL,Pt_acq,NULL);
	  if(retour !=OK)
	    the_errno.where=FICH_PAR_PHY;
	  }
 	else
	  {
	    the_errno.where=FICH_PAR_SEM;
	  }
	}
      else
	the_errno.where=FICH_PAR_FIX;
    }
  else
    {
      if(retour != OK)
	{
	  the_errno.where=FICH_PARA;
	  sprintf(message," %d ",retour);
	  message_spy(fd_spy,"\nENRG ------------> FICH_PARA en erreur");
	  message_spy(fd_spy,message);
	}
    }

  

  if(retour==OK)
    {
      message_spy(fd_spy,"\nENRG.c Avant check_param");
      retour=check_param(Pt_acq,Pt_enrg,Pt_cam,Pt_visu);
      sprintf(message,"\nENRG: retour de check param : %i",retour);
      message_spy(fd_spy,message);

      if (retour == OK)
	{
	  /* on ne fait rien pour la visu jusqu'a ce qu'elle le demande */
	  Pt_synchro[VISU_ETAT]=ACTION_NOVISU;

	  /* dit a la visu de lire le fichier de parametre d'acquisition */
	  Pt_synchro[VISU_ACTION]=ACTION_DECODE;
	}
      else
	{
	  init_tb_acq(Pt_acq,OK);
	  init_tb_enrg(Pt_enrg,OK);
	}


      Pt_synchro[ENRG_ETAT]=ETAT_OK;
      Pt_synchro[ENRG_COD_ERR]=retour;
    }
  else
    {
      Pt_synchro[ENRG_COD_ERR]=retour;
    }

  sprintf(message,"\nENRG avant de sortir de enrg_decode: %i",retour);
  message_spy(fd_spy,message);
  return(retour);
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:enrg_decode2
------------------

-Rle:
Regroupe tout ce qu'il faut faire pour lire et dcoder le fichier de paramtres d'acquisition.
-inclure:
-Prototype:
	int enrg_decode2()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour: OK ou ERROR
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:
		analyseur_fich (decode.a)
		check_param (decode.a)
		init_tb_acq ""
		init_tb_enrg ""
		init_tb_ctrl_cam ""
-Exemple:
-Commentaires:
********************************************************************--*/


int enrg_decode2()
{
  int retour;
  char message[TAILLE_MES];


  init_tb_acq(Pt_acq,OK);
  init_tb_enrg(Pt_enrg,OK);
  init_tb_ctrl_cam(Pt_cam);
  init_tb_visu(Pt_visu);


  retour=analyseur_fich(Mcle_tout,NB_MCLE_TOUT,FILE_RAO_PAR,
			Pt_enrg,Pt_visu,Pt_acq,Pt_cam);


  if(retour != OK)
    {
      the_errno.where=FICH_PARA;
      sprintf(message," %d ",retour);
      message_spy(fd_spy,"\nENRG ------------> FICH_PARA en erreur");
      message_spy(fd_spy,message);
    }

  if(retour==OK)
    {
      message_spy(fd_spy,"\nENRG.c Avant check_param");
      retour=check_param(Pt_acq,Pt_enrg,Pt_cam,Pt_visu);
      sprintf(message,"\nENRG: retour de check param : %i",retour);
      message_spy(fd_spy,message);

      if (retour == OK)
	{
	  /* on ne fait rien pour la visu jusqu'a ce qu'elle le demande */
	  Pt_synchro[VISU_ETAT]=ACTION_NOVISU;

	  /* dit a la visu de lire le fichier de parametre d'acquisition */
	  Pt_synchro[VISU_ACTION]=ACTION_DECODE;
	}
      else
	{
	  init_tb_acq(Pt_acq,OK);
	  init_tb_enrg(Pt_enrg,OK);
	}


      Pt_synchro[ENRG_ETAT]=ETAT_OK;
      Pt_synchro[ENRG_COD_ERR]=retour;
    }
  else
    {
      Pt_synchro[ENRG_COD_ERR]=retour;
    }

  sprintf(message,"\nENRG avant de sortir de enrg_decode2: %i",retour);
  message_spy(fd_spy,message);
  return(retour);
}

 
/*++********************************************************************
------------------
ENTETE DE FONCTION	: enrg_action
------------------

-Rle:
	Lance l'action qu'on lui demande. besoin utilisateur la pluspart
	du temps.
-inclure:
-Prototype:
	int enrg_action()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

int enrg_action()
{
char message[TAILLE_MES];

  switch(Pt_synchro[ENRG_ACTION])
    {

    case	ACTION_DECODE:
      {		  
	if(enrg_decode()!=OK)
	  {
	    message_spy(fd_spy,"\nENRG: probleme ds enrg_action,decode");
	    write(sock_enrg[0],&the_errno,sizeof(Erreur));
	    clean_erreur();
	  }
	else
	  {
	    indice_fenetre(Pt_acq);
	  }

	Pt_synchro[ENRG_ACTION]=ACTION_RIEN;			
	Pt_synchro[VISU_COMPT]=NOTH;
	break;
      }

    case	ACTION_DECODE2:
      {		  
	if(enrg_decode2()!=OK)
	  {
	    message_spy(fd_spy,"\nENRG: probleme ds enrg_action,decode2");
	    write(sock_enrg[0],&the_errno,sizeof(Erreur));
	    clean_erreur();
	  }
	else
	  {
	    indice_fenetre(Pt_acq);
	  }

	Pt_synchro[ENRG_ACTION]=ACTION_RIEN;			
	Pt_synchro[VISU_COMPT]=NOTH;
	break;
      }

    case	ACTION_WAIT:
      {
	Pt_synchro[ENRG_ACTION]=ACTION_RIEN;
	Pt_synchro[VISU_ACTION]=ACTION_RIEN;
	break;
      }

    case 	ACTION_DIE:
      {
	message_spy(fd_spy,"\nENRG sortie sur ACTION_DIE");
	Pt_synchro[VISU_ACTION]=ACTION_RIEN;
	Pt_synchro[ENRG_ETAT]=ETAT_OK;
	fin_enrg();
	break;
      }
		
    case	ACTION_ENRG:
      {
	Pt_synchro[ENRG_ETAT]=ETAT_OK;
	Pt_synchro[ENRG_ACTION]=ACTION_RIEN;
	Pt_synchro[VISU_ACTION]=ACTION_RIEN;
	init_tb_enrg(Pt_enrg,NOTH);
	init_tb_acq(Pt_acq,NOTH);
	break;
      }
    }

  return(OK);
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:enrg_attente
------------------

-Rle:
	Reprsente l'tat d'attente du systme d'enregistrement.
	Cette fonction est en attente d'un venement qui est une demande
	d'action du processus de contrle ou de l'utilisateur.
-inclure:
-Prototype:
	int enrg_attente()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		ENRG_ETAT	(process.h)
		ETAT_WAIT
		ACTION_RIEN	
		TIME_SLEEP_ENR	(enrg.h)
	
-Fonctions utilises
	Internes au fichier:
	Importes:
		 
-Exemple:
-Commentaires:
********************************************************************--*/


int enrg_attente()
{
  

  
  Pt_synchro[ENRG_ETAT]=ETAT_WAIT;
  message_spy(fd_spy,"\nENRG: Debut d'etat attente");

  while(Pt_synchro[ENRG_ETAT]==ETAT_WAIT)
    {

      while(Pt_synchro[ENRG_ACTION]==ACTION_RIEN)
	{
	  micro_sleep(0,TIME_SLEEP_ENR);
	}
      message_spy(fd_spy,"\nENRG: attente, lance une action");
      enrg_action();
    }

  message_spy(fd_spy,"\nENRG: Fin d'etat attente");
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:rao
------------------

-Rle:
	Cette fonction est la fonction principale qui gre l'enregistrement 
	en mode reglage.
-inclure:
-Prototype:
	int rao()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	0 si tout va bien
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		ENRG_ACTION	(process.h)
		ACTION_RIEN
		VISU_ACTION
		SUN_BUSY	(acq.h)
		SUN_NOT_BUSY
		TIME_SLEEP_ENR	(enrg.h)
	
-Fonctions utilises
	Internes au fichier:
	Importes:
		total_data	(shared_mem.c)

-Exemple:
-Commentaires:
********************************************************************--*/


int rao()
{

  while(Pt_synchro[ENRG_ACTION]==ACTION_RIEN)
    {
      micro_sleep(0,TIME_SLEEP_ENR);
      if(SUN_NOT_BUSY==is_locked_zone(Pt_ctrl,base))
	{
	  message_spy(fd_spy,"\nENRG: rao active action visu");
	  
	  Pt_synchro[VISU_COMPT]++;

	  if(ERROR==record_rao(base,Pt_enrg,Pt_acq))
	    return(ERROR);
	   message_spy(fd_spy,"\nENRG: rao apres record_rao");

	  if(Pt_synchro[VISU_ETAT]==ACTION_WAIT)
	    {
	      
	      message_spy(fd_spy,"\nENRG: ecriture pour la visu");
	      if(ERROR==record_visu(base,Pt_acq))
		return(ERROR);
	      Pt_synchro[VISU_ETAT]=ACTION_NOVISU;
	      
	    }

	  lock_zone(Pt_ctrl,base,SUN_BUSY);
	  base=base^1;
	}
    }
  return(OK);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:obs
------------------

-Rle:
	Cette fonction est la fonction principale qui gre l'enregistrement 
	en mode observation.
-inclure:
-Prototype:
	int obs()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	0 si tout va bien
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		ENRG_ACTION	(process.h)
		ACTION_RIEN
		VISU_ACTION
		SUN_BUSY	(acq.h)
		SUN_NOT_BUSY
		TIME_SLEEP_ENR	(enrg.h)
	
-Fonctions utilises
	Internes au fichier:
	Importes:
		total_data	(shared_mem.c)

-Exemple:
-Commentaires:
********************************************************************--*/


int obs()
{
  FILE	*fd_images;
 

  message_spy(fd_spy,"\nENRG: Entre dans obs");
  if(ERROR == open_file(Pt_enrg))
    return(ERROR);


  while(Pt_synchro[ENRG_ACTION]==ACTION_RIEN)
    {
      micro_sleep(0,TIME_SLEEP_ENR);
      /* message_spy(fd_spy,"\n after microsleep");*/
      if(SUN_NOT_BUSY==is_locked_zone(Pt_ctrl,base))
	{

	  Pt_synchro[VISU_COMPT]++;

	  message_spy(fd_spy,"\nENRG: start recording...");

	  if(record_obs(base,Pt_enrg,Pt_acq)==ERROR)
	    return(ERROR);

	  message_spy(fd_spy,"\nENRG: end recording...");
	  lock_zone(Pt_ctrl,base,SUN_BUSY);
	  
	  message_spy(fd_spy,"\nENRG: zone unlocked...");

	  if(base == 0)
	    {
	      if(Pt_synchro[VISU_ETAT]==ACTION_WAIT)
		{
		  if(ERROR==record_visu(base,Pt_acq))
		    return(ERROR);
		  Pt_synchro[VISU_ETAT]=ACTION_NOVISU;
		}

	      message_spy(fd_spy,"\nENRG: visu written , before microsleep");
	    }
	  

	  base=base^1;
	}
    }
 	
  if(ERROR == close_file(Pt_enrg))
    {
      the_errno.code=errno;
      the_errno.where=FICH_OBS;
      return(ERROR);
    }
}



/*****************************************************************;;#f#>
-----------------
HEAD_OF_FUNCTION: process_enrg()
-----------------
-Rle:
Cette fonction est la fonction principale du processus d'enregistrement.
C'est une sorte de main qui coordonne et organise les procdures de cette 
tche.
-inclure:
-Prototype:
	void process_enrg()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:
		Pt_synchro		(controle.c)
-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		ENRG_ETAT		(process.h)
		ENRG_ACTION
		ACTION_DIE
		ETAT_WAIT	   	

	
-Fonctions utilises
	Internes au fichier:
	Importes:
		initialise_rao		(ready-enrg.c)
		get_ready_enrg	 
		fin_enrg		 
-Exemple:
-Commentaires:
	en cours de developpement. 

;;#f#<*****************************************************************/


void process_enrg()
{
  /* initialisation */
  char message[TAILLE_MES];

  /*
  sleep(1);
  message_spy(fd_spy,"\n ENRG: Lancement du trt errs dans le VME");
  init_err_vme();
  */

  alarm(TIME_OUT_ENRG);
  message_spy(fd_spy,"\n ENRG: avant get ready enrg");
  if(ERROR==get_ready_enrg())
    {
      kill(getppid(),SIGINT);
      fin_enrg();
    }	
  alarm(0);
		
  message_spy(fd_spy,"\n ENRG: avant initialise_rao");
  if(ERROR==initialise_rao())
    {
      write(sock_enrg[0],&the_errno,sizeof(Erreur));
      clean_erreur();
      fin_enrg();	
    }
  /* pour indiquer au serveur qu'un process de + est ok */
  Pt_synchro[CTRL_EXT]++;	


  sprintf(message,"\nENRG valeur de ctrl ext %i",Pt_synchro[CTRL_EXT]);
  message_spy(fd_spy,message);
  message_spy(fd_spy,"\nENRG : avant boucle ppale");

  Pt_shm_pid[0]=getpid();
  /* boucle principale */

  while(Pt_synchro[ENRG_ACTION]!=ACTION_DIE)
    {	
      Pt_synchro[ENRG_ETAT]=ETAT_WAIT;
      enrg_attente();		

      switch(Pt_acq->themisff)
	{
	  
	case FITS0:
	  {
	    switch(Pt_acq->modob)
	      {
	
	      case MODE_STK:
		{
		  message_spy(fd_spy,"\nENRG: mode FITS0 - STK");
		  if(ERROR==obs())
		    {
		      message_spy(fd_spy,"\nENRG:  erreur mode FITS0 - STK");
		      write(sock_enrg[0],&the_errno,sizeof(Erreur));
		      clean_erreur();
		    }
		  break;	
		}
	      
	      case MODE_RAO:
		{
		  message_spy(fd_spy,"\nENRG: mode FITS0 - RAO");
		  if(ERROR==rao())
		    {
		      message_spy(fd_spy,"\nENRG: erreur mode FITS0 - RAO");
		      write(sock_enrg[0],&the_errno,sizeof(Erreur));
		      clean_erreur();
		    }
		  break;
		}
		
	      default:
		{
		  message_spy(fd_spy,"\nENRG: FITS0 - mode rien avant enrg_attente()");
		  break;
		}
		
	      }
	    break;
	  }
	
	case FITS1:
	  {
	    message_spy(fd_spy,"\nENRG:  mode FITS1");
	    if(ERROR==fits1())
	      {
		message_spy(fd_spy,"\nENRG:  erreur mode FITS1");
		write(sock_enrg[0],&the_errno,sizeof(Erreur));
		clean_erreur();
	      }
	    break;
	  }
	
	case FITS2:
	  {
	    message_spy(fd_spy,"\nENRG:  mode FITS2");
	    if(ERROR==fits2())
	      {
		message_spy(fd_spy,"\nENRG:  erreur mode FITS2");
		write(sock_enrg[0],&the_errno,sizeof(Erreur));
		clean_erreur();
	      }
	    break;
	  }
	
	case FITS3:
	  {
	    message_spy(fd_spy,"\nENRG:  mode FITS3");
	    if(ERROR==fits3())
	      {
		message_spy(fd_spy,"\nENRG:  erreur mode FITS3");
		write(sock_enrg[0],&the_errno,sizeof(Erreur));
		clean_erreur();
	      }
	    break;
	  }
	
	default:
	  {
	    message_spy(fd_spy,"\nENRG: Valeur THEMISFF non valide avant enrg_attente()");
	    break;
	  }
	}
    }
  message_spy(fd_spy,"\nENRG, normalement je devrais pas ecrire ca");
  fin_enrg();
}

/***********************************************************************;;#f#>
-----------------
HEAD_OF_FUNCTION: fits1
-----------------

-Purpose:

Fonction principale qui gere l'enregistrement des images au format FITS1:
une image (avec entete) au format FITS par fichier.

-Prototype:
int fits1()

-Return:
0K si tout va bien ...sinon ERROR.

;;#f#<***********************************************************************/
int fits1()
{
  int retour;
  
  
  message_spy(fd_spy,"\nEntre dans fits1()");
  
  /*Allocation memoire pour l'entete principale*/
  if((Pt_top_header = alloc_Mem_header(TOP_HEADER)) == NULL)
    {
      return(ERROR);
    }
  
  /*Allocation memoire pour l'entete dynamique (sous-entete)*/
  if((Pt_dyn_header = alloc_Mem_header(DYN_HEADER)) == NULL)
    {
      free_Mem_header(Pt_top_header);
      return(ERROR);
    }

  if(ERROR == store_da0(Tb_header_princ,Pt_acq,Pt_enrg,TOP_HEADER))
     {
       return(ERROR);
     }


  while(Pt_synchro[ENRG_ACTION]==ACTION_RIEN)
    {
      micro_sleep(0,TIME_SLEEP_ENR);
      if(SUN_NOT_BUSY==is_locked_zone(Pt_ctrl,base))
	{
	  message_spy(fd_spy,"\n Dans ENRG fits1(): active action visu");
	  
	  Pt_synchro[VISU_COMPT]++;
	  
	  if(ERROR==record_fits1(base,Pt_enrg,Pt_acq))
	    {
	      free_Mem_header(Pt_top_header);
	      free_Mem_header(Pt_dyn_header);
	      return(ERROR);
	    }
	  message_spy(fd_spy,"\n Dans ENRG fits1() apres record_fits1()");
	  
	  if(Pt_synchro[VISU_ETAT]==ACTION_WAIT)
	    {
	      if(base==0)
		{
		  message_spy(fd_spy,"\n ecriture pour la visu");
		  if(ERROR==record_visu(base,Pt_acq))
		    {
		      free_Mem_header(Pt_top_header);
		      free_Mem_header(Pt_dyn_header);
		      return(ERROR);
		    }
		  Pt_synchro[VISU_ETAT]=ACTION_NOVISU;
		}
	    }
	  
	  lock_zone(Pt_ctrl,base,SUN_BUSY);
	  base=base^1;
	}
    }
  
  /*Liberation de la memoire de l'entete principale et de l'entete dynamique*/
  free_Mem_header(Pt_top_header);
  free_Mem_header(Pt_dyn_header);
  return(OK);
}


/***********************************************************************;;#f#>
-----------------
HEAD_OF_FUNCTION: fits2
-----------------

-Purpose:

Fonction principale qui gere l'enregistrement des images au format FITS2:
chaque fichier (1 par fenetre) possede une entete principale et peut
contenir plusieurs images avec chacune une entete dynamique.

-Prototype:
int fits2()

-Return:
0K si tout va bien ...sinon ERROR.

;;#f#<***********************************************************************/
int fits2()
{  
  
  int retour;
  int type_header=TOP_HEADER;
  
  message_spy(fd_spy,"\nEntre dans fits2()");
  
  /*Allocation memoire pour l'entete principale*/
  if((Pt_top_header = alloc_Mem_header(TOP_HEADER)) == NULL)
    {
      return(ERROR);
    }
  
  /*Allocation memoire pour l'entete dynamique (sous-entete)*/
  if((Pt_dyn_header = alloc_Mem_header(DYN_HEADER)) == NULL)
    {
      free_Mem_header(Pt_top_header);
      return(ERROR);
    }
  if(ERROR == store_da0(Tb_header_princ,Pt_acq,Pt_enrg,TOP_HEADER))
     {
       return(ERROR);
     }
  retour = build_Tb_header_dyn(Tb_header_princ,Pt_acq,Pt_enrg,Pt_ctrl,TOP_HEADER);
  if(retour == ERROR)
    {
      free_Mem_header(Pt_dyn_header);
      return(ERROR);
    }

  /*Creation de l'entete fits principale en memoire*/
  retour = gen_header(Pt_top_header,Tb_header_princ,Pt_enrg,Liste_ordo,TOP_HEADER);
  if(retour == ERROR)
    {
      free_Mem_header(Pt_top_header);
      free_Mem_header(Pt_dyn_header);
      return(ERROR);
    }
  
  
  /*ouverture des fichiers a enregistrer*/
  if(ERROR == open_file(Pt_enrg))
    {
      free_Mem_header(Pt_top_header);
      free_Mem_header(Pt_dyn_header);
      return(ERROR);
    }
  
  /*ajout des informations disponibles uniquement apres ouvertures des fichiers*/
  /*i.e. FILENAME,FILORIG,DATE,DATE_END.*/
  if(ERROR == complete_mem_header_princ(Pt_top_header,Pt_enrg))
    {
      free_Mem_header(Pt_top_header);
      free_Mem_header(Pt_dyn_header);
      return(ERROR);
    }
  
  /*Ecriture des entetes top dans tous les fichiers*/
  if(ERROR == write_fits_header_in_all_files(Pt_top_header,Pt_enrg))
    {
      free_Mem_header(Pt_top_header);
      free_Mem_header(Pt_dyn_header);
      return(ERROR);
    }

  
  /*Liberation de la memoire de l'entete principale*/
  free_Mem_header(Pt_top_header);
  
  while(Pt_synchro[ENRG_ACTION]==ACTION_RIEN)
    {
      micro_sleep(0,TIME_SLEEP_ENR);
      if(SUN_NOT_BUSY==is_locked_zone(Pt_ctrl,base))
	{
	  message_spy(fd_spy,"\n Dans ENRG fits2(): active action visu");
	  
	  Pt_synchro[VISU_COMPT]++;
	  
	  if(ERROR==record_fits2(base,Pt_enrg,Pt_acq,type_header))
	    {
	      free_Mem_header(Pt_dyn_header);
	      return(ERROR);
	    }
	  type_header=DYN_HEADER;
	  message_spy(fd_spy,"\n Dans ENRG fits2() apres record_fits2()");
	  
	  if(Pt_synchro[VISU_ETAT]==ACTION_WAIT)
	    {
	      if(base==0)
		{
		  message_spy(fd_spy,"\n ecriture pour la visu");
		  if(ERROR==record_visu(base,Pt_acq))
		    {
		      free_Mem_header(Pt_dyn_header);
		      return(ERROR);
		    }
		  Pt_synchro[VISU_ETAT]=ACTION_NOVISU;
		}
	    }
	  
	  lock_zone(Pt_ctrl,base,SUN_BUSY);
	  base=base^1;
	}
    }
  
  /*liberation de la memoire de l'entete dynamique*/
  free_Mem_header(Pt_dyn_header);
  
  /*Fermetures des fichiers ...*/
  if(ERROR == close_file(Pt_enrg))
    return(ERROR);
  
  return(OK);
}

/***********************************************************************;;#f#>
-----------------
HEAD_OF_FUNCTION: fits3
-----------------

-Purpose:

Fonction principale qui gere l'enregistrement des images au format FITS3:
chaque fichier (1 par fenetre) possede une entete principale et un ensemble
d'image sans mini-entetes.

-Prototype:
int fits3()

-Return:
0K si tout va bien ...sinon ERROR.

;;#f#<***********************************************************************/
int fits3()
{
  int ii,retour, num_cycle_image=0;
  
  message_spy(fd_spy,"\nEntre dans fits3()");
  
  /*Allocation memoire pour l'entete principale*/
  if((Pt_top_header = alloc_Mem_header(TOP_HEADER)) == NULL)
    {
      return(ERROR);
    }
  
  /*Allocation memoire pour l'entete dynamique (sous-entete)*/

  if((Pt_dyn_header = alloc_Mem_header(DYN_HEADER)) == NULL)
    {
      free_Mem_header(Pt_top_header);
      return(ERROR);
    }
  if(ERROR == store_da0(Tb_header_princ,Pt_acq,Pt_enrg,TOP_HEADER))
     {
       return(ERROR);
     }

  retour = build_Tb_header_dyn(Tb_header_princ,Pt_acq,Pt_enrg,Pt_ctrl,TOP_HEADER);
  if(retour == ERROR)
    {
      free_Mem_header(Pt_dyn_header);
      return(ERROR);
    }
  
  /*Creation (et allocation) de l'entete fits principale en memoire*/
  retour = gen_header(Pt_top_header,Tb_header_princ,Pt_enrg,Liste_ordo,TOP_HEADER);
  if(retour == ERROR)
    {
      free_Mem_header(Pt_top_header);
      free_Mem_header(Pt_dyn_header);
      return(ERROR);
    }
  
  
  /*ouverture des fichiers a enregistrer*/
  if(ERROR == open_file(Pt_enrg))
    {
      free_Mem_header(Pt_top_header);
      free_Mem_header(Pt_dyn_header);
      return(ERROR);
    }
  
  /*ajout des informations disponibles uniquement apres ouvertures des fichiers*/
  /*i.e. FILENAME,FILORIG,DATE,DATE_END.*/
  if(ERROR == complete_mem_header_princ(Pt_top_header,Pt_enrg))
    {
      free_Mem_header(Pt_top_header);
      free_Mem_header(Pt_dyn_header);
      return(ERROR);
    }
  
  /*Ecriture des entetes top dans tous les fichiers*/

  if(ERROR == write_fits_header_in_all_files(Pt_top_header,Pt_enrg))
    {
      free_Mem_header(Pt_top_header);
      free_Mem_header(Pt_dyn_header);
      return(ERROR);
    } 

  /*Liberation de la memoire de l'entete principale*/
  free_Mem_header(Pt_top_header);
  
  message_spy(fd_spy,"\n Dans ENRG fits3(): apres free_Mem_header(Pt_top_header) ");

  num_cycle_image = 0;
  
  while(Pt_synchro[ENRG_ACTION]==ACTION_RIEN)
    {
      micro_sleep(0,TIME_SLEEP_ENR);
      if(SUN_NOT_BUSY==is_locked_zone(Pt_ctrl,base))
	{

	  
	  Pt_synchro[VISU_COMPT]++;
	  
	  /*generation et copy de l'entete dynamique uniquement et juste*/
	  /*avant l'ecriture de la premiere image dans les fichiers*/
	  num_cycle_image ++;
	  if(num_cycle_image == 1)
	    {
	      /*On s'apprete a faire l'enregistrement de la premiere image dans*/
	      /*chaque fichier...donc preparer et ecrire ce qui sera la seule*/
	      /* entete dynamique du fichier*/
	      /*Re-construction du tableau pour les informations dynamiques (sous-entetes)*/
	      /*
	      retour = build_Tb_header_dyn(Tb_header_princ,Pt_acq,Pt_enrg,Pt_ctrl,TOP_HEADER);
	      if(retour == ERROR)
		{
		  free_Mem_header(Pt_dyn_header);
		  return(ERROR);
		}
		*/
	      /*generation de l'entete dynamique de la premiere image pour chaque fenetre*/
	      /* test_sans_dyn
	      retour = gen_header(Pt_dyn_header,Tb_header_dyn,Pt_enrg,Liste_ordo,DYN_HEADER);
	      if(retour == ERROR)
		{
		  free_Mem_header(Pt_dyn_header);
		  return(ERROR);
		}
		*/
	      /*ecriture de ces entetes*/ 
	      /* test_sans_dyn
	      if(ERROR == write_fits_header_in_all_files(Pt_dyn_header,Pt_enrg))
		{
		  free_Mem_header(Pt_dyn_header);
		  return(ERROR);
		}
		*/
	      /*Liberation des entetes fits dynamiques en zone memoire*/
	      
	      free_Mem_header(Pt_dyn_header);
	      
	    }
	  
	  
	  if(ERROR==record_fits3(base,Pt_enrg,Pt_acq))
	    return(ERROR);

	  
	  if(Pt_synchro[VISU_ETAT]==ACTION_WAIT)
	    {
	      
	      if(base==0)
		{
		  if(ERROR==record_visu(base,Pt_acq))
		    return(ERROR);
		  Pt_synchro[VISU_ETAT]=ACTION_NOVISU;
	      
		}
	    }
	  lock_zone(Pt_ctrl,base,SUN_BUSY);
	  base=base^1;
	}
    }
  
  /*Fermetures des fichiers ...*/
  if(ERROR == close_file(Pt_enrg))
    return(ERROR);
  
  return(OK);
}






