
static char *SccsId="%W% %G%";

/*;+********************************************************************
-----------------
HEAD OF FILE	:controle.c
-----------------
-Author(s):	Christian Miguel
-Role:		 
This contains the principal functions that creates the control process which then
will create the recording process

	
-Variables
u_long	*Pt_synchro;
synchronise the process.
	
-Functions:

fin_ctrl
hand_ctrl
init_ctrl
process_ctrl
init_synchro
ctrl_action
check

-Comments:
That's all right

********************************************************************;-*/

#include 	<stdio.h>
#include	<sys/signal.h>
#include	<sys/file.h>
#include	<errno.h>
#include 	<fcntl.h>

#include	<sun.h>
#include 	<acq.h>
#include	<process.h>
#include	<enrg.h>
#include	<the_time.h>
#include	<the_errno.h>
 

/* procedures principales des deux processus*/
extern 		void process_enrg();


/* tableau des procedures */
void 		(*tab_fonc[NB_PROC])(void);	 
int 		tab_pid[NB_PROC]; 


/* pointeur sur le segment de memoire partagee, organe de communication inter
	processus */
long		*Pt_synchro=NULL; 

/* pointeur sur les tables de la memoire commune, base de l'acquisition */

extern Tb_point	*Pt_point;
extern Tb_acq	*Pt_acq;
extern Tb_ctrl	*Pt_ctrl;
extern Datum	*Pt_data;

/* pointeur utile pour le mapping sur la memoire commune*/
extern void	*Pt_vme_base;
extern int	desc_pont;

/* variables globales pour le traitement des erreurs */

extern int 		the_nb_err;
extern Erreur 		the_errno;
extern Erreur 		*historique_err;
extern Fonc_trt		aiguillage_err[NB_ERR];

extern 	FILE		*fd_fich_err;

int sock_enrg[2];
/*
int sock_vme;
*/



extern FILE* fd_spy;


/*++********************************************************************
------------------
HEAD OF FUNCION      :fin_ctrl
------------------

-Role:
cleans evry thing before sayin' good bye

-Prototype:
	void fin_ctrl()
-Parametres:
-Variables globales utilises
long *Pt_synchro	,the memory share segment, IPC sys 5

Tb_point *Pt_point	(Sun-inst-pont.c)

-Return:
nothin', this is the end, the end, my only...

	
-uses:
--functions:
	ferme_pont	(Sun-inst-pont.a)
	fin_ctrl_err	(util_err.a)
	fin_trt_err	(util_err.a)

-Exemple:
-Commentaires:
********************************************************************--*/


void fin_ctrl()
{
  char  message[TAILLE_MES];

  if(Pt_synchro!=NULL)
    {
      Pt_synchro[ENRG_ACTION]=ACTION_DIE;
      sleep(1);
    }

  if(Pt_point!=NULL)
    {
      ferme_pont();

      message_spy(fd_spy,"\nCTRL fermeture du pont");

    }
  else
    message_spy(fd_spy,"\nCTRL fermeture inutile du pont de bus");
      

  /*
  if(sock_vme!=NULL)
    {
      fin_err_vme();
    }
    */
  if(sock_enrg[1]!=ERROR)
    {
      message_spy(fd_spy,"\n CTRL:checking errors before leaving");
      check();
    }


  message_spy(fd_spy,"\n Exit acq");


  if(Pt_acq!=NULL)
    exit_acq();

	
  fin_ctrl_err();
  fin_trt_err(fd_fich_err);
				

  if(Pt_synchro!=NULL)
    {

      Pt_synchro[CTRL]=SYNCHRO;
      Pt_synchro[CTRL_EXT]=-NB_PROC;
      shmdt(Pt_synchro);
    }


  printf("\n father killing himself ");


  _exit(OK);
}



/*++********************************************************************
------------------
HEAD OF FUNCTION	:hand_ctrl
------------------

-Role:
This function is a message (software interrupt) handler usefull in
case of crash, to avoid passing through the cleaning stage (fin_ctrl etc...)

-Prototype:
	void hand_ctrl(s)
-Parameters:
	int s; signal
-uses:
--function:
fin_ctrl
--variables:	
long *Pt_synchro;
	

-Return:
noth


********************************************************************--*/



void hand_ctrl(s)
int s;
{
  switch(s)
    {
    case SIGINT:
      {
	message_spy(fd_spy,"\nCTRL: SIGINT USER EXIT\n");
	fin_ctrl();
	break;	
      }

    case SIGBUS:
      {
	message_spy(fd_spy,"\nCTRL: SIGBUS Bus error...\n");
	fin_ctrl();
	break;	
      }
    case SIGSEGV:
      {
	message_spy(fd_spy,"\nCTRL: SIGSEGV Segmentation fault...\n");
	fin_ctrl();
	break;
      }
    case SIGCHLD:
      {
	message_spy(fd_spy,"\nCTRL: SIGCHLD Sigchld");
	fin_ctrl();
	break;
      }
    case SIGALRM:
      {
	message_spy(fd_spy,"\nCTRL: SIGALARM TIME_OUT");
	fin_ctrl();
      }
    }	
}


/*++********************************************************************
------------------
HEAD OF FUNCTION	:init_synchro
------------------

-Role:
Creation et initialisation of shared memory segments for process synchro
-Prototype:
	int init_synchro()


-Returnr:
OK or ERROR, there is an error control

-uses:
--functions:
shared_segment (process.a)


********************************************************************--*/


int init_synchro()
{
  int i;
  Pt_synchro=(long *)shared_segment(CLE,NB_SH_SEG);	 	
	
  if(Pt_synchro==NULL)
    {
      the_errno.code=errno;
      the_errno.ctxt=INIT;
      return(ERROR);
    }
  else
    {
      Pt_synchro[CTRL]=SYNCHRO;
      Pt_synchro[ENRG]=SYNCHRO;
      Pt_synchro[ENRG_ACTION]=ACTION_RIEN;
      Pt_synchro[CTRL_ACTION]=ACTION_RIEN;
      Pt_synchro[ENRG_PID]=NOTH;
      Pt_synchro[VISU_ETAT]=ACTION_NOVISU;
    }

  return(OK);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:init_ctrl
------------------

-Rle:
init of control process
-inclure:
-Prototype:
	void init_ctrl()
-Parametres:
-uses:
--Variables:
*tab_fonc[NB_PROC]  array of functions for the child process
int tab_pid[NB_PROC]; 	array of child proces pid
--Constants:
VISU	(process.h)
ENRG	(process.h)
--functions
init_synchro
adresse_tb_point	(Sun-clnt-vme.a)
installe_pont		(Sun-clnt-vme.a)

-Return:
OK or ERROR, there is an error control


********************************************************************--*/

int init_ctrl()
{
  u_long adresse;
  int retour;

  
  message_spy(fd_spy,"\nCTRL--> Avant init_acq\n");
  if(OK != init_acq())
    {
      message_spy(fd_spy,"\nCTRL--> Erreur init_acq\n");
      clean_erreur();
      the_errno.code=E_ALLOC_VME;
      the_errno.ctxt=INIT;
      return(ERROR);
    }

  adresse=adresse_tb_point();  
  printf("adresse=%lu\n", adresse);
  if(adresse!=NULL)
    {
      message_spy(fd_spy,"\n(init_ctrl) apres adresse_tb_point\n");

      if(installe_pont(adresse)  == NULL)
	return(ERROR);
      else
	{
	  message_spy(fd_spy,"\n(init_ctrl) apres installe_pont\n");

	  Pt_synchro[CTRL]=(long)Pt_vme_base;		
	  
	  while(Pt_synchro[ENRG]==SYNCHRO)
	    micro_sleep(0,TIME_SLEEP_CTRL);
	}
    }
  else
    {
      the_errno.code=E_PONT_BUSY;
      the_errno.ctxt=INIT;
      return(ERROR);
    }
  return(OK);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:ctrl_action
------------------

-Rle:
Utilise le segment de mmoire partag pour lancer les actions. Cette fonction permet de lancer des dcodages du fichier de paramtres d'acqusition ou de tuer un processus.
-inclure:
-Prototype:
	int ctrl_action();
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


int  ctrl_action()
{
  char message[TAILLE_MES];
  long timeout=0;

  switch(Pt_synchro[CTRL_ACTION])
    {

    case ACTION_DECODE:
      {
	message_spy(fd_spy,"\nCTRL: lance decodage");
	Pt_synchro[ENRG_ACTION]=ACTION_DECODE;
	
	
	while((Pt_synchro[ENRG_ACTION]==ACTION_DECODE)&&
	      (Pt_synchro[ENRG_ETAT]!=ETAT_DEAD)&&
	      (timeout!=200))
	  {
	    micro_sleep(0,TIME_SLEEP_CTRL);
	    timeout++;
	  }

	Pt_synchro[CTRL_ACTION]=ACTION_RIEN;
	message_spy(fd_spy,"\nCTRL: sort de controle action");
	break;
      }

    case ACTION_DECODE2:
      {
	message_spy(fd_spy,"\nCTRL: lance decodage2");
	Pt_synchro[ENRG_ACTION]=ACTION_DECODE2;
	
	
	while((Pt_synchro[ENRG_ACTION]==ACTION_DECODE2)&&
	      (Pt_synchro[ENRG_ETAT]!=ETAT_DEAD)&&
	      (timeout!=200))
	  {
	    micro_sleep(0,TIME_SLEEP_CTRL);
	    timeout++;
	  }

	Pt_synchro[CTRL_ACTION]=ACTION_RIEN;
	message_spy(fd_spy,"\nCTRL: sort de controle action");
	break;
      }

    case ACTION_DIE:
      {
	Pt_synchro[ENRG_ACTION]=ACTION_DIE;

	break;
      }
    }
  return(OK);
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:check
------------------

-Rle:
Vrifie que tout va bien.
-Commentaires:
********************************************************************--*/


int check()
{
char message[TAILLE_MES];

  while(read(sock_enrg[1],&the_errno,sizeof(Erreur))>0)
    {
      sprintf(message,"\n Recept err de enrg code %d",the_errno.code);
      message_spy(fd_spy,message);
      (aiguillage_err[the_errno.code])(&the_errno);
    }
	
  /*
  while(read(sock_vme,&the_errno,sizeof(Erreur))>0)
    {
      sprintf(message,"\nRecept err du vme code %d",the_errno.code);
      message_spy(fd_spy,message);
      (aiguillage_err[the_errno.code])(&the_errno);
    }
    */
  return(OK);
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:process_ctrl
------------------

-Rle:
	C'est la fonction principale du processus de contrle.
-inclure:
-Prototype:
	void process_ctrl()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
		void (*tab_fonc[NB_PROC])(void)  
		Tableau des programes associs aux processus fils.
		int tab_pid[NB_PROC]; 
		Tableau des numros des processus fils.

	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		CTRL		(process.h)
		VISU		"
		ENRG		"	
		ENRG_ETAT 	"
		VISU_ETAT	"
		NB_PROC		"
		TIME_SLEEP_CTRL (the_time.h)
	
-Fonctions utilises
	Internes au fichier:
	Importes:
		init_ctrl_err (util_err.a)
		init_trt_err  (util_err.a)

-Exemple:
-Commentaires:

********************************************************************--*/

 
void process_ctrl()
{
  char message[TAILLE_MES];
  tab_fonc[ENRG]=process_enrg;


  signal(SIGBUS,hand_ctrl);
  signal(SIGSEGV,hand_ctrl);
  signal(SIGCHLD,hand_ctrl);
  signal(SIGINT,hand_ctrl);
  signal(SIGALRM,hand_ctrl);

  sock_enrg[0]=ERROR;
  sock_enrg[1]=ERROR;
  /*
  sock_vme=ERROR;
  */

  /* mise en place du traitement des erreurs */
  message_spy(fd_spy,"\n mise en place du traitement des erreurs");

  if((ERROR==init_ctrl_err(sock_enrg))||
     (ERROR==init_trt_err()))
    {
      the_errno.code=errno;
      the_errno.ctxt=INIT;
      (aiguillage_err[the_errno.code])(&the_errno);
      clean_erreur();
      _exit(0);
    }

  message_spy(fd_spy,"\n init synchro");
  if(ERROR==init_synchro())
    {
      (aiguillage_err[the_errno.code])(&the_errno);
      clean_erreur();
      message_spy(fd_spy,"\n plante dans init synchro");
      fin_ctrl();
    }

  message_spy(fd_spy,"\n Initialisation des processus");

  if(NB_PROC != forkn(tab_fonc,NB_PROC,tab_pid))
    {
      the_errno.code=E_PROC_CREAT;
      the_errno.ctxt=INIT;
      kill(tab_pid[ENRG],SIGKILL);
      (aiguillage_err[the_errno.code])(&the_errno);
      clean_erreur();
      fin_ctrl();
    }


  alarm(NO_TIME_OUT);


  message_spy(fd_spy,"\n Avant init_ctrl");
  alarm(TIME_OUT_CTRL); 

  if(ERROR==init_ctrl())	
    {
      sprintf(message,"\nprocess ctrl  Erreur %d",the_errno.code);
      message_spy(fd_spy,message);
      (aiguillage_err[the_errno.code])(&the_errno);
      clean_erreur();
      fin_ctrl();
    }
  alarm(NO_TIME_OUT); 

  Pt_synchro[ENRG_PID]=tab_pid[ENRG];


  message_spy(fd_spy,"\nCTRL: installation terminee");


  /* corps du programme de controle */

  while(Pt_synchro[CTRL_ACTION]!=ACTION_DIE)
    {
      micro_sleep(0,TIME_SLEEP_CTRL);

      check();

      if(Pt_synchro[CTRL_ACTION]!=ACTION_RIEN)
	{
	  message_spy(fd_spy,"\nCTRL: Reception d`une action");
	  ctrl_action();
	}


      /*
	if(the_nb_err!=0)
	write_histo();
	*/
    }	

  message_spy(fd_spy,"\nCTRL Normalement je dois pas passer par la");
  fin_ctrl();
}










