h14039
s 00000/00000/00348
d D 3.4 98/04/14 15:37:19 chris 9 8
c modif de chris !?
e
s 00000/00000/00348
d D 3.3 98/03/11 17:40:00 chris 8 7
c 
e
s 00000/00000/00348
d D 3.2 98/03/11 17:36:32 chris 7 6
c 
e
s 00000/00000/00348
d D 3.1 98/03/11 10:44:52 chris 6 5
c 
e
s 00000/00000/00348
d D 1.4 97/09/29 14:50:25 chris 5 4
c 
e
s 00000/00000/00348
d D 1.3 97/09/24 09:04:15 chris 4 3
c ver 3, ok
e
s 00000/00000/00348
d D 1.2 97/08/31 16:51:21 chris 3 1
c fonctionne rao enrg rao stop, pas tout teste
e
s 00000/00000/00000
d R 1.2 97/07/26 17:22:31 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 sun/src/record/ready-visu.c
e
s 00348/00000/00000
d D 1.1 97/07/26 17:22:30 chris 1 0
c date and time created 97/07/26 17:22:30 by chris
e
u
U
f e 0
t
T
I 1

static char *SccsId="%W% %G%";

/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:ready-visu.c
-----------------
-Auteur(s):	Christian Miguel
-Rle:
	Ce fichier regroupe les fonctions d'initialisation et de mise en
	route du processus de visualisation.
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
		fin_visu
		fin_visu_sig
		hand_visu
		get_ready_visu
	 
-Commentaires:
********************************************************************;-*/


#include 	<stdio.h>
#include	<sys/types.h>
#include	<sys/file.h>
#include	<signal.h>
#include	<errno.h>
#include	<rpc/rpc.h>
#include	<export.h>
#include	<rpc_idl.h>

#include	<sun.h>
#include	<process.h>
#include	<acq.h>
#include	<visu.h>
#include 	<Sun-inst-pont.h>
#include	<the_errno.h>


extern	Tb_point	*Pt_point;
extern	Tb_visu		*Pt_visu;
extern	long		*Pt_synchro;
extern	int		desc_pont;
extern	void		*Pt_vme_base;
extern	CLIENT		*client;
extern  FILE            *fdvisu;
extern	Erreur		the_errno;



 

/*++********************************************************************
------------------
ENTETE DE FONCTION	:fin_visu
------------------

-Rle:
Cette fonction remet tout en place avant de mettre la cle sous la porte. En clair elle nettoie ce qu'il faut nettoyer. Par exemple, elle libre Pt_visu si celui-ci a t allou.
-inclure:
-Prototype:
	void fin_visu()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:
		Tb_point 	*Pt_point	(Sun-inst-pont.a)
		Tb_visu	  	*Pt_visu		(visu.c)
		long		*Pt_synchro

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		VISU_ETAT	(process.h)
		
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:

********************************************************************--*/


void fin_visu()
{
  if(Pt_point == NULL)
    printf("\nVISU PAS de netoyage avant l'arret");
  else
    {
      printf("\nVISU netoyage	avant l'arret");
      munmap(Pt_vme_base,TAILLE_MEM_COM);
      close(desc_pont);
    }
  close_idl(FILE_UNIT_IDL,client);
  delete_max_win(Pt_visu,client);
  unregister_idl_client(client);

  if(Pt_visu!=NULL)
    free(Pt_visu);
  if(fdvisu != NULL)
    fclose(fdvisu);
  if(Pt_synchro!=NULL)
    {
      Pt_synchro[VISU_PID]=NOTH;
      Pt_synchro[VISU_ETAT]=ETAT_DEAD;
      Pt_synchro[VISU]=SYNCHRO;
      Pt_synchro[VISU_ACTION]=ACTION_RIEN;
      shmdt(Pt_synchro);
      Pt_synchro=NULL;
    }
  printf("\n Sort de visu ");	
  _exit(0);
}
/*++********************************************************************
------------------
ENTETE DE FONCTION	:fin_visu_sig
------------------

-Rle:
Cette fonction remet tout en place avant de mettre la cle sous la porte. En clair elle nettoie ce qu'il faut nettoyer. Par exemple, elle libre Pt_visu si celui-ci a t allou (il vaut mieux qu'il soit allou  ce stade sinon ca veut dire qu'il y a eu une erreur).
-inclure:
-Prototype:
	void fin_visu_sig()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:
		Tb_point 	*Pt_point	(Sun-inst-pont.a)
		Tb_visu	  	*Pt_visu		(visu.c)
		long		*Pt_synchro

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
A la diffrence de fin_visu, cette fonction n'indique pas par l'intermdiaire
de Pt_synchro que le processus disparat.
********************************************************************--*/


void fin_visu_sig()
{
	if(Pt_point == NULL)
		printf("\nVISU PAS de netoyage avant l'arret");
	else
	{
		printf("\nVISU netoyage	avant l'arret");
		munmap(Pt_vme_base,TAILLE_MEM_COM);
		close(desc_pont);
	}
	idl_fin(Pt_visu,client);

	if(Pt_visu!=NULL)
		free(Pt_visu);
	if(Pt_synchro!=NULL)
	{
		shmdt(Pt_synchro);
		Pt_synchro=NULL;
	}
	
	_exit(0);
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:hand_visu
------------------

-Rle:
	Permettre au processus visu de ne pas sortir ds qu'il reoit un
	signal de type SIGSEGV, cela lui donne une occasion pour sortir
	la tte haute apres avoir nettoy ses variables etc...
-inclure:
-Prototype:
	void hand_visu(s)
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
	Ce genre de fonction est bien utile en phase de dveloppement.
	Puisque le comportement par dfaut de Joe processus de tout pter
	quand il reoit un message pas sympa.
********************************************************************--*/


void hand_visu(s)
int s;
{	

	switch(s)
	{
		case SIGBUS:
			printf("\n\nVISU Bus error ...");
			break;

		case SIGSEGV:
			printf("\n\nVISU Segmentation fault...");
			break;

		case SIGALRM:
			printf("\n\nVISU ALARM, TIME OUT init");
			kill(getppid(),SIGINT);
			break;
		case SIGUSR1:
			printf("\n\nVISU SIGUSR1...");
			fin_visu_sig();
			break;
 	}

	fin_visu();	
}
/*++********************************************************************
------------------
ENTETE DE FONCTION	:get_ready_visu
------------------

-Rle:
	Cette fonction doit prparer notre ami visu  travailler correctement 
	en lui permettant d'avoir accs  la mmoire commune par un mapping 
	et synchroniser cette initialisation avec l'accs aux mmes ressources 
	par ses petits camarades enrg et ctrl.
-inclure:
-Prototype:
	void get_ready_visu()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:
		Pt_synchro	(visu.c)
		Pt_point	(Sun-inst-pont.a)

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		VISU	(process.h)
		CTRL	
		ENRG
	
-Fonctions utilises
	Internes au fichier:
	Importes:
		shared_segment		(process.c)
		open_driver_pont	(Sun-inst-pont.c)
		map_mem_fils
		

-Exemple:
-Commentaires:
********************************************************************--*/




int get_ready_visu()
{
u_long		



adresse;
int 		i;
sigset_t	ens; 

signal(SIGBUS,hand_visu);
signal(SIGSEGV,hand_visu);
signal(SIGALRM,hand_visu);
signal(SIGUSR1,hand_visu);

sigemptyset(&ens);
sigaddset(&ens,SIGINT);

	if(sigprocmask(SIG_SETMASK,&ens,NULL)==ERROR)
	{
		the_errno.code=errno;
		return(ERROR);
	}
	

	Pt_synchro=NULL;
	Pt_point=NULL;
	
 
	if(NULL==(Pt_synchro=(long *)shared_segment(CLE,NB_SH_SEG)))
	{
		the_errno.code=errno;
		printf("\nVISU Pt_synchro NULL");
		return(ERROR);
	}
 printf("\n ready visu en attente du semaphore de enrg");
 	while(Pt_synchro[ENRG]==SYNCHRO)
 	{
 		if(Pt_synchro[VISU_ACTION]==ACTION_DIE)
			fin_visu();
	}
 printf("\n ready visu ouverture du pont de bus");

	desc_pont=open_driver_pont();
	adresse=adresse_tb_point();
	
	map_mem_fils(Pt_synchro[CTRL],adresse,desc_pont);
	Pt_synchro[VISU]=(long)Pt_vme_base;
 printf("\n ready visu, tab visu");
	
	Pt_visu=(Tb_visu *)malloc(sizeof(Tb_visu));
	if(Pt_visu==NULL)
	{
		the_errno.code=E_ALLOC_SUN;
		return(ERROR);
	}
 printf("\n ready visu, init_tb_visu");
	init_tb_visu(Pt_visu);
	return(OK);

 }

E 1
